/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand
 * queues.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservationPlanSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservationPlanSettings.Builder, ReservationPlanSettings> {
    private static final SdkField<String> COMMITMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Commitment").getter(getter(ReservationPlanSettings::commitmentAsString))
            .setter(setter(Builder::commitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitment").build()).build();

    private static final SdkField<String> RENEWAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RenewalType").getter(getter(ReservationPlanSettings::renewalTypeAsString))
            .setter(setter(Builder::renewalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalType").build()).build();

    private static final SdkField<Integer> RESERVED_SLOTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReservedSlots").getter(getter(ReservationPlanSettings::reservedSlots))
            .setter(setter(Builder::reservedSlots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedSlots").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMITMENT_FIELD,
            RENEWAL_TYPE_FIELD, RESERVED_SLOTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String commitment;

    private final String renewalType;

    private final Integer reservedSlots;

    private ReservationPlanSettings(BuilderImpl builder) {
        this.commitment = builder.commitment;
        this.renewalType = builder.renewalType;
        this.reservedSlots = builder.reservedSlots;
    }

    /**
     * The length of the term of your reserved queue pricing plan commitment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commitment} will
     * return {@link Commitment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #commitmentAsString}.
     * </p>
     * 
     * @return The length of the term of your reserved queue pricing plan commitment.
     * @see Commitment
     */
    public final Commitment commitment() {
        return Commitment.fromValue(commitment);
    }

    /**
     * The length of the term of your reserved queue pricing plan commitment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commitment} will
     * return {@link Commitment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #commitmentAsString}.
     * </p>
     * 
     * @return The length of the term of your reserved queue pricing plan commitment.
     * @see Commitment
     */
    public final String commitmentAsString() {
        return commitment;
    }

    /**
     * Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires
     * (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment by 12 months from the
     * auto renew date. You can cancel this commitment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #renewalType} will
     * return {@link RenewalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #renewalTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or
     *         expires (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment by 12
     *         months from the auto renew date. You can cancel this commitment.
     * @see RenewalType
     */
    public final RenewalType renewalType() {
        return RenewalType.fromValue(renewalType);
    }

    /**
     * Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires
     * (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment by 12 months from the
     * auto renew date. You can cancel this commitment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #renewalType} will
     * return {@link RenewalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #renewalTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or
     *         expires (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment by 12
     *         months from the auto renew date. You can cancel this commitment.
     * @see RenewalType
     */
    public final String renewalTypeAsString() {
        return renewalType;
    }

    /**
     * Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs
     * the queue can process in parallel; each RTS can process one job at a time. You can't decrease the number of RTS
     * in your reserved queue. You can increase the number of RTS by extending your existing commitment with a new
     * 12-month commitment for the larger number. The new commitment begins when you purchase the additional capacity.
     * You can't cancel your commitment or revert to your original commitment after you increase the capacity.
     * 
     * @return Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how
     *         many jobs the queue can process in parallel; each RTS can process one job at a time. You can't decrease
     *         the number of RTS in your reserved queue. You can increase the number of RTS by extending your existing
     *         commitment with a new 12-month commitment for the larger number. The new commitment begins when you
     *         purchase the additional capacity. You can't cancel your commitment or revert to your original commitment
     *         after you increase the capacity.
     */
    public final Integer reservedSlots() {
        return reservedSlots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commitmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(renewalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reservedSlots());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationPlanSettings)) {
            return false;
        }
        ReservationPlanSettings other = (ReservationPlanSettings) obj;
        return Objects.equals(commitmentAsString(), other.commitmentAsString())
                && Objects.equals(renewalTypeAsString(), other.renewalTypeAsString())
                && Objects.equals(reservedSlots(), other.reservedSlots());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservationPlanSettings").add("Commitment", commitmentAsString())
                .add("RenewalType", renewalTypeAsString()).add("ReservedSlots", reservedSlots()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Commitment":
            return Optional.ofNullable(clazz.cast(commitmentAsString()));
        case "RenewalType":
            return Optional.ofNullable(clazz.cast(renewalTypeAsString()));
        case "ReservedSlots":
            return Optional.ofNullable(clazz.cast(reservedSlots()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservationPlanSettings, T> g) {
        return obj -> g.apply((ReservationPlanSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservationPlanSettings> {
        /**
         * The length of the term of your reserved queue pricing plan commitment.
         * 
         * @param commitment
         *        The length of the term of your reserved queue pricing plan commitment.
         * @see Commitment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Commitment
         */
        Builder commitment(String commitment);

        /**
         * The length of the term of your reserved queue pricing plan commitment.
         * 
         * @param commitment
         *        The length of the term of your reserved queue pricing plan commitment.
         * @see Commitment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Commitment
         */
        Builder commitment(Commitment commitment);

        /**
         * Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or
         * expires (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment by 12
         * months from the auto renew date. You can cancel this commitment.
         * 
         * @param renewalType
         *        Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW)
         *        or expires (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment
         *        by 12 months from the auto renew date. You can cancel this commitment.
         * @see RenewalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RenewalType
         */
        Builder renewalType(String renewalType);

        /**
         * Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or
         * expires (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment by 12
         * months from the auto renew date. You can cancel this commitment.
         * 
         * @param renewalType
         *        Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW)
         *        or expires (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment
         *        by 12 months from the auto renew date. You can cancel this commitment.
         * @see RenewalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RenewalType
         */
        Builder renewalType(RenewalType renewalType);

        /**
         * Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many
         * jobs the queue can process in parallel; each RTS can process one job at a time. You can't decrease the number
         * of RTS in your reserved queue. You can increase the number of RTS by extending your existing commitment with
         * a new 12-month commitment for the larger number. The new commitment begins when you purchase the additional
         * capacity. You can't cancel your commitment or revert to your original commitment after you increase the
         * capacity.
         * 
         * @param reservedSlots
         *        Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines
         *        how many jobs the queue can process in parallel; each RTS can process one job at a time. You can't
         *        decrease the number of RTS in your reserved queue. You can increase the number of RTS by extending
         *        your existing commitment with a new 12-month commitment for the larger number. The new commitment
         *        begins when you purchase the additional capacity. You can't cancel your commitment or revert to your
         *        original commitment after you increase the capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedSlots(Integer reservedSlots);
    }

    static final class BuilderImpl implements Builder {
        private String commitment;

        private String renewalType;

        private Integer reservedSlots;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationPlanSettings model) {
            commitment(model.commitment);
            renewalType(model.renewalType);
            reservedSlots(model.reservedSlots);
        }

        public final String getCommitment() {
            return commitment;
        }

        @Override
        public final Builder commitment(String commitment) {
            this.commitment = commitment;
            return this;
        }

        @Override
        public final Builder commitment(Commitment commitment) {
            this.commitment(commitment == null ? null : commitment.toString());
            return this;
        }

        public final void setCommitment(String commitment) {
            this.commitment = commitment;
        }

        public final String getRenewalType() {
            return renewalType;
        }

        @Override
        public final Builder renewalType(String renewalType) {
            this.renewalType = renewalType;
            return this;
        }

        @Override
        public final Builder renewalType(RenewalType renewalType) {
            this.renewalType(renewalType == null ? null : renewalType.toString());
            return this;
        }

        public final void setRenewalType(String renewalType) {
            this.renewalType = renewalType;
        }

        public final Integer getReservedSlots() {
            return reservedSlots;
        }

        @Override
        public final Builder reservedSlots(Integer reservedSlots) {
            this.reservedSlots = reservedSlots;
            return this;
        }

        public final void setReservedSlots(Integer reservedSlots) {
            this.reservedSlots = reservedSlots;
        }

        @Override
        public ReservationPlanSettings build() {
            return new ReservationPlanSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
