/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProresSettings implements SdkPojo, Serializable, ToCopyableBuilder<ProresSettings.Builder, ProresSettings> {
    private static final SdkField<String> CODEC_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodecProfile").getter(getter(ProresSettings::codecProfileAsString))
            .setter(setter(Builder::codecProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecProfile").build()).build();

    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FramerateControl").getter(getter(ProresSettings::framerateControlAsString))
            .setter(setter(Builder::framerateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()).build();

    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FramerateConversionAlgorithm")
            .getter(getter(ProresSettings::framerateConversionAlgorithmAsString))
            .setter(setter(Builder::framerateConversionAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm")
                    .build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(ProresSettings::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(ProresSettings::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InterlaceMode").getter(getter(ProresSettings::interlaceModeAsString))
            .setter(setter(Builder::interlaceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()).build();

    private static final SdkField<String> PAR_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParControl").getter(getter(ProresSettings::parControlAsString)).setter(setter(Builder::parControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parControl").build()).build();

    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParDenominator").getter(getter(ProresSettings::parDenominator)).setter(setter(Builder::parDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()).build();

    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParNumerator").getter(getter(ProresSettings::parNumerator)).setter(setter(Builder::parNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()).build();

    private static final SdkField<String> SCAN_TYPE_CONVERSION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanTypeConversionMode").getter(getter(ProresSettings::scanTypeConversionModeAsString))
            .setter(setter(Builder::scanTypeConversionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanTypeConversionMode").build())
            .build();

    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlowPal").getter(getter(ProresSettings::slowPalAsString)).setter(setter(Builder::slowPal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()).build();

    private static final SdkField<String> TELECINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Telecine").getter(getter(ProresSettings::telecineAsString)).setter(setter(Builder::telecine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_PROFILE_FIELD,
            FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD,
            FRAMERATE_NUMERATOR_FIELD, INTERLACE_MODE_FIELD, PAR_CONTROL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD,
            SCAN_TYPE_CONVERSION_MODE_FIELD, SLOW_PAL_FIELD, TELECINE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String codecProfile;

    private final String framerateControl;

    private final String framerateConversionAlgorithm;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final String interlaceMode;

    private final String parControl;

    private final Integer parDenominator;

    private final Integer parNumerator;

    private final String scanTypeConversionMode;

    private final String slowPal;

    private final String telecine;

    private ProresSettings(BuilderImpl builder) {
        this.codecProfile = builder.codecProfile;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.interlaceMode = builder.interlaceMode;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.scanTypeConversionMode = builder.scanTypeConversionMode;
        this.slowPal = builder.slowPal;
        this.telecine = builder.telecine;
    }

    /**
     * Use Profile (ProResCodecProfile) to specify the type of Apple ProRes codec to use for this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link ProresCodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecProfileAsString}.
     * </p>
     * 
     * @return Use Profile (ProResCodecProfile) to specify the type of Apple ProRes codec to use for this output.
     * @see ProresCodecProfile
     */
    public final ProresCodecProfile codecProfile() {
        return ProresCodecProfile.fromValue(codecProfile);
    }

    /**
     * Use Profile (ProResCodecProfile) to specify the type of Apple ProRes codec to use for this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link ProresCodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecProfileAsString}.
     * </p>
     * 
     * @return Use Profile (ProResCodecProfile) to specify the type of Apple ProRes codec to use for this output.
     * @see ProresCodecProfile
     */
    public final String codecProfileAsString() {
        return codecProfile;
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link ProresFramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see ProresFramerateControl
     */
    public final ProresFramerateControl framerateControl() {
        return ProresFramerateControl.fromValue(framerateControl);
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link ProresFramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see ProresFramerateControl
     */
    public final String framerateControlAsString() {
        return framerateControl;
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend
     * using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For
     * numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth
     * picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your
     * source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do
     * motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using
     * FrameFormer increases the transcoding time and incurs a significant add-on cost.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return
     * {@link ProresFramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
     *         recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30
     *         fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This
     *         results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
     *         conversions, especially if your source video has already been converted from its original cadence, use
     *         FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion
     *         method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a
     *         significant add-on cost.
     * @see ProresFramerateConversionAlgorithm
     */
    public final ProresFramerateConversionAlgorithm framerateConversionAlgorithm() {
        return ProresFramerateConversionAlgorithm.fromValue(framerateConversionAlgorithm);
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend
     * using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For
     * numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth
     * picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your
     * source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do
     * motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using
     * FrameFormer increases the transcoding time and incurs a significant add-on cost.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return
     * {@link ProresFramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
     *         recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30
     *         fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This
     *         results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
     *         conversions, especially if your source video has already been converted from its original cadence, use
     *         FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion
     *         method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a
     *         significant add-on cost.
     * @see ProresFramerateConversionAlgorithm
     */
    public final String framerateConversionAlgorithmAsString() {
        return framerateConversionAlgorithm;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this
     * example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of
     *         this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console
     *         for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate.
     *         In this example, specify 23.976.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this
     * example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this
     *         fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for
     *         transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In
     *         this example, specify 23.976.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
     * progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field
     * first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow,
     * default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same
     * field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the
     * course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output
     * will be interlaced with the same polarity as the source. If the source is progressive, the output will be
     * interlaced with top field bottom field first, depending on which of the Follow options you choose.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link ProresInterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
     *         progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
     *         field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout.
     *         Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce
     *         outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field
     *         polarity might change over the course of the output. Follow behavior depends on the input scan type. If
     *         the source is interlaced, the output will be interlaced with the same polarity as the source. If the
     *         source is progressive, the output will be interlaced with top field bottom field first, depending on
     *         which of the Follow options you choose.
     * @see ProresInterlaceMode
     */
    public final ProresInterlaceMode interlaceMode() {
        return ProresInterlaceMode.fromValue(interlaceMode);
    }

    /**
     * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
     * progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field
     * first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow,
     * default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same
     * field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the
     * course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output
     * will be interlaced with the same polarity as the source. If the source is progressive, the output will be
     * interlaced with top field bottom field first, depending on which of the Follow options you choose.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link ProresInterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
     *         progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
     *         field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout.
     *         Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce
     *         outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field
     *         polarity might change over the course of the output. Follow behavior depends on the input scan type. If
     *         the source is interlaced, the output will be interlaced with the same polarity as the source. If the
     *         source is progressive, the output will be interlaced with top field bottom field first, depending on
     *         which of the Follow options you choose.
     * @see ProresInterlaceMode
     */
    public final String interlaceModeAsString() {
        return interlaceMode;
    }

    /**
     * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior,
     * Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a
     * different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing
     * the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify
     * values for the parNumerator and parDenominator settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link ProresParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
     *         behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
     *         specify a different PAR in the console, choose any value other than Follow source. To specify a different
     *         PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting,
     *         you must also specify values for the parNumerator and parDenominator settings.
     * @see ProresParControl
     */
    public final ProresParControl parControl() {
        return ProresParControl.fromValue(parControl);
    }

    /**
     * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior,
     * Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a
     * different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing
     * the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify
     * values for the parNumerator and parDenominator settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link ProresParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
     *         behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
     *         specify a different PAR in the console, choose any value other than Follow source. To specify a different
     *         PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting,
     *         you must also specify values for the parNumerator and parDenominator settings.
     * @see ProresParControl
     */
    public final String parControlAsString() {
        return parControl;
    }

    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value
     * other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input
     * video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the
     * ratio 40:33. In this example, the value for parDenominator is 33.
     * 
     * @return Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to
     *         any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different
     *         from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen,
     *         you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
     */
    public final Integer parDenominator() {
        return parDenominator;
    }

    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value
     * other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input
     * video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the
     * ratio 40:33. In this example, the value for parNumerator is 40.
     * 
     * @return Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to
     *         any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different
     *         from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen,
     *         you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
     */
    public final Integer parNumerator() {
        return parNumerator;
    }

    /**
     * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this
     * situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In
     * this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the
     * default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing,
     * MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized
     * interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing,
     * MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you
     * must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine
     * outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scanTypeConversionMode} will return {@link ProresScanTypeConversionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #scanTypeConversionModeAsString}.
     * </p>
     * 
     * @return Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
     *         this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
     *         output. In this case, each progressive frame from the input corresponds to an interlaced field in the
     *         output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With
     *         basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames.
     *         When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable
     *         for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings:
     *         To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't
     *         use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to
     *         a value other than Progressive (PROGRESSIVE).
     * @see ProresScanTypeConversionMode
     */
    public final ProresScanTypeConversionMode scanTypeConversionMode() {
        return ProresScanTypeConversionMode.fromValue(scanTypeConversionMode);
    }

    /**
     * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this
     * situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In
     * this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the
     * default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing,
     * MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized
     * interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing,
     * MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you
     * must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine
     * outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scanTypeConversionMode} will return {@link ProresScanTypeConversionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #scanTypeConversionModeAsString}.
     * </p>
     * 
     * @return Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
     *         this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
     *         output. In this case, each progressive frame from the input corresponds to an interlaced field in the
     *         output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With
     *         basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames.
     *         When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable
     *         for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings:
     *         To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't
     *         use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to
     *         a value other than Progressive (PROGRESSIVE).
     * @see ProresScanTypeConversionMode
     */
    public final String scanTypeConversionModeAsString() {
        return scanTypeConversionMode;
    }

    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
     * create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples
     * your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the
     * duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set
     * (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link ProresSlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL
     *         to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and
     *         resamples your audio to keep it synchronized with the video. Note that enabling this setting will
     *         slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your
     *         JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
     *         (framerateDenominator) to 1.
     * @see ProresSlowPal
     */
    public final ProresSlowPal slowPal() {
        return ProresSlowPal.fromValue(slowPal);
    }

    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
     * create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples
     * your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the
     * duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set
     * (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link ProresSlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL
     *         to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and
     *         resamples your audio to keep it synchronized with the video. Note that enabling this setting will
     *         slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your
     *         JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
     *         (framerateDenominator) to 1.
     * @see ProresSlowPal
     */
    public final String slowPalAsString() {
        return slowPal;
    }

    /**
     * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is
     * interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the
     * default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything
     * with the field polarity to create a smoother picture.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link ProresTelecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telecineAsString}.
     * </p>
     * 
     * @return When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan
     *         type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you
     *         keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without
     *         doing anything with the field polarity to create a smoother picture.
     * @see ProresTelecine
     */
    public final ProresTelecine telecine() {
        return ProresTelecine.fromValue(telecine);
    }

    /**
     * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is
     * interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the
     * default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything
     * with the field polarity to create a smoother picture.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link ProresTelecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telecineAsString}.
     * </p>
     * 
     * @return When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan
     *         type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you
     *         keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without
     *         doing anything with the field polarity to create a smoother picture.
     * @see ProresTelecine
     */
    public final String telecineAsString() {
        return telecine;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(scanTypeConversionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(telecineAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProresSettings)) {
            return false;
        }
        ProresSettings other = (ProresSettings) obj;
        return Objects.equals(codecProfileAsString(), other.codecProfileAsString())
                && Objects.equals(framerateControlAsString(), other.framerateControlAsString())
                && Objects.equals(framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator())
                && Objects.equals(interlaceModeAsString(), other.interlaceModeAsString())
                && Objects.equals(parControlAsString(), other.parControlAsString())
                && Objects.equals(parDenominator(), other.parDenominator())
                && Objects.equals(parNumerator(), other.parNumerator())
                && Objects.equals(scanTypeConversionModeAsString(), other.scanTypeConversionModeAsString())
                && Objects.equals(slowPalAsString(), other.slowPalAsString())
                && Objects.equals(telecineAsString(), other.telecineAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProresSettings").add("CodecProfile", codecProfileAsString())
                .add("FramerateControl", framerateControlAsString())
                .add("FramerateConversionAlgorithm", framerateConversionAlgorithmAsString())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("InterlaceMode", interlaceModeAsString()).add("ParControl", parControlAsString())
                .add("ParDenominator", parDenominator()).add("ParNumerator", parNumerator())
                .add("ScanTypeConversionMode", scanTypeConversionModeAsString()).add("SlowPal", slowPalAsString())
                .add("Telecine", telecineAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodecProfile":
            return Optional.ofNullable(clazz.cast(codecProfileAsString()));
        case "FramerateControl":
            return Optional.ofNullable(clazz.cast(framerateControlAsString()));
        case "FramerateConversionAlgorithm":
            return Optional.ofNullable(clazz.cast(framerateConversionAlgorithmAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "InterlaceMode":
            return Optional.ofNullable(clazz.cast(interlaceModeAsString()));
        case "ParControl":
            return Optional.ofNullable(clazz.cast(parControlAsString()));
        case "ParDenominator":
            return Optional.ofNullable(clazz.cast(parDenominator()));
        case "ParNumerator":
            return Optional.ofNullable(clazz.cast(parNumerator()));
        case "ScanTypeConversionMode":
            return Optional.ofNullable(clazz.cast(scanTypeConversionModeAsString()));
        case "SlowPal":
            return Optional.ofNullable(clazz.cast(slowPalAsString()));
        case "Telecine":
            return Optional.ofNullable(clazz.cast(telecineAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProresSettings, T> g) {
        return obj -> g.apply((ProresSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProresSettings> {
        /**
         * Use Profile (ProResCodecProfile) to specify the type of Apple ProRes codec to use for this output.
         * 
         * @param codecProfile
         *        Use Profile (ProResCodecProfile) to specify the type of Apple ProRes codec to use for this output.
         * @see ProresCodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresCodecProfile
         */
        Builder codecProfile(String codecProfile);

        /**
         * Use Profile (ProResCodecProfile) to specify the type of Apple ProRes codec to use for this output.
         * 
         * @param codecProfile
         *        Use Profile (ProResCodecProfile) to specify the type of Apple ProRes codec to use for this output.
         * @see ProresCodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresCodecProfile
         */
        Builder codecProfile(ProresCodecProfile codecProfile);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see ProresFramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresFramerateControl
         */
        Builder framerateControl(String framerateControl);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see ProresFramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresFramerateControl
         */
        Builder framerateControl(ProresFramerateControl framerateControl);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         * recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps.
         * For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in
         * a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence, use FrameFormer
         * (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by
         * frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         *        recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
         *        30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter.
         *        This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame
         *        rate conversions, especially if your source video has already been converted from its original
         *        cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the
         *        best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and
         *        incurs a significant add-on cost.
         * @see ProresFramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresFramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(String framerateConversionAlgorithm);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         * recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps.
         * For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in
         * a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence, use FrameFormer
         * (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by
         * frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         *        recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
         *        30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter.
         *        This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame
         *        rate conversions, especially if your source video has already been converted from its original
         *        cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the
         *        best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and
         *        incurs a significant add-on cost.
         * @see ProresFramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresFramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(ProresFramerateConversionAlgorithm framerateConversionAlgorithm);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction.
         * In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs
         * that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateDenominator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator
         *        of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In
         * this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that
         * use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateNumerator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of
         *        this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
         * progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
         * field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use
         * Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs
         * with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity
         * might change over the course of the output. Follow behavior depends on the input scan type. If the source is
         * interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive,
         * the output will be interlaced with top field bottom field first, depending on which of the Follow options you
         * choose.
         * 
         * @param interlaceMode
         *        Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create
         *        a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or
         *        Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity
         *        throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD)
         *        to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the
         *        output field polarity might change over the course of the output. Follow behavior depends on the input
         *        scan type. If the source is interlaced, the output will be interlaced with the same polarity as the
         *        source. If the source is progressive, the output will be interlaced with top field bottom field first,
         *        depending on which of the Follow options you choose.
         * @see ProresInterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresInterlaceMode
         */
        Builder interlaceMode(String interlaceMode);

        /**
         * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
         * progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
         * field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use
         * Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs
         * with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity
         * might change over the course of the output. Follow behavior depends on the input scan type. If the source is
         * interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive,
         * the output will be interlaced with top field bottom field first, depending on which of the Follow options you
         * choose.
         * 
         * @param interlaceMode
         *        Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create
         *        a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or
         *        Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity
         *        throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD)
         *        to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the
         *        output field polarity might change over the course of the output. Follow behavior depends on the input
         *        scan type. If the source is interlaced, the output will be interlaced with the same polarity as the
         *        source. If the source is progressive, the output will be interlaced with top field bottom field first,
         *        depending on which of the Follow options you choose.
         * @see ProresInterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresInterlaceMode
         */
        Builder interlaceMode(ProresInterlaceMode interlaceMode);

        /**
         * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         * behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
         * specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR
         * by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must
         * also specify values for the parNumerator and parDenominator settings.
         * 
         * @param parControl
         *        Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         *        behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output.
         *        To specify a different PAR in the console, choose any value other than Follow source. To specify a
         *        different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for
         *        this setting, you must also specify values for the parNumerator and parDenominator settings.
         * @see ProresParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresParControl
         */
        Builder parControl(String parControl);

        /**
         * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         * behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
         * specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR
         * by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must
         * also specify values for the parNumerator and parDenominator settings.
         * 
         * @param parControl
         *        Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         *        behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output.
         *        To specify a different PAR in the console, choose any value other than Follow source. To specify a
         *        different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for
         *        this setting, you must also specify values for the parNumerator and parDenominator settings.
         * @see ProresParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresParControl
         */
        Builder parControl(ProresParControl parControl);

        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any
         * value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from
         * your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would
         * specify the ratio 40:33. In this example, the value for parDenominator is 33.
         * 
         * @param parDenominator
         *        Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds
         *        to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is
         *        different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC
         *        widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parDenominator(Integer parDenominator);

        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any
         * value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from
         * your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would
         * specify the ratio 40:33. In this example, the value for parNumerator is 40.
         * 
         * @param parNumerator
         *        Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds
         *        to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is
         *        different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC
         *        widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parNumerator(Integer parNumerator);

        /**
         * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
         * this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
         * output. In this case, each progressive frame from the input corresponds to an interlaced field in the output.
         * Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic
         * interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you
         * choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized
         * interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized
         * interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized
         * interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than
         * Progressive (PROGRESSIVE).
         * 
         * @param scanTypeConversionMode
         *        Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate.
         *        In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality
         *        interlaced output. In this case, each progressive frame from the input corresponds to an interlaced
         *        field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output
         *        frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then
         *        interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a
         *        value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic
         *        interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None
         *        (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also
         *        set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
         * @see ProresScanTypeConversionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresScanTypeConversionMode
         */
        Builder scanTypeConversionMode(String scanTypeConversionMode);

        /**
         * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
         * this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
         * output. In this case, each progressive frame from the input corresponds to an interlaced field in the output.
         * Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic
         * interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you
         * choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized
         * interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized
         * interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized
         * interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than
         * Progressive (PROGRESSIVE).
         * 
         * @param scanTypeConversionMode
         *        Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate.
         *        In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality
         *        interlaced output. In this case, each progressive frame from the input corresponds to an interlaced
         *        field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output
         *        frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then
         *        interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a
         *        value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic
         *        interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None
         *        (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also
         *        set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
         * @see ProresScanTypeConversionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresScanTypeConversionMode
         */
        Builder scanTypeConversionMode(ProresScanTypeConversionMode scanTypeConversionMode);

        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
         * create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and
         * resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly
         * reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job
         * specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator)
         * to 1.
         * 
         * @param slowPal
         *        Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow
         *        PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25
         *        fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting
         *        will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25.
         *        In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
         *        (framerateDenominator) to 1.
         * @see ProresSlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresSlowPal
         */
        Builder slowPal(String slowPal);

        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
         * create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and
         * resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly
         * reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job
         * specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator)
         * to 1.
         * 
         * @param slowPal
         *        Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow
         *        PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25
         *        fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting
         *        will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25.
         *        In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
         *        (framerateDenominator) to 1.
         * @see ProresSlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresSlowPal
         */
        Builder slowPal(ProresSlowPal slowPal);

        /**
         * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type
         * is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the
         * default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing
         * anything with the field polarity to create a smoother picture.
         * 
         * @param telecine
         *        When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output
         *        scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture.
         *        When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to
         *        29.97 without doing anything with the field polarity to create a smoother picture.
         * @see ProresTelecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresTelecine
         */
        Builder telecine(String telecine);

        /**
         * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type
         * is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the
         * default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing
         * anything with the field polarity to create a smoother picture.
         * 
         * @param telecine
         *        When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output
         *        scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture.
         *        When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to
         *        29.97 without doing anything with the field polarity to create a smoother picture.
         * @see ProresTelecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProresTelecine
         */
        Builder telecine(ProresTelecine telecine);
    }

    static final class BuilderImpl implements Builder {
        private String codecProfile;

        private String framerateControl;

        private String framerateConversionAlgorithm;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private String interlaceMode;

        private String parControl;

        private Integer parDenominator;

        private Integer parNumerator;

        private String scanTypeConversionMode;

        private String slowPal;

        private String telecine;

        private BuilderImpl() {
        }

        private BuilderImpl(ProresSettings model) {
            codecProfile(model.codecProfile);
            framerateControl(model.framerateControl);
            framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            interlaceMode(model.interlaceMode);
            parControl(model.parControl);
            parDenominator(model.parDenominator);
            parNumerator(model.parNumerator);
            scanTypeConversionMode(model.scanTypeConversionMode);
            slowPal(model.slowPal);
            telecine(model.telecine);
        }

        public final String getCodecProfile() {
            return codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(ProresCodecProfile codecProfile) {
            this.codecProfile(codecProfile == null ? null : codecProfile.toString());
            return this;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        public final String getFramerateControl() {
            return framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(ProresFramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(ProresFramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm
                    .toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final String getInterlaceMode() {
            return interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(ProresInterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        public final String getParControl() {
            return parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(ProresParControl parControl) {
            this.parControl(parControl == null ? null : parControl.toString());
            return this;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        public final Integer getParDenominator() {
            return parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        public final Integer getParNumerator() {
            return parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        public final String getScanTypeConversionMode() {
            return scanTypeConversionMode;
        }

        @Override
        public final Builder scanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
            return this;
        }

        @Override
        public final Builder scanTypeConversionMode(ProresScanTypeConversionMode scanTypeConversionMode) {
            this.scanTypeConversionMode(scanTypeConversionMode == null ? null : scanTypeConversionMode.toString());
            return this;
        }

        public final void setScanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
        }

        public final String getSlowPal() {
            return slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(ProresSlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        public final String getTelecine() {
            return telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(ProresTelecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        @Override
        public ProresSettings build() {
            return new ProresSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
