/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Details regarding output
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputDetail implements SdkPojo, Serializable, ToCopyableBuilder<OutputDetail.Builder, OutputDetail> {
    private static final SdkField<Integer> DURATION_IN_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInMs").getter(getter(OutputDetail::durationInMs)).setter(setter(Builder::durationInMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInMs").build()).build();

    private static final SdkField<VideoDetail> VIDEO_DETAILS_FIELD = SdkField.<VideoDetail> builder(MarshallingType.SDK_POJO)
            .memberName("VideoDetails").getter(getter(OutputDetail::videoDetails)).setter(setter(Builder::videoDetails))
            .constructor(VideoDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_IN_MS_FIELD,
            VIDEO_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer durationInMs;

    private final VideoDetail videoDetails;

    private OutputDetail(BuilderImpl builder) {
        this.durationInMs = builder.durationInMs;
        this.videoDetails = builder.videoDetails;
    }

    /**
     * Duration in milliseconds
     * 
     * @return Duration in milliseconds
     */
    public final Integer durationInMs() {
        return durationInMs;
    }

    /**
     * Contains details about the output's video stream
     * 
     * @return Contains details about the output's video stream
     */
    public final VideoDetail videoDetails() {
        return videoDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durationInMs());
        hashCode = 31 * hashCode + Objects.hashCode(videoDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDetail)) {
            return false;
        }
        OutputDetail other = (OutputDetail) obj;
        return Objects.equals(durationInMs(), other.durationInMs()) && Objects.equals(videoDetails(), other.videoDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputDetail").add("DurationInMs", durationInMs()).add("VideoDetails", videoDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurationInMs":
            return Optional.ofNullable(clazz.cast(durationInMs()));
        case "VideoDetails":
            return Optional.ofNullable(clazz.cast(videoDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputDetail, T> g) {
        return obj -> g.apply((OutputDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputDetail> {
        /**
         * Duration in milliseconds
         * 
         * @param durationInMs
         *        Duration in milliseconds
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInMs(Integer durationInMs);

        /**
         * Contains details about the output's video stream
         * 
         * @param videoDetails
         *        Contains details about the output's video stream
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoDetails(VideoDetail videoDetails);

        /**
         * Contains details about the output's video stream This is a convenience that creates an instance of the
         * {@link VideoDetail.Builder} avoiding the need to create one manually via {@link VideoDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link VideoDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #videoDetails(VideoDetail)}.
         * 
         * @param videoDetails
         *        a consumer that will call methods on {@link VideoDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoDetails(VideoDetail)
         */
        default Builder videoDetails(Consumer<VideoDetail.Builder> videoDetails) {
            return videoDetails(VideoDetail.builder().applyMutation(videoDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer durationInMs;

        private VideoDetail videoDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDetail model) {
            durationInMs(model.durationInMs);
            videoDetails(model.videoDetails);
        }

        public final Integer getDurationInMs() {
            return durationInMs;
        }

        @Override
        public final Builder durationInMs(Integer durationInMs) {
            this.durationInMs = durationInMs;
            return this;
        }

        public final void setDurationInMs(Integer durationInMs) {
            this.durationInMs = durationInMs;
        }

        public final VideoDetail.Builder getVideoDetails() {
            return videoDetails != null ? videoDetails.toBuilder() : null;
        }

        @Override
        public final Builder videoDetails(VideoDetail videoDetails) {
            this.videoDetails = videoDetails;
            return this;
        }

        public final void setVideoDetails(VideoDetail.BuilderImpl videoDetails) {
            this.videoDetails = videoDetails != null ? videoDetails.build() : null;
        }

        @Override
        public OutputDetail build() {
            return new OutputDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
