/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Overlay motion graphics on top of your video at the time that you specify.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MotionImageInserter implements SdkPojo, Serializable,
        ToCopyableBuilder<MotionImageInserter.Builder, MotionImageInserter> {
    private static final SdkField<MotionImageInsertionFramerate> FRAMERATE_FIELD = SdkField
            .<MotionImageInsertionFramerate> builder(MarshallingType.SDK_POJO).memberName("Framerate")
            .getter(getter(MotionImageInserter::framerate)).setter(setter(Builder::framerate))
            .constructor(MotionImageInsertionFramerate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerate").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Input")
            .getter(getter(MotionImageInserter::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> INSERTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InsertionMode").getter(getter(MotionImageInserter::insertionModeAsString))
            .setter(setter(Builder::insertionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insertionMode").build()).build();

    private static final SdkField<MotionImageInsertionOffset> OFFSET_FIELD = SdkField
            .<MotionImageInsertionOffset> builder(MarshallingType.SDK_POJO).memberName("Offset")
            .getter(getter(MotionImageInserter::offset)).setter(setter(Builder::offset))
            .constructor(MotionImageInsertionOffset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()).build();

    private static final SdkField<String> PLAYBACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Playback").getter(getter(MotionImageInserter::playbackAsString)).setter(setter(Builder::playback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playback").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTime").getter(getter(MotionImageInserter::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMERATE_FIELD, INPUT_FIELD,
            INSERTION_MODE_FIELD, OFFSET_FIELD, PLAYBACK_FIELD, START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final MotionImageInsertionFramerate framerate;

    private final String input;

    private final String insertionMode;

    private final MotionImageInsertionOffset offset;

    private final String playback;

    private final String startTime;

    private MotionImageInserter(BuilderImpl builder) {
        this.framerate = builder.framerate;
        this.input = builder.input;
        this.insertionMode = builder.insertionMode;
        this.offset = builder.offset;
        this.playback = builder.playback;
        this.startTime = builder.startTime;
    }

    /**
     * If your motion graphic asset is a .mov file, keep this setting unspecified. If your motion graphic asset is a
     * series of .png files, specify the frame rate of the overlay in frames per second, as a fraction. For example,
     * specify 24 fps as 24/1. Make sure that the number of images in your series matches the frame rate and your
     * intended overlay duration. For example, if you want a 30-second overlay at 30 fps, you should have 900 .png
     * images. This overlay frame rate doesn't need to match the frame rate of the underlying video.
     * 
     * @return If your motion graphic asset is a .mov file, keep this setting unspecified. If your motion graphic asset
     *         is a series of .png files, specify the frame rate of the overlay in frames per second, as a fraction. For
     *         example, specify 24 fps as 24/1. Make sure that the number of images in your series matches the frame
     *         rate and your intended overlay duration. For example, if you want a 30-second overlay at 30 fps, you
     *         should have 900 .png images. This overlay frame rate doesn't need to match the frame rate of the
     *         underlying video.
     */
    public final MotionImageInsertionFramerate framerate() {
        return framerate;
    }

    /**
     * Specify the .mov file or series of .png files that you want to overlay on your video. For .png files, provide the
     * file name of the first file in the series. Make sure that the names of the .png files end with sequential numbers
     * that specify the order that they are played in. For example, overlay_000.png, overlay_001.png, overlay_002.png,
     * and so on. The sequence must start at zero, and each image file name must have the same number of digits. Pad
     * your initial file names with enough zeros to complete the sequence. For example, if the first image is
     * overlay_0.png, there can be only 10 images in the sequence, with the last image being overlay_9.png. But if the
     * first image is overlay_00.png, there can be 100 images in the sequence.
     * 
     * @return Specify the .mov file or series of .png files that you want to overlay on your video. For .png files,
     *         provide the file name of the first file in the series. Make sure that the names of the .png files end
     *         with sequential numbers that specify the order that they are played in. For example, overlay_000.png,
     *         overlay_001.png, overlay_002.png, and so on. The sequence must start at zero, and each image file name
     *         must have the same number of digits. Pad your initial file names with enough zeros to complete the
     *         sequence. For example, if the first image is overlay_0.png, there can be only 10 images in the sequence,
     *         with the last image being overlay_9.png. But if the first image is overlay_00.png, there can be 100
     *         images in the sequence.
     */
    public final String input() {
        return input;
    }

    /**
     * Choose the type of motion graphic asset that you are providing for your overlay. You can choose either a .mov
     * file or a series of .png files.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #insertionMode}
     * will return {@link MotionImageInsertionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #insertionModeAsString}.
     * </p>
     * 
     * @return Choose the type of motion graphic asset that you are providing for your overlay. You can choose either a
     *         .mov file or a series of .png files.
     * @see MotionImageInsertionMode
     */
    public final MotionImageInsertionMode insertionMode() {
        return MotionImageInsertionMode.fromValue(insertionMode);
    }

    /**
     * Choose the type of motion graphic asset that you are providing for your overlay. You can choose either a .mov
     * file or a series of .png files.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #insertionMode}
     * will return {@link MotionImageInsertionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #insertionModeAsString}.
     * </p>
     * 
     * @return Choose the type of motion graphic asset that you are providing for your overlay. You can choose either a
     *         .mov file or a series of .png files.
     * @see MotionImageInsertionMode
     */
    public final String insertionModeAsString() {
        return insertionMode;
    }

    /**
     * Use Offset to specify the placement of your motion graphic overlay on the video frame. Specify in pixels, from
     * the upper-left corner of the frame. If you don't specify an offset, the service scales your overlay to the full
     * size of the frame. Otherwise, the service inserts the overlay at its native resolution and scales the size up or
     * down with any video scaling.
     * 
     * @return Use Offset to specify the placement of your motion graphic overlay on the video frame. Specify in pixels,
     *         from the upper-left corner of the frame. If you don't specify an offset, the service scales your overlay
     *         to the full size of the frame. Otherwise, the service inserts the overlay at its native resolution and
     *         scales the size up or down with any video scaling.
     */
    public final MotionImageInsertionOffset offset() {
        return offset;
    }

    /**
     * Specify whether your motion graphic overlay repeats on a loop or plays only once.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #playback} will
     * return {@link MotionImagePlayback#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #playbackAsString}.
     * </p>
     * 
     * @return Specify whether your motion graphic overlay repeats on a loop or plays only once.
     * @see MotionImagePlayback
     */
    public final MotionImagePlayback playback() {
        return MotionImagePlayback.fromValue(playback);
    }

    /**
     * Specify whether your motion graphic overlay repeats on a loop or plays only once.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #playback} will
     * return {@link MotionImagePlayback#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #playbackAsString}.
     * </p>
     * 
     * @return Specify whether your motion graphic overlay repeats on a loop or plays only once.
     * @see MotionImagePlayback
     */
    public final String playbackAsString() {
        return playback;
    }

    /**
     * Specify when the motion overlay begins. Use timecode format (HH:MM:SS:FF or HH:MM:SS;FF). Make sure that the
     * timecode you provide here takes into account how you have set up your timecode configuration under both job
     * settings and input settings. The simplest way to do that is to set both to start at 0. If you need to set up your
     * job to follow timecodes embedded in your source that don't start at zero, make sure that you specify a start time
     * that is after the first embedded timecode. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/setting-up-timecode.html Find job-wide and input timecode
     * configuration settings in your JSON job settings specification at settings>timecodeConfig>source and
     * settings>inputs>timecodeSource.
     * 
     * @return Specify when the motion overlay begins. Use timecode format (HH:MM:SS:FF or HH:MM:SS;FF). Make sure that
     *         the timecode you provide here takes into account how you have set up your timecode configuration under
     *         both job settings and input settings. The simplest way to do that is to set both to start at 0. If you
     *         need to set up your job to follow timecodes embedded in your source that don't start at zero, make sure
     *         that you specify a start time that is after the first embedded timecode. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/setting-up-timecode.html Find job-wide and input
     *         timecode configuration settings in your JSON job settings specification at settings>timecodeConfig>source
     *         and settings>inputs>timecodeSource.
     */
    public final String startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(framerate());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(insertionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        hashCode = 31 * hashCode + Objects.hashCode(playbackAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MotionImageInserter)) {
            return false;
        }
        MotionImageInserter other = (MotionImageInserter) obj;
        return Objects.equals(framerate(), other.framerate()) && Objects.equals(input(), other.input())
                && Objects.equals(insertionModeAsString(), other.insertionModeAsString())
                && Objects.equals(offset(), other.offset()) && Objects.equals(playbackAsString(), other.playbackAsString())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MotionImageInserter").add("Framerate", framerate()).add("Input", input())
                .add("InsertionMode", insertionModeAsString()).add("Offset", offset()).add("Playback", playbackAsString())
                .add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Framerate":
            return Optional.ofNullable(clazz.cast(framerate()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "InsertionMode":
            return Optional.ofNullable(clazz.cast(insertionModeAsString()));
        case "Offset":
            return Optional.ofNullable(clazz.cast(offset()));
        case "Playback":
            return Optional.ofNullable(clazz.cast(playbackAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MotionImageInserter, T> g) {
        return obj -> g.apply((MotionImageInserter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MotionImageInserter> {
        /**
         * If your motion graphic asset is a .mov file, keep this setting unspecified. If your motion graphic asset is a
         * series of .png files, specify the frame rate of the overlay in frames per second, as a fraction. For example,
         * specify 24 fps as 24/1. Make sure that the number of images in your series matches the frame rate and your
         * intended overlay duration. For example, if you want a 30-second overlay at 30 fps, you should have 900 .png
         * images. This overlay frame rate doesn't need to match the frame rate of the underlying video.
         * 
         * @param framerate
         *        If your motion graphic asset is a .mov file, keep this setting unspecified. If your motion graphic
         *        asset is a series of .png files, specify the frame rate of the overlay in frames per second, as a
         *        fraction. For example, specify 24 fps as 24/1. Make sure that the number of images in your series
         *        matches the frame rate and your intended overlay duration. For example, if you want a 30-second
         *        overlay at 30 fps, you should have 900 .png images. This overlay frame rate doesn't need to match the
         *        frame rate of the underlying video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerate(MotionImageInsertionFramerate framerate);

        /**
         * If your motion graphic asset is a .mov file, keep this setting unspecified. If your motion graphic asset is a
         * series of .png files, specify the frame rate of the overlay in frames per second, as a fraction. For example,
         * specify 24 fps as 24/1. Make sure that the number of images in your series matches the frame rate and your
         * intended overlay duration. For example, if you want a 30-second overlay at 30 fps, you should have 900 .png
         * images. This overlay frame rate doesn't need to match the frame rate of the underlying video. This is a
         * convenience that creates an instance of the {@link MotionImageInsertionFramerate.Builder} avoiding the need
         * to create one manually via {@link MotionImageInsertionFramerate#builder()}.
         *
         * When the {@link Consumer} completes, {@link MotionImageInsertionFramerate.Builder#build()} is called
         * immediately and its result is passed to {@link #framerate(MotionImageInsertionFramerate)}.
         * 
         * @param framerate
         *        a consumer that will call methods on {@link MotionImageInsertionFramerate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #framerate(MotionImageInsertionFramerate)
         */
        default Builder framerate(Consumer<MotionImageInsertionFramerate.Builder> framerate) {
            return framerate(MotionImageInsertionFramerate.builder().applyMutation(framerate).build());
        }

        /**
         * Specify the .mov file or series of .png files that you want to overlay on your video. For .png files, provide
         * the file name of the first file in the series. Make sure that the names of the .png files end with sequential
         * numbers that specify the order that they are played in. For example, overlay_000.png, overlay_001.png,
         * overlay_002.png, and so on. The sequence must start at zero, and each image file name must have the same
         * number of digits. Pad your initial file names with enough zeros to complete the sequence. For example, if the
         * first image is overlay_0.png, there can be only 10 images in the sequence, with the last image being
         * overlay_9.png. But if the first image is overlay_00.png, there can be 100 images in the sequence.
         * 
         * @param input
         *        Specify the .mov file or series of .png files that you want to overlay on your video. For .png files,
         *        provide the file name of the first file in the series. Make sure that the names of the .png files end
         *        with sequential numbers that specify the order that they are played in. For example, overlay_000.png,
         *        overlay_001.png, overlay_002.png, and so on. The sequence must start at zero, and each image file name
         *        must have the same number of digits. Pad your initial file names with enough zeros to complete the
         *        sequence. For example, if the first image is overlay_0.png, there can be only 10 images in the
         *        sequence, with the last image being overlay_9.png. But if the first image is overlay_00.png, there can
         *        be 100 images in the sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * Choose the type of motion graphic asset that you are providing for your overlay. You can choose either a .mov
         * file or a series of .png files.
         * 
         * @param insertionMode
         *        Choose the type of motion graphic asset that you are providing for your overlay. You can choose either
         *        a .mov file or a series of .png files.
         * @see MotionImageInsertionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MotionImageInsertionMode
         */
        Builder insertionMode(String insertionMode);

        /**
         * Choose the type of motion graphic asset that you are providing for your overlay. You can choose either a .mov
         * file or a series of .png files.
         * 
         * @param insertionMode
         *        Choose the type of motion graphic asset that you are providing for your overlay. You can choose either
         *        a .mov file or a series of .png files.
         * @see MotionImageInsertionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MotionImageInsertionMode
         */
        Builder insertionMode(MotionImageInsertionMode insertionMode);

        /**
         * Use Offset to specify the placement of your motion graphic overlay on the video frame. Specify in pixels,
         * from the upper-left corner of the frame. If you don't specify an offset, the service scales your overlay to
         * the full size of the frame. Otherwise, the service inserts the overlay at its native resolution and scales
         * the size up or down with any video scaling.
         * 
         * @param offset
         *        Use Offset to specify the placement of your motion graphic overlay on the video frame. Specify in
         *        pixels, from the upper-left corner of the frame. If you don't specify an offset, the service scales
         *        your overlay to the full size of the frame. Otherwise, the service inserts the overlay at its native
         *        resolution and scales the size up or down with any video scaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(MotionImageInsertionOffset offset);

        /**
         * Use Offset to specify the placement of your motion graphic overlay on the video frame. Specify in pixels,
         * from the upper-left corner of the frame. If you don't specify an offset, the service scales your overlay to
         * the full size of the frame. Otherwise, the service inserts the overlay at its native resolution and scales
         * the size up or down with any video scaling. This is a convenience that creates an instance of the
         * {@link MotionImageInsertionOffset.Builder} avoiding the need to create one manually via
         * {@link MotionImageInsertionOffset#builder()}.
         *
         * When the {@link Consumer} completes, {@link MotionImageInsertionOffset.Builder#build()} is called immediately
         * and its result is passed to {@link #offset(MotionImageInsertionOffset)}.
         * 
         * @param offset
         *        a consumer that will call methods on {@link MotionImageInsertionOffset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offset(MotionImageInsertionOffset)
         */
        default Builder offset(Consumer<MotionImageInsertionOffset.Builder> offset) {
            return offset(MotionImageInsertionOffset.builder().applyMutation(offset).build());
        }

        /**
         * Specify whether your motion graphic overlay repeats on a loop or plays only once.
         * 
         * @param playback
         *        Specify whether your motion graphic overlay repeats on a loop or plays only once.
         * @see MotionImagePlayback
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MotionImagePlayback
         */
        Builder playback(String playback);

        /**
         * Specify whether your motion graphic overlay repeats on a loop or plays only once.
         * 
         * @param playback
         *        Specify whether your motion graphic overlay repeats on a loop or plays only once.
         * @see MotionImagePlayback
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MotionImagePlayback
         */
        Builder playback(MotionImagePlayback playback);

        /**
         * Specify when the motion overlay begins. Use timecode format (HH:MM:SS:FF or HH:MM:SS;FF). Make sure that the
         * timecode you provide here takes into account how you have set up your timecode configuration under both job
         * settings and input settings. The simplest way to do that is to set both to start at 0. If you need to set up
         * your job to follow timecodes embedded in your source that don't start at zero, make sure that you specify a
         * start time that is after the first embedded timecode. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/setting-up-timecode.html Find job-wide and input timecode
         * configuration settings in your JSON job settings specification at settings>timecodeConfig>source and
         * settings>inputs>timecodeSource.
         * 
         * @param startTime
         *        Specify when the motion overlay begins. Use timecode format (HH:MM:SS:FF or HH:MM:SS;FF). Make sure
         *        that the timecode you provide here takes into account how you have set up your timecode configuration
         *        under both job settings and input settings. The simplest way to do that is to set both to start at 0.
         *        If you need to set up your job to follow timecodes embedded in your source that don't start at zero,
         *        make sure that you specify a start time that is after the first embedded timecode. For more
         *        information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/setting-up-timecode.html Find
         *        job-wide and input timecode configuration settings in your JSON job settings specification at
         *        settings>timecodeConfig>source and settings>inputs>timecodeSource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);
    }

    static final class BuilderImpl implements Builder {
        private MotionImageInsertionFramerate framerate;

        private String input;

        private String insertionMode;

        private MotionImageInsertionOffset offset;

        private String playback;

        private String startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MotionImageInserter model) {
            framerate(model.framerate);
            input(model.input);
            insertionMode(model.insertionMode);
            offset(model.offset);
            playback(model.playback);
            startTime(model.startTime);
        }

        public final MotionImageInsertionFramerate.Builder getFramerate() {
            return framerate != null ? framerate.toBuilder() : null;
        }

        @Override
        public final Builder framerate(MotionImageInsertionFramerate framerate) {
            this.framerate = framerate;
            return this;
        }

        public final void setFramerate(MotionImageInsertionFramerate.BuilderImpl framerate) {
            this.framerate = framerate != null ? framerate.build() : null;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getInsertionMode() {
            return insertionMode;
        }

        @Override
        public final Builder insertionMode(String insertionMode) {
            this.insertionMode = insertionMode;
            return this;
        }

        @Override
        public final Builder insertionMode(MotionImageInsertionMode insertionMode) {
            this.insertionMode(insertionMode == null ? null : insertionMode.toString());
            return this;
        }

        public final void setInsertionMode(String insertionMode) {
            this.insertionMode = insertionMode;
        }

        public final MotionImageInsertionOffset.Builder getOffset() {
            return offset != null ? offset.toBuilder() : null;
        }

        @Override
        public final Builder offset(MotionImageInsertionOffset offset) {
            this.offset = offset;
            return this;
        }

        public final void setOffset(MotionImageInsertionOffset.BuilderImpl offset) {
            this.offset = offset != null ? offset.build() : null;
        }

        public final String getPlayback() {
            return playback;
        }

        @Override
        public final Builder playback(String playback) {
            this.playback = playback;
            return this;
        }

        @Override
        public final Builder playback(MotionImagePlayback playback) {
            this.playback(playback == null ? null : playback.toString());
            return this;
        }

        public final void setPlayback(String playback) {
            this.playback = playback;
        }

        public final String getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public MotionImageInserter build() {
            return new MotionImageInserter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
