/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobTemplate implements SdkPojo, Serializable, ToCopyableBuilder<JobTemplate.Builder, JobTemplate> {
    private static final SdkField<AccelerationSettings> ACCELERATION_SETTINGS_FIELD = SdkField
            .<AccelerationSettings> builder(MarshallingType.SDK_POJO).memberName("AccelerationSettings")
            .getter(getter(JobTemplate::accelerationSettings)).setter(setter(Builder::accelerationSettings))
            .constructor(AccelerationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerationSettings").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(JobTemplate::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(JobTemplate::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(JobTemplate::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(JobTemplate::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<HopDestination>> HOP_DESTINATIONS_FIELD = SdkField
            .<List<HopDestination>> builder(MarshallingType.LIST)
            .memberName("HopDestinations")
            .getter(getter(JobTemplate::hopDestinations))
            .setter(setter(Builder::hopDestinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hopDestinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HopDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(HopDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated")
            .getter(getter(JobTemplate::lastUpdated))
            .setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(JobTemplate::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(JobTemplate::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Queue")
            .getter(getter(JobTemplate::queue)).setter(setter(Builder::queue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()).build();

    private static final SdkField<JobTemplateSettings> SETTINGS_FIELD = SdkField
            .<JobTemplateSettings> builder(MarshallingType.SDK_POJO).memberName("Settings").getter(getter(JobTemplate::settings))
            .setter(setter(Builder::settings)).constructor(JobTemplateSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()).build();

    private static final SdkField<String> STATUS_UPDATE_INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusUpdateInterval").getter(getter(JobTemplate::statusUpdateIntervalAsString))
            .setter(setter(Builder::statusUpdateInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusUpdateInterval").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(JobTemplate::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATION_SETTINGS_FIELD,
            ARN_FIELD, CATEGORY_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, HOP_DESTINATIONS_FIELD, LAST_UPDATED_FIELD,
            NAME_FIELD, PRIORITY_FIELD, QUEUE_FIELD, SETTINGS_FIELD, STATUS_UPDATE_INTERVAL_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AccelerationSettings accelerationSettings;

    private final String arn;

    private final String category;

    private final Instant createdAt;

    private final String description;

    private final List<HopDestination> hopDestinations;

    private final Instant lastUpdated;

    private final String name;

    private final Integer priority;

    private final String queue;

    private final JobTemplateSettings settings;

    private final String statusUpdateInterval;

    private final String type;

    private JobTemplate(BuilderImpl builder) {
        this.accelerationSettings = builder.accelerationSettings;
        this.arn = builder.arn;
        this.category = builder.category;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.hopDestinations = builder.hopDestinations;
        this.lastUpdated = builder.lastUpdated;
        this.name = builder.name;
        this.priority = builder.priority;
        this.queue = builder.queue;
        this.settings = builder.settings;
        this.statusUpdateInterval = builder.statusUpdateInterval;
        this.type = builder.type;
    }

    /**
     * Accelerated transcoding can significantly speed up jobs with long, visually complex content.
     * 
     * @return Accelerated transcoding can significantly speed up jobs with long, visually complex content.
     */
    public final AccelerationSettings accelerationSettings() {
        return accelerationSettings;
    }

    /**
     * An identifier for this resource that is unique within all of AWS.
     * 
     * @return An identifier for this resource that is unique within all of AWS.
     */
    public final String arn() {
        return arn;
    }

    /**
     * An optional category you create to organize your job templates.
     * 
     * @return An optional category you create to organize your job templates.
     */
    public final String category() {
        return category;
    }

    /**
     * The timestamp in epoch seconds for Job template creation.
     * 
     * @return The timestamp in epoch seconds for Job template creation.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * An optional description you create for each job template.
     * 
     * @return An optional description you create for each job template.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the HopDestinations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasHopDestinations() {
        return hopDestinations != null && !(hopDestinations instanceof SdkAutoConstructList);
    }

    /**
     * Optional list of hop destinations.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHopDestinations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional list of hop destinations.
     */
    public final List<HopDestination> hopDestinations() {
        return hopDestinations;
    }

    /**
     * The timestamp in epoch seconds when the Job template was last updated.
     * 
     * @return The timestamp in epoch seconds when the Job template was last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * A name you create for each job template. Each name must be unique within your account.
     * 
     * @return A name you create for each job template. Each name must be unique within your account.
     */
    public final String name() {
        return name;
    }

    /**
     * Relative priority on the job.
     * 
     * @return Relative priority on the job.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * Optional. The queue that jobs created from this template are assigned to. If you don't specify this, jobs will go
     * to the default queue.
     * 
     * @return Optional. The queue that jobs created from this template are assigned to. If you don't specify this, jobs
     *         will go to the default queue.
     */
    public final String queue() {
        return queue;
    }

    /**
     * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs
     * created from it.
     * 
     * @return JobTemplateSettings contains all the transcode settings saved in the template that will be applied to
     *         jobs created from it.
     */
    public final JobTemplateSettings settings() {
        return settings;
    }

    /**
     * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in
     * seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins
     * processing your job to the time it completes the transcode or encounters an error.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #statusUpdateInterval} will return {@link StatusUpdateInterval#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #statusUpdateIntervalAsString}.
     * </p>
     * 
     * @return Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval,
     *         in seconds, between status updates. MediaConvert sends an update at this interval from the time the
     *         service begins processing your job to the time it completes the transcode or encounters an error.
     * @see StatusUpdateInterval
     */
    public final StatusUpdateInterval statusUpdateInterval() {
        return StatusUpdateInterval.fromValue(statusUpdateInterval);
    }

    /**
     * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in
     * seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins
     * processing your job to the time it completes the transcode or encounters an error.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #statusUpdateInterval} will return {@link StatusUpdateInterval#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #statusUpdateIntervalAsString}.
     * </p>
     * 
     * @return Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval,
     *         in seconds, between status updates. MediaConvert sends an update at this interval from the time the
     *         service begins processing your job to the time it completes the transcode or encounters an error.
     * @see StatusUpdateInterval
     */
    public final String statusUpdateIntervalAsString() {
        return statusUpdateInterval;
    }

    /**
     * A job template can be of two types: system or custom. System or built-in job templates can't be modified or
     * deleted by the user.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return A job template can be of two types: system or custom. System or built-in job templates can't be modified
     *         or deleted by the user.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * A job template can be of two types: system or custom. System or built-in job templates can't be modified or
     * deleted by the user.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return A job template can be of two types: system or custom. System or built-in job templates can't be modified
     *         or deleted by the user.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accelerationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasHopDestinations() ? hopDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(queue());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(statusUpdateIntervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobTemplate)) {
            return false;
        }
        JobTemplate other = (JobTemplate) obj;
        return Objects.equals(accelerationSettings(), other.accelerationSettings()) && Objects.equals(arn(), other.arn())
                && Objects.equals(category(), other.category()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(description(), other.description()) && hasHopDestinations() == other.hasHopDestinations()
                && Objects.equals(hopDestinations(), other.hopDestinations())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(name(), other.name())
                && Objects.equals(priority(), other.priority()) && Objects.equals(queue(), other.queue())
                && Objects.equals(settings(), other.settings())
                && Objects.equals(statusUpdateIntervalAsString(), other.statusUpdateIntervalAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobTemplate").add("AccelerationSettings", accelerationSettings()).add("Arn", arn())
                .add("Category", category()).add("CreatedAt", createdAt()).add("Description", description())
                .add("HopDestinations", hasHopDestinations() ? hopDestinations() : null).add("LastUpdated", lastUpdated())
                .add("Name", name()).add("Priority", priority()).add("Queue", queue()).add("Settings", settings())
                .add("StatusUpdateInterval", statusUpdateIntervalAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccelerationSettings":
            return Optional.ofNullable(clazz.cast(accelerationSettings()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HopDestinations":
            return Optional.ofNullable(clazz.cast(hopDestinations()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Queue":
            return Optional.ofNullable(clazz.cast(queue()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "StatusUpdateInterval":
            return Optional.ofNullable(clazz.cast(statusUpdateIntervalAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobTemplate, T> g) {
        return obj -> g.apply((JobTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobTemplate> {
        /**
         * Accelerated transcoding can significantly speed up jobs with long, visually complex content.
         * 
         * @param accelerationSettings
         *        Accelerated transcoding can significantly speed up jobs with long, visually complex content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerationSettings(AccelerationSettings accelerationSettings);

        /**
         * Accelerated transcoding can significantly speed up jobs with long, visually complex content. This is a
         * convenience that creates an instance of the {@link AccelerationSettings.Builder} avoiding the need to create
         * one manually via {@link AccelerationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccelerationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #accelerationSettings(AccelerationSettings)}.
         * 
         * @param accelerationSettings
         *        a consumer that will call methods on {@link AccelerationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accelerationSettings(AccelerationSettings)
         */
        default Builder accelerationSettings(Consumer<AccelerationSettings.Builder> accelerationSettings) {
            return accelerationSettings(AccelerationSettings.builder().applyMutation(accelerationSettings).build());
        }

        /**
         * An identifier for this resource that is unique within all of AWS.
         * 
         * @param arn
         *        An identifier for this resource that is unique within all of AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * An optional category you create to organize your job templates.
         * 
         * @param category
         *        An optional category you create to organize your job templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * The timestamp in epoch seconds for Job template creation.
         * 
         * @param createdAt
         *        The timestamp in epoch seconds for Job template creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * An optional description you create for each job template.
         * 
         * @param description
         *        An optional description you create for each job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Optional list of hop destinations.
         * 
         * @param hopDestinations
         *        Optional list of hop destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hopDestinations(Collection<HopDestination> hopDestinations);

        /**
         * Optional list of hop destinations.
         * 
         * @param hopDestinations
         *        Optional list of hop destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hopDestinations(HopDestination... hopDestinations);

        /**
         * Optional list of hop destinations. This is a convenience that creates an instance of the {@link List
         * <HopDestination>.Builder} avoiding the need to create one manually via {@link List<HopDestination>#builder()}
         * .
         *
         * When the {@link Consumer} completes, {@link List<HopDestination>.Builder#build()} is called immediately and
         * its result is passed to {@link #hopDestinations(List<HopDestination>)}.
         * 
         * @param hopDestinations
         *        a consumer that will call methods on {@link List<HopDestination>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hopDestinations(List<HopDestination>)
         */
        Builder hopDestinations(Consumer<HopDestination.Builder>... hopDestinations);

        /**
         * The timestamp in epoch seconds when the Job template was last updated.
         * 
         * @param lastUpdated
         *        The timestamp in epoch seconds when the Job template was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * A name you create for each job template. Each name must be unique within your account.
         * 
         * @param name
         *        A name you create for each job template. Each name must be unique within your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Relative priority on the job.
         * 
         * @param priority
         *        Relative priority on the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * Optional. The queue that jobs created from this template are assigned to. If you don't specify this, jobs
         * will go to the default queue.
         * 
         * @param queue
         *        Optional. The queue that jobs created from this template are assigned to. If you don't specify this,
         *        jobs will go to the default queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queue(String queue);

        /**
         * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs
         * created from it.
         * 
         * @param settings
         *        JobTemplateSettings contains all the transcode settings saved in the template that will be applied to
         *        jobs created from it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(JobTemplateSettings settings);

        /**
         * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs
         * created from it. This is a convenience that creates an instance of the {@link JobTemplateSettings.Builder}
         * avoiding the need to create one manually via {@link JobTemplateSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobTemplateSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #settings(JobTemplateSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link JobTemplateSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(JobTemplateSettings)
         */
        default Builder settings(Consumer<JobTemplateSettings.Builder> settings) {
            return settings(JobTemplateSettings.builder().applyMutation(settings).build());
        }

        /**
         * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in
         * seconds, between status updates. MediaConvert sends an update at this interval from the time the service
         * begins processing your job to the time it completes the transcode or encounters an error.
         * 
         * @param statusUpdateInterval
         *        Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the
         *        interval, in seconds, between status updates. MediaConvert sends an update at this interval from the
         *        time the service begins processing your job to the time it completes the transcode or encounters an
         *        error.
         * @see StatusUpdateInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusUpdateInterval
         */
        Builder statusUpdateInterval(String statusUpdateInterval);

        /**
         * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in
         * seconds, between status updates. MediaConvert sends an update at this interval from the time the service
         * begins processing your job to the time it completes the transcode or encounters an error.
         * 
         * @param statusUpdateInterval
         *        Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the
         *        interval, in seconds, between status updates. MediaConvert sends an update at this interval from the
         *        time the service begins processing your job to the time it completes the transcode or encounters an
         *        error.
         * @see StatusUpdateInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusUpdateInterval
         */
        Builder statusUpdateInterval(StatusUpdateInterval statusUpdateInterval);

        /**
         * A job template can be of two types: system or custom. System or built-in job templates can't be modified or
         * deleted by the user.
         * 
         * @param type
         *        A job template can be of two types: system or custom. System or built-in job templates can't be
         *        modified or deleted by the user.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * A job template can be of two types: system or custom. System or built-in job templates can't be modified or
         * deleted by the user.
         * 
         * @param type
         *        A job template can be of two types: system or custom. System or built-in job templates can't be
         *        modified or deleted by the user.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);
    }

    static final class BuilderImpl implements Builder {
        private AccelerationSettings accelerationSettings;

        private String arn;

        private String category;

        private Instant createdAt;

        private String description;

        private List<HopDestination> hopDestinations = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdated;

        private String name;

        private Integer priority;

        private String queue;

        private JobTemplateSettings settings;

        private String statusUpdateInterval;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(JobTemplate model) {
            accelerationSettings(model.accelerationSettings);
            arn(model.arn);
            category(model.category);
            createdAt(model.createdAt);
            description(model.description);
            hopDestinations(model.hopDestinations);
            lastUpdated(model.lastUpdated);
            name(model.name);
            priority(model.priority);
            queue(model.queue);
            settings(model.settings);
            statusUpdateInterval(model.statusUpdateInterval);
            type(model.type);
        }

        public final AccelerationSettings.Builder getAccelerationSettings() {
            return accelerationSettings != null ? accelerationSettings.toBuilder() : null;
        }

        @Override
        public final Builder accelerationSettings(AccelerationSettings accelerationSettings) {
            this.accelerationSettings = accelerationSettings;
            return this;
        }

        public final void setAccelerationSettings(AccelerationSettings.BuilderImpl accelerationSettings) {
            this.accelerationSettings = accelerationSettings != null ? accelerationSettings.build() : null;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCategory() {
            return category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<HopDestination.Builder> getHopDestinations() {
            if (hopDestinations instanceof SdkAutoConstructList) {
                return null;
            }
            return hopDestinations != null ? hopDestinations.stream().map(HopDestination::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder hopDestinations(Collection<HopDestination> hopDestinations) {
            this.hopDestinations = ___listOfHopDestinationCopier.copy(hopDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hopDestinations(HopDestination... hopDestinations) {
            hopDestinations(Arrays.asList(hopDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hopDestinations(Consumer<HopDestination.Builder>... hopDestinations) {
            hopDestinations(Stream.of(hopDestinations).map(c -> HopDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHopDestinations(Collection<HopDestination.BuilderImpl> hopDestinations) {
            this.hopDestinations = ___listOfHopDestinationCopier.copyFromBuilder(hopDestinations);
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getQueue() {
            return queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        public final JobTemplateSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(JobTemplateSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(JobTemplateSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final String getStatusUpdateInterval() {
            return statusUpdateInterval;
        }

        @Override
        public final Builder statusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
            return this;
        }

        @Override
        public final Builder statusUpdateInterval(StatusUpdateInterval statusUpdateInterval) {
            this.statusUpdateInterval(statusUpdateInterval == null ? null : statusUpdateInterval.toString());
            return this;
        }

        public final void setStatusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public JobTemplate build() {
            return new JobTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
