/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Optional. Configuration for a destination queue to which the job can hop once a customer-defined minimum wait time
 * has passed.
 */
@Generated("software.amazon.awssdk:codegen")
public final class HopDestination implements SdkPojo, Serializable, ToCopyableBuilder<HopDestination.Builder, HopDestination> {
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(HopDestination::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Queue")
            .getter(getter(HopDestination::queue)).setter(setter(Builder::queue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()).build();

    private static final SdkField<Integer> WAIT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WaitMinutes").getter(getter(HopDestination::waitMinutes)).setter(setter(Builder::waitMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waitMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIORITY_FIELD, QUEUE_FIELD,
            WAIT_MINUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer priority;

    private final String queue;

    private final Integer waitMinutes;

    private HopDestination(BuilderImpl builder) {
        this.priority = builder.priority;
        this.queue = builder.queue;
        this.waitMinutes = builder.waitMinutes;
    }

    /**
     * Optional. When you set up a job to use queue hopping, you can specify a different relative priority for the job
     * in the destination queue. If you don't specify, the relative priority will remain the same as in the previous
     * queue.
     * 
     * @return Optional. When you set up a job to use queue hopping, you can specify a different relative priority for
     *         the job in the destination queue. If you don't specify, the relative priority will remain the same as in
     *         the previous queue.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * Optional unless the job is submitted on the default queue. When you set up a job to use queue hopping, you can
     * specify a destination queue. This queue cannot be the original queue to which the job is submitted. If the
     * original queue isn't the default queue and you don't specify the destination queue, the job will move to the
     * default queue.
     * 
     * @return Optional unless the job is submitted on the default queue. When you set up a job to use queue hopping,
     *         you can specify a destination queue. This queue cannot be the original queue to which the job is
     *         submitted. If the original queue isn't the default queue and you don't specify the destination queue, the
     *         job will move to the default queue.
     */
    public final String queue() {
        return queue;
    }

    /**
     * Required for setting up a job to use queue hopping. Minimum wait time in minutes until the job can hop to the
     * destination queue. Valid range is 1 to 1440 minutes, inclusive.
     * 
     * @return Required for setting up a job to use queue hopping. Minimum wait time in minutes until the job can hop to
     *         the destination queue. Valid range is 1 to 1440 minutes, inclusive.
     */
    public final Integer waitMinutes() {
        return waitMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(queue());
        hashCode = 31 * hashCode + Objects.hashCode(waitMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HopDestination)) {
            return false;
        }
        HopDestination other = (HopDestination) obj;
        return Objects.equals(priority(), other.priority()) && Objects.equals(queue(), other.queue())
                && Objects.equals(waitMinutes(), other.waitMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HopDestination").add("Priority", priority()).add("Queue", queue())
                .add("WaitMinutes", waitMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Queue":
            return Optional.ofNullable(clazz.cast(queue()));
        case "WaitMinutes":
            return Optional.ofNullable(clazz.cast(waitMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HopDestination, T> g) {
        return obj -> g.apply((HopDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HopDestination> {
        /**
         * Optional. When you set up a job to use queue hopping, you can specify a different relative priority for the
         * job in the destination queue. If you don't specify, the relative priority will remain the same as in the
         * previous queue.
         * 
         * @param priority
         *        Optional. When you set up a job to use queue hopping, you can specify a different relative priority
         *        for the job in the destination queue. If you don't specify, the relative priority will remain the same
         *        as in the previous queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * Optional unless the job is submitted on the default queue. When you set up a job to use queue hopping, you
         * can specify a destination queue. This queue cannot be the original queue to which the job is submitted. If
         * the original queue isn't the default queue and you don't specify the destination queue, the job will move to
         * the default queue.
         * 
         * @param queue
         *        Optional unless the job is submitted on the default queue. When you set up a job to use queue hopping,
         *        you can specify a destination queue. This queue cannot be the original queue to which the job is
         *        submitted. If the original queue isn't the default queue and you don't specify the destination queue,
         *        the job will move to the default queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queue(String queue);

        /**
         * Required for setting up a job to use queue hopping. Minimum wait time in minutes until the job can hop to the
         * destination queue. Valid range is 1 to 1440 minutes, inclusive.
         * 
         * @param waitMinutes
         *        Required for setting up a job to use queue hopping. Minimum wait time in minutes until the job can hop
         *        to the destination queue. Valid range is 1 to 1440 minutes, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitMinutes(Integer waitMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Integer priority;

        private String queue;

        private Integer waitMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(HopDestination model) {
            priority(model.priority);
            queue(model.queue);
            waitMinutes(model.waitMinutes);
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getQueue() {
            return queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        public final Integer getWaitMinutes() {
            return waitMinutes;
        }

        @Override
        public final Builder waitMinutes(Integer waitMinutes) {
            this.waitMinutes = waitMinutes;
            return this;
        }

        public final void setWaitMinutes(Integer waitMinutes) {
            this.waitMinutes = waitMinutes;
        }

        @Override
        public HopDestination build() {
            return new HopDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
