/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for H265 codec
 */
@Generated("software.amazon.awssdk:codegen")
public final class H265Settings implements SdkPojo, Serializable, ToCopyableBuilder<H265Settings.Builder, H265Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdaptiveQuantization").getter(getter(H265Settings::adaptiveQuantizationAsString))
            .setter(setter(Builder::adaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build())
            .build();

    private static final SdkField<String> ALTERNATE_TRANSFER_FUNCTION_SEI_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AlternateTransferFunctionSei")
            .getter(getter(H265Settings::alternateTransferFunctionSeiAsString))
            .setter(setter(Builder::alternateTransferFunctionSei))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternateTransferFunctionSei")
                    .build()).build();

    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Bitrate").getter(getter(H265Settings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> CODEC_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodecLevel").getter(getter(H265Settings::codecLevelAsString)).setter(setter(Builder::codecLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecLevel").build()).build();

    private static final SdkField<String> CODEC_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodecProfile").getter(getter(H265Settings::codecProfileAsString)).setter(setter(Builder::codecProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecProfile").build()).build();

    private static final SdkField<String> DYNAMIC_SUB_GOP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DynamicSubGop").getter(getter(H265Settings::dynamicSubGopAsString))
            .setter(setter(Builder::dynamicSubGop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicSubGop").build()).build();

    private static final SdkField<String> FLICKER_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FlickerAdaptiveQuantization")
            .getter(getter(H265Settings::flickerAdaptiveQuantizationAsString))
            .setter(setter(Builder::flickerAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flickerAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FramerateControl").getter(getter(H265Settings::framerateControlAsString))
            .setter(setter(Builder::framerateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()).build();

    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FramerateConversionAlgorithm")
            .getter(getter(H265Settings::framerateConversionAlgorithmAsString))
            .setter(setter(Builder::framerateConversionAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm")
                    .build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(H265Settings::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(H265Settings::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<String> GOP_B_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GopBReference").getter(getter(H265Settings::gopBReferenceAsString))
            .setter(setter(Builder::gopBReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopBReference").build()).build();

    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GopClosedCadence").getter(getter(H265Settings::gopClosedCadence))
            .setter(setter(Builder::gopClosedCadence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()).build();

    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("GopSize").getter(getter(H265Settings::gopSize)).setter(setter(Builder::gopSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()).build();

    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GopSizeUnits").getter(getter(H265Settings::gopSizeUnitsAsString)).setter(setter(Builder::gopSizeUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()).build();

    private static final SdkField<Integer> HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("HrdBufferInitialFillPercentage")
            .getter(getter(H265Settings::hrdBufferInitialFillPercentage))
            .setter(setter(Builder::hrdBufferInitialFillPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferInitialFillPercentage")
                    .build()).build();

    private static final SdkField<Integer> HRD_BUFFER_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HrdBufferSize").getter(getter(H265Settings::hrdBufferSize)).setter(setter(Builder::hrdBufferSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferSize").build()).build();

    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InterlaceMode").getter(getter(H265Settings::interlaceModeAsString))
            .setter(setter(Builder::interlaceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(H265Settings::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinIInterval").getter(getter(H265Settings::minIInterval)).setter(setter(Builder::minIInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()).build();

    private static final SdkField<Integer> NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberBFramesBetweenReferenceFrames")
            .getter(getter(H265Settings::numberBFramesBetweenReferenceFrames))
            .setter(setter(Builder::numberBFramesBetweenReferenceFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("numberBFramesBetweenReferenceFrames").build()).build();

    private static final SdkField<Integer> NUMBER_REFERENCE_FRAMES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberReferenceFrames").getter(getter(H265Settings::numberReferenceFrames))
            .setter(setter(Builder::numberReferenceFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberReferenceFrames").build())
            .build();

    private static final SdkField<String> PAR_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParControl").getter(getter(H265Settings::parControlAsString)).setter(setter(Builder::parControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parControl").build()).build();

    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParDenominator").getter(getter(H265Settings::parDenominator)).setter(setter(Builder::parDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()).build();

    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParNumerator").getter(getter(H265Settings::parNumerator)).setter(setter(Builder::parNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()).build();

    private static final SdkField<String> QUALITY_TUNING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualityTuningLevel").getter(getter(H265Settings::qualityTuningLevelAsString))
            .setter(setter(Builder::qualityTuningLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityTuningLevel").build())
            .build();

    private static final SdkField<H265QvbrSettings> QVBR_SETTINGS_FIELD = SdkField
            .<H265QvbrSettings> builder(MarshallingType.SDK_POJO).memberName("QvbrSettings")
            .getter(getter(H265Settings::qvbrSettings)).setter(setter(Builder::qvbrSettings))
            .constructor(H265QvbrSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrSettings").build()).build();

    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RateControlMode").getter(getter(H265Settings::rateControlModeAsString))
            .setter(setter(Builder::rateControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()).build();

    private static final SdkField<String> SAMPLE_ADAPTIVE_OFFSET_FILTER_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SampleAdaptiveOffsetFilterMode")
            .getter(getter(H265Settings::sampleAdaptiveOffsetFilterModeAsString))
            .setter(setter(Builder::sampleAdaptiveOffsetFilterMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleAdaptiveOffsetFilterMode")
                    .build()).build();

    private static final SdkField<String> SCAN_TYPE_CONVERSION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanTypeConversionMode").getter(getter(H265Settings::scanTypeConversionModeAsString))
            .setter(setter(Builder::scanTypeConversionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanTypeConversionMode").build())
            .build();

    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SceneChangeDetect").getter(getter(H265Settings::sceneChangeDetectAsString))
            .setter(setter(Builder::sceneChangeDetect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()).build();

    private static final SdkField<Integer> SLICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Slices").getter(getter(H265Settings::slices)).setter(setter(Builder::slices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()).build();

    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlowPal").getter(getter(H265Settings::slowPalAsString)).setter(setter(Builder::slowPal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()).build();

    private static final SdkField<String> SPATIAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpatialAdaptiveQuantization")
            .getter(getter(H265Settings::spatialAdaptiveQuantizationAsString))
            .setter(setter(Builder::spatialAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<String> TELECINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Telecine").getter(getter(H265Settings::telecineAsString)).setter(setter(Builder::telecine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()).build();

    private static final SdkField<String> TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TemporalAdaptiveQuantization")
            .getter(getter(H265Settings::temporalAdaptiveQuantizationAsString))
            .setter(setter(Builder::temporalAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<String> TEMPORAL_IDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemporalIds").getter(getter(H265Settings::temporalIdsAsString)).setter(setter(Builder::temporalIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalIds").build()).build();

    private static final SdkField<String> TILES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tiles")
            .getter(getter(H265Settings::tilesAsString)).setter(setter(Builder::tiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tiles").build()).build();

    private static final SdkField<String> UNREGISTERED_SEI_TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnregisteredSeiTimecode").getter(getter(H265Settings::unregisteredSeiTimecodeAsString))
            .setter(setter(Builder::unregisteredSeiTimecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unregisteredSeiTimecode").build())
            .build();

    private static final SdkField<String> WRITE_MP4_PACKAGING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WriteMp4PackagingType").getter(getter(H265Settings::writeMp4PackagingTypeAsString))
            .setter(setter(Builder::writeMp4PackagingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeMp4PackagingType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD,
            ALTERNATE_TRANSFER_FUNCTION_SEI_FIELD, BITRATE_FIELD, CODEC_LEVEL_FIELD, CODEC_PROFILE_FIELD, DYNAMIC_SUB_GOP_FIELD,
            FLICKER_ADAPTIVE_QUANTIZATION_FIELD, FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD,
            FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_B_REFERENCE_FIELD, GOP_CLOSED_CADENCE_FIELD,
            GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD, HRD_BUFFER_SIZE_FIELD,
            INTERLACE_MODE_FIELD, MAX_BITRATE_FIELD, MIN_I_INTERVAL_FIELD, NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD,
            NUMBER_REFERENCE_FRAMES_FIELD, PAR_CONTROL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD,
            QUALITY_TUNING_LEVEL_FIELD, QVBR_SETTINGS_FIELD, RATE_CONTROL_MODE_FIELD, SAMPLE_ADAPTIVE_OFFSET_FILTER_MODE_FIELD,
            SCAN_TYPE_CONVERSION_MODE_FIELD, SCENE_CHANGE_DETECT_FIELD, SLICES_FIELD, SLOW_PAL_FIELD,
            SPATIAL_ADAPTIVE_QUANTIZATION_FIELD, TELECINE_FIELD, TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD, TEMPORAL_IDS_FIELD,
            TILES_FIELD, UNREGISTERED_SEI_TIMECODE_FIELD, WRITE_MP4_PACKAGING_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adaptiveQuantization;

    private final String alternateTransferFunctionSei;

    private final Integer bitrate;

    private final String codecLevel;

    private final String codecProfile;

    private final String dynamicSubGop;

    private final String flickerAdaptiveQuantization;

    private final String framerateControl;

    private final String framerateConversionAlgorithm;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final String gopBReference;

    private final Integer gopClosedCadence;

    private final Double gopSize;

    private final String gopSizeUnits;

    private final Integer hrdBufferInitialFillPercentage;

    private final Integer hrdBufferSize;

    private final String interlaceMode;

    private final Integer maxBitrate;

    private final Integer minIInterval;

    private final Integer numberBFramesBetweenReferenceFrames;

    private final Integer numberReferenceFrames;

    private final String parControl;

    private final Integer parDenominator;

    private final Integer parNumerator;

    private final String qualityTuningLevel;

    private final H265QvbrSettings qvbrSettings;

    private final String rateControlMode;

    private final String sampleAdaptiveOffsetFilterMode;

    private final String scanTypeConversionMode;

    private final String sceneChangeDetect;

    private final Integer slices;

    private final String slowPal;

    private final String spatialAdaptiveQuantization;

    private final String telecine;

    private final String temporalAdaptiveQuantization;

    private final String temporalIds;

    private final String tiles;

    private final String unregisteredSeiTimecode;

    private final String writeMp4PackagingType;

    private H265Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.alternateTransferFunctionSei = builder.alternateTransferFunctionSei;
        this.bitrate = builder.bitrate;
        this.codecLevel = builder.codecLevel;
        this.codecProfile = builder.codecProfile;
        this.dynamicSubGop = builder.dynamicSubGop;
        this.flickerAdaptiveQuantization = builder.flickerAdaptiveQuantization;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopBReference = builder.gopBReference;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.hrdBufferInitialFillPercentage = builder.hrdBufferInitialFillPercentage;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.interlaceMode = builder.interlaceMode;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.numberBFramesBetweenReferenceFrames = builder.numberBFramesBetweenReferenceFrames;
        this.numberReferenceFrames = builder.numberReferenceFrames;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.qvbrSettings = builder.qvbrSettings;
        this.rateControlMode = builder.rateControlMode;
        this.sampleAdaptiveOffsetFilterMode = builder.sampleAdaptiveOffsetFilterMode;
        this.scanTypeConversionMode = builder.scanTypeConversionMode;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slices = builder.slices;
        this.slowPal = builder.slowPal;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
        this.telecine = builder.telecine;
        this.temporalAdaptiveQuantization = builder.temporalAdaptiveQuantization;
        this.temporalIds = builder.temporalIds;
        this.tiles = builder.tiles;
        this.unregisteredSeiTimecode = builder.unregisteredSeiTimecode;
        this.writeMp4PackagingType = builder.writeMp4PackagingType;
    }

    /**
     * Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies
     * to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive
     * quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link H265AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Specify the strength of any adaptive quantization filters that you enable. The value that you choose here
     *         applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial
     *         adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization
     *         (temporalAdaptiveQuantization).
     * @see H265AdaptiveQuantization
     */
    public final H265AdaptiveQuantization adaptiveQuantization() {
        return H265AdaptiveQuantization.fromValue(adaptiveQuantization);
    }

    /**
     * Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies
     * to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive
     * quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link H265AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Specify the strength of any adaptive quantization filters that you enable. The value that you choose here
     *         applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial
     *         adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization
     *         (temporalAdaptiveQuantization).
     * @see H265AdaptiveQuantization
     */
    public final String adaptiveQuantizationAsString() {
        return adaptiveQuantization;
    }

    /**
     * Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical Transfer
     * Function (EOTF).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #alternateTransferFunctionSei} will return {@link H265AlternateTransferFunctionSei#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #alternateTransferFunctionSeiAsString}.
     * </p>
     * 
     * @return Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical
     *         Transfer Function (EOTF).
     * @see H265AlternateTransferFunctionSei
     */
    public final H265AlternateTransferFunctionSei alternateTransferFunctionSei() {
        return H265AlternateTransferFunctionSei.fromValue(alternateTransferFunctionSei);
    }

    /**
     * Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical Transfer
     * Function (EOTF).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #alternateTransferFunctionSei} will return {@link H265AlternateTransferFunctionSei#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #alternateTransferFunctionSeiAsString}.
     * </p>
     * 
     * @return Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical
     *         Transfer Function (EOTF).
     * @see H265AlternateTransferFunctionSei
     */
    public final String alternateTransferFunctionSeiAsString() {
        return alternateTransferFunctionSei;
    }

    /**
     * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be
     * unique when rounded down to the nearest multiple of 1000.
     * 
     * @return Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates
     *         must be unique when rounded down to the nearest multiple of 1000.
     */
    public final Integer bitrate() {
        return bitrate;
    }

    /**
     * H.265 Level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecLevel} will
     * return {@link H265CodecLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecLevelAsString}.
     * </p>
     * 
     * @return H.265 Level.
     * @see H265CodecLevel
     */
    public final H265CodecLevel codecLevel() {
        return H265CodecLevel.fromValue(codecLevel);
    }

    /**
     * H.265 Level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecLevel} will
     * return {@link H265CodecLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecLevelAsString}.
     * </p>
     * 
     * @return H.265 Level.
     * @see H265CodecLevel
     */
    public final String codecLevelAsString() {
        return codecLevel;
    }

    /**
     * Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as [Profile] /
     * [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with the HEVC
     * 4:2:2 License.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link H265CodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecProfileAsString}.
     * </p>
     * 
     * @return Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as [Profile]
     *         / [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with
     *         the HEVC 4:2:2 License.
     * @see H265CodecProfile
     */
    public final H265CodecProfile codecProfile() {
        return H265CodecProfile.fromValue(codecProfile);
    }

    /**
     * Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as [Profile] /
     * [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with the HEVC
     * 4:2:2 License.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link H265CodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecProfileAsString}.
     * </p>
     * 
     * @return Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as [Profile]
     *         / [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with
     *         the HEVC 4:2:2 License.
     * @see H265CodecProfile
     */
    public final String codecProfileAsString() {
        return codecProfile;
    }

    /**
     * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use
     * fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more
     * B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the
     * setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynamicSubGop}
     * will return {@link H265DynamicSubGop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dynamicSubGopAsString}.
     * </p>
     * 
     * @return Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service
     *         to use fewer B-frames (which infer information based on other frames) for high-motion portions of the
     *         video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value
     *         you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     * @see H265DynamicSubGop
     */
    public final H265DynamicSubGop dynamicSubGop() {
        return H265DynamicSubGop.fromValue(dynamicSubGop);
    }

    /**
     * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use
     * fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more
     * B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the
     * setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynamicSubGop}
     * will return {@link H265DynamicSubGop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dynamicSubGopAsString}.
     * </p>
     * 
     * @return Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service
     *         to use fewer B-frames (which infer information based on other frames) for high-motion portions of the
     *         video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value
     *         you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     * @see H265DynamicSubGop
     */
    public final String dynamicSubGopAsString() {
        return dynamicSubGop;
    }

    /**
     * Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can
     * arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes
     * them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to
     * smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this
     * setting, you must also set adaptiveQuantization to a value other than Off (OFF).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flickerAdaptiveQuantization} will return {@link H265FlickerAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #flickerAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that
     *         can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and
     *         then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks
     *         slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In
     *         addition to enabling this setting, you must also set adaptiveQuantization to a value other than Off
     *         (OFF).
     * @see H265FlickerAdaptiveQuantization
     */
    public final H265FlickerAdaptiveQuantization flickerAdaptiveQuantization() {
        return H265FlickerAdaptiveQuantization.fromValue(flickerAdaptiveQuantization);
    }

    /**
     * Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can
     * arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes
     * them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to
     * smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this
     * setting, you must also set adaptiveQuantization to a value other than Off (OFF).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flickerAdaptiveQuantization} will return {@link H265FlickerAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #flickerAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that
     *         can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and
     *         then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks
     *         slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In
     *         addition to enabling this setting, you must also set adaptiveQuantization to a value other than Off
     *         (OFF).
     * @see H265FlickerAdaptiveQuantization
     */
    public final String flickerAdaptiveQuantizationAsString() {
        return flickerAdaptiveQuantization;
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link H265FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see H265FramerateControl
     */
    public final H265FramerateControl framerateControl() {
        return H265FramerateControl.fromValue(framerateControl);
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link H265FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see H265FramerateControl
     */
    public final String framerateControlAsString() {
        return framerateControl;
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend
     * using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For
     * numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth
     * picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your
     * source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do
     * motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using
     * FrameFormer increases the transcoding time and incurs a significant add-on cost.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link H265FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
     *         recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30
     *         fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This
     *         results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
     *         conversions, especially if your source video has already been converted from its original cadence, use
     *         FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion
     *         method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a
     *         significant add-on cost.
     * @see H265FramerateConversionAlgorithm
     */
    public final H265FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return H265FramerateConversionAlgorithm.fromValue(framerateConversionAlgorithm);
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend
     * using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For
     * numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth
     * picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your
     * source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do
     * motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using
     * FrameFormer increases the transcoding time and incurs a significant add-on cost.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link H265FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
     *         recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30
     *         fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This
     *         results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
     *         conversions, especially if your source video has already been converted from its original cadence, use
     *         FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion
     *         method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a
     *         significant add-on cost.
     * @see H265FramerateConversionAlgorithm
     */
    public final String framerateConversionAlgorithmAsString() {
        return framerateConversionAlgorithm;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this
     * example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of
     *         this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console
     *         for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate.
     *         In this example, specify 23.976.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this
     * example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this
     *         fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for
     *         transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In
     *         this example, specify 23.976.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * If enable, use reference B frames for GOP structures that have B frames > 1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopBReference}
     * will return {@link H265GopBReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gopBReferenceAsString}.
     * </p>
     * 
     * @return If enable, use reference B frames for GOP structures that have B frames > 1.
     * @see H265GopBReference
     */
    public final H265GopBReference gopBReference() {
        return H265GopBReference.fromValue(gopBReference);
    }

    /**
     * If enable, use reference B frames for GOP structures that have B frames > 1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopBReference}
     * will return {@link H265GopBReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gopBReferenceAsString}.
     * </p>
     * 
     * @return If enable, use reference B frames for GOP structures that have B frames > 1.
     * @see H265GopBReference
     */
    public final String gopBReferenceAsString() {
        return gopBReference;
    }

    /**
     * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining
     * mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output
     * segmenting.
     * 
     * @return Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
     *         joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
     *         output segmenting.
     */
    public final Integer gopClosedCadence() {
        return gopClosedCadence;
    }

    /**
     * GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
     * 
     * @return GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
     */
    public final Double gopSize() {
        return gopSize;
    }

    /**
     * Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will convert the GOP
     * Size into a frame count at run time.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link H265GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will convert
     *         the GOP Size into a frame count at run time.
     * @see H265GopSizeUnits
     */
    public final H265GopSizeUnits gopSizeUnits() {
        return H265GopSizeUnits.fromValue(gopSizeUnits);
    }

    /**
     * Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will convert the GOP
     * Size into a frame count at run time.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link H265GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will convert
     *         the GOP Size into a frame count at run time.
     * @see H265GopSizeUnits
     */
    public final String gopSizeUnitsAsString() {
        return gopSizeUnits;
    }

    /**
     * Percentage of the buffer that should initially be filled (HRD buffer model).
     * 
     * @return Percentage of the buffer that should initially be filled (HRD buffer model).
     */
    public final Integer hrdBufferInitialFillPercentage() {
        return hrdBufferInitialFillPercentage;
    }

    /**
     * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     * 
     * @return Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     */
    public final Integer hrdBufferSize() {
        return hrdBufferSize;
    }

    /**
     * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
     * progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field
     * first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow,
     * default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same
     * field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the
     * course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output
     * will be interlaced with the same polarity as the source. If the source is progressive, the output will be
     * interlaced with top field bottom field first, depending on which of the Follow options you choose.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link H265InterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
     *         progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
     *         field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout.
     *         Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce
     *         outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field
     *         polarity might change over the course of the output. Follow behavior depends on the input scan type. If
     *         the source is interlaced, the output will be interlaced with the same polarity as the source. If the
     *         source is progressive, the output will be interlaced with top field bottom field first, depending on
     *         which of the Follow options you choose.
     * @see H265InterlaceMode
     */
    public final H265InterlaceMode interlaceMode() {
        return H265InterlaceMode.fromValue(interlaceMode);
    }

    /**
     * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
     * progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field
     * first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow,
     * default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same
     * field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the
     * course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output
     * will be interlaced with the same polarity as the source. If the source is progressive, the output will be
     * interlaced with top field bottom field first, depending on which of the Follow options you choose.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link H265InterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
     *         progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
     *         field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout.
     *         Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce
     *         outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field
     *         polarity might change over the course of the output. Follow behavior depends on the input scan type. If
     *         the source is interlaced, the output will be interlaced with the same polarity as the source. If the
     *         source is progressive, the output will be interlaced with top field bottom field first, depending on
     *         which of the Follow options you choose.
     * @see H265InterlaceMode
     */
    public final String interlaceModeAsString() {
        return interlaceMode;
    }

    /**
     * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate
     * control mode is QVBR.
     * 
     * @return Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when
     *         Rate control mode is QVBR.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a
     * scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the
     * scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence
     * resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP
     * stretch = GOP size + Min-I-interval - 1
     * 
     * @return Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection.
     *         If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or
     *         stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting
     *         I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change
     *         Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
     */
    public final Integer minIInterval() {
        return minIInterval;
    }

    /**
     * Number of B-frames between reference frames.
     * 
     * @return Number of B-frames between reference frames.
     */
    public final Integer numberBFramesBetweenReferenceFrames() {
        return numberBFramesBetweenReferenceFrames;
    }

    /**
     * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced
     * encoding.
     * 
     * @return Number of reference frames to use. The encoder may use more than requested if using B-frames and/or
     *         interlaced encoding.
     */
    public final Integer numberReferenceFrames() {
        return numberReferenceFrames;
    }

    /**
     * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior,
     * Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a
     * different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing
     * the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify
     * values for the parNumerator and parDenominator settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link H265ParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
     *         behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
     *         specify a different PAR in the console, choose any value other than Follow source. To specify a different
     *         PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting,
     *         you must also specify values for the parNumerator and parDenominator settings.
     * @see H265ParControl
     */
    public final H265ParControl parControl() {
        return H265ParControl.fromValue(parControl);
    }

    /**
     * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior,
     * Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a
     * different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing
     * the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify
     * values for the parNumerator and parDenominator settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link H265ParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
     *         behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
     *         specify a different PAR in the console, choose any value other than Follow source. To specify a different
     *         PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting,
     *         you must also specify values for the parNumerator and parDenominator settings.
     * @see H265ParControl
     */
    public final String parControlAsString() {
        return parControl;
    }

    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value
     * other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input
     * video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the
     * ratio 40:33. In this example, the value for parDenominator is 33.
     * 
     * @return Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to
     *         any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different
     *         from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen,
     *         you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
     */
    public final Integer parDenominator() {
        return parDenominator;
    }

    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value
     * other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input
     * video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the
     * ratio 40:33. In this example, the value for parNumerator is 40.
     * 
     * @return Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to
     *         any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different
     *         from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen,
     *         you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
     */
    public final Integer parNumerator() {
        return parNumerator;
    }

    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for
     * output video quality. The default behavior is faster, lower quality, single-pass encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link H265QualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
     *         speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
     * @see H265QualityTuningLevel
     */
    public final H265QualityTuningLevel qualityTuningLevel() {
        return H265QualityTuningLevel.fromValue(qualityTuningLevel);
    }

    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for
     * output video quality. The default behavior is faster, lower quality, single-pass encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link H265QualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
     *         speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
     * @see H265QualityTuningLevel
     */
    public final String qualityTuningLevelAsString() {
        return qualityTuningLevel;
    }

    /**
     * Settings for quality-defined variable bitrate encoding with the H.265 codec. Required when you set Rate control
     * mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don't define Rate
     * control mode.
     * 
     * @return Settings for quality-defined variable bitrate encoding with the H.265 codec. Required when you set Rate
     *         control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you
     *         don't define Rate control mode.
     */
    public final H265QvbrSettings qvbrSettings() {
        return qvbrSettings;
    }

    /**
     * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
     * quality-defined variable bitrate (QVBR).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link H265RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
     *         quality-defined variable bitrate (QVBR).
     * @see H265RateControlMode
     */
    public final H265RateControlMode rateControlMode() {
        return H265RateControlMode.fromValue(rateControlMode);
    }

    /**
     * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
     * quality-defined variable bitrate (QVBR).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link H265RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
     *         quality-defined variable bitrate (QVBR).
     * @see H265RateControlMode
     */
    public final String rateControlModeAsString() {
        return rateControlMode;
    }

    /**
     * Specify Sample Adaptive Offset (SAO) filter strength. Adaptive mode dynamically selects best strength based on
     * content
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sampleAdaptiveOffsetFilterMode} will return
     * {@link H265SampleAdaptiveOffsetFilterMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sampleAdaptiveOffsetFilterModeAsString}.
     * </p>
     * 
     * @return Specify Sample Adaptive Offset (SAO) filter strength. Adaptive mode dynamically selects best strength
     *         based on content
     * @see H265SampleAdaptiveOffsetFilterMode
     */
    public final H265SampleAdaptiveOffsetFilterMode sampleAdaptiveOffsetFilterMode() {
        return H265SampleAdaptiveOffsetFilterMode.fromValue(sampleAdaptiveOffsetFilterMode);
    }

    /**
     * Specify Sample Adaptive Offset (SAO) filter strength. Adaptive mode dynamically selects best strength based on
     * content
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sampleAdaptiveOffsetFilterMode} will return
     * {@link H265SampleAdaptiveOffsetFilterMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sampleAdaptiveOffsetFilterModeAsString}.
     * </p>
     * 
     * @return Specify Sample Adaptive Offset (SAO) filter strength. Adaptive mode dynamically selects best strength
     *         based on content
     * @see H265SampleAdaptiveOffsetFilterMode
     */
    public final String sampleAdaptiveOffsetFilterModeAsString() {
        return sampleAdaptiveOffsetFilterMode;
    }

    /**
     * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this
     * situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In
     * this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the
     * default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing,
     * MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized
     * interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing,
     * MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you
     * must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine
     * outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scanTypeConversionMode} will return {@link H265ScanTypeConversionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #scanTypeConversionModeAsString}.
     * </p>
     * 
     * @return Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
     *         this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
     *         output. In this case, each progressive frame from the input corresponds to an interlaced field in the
     *         output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With
     *         basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames.
     *         When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable
     *         for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings:
     *         To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't
     *         use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to
     *         a value other than Progressive (PROGRESSIVE).
     * @see H265ScanTypeConversionMode
     */
    public final H265ScanTypeConversionMode scanTypeConversionMode() {
        return H265ScanTypeConversionMode.fromValue(scanTypeConversionMode);
    }

    /**
     * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this
     * situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In
     * this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the
     * default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing,
     * MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized
     * interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing,
     * MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you
     * must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine
     * outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scanTypeConversionMode} will return {@link H265ScanTypeConversionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #scanTypeConversionModeAsString}.
     * </p>
     * 
     * @return Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
     *         this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
     *         output. In this case, each progressive frame from the input corresponds to an interlaced field in the
     *         output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With
     *         basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames.
     *         When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable
     *         for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings:
     *         To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't
     *         use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to
     *         a value other than Progressive (PROGRESSIVE).
     * @see H265ScanTypeConversionMode
     */
    public final String scanTypeConversionModeAsString() {
        return scanTypeConversionMode;
    }

    /**
     * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
     * video quality and is enabled by default. If this output uses QVBR, choose Transition detection
     * (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
     * https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link H265SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Enable this setting to insert I-frames at scene changes that the service automatically detects. This
     *         improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection
     *         (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
     *         https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     * @see H265SceneChangeDetect
     */
    public final H265SceneChangeDetect sceneChangeDetect() {
        return H265SceneChangeDetect.fromValue(sceneChangeDetect);
    }

    /**
     * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
     * video quality and is enabled by default. If this output uses QVBR, choose Transition detection
     * (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
     * https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link H265SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Enable this setting to insert I-frames at scene changes that the service automatically detects. This
     *         improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection
     *         (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
     *         https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     * @see H265SceneChangeDetect
     */
    public final String sceneChangeDetectAsString() {
        return sceneChangeDetect;
    }

    /**
     * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     * 
     * @return Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     *         pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     */
    public final Integer slices() {
        return slices;
    }

    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
     * create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples
     * your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the
     * duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set
     * (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link H265SlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL
     *         to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and
     *         resamples your audio to keep it synchronized with the video. Note that enabling this setting will
     *         slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your
     *         JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
     *         (framerateDenominator) to 1.
     * @see H265SlowPal
     */
    public final H265SlowPal slowPal() {
        return H265SlowPal.fromValue(slowPal);
    }

    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
     * create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples
     * your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the
     * duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set
     * (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link H265SlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL
     *         to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and
     *         resamples your audio to keep it synchronized with the video. Note that enabling this setting will
     *         slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your
     *         JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
     *         (framerateDenominator) to 1.
     * @see H265SlowPal
     */
    public final String slowPalAsString() {
        return slowPal;
    }

    /**
     * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of
     * content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more
     * distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be
     * noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are
     * encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that
     * this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be
     * focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this
     * feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization
     * (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set
     * it to Low. For content with a wider variety of textures, set it to High or Higher.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spatialAdaptiveQuantization} will return {@link H265SpatialAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #spatialAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial
     *         variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that
     *         can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any
     *         small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and
     *         smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your
     *         video quality. Note, though, that this feature doesn't take into account where the viewer's attention is
     *         likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of
     *         complex texture, you might choose to disable this feature. Related setting: When you enable spatial
     *         adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your
     *         content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a
     *         wider variety of textures, set it to High or Higher.
     * @see H265SpatialAdaptiveQuantization
     */
    public final H265SpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return H265SpatialAdaptiveQuantization.fromValue(spatialAdaptiveQuantization);
    }

    /**
     * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of
     * content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more
     * distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be
     * noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are
     * encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that
     * this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be
     * focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this
     * feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization
     * (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set
     * it to Low. For content with a wider variety of textures, set it to High or Higher.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spatialAdaptiveQuantization} will return {@link H265SpatialAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #spatialAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial
     *         variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that
     *         can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any
     *         small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and
     *         smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your
     *         video quality. Note, though, that this feature doesn't take into account where the viewer's attention is
     *         likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of
     *         complex texture, you might choose to disable this feature. Related setting: When you enable spatial
     *         adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your
     *         content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a
     *         wider variety of textures, set it to High or Higher.
     * @see H265SpatialAdaptiveQuantization
     */
    public final String spatialAdaptiveQuantizationAsString() {
        return spatialAdaptiveQuantization;
    }

    /**
     * This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field
     * works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams >
     * Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive,
     * Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces
     * 23.976; the player converts this output to 29.97i.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link H265Telecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telecineAsString}.
     * </p>
     * 
     * @return This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This
     *         field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the
     *         Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output:
     *         Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976
     *         input. - Soft: produces 23.976; the player converts this output to 29.97i.
     * @see H265Telecine
     */
    public final H265Telecine telecine() {
        return H265Telecine.fromValue(telecine);
    }

    /**
     * This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field
     * works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams >
     * Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive,
     * Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces
     * 23.976; the player converts this output to 29.97i.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link H265Telecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telecineAsString}.
     * </p>
     * 
     * @return This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This
     *         field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the
     *         Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output:
     *         Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976
     *         input. - Soft: produces 23.976; the player converts this output to 29.97i.
     * @see H265Telecine
     */
    public final String telecineAsString() {
        return telecine;
    }

    /**
     * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation
     * of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that
     * aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature
     * improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature
     * will almost always improve your video quality. Note, though, that this feature doesn't take into account where
     * the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the
     * screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to
     * disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter
     * with the setting Adaptive quantization (adaptiveQuantization).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #temporalAdaptiveQuantization} will return {@link H265TemporalAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #temporalAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal
     *         variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of
     *         the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For
     *         example, this feature improves the readability of text tickers on newscasts and scoreboards on sports
     *         matches. Enabling this feature will almost always improve your video quality. Note, though, that this
     *         feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to
     *         be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges,
     *         such as sports athletes' faces, you might choose to disable this feature. Related setting: When you
     *         enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization
     *         (adaptiveQuantization).
     * @see H265TemporalAdaptiveQuantization
     */
    public final H265TemporalAdaptiveQuantization temporalAdaptiveQuantization() {
        return H265TemporalAdaptiveQuantization.fromValue(temporalAdaptiveQuantization);
    }

    /**
     * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation
     * of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that
     * aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature
     * improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature
     * will almost always improve your video quality. Note, though, that this feature doesn't take into account where
     * the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the
     * screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to
     * disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter
     * with the setting Adaptive quantization (adaptiveQuantization).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #temporalAdaptiveQuantization} will return {@link H265TemporalAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #temporalAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal
     *         variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of
     *         the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For
     *         example, this feature improves the readability of text tickers on newscasts and scoreboards on sports
     *         matches. Enabling this feature will almost always improve your video quality. Note, though, that this
     *         feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to
     *         be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges,
     *         such as sports athletes' faces, you might choose to disable this feature. Related setting: When you
     *         enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization
     *         (adaptiveQuantization).
     * @see H265TemporalAdaptiveQuantization
     */
    public final String temporalAdaptiveQuantizationAsString() {
        return temporalAdaptiveQuantization;
    }

    /**
     * Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on GOP
     * structure: I- and P-frames form one layer, reference B-frames can form a second layer and non-reference b-frames
     * can form a third layer. Decoders can optionally decode only the lower temporal layers to generate a lower frame
     * rate output. For example, given a bitstream with temporal IDs and with b-frames = 1 (i.e. IbPbPb display order),
     * a decoder could decode all the frames for full frame rate output or only the I and P frames (lowest temporal
     * layer) for a half frame rate output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temporalIds} will
     * return {@link H265TemporalIds#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #temporalIdsAsString}.
     * </p>
     * 
     * @return Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on
     *         GOP structure: I- and P-frames form one layer, reference B-frames can form a second layer and
     *         non-reference b-frames can form a third layer. Decoders can optionally decode only the lower temporal
     *         layers to generate a lower frame rate output. For example, given a bitstream with temporal IDs and with
     *         b-frames = 1 (i.e. IbPbPb display order), a decoder could decode all the frames for full frame rate
     *         output or only the I and P frames (lowest temporal layer) for a half frame rate output.
     * @see H265TemporalIds
     */
    public final H265TemporalIds temporalIds() {
        return H265TemporalIds.fromValue(temporalIds);
    }

    /**
     * Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on GOP
     * structure: I- and P-frames form one layer, reference B-frames can form a second layer and non-reference b-frames
     * can form a third layer. Decoders can optionally decode only the lower temporal layers to generate a lower frame
     * rate output. For example, given a bitstream with temporal IDs and with b-frames = 1 (i.e. IbPbPb display order),
     * a decoder could decode all the frames for full frame rate output or only the I and P frames (lowest temporal
     * layer) for a half frame rate output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temporalIds} will
     * return {@link H265TemporalIds#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #temporalIdsAsString}.
     * </p>
     * 
     * @return Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on
     *         GOP structure: I- and P-frames form one layer, reference B-frames can form a second layer and
     *         non-reference b-frames can form a third layer. Decoders can optionally decode only the lower temporal
     *         layers to generate a lower frame rate output. For example, given a bitstream with temporal IDs and with
     *         b-frames = 1 (i.e. IbPbPb display order), a decoder could decode all the frames for full frame rate
     *         output or only the I and P frames (lowest temporal layer) for a half frame rate output.
     * @see H265TemporalIds
     */
    public final String temporalIdsAsString() {
        return temporalIds;
    }

    /**
     * Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tiles} will return
     * {@link H265Tiles#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tilesAsString}.
     * </p>
     * 
     * @return Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
     * @see H265Tiles
     */
    public final H265Tiles tiles() {
        return H265Tiles.fromValue(tiles);
    }

    /**
     * Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tiles} will return
     * {@link H265Tiles#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tilesAsString}.
     * </p>
     * 
     * @return Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
     * @see H265Tiles
     */
    public final String tilesAsString() {
        return tiles;
    }

    /**
     * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unregisteredSeiTimecode} will return {@link H265UnregisteredSeiTimecode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #unregisteredSeiTimecodeAsString}.
     * </p>
     * 
     * @return Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     * @see H265UnregisteredSeiTimecode
     */
    public final H265UnregisteredSeiTimecode unregisteredSeiTimecode() {
        return H265UnregisteredSeiTimecode.fromValue(unregisteredSeiTimecode);
    }

    /**
     * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unregisteredSeiTimecode} will return {@link H265UnregisteredSeiTimecode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #unregisteredSeiTimecodeAsString}.
     * </p>
     * 
     * @return Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     * @see H265UnregisteredSeiTimecode
     */
    public final String unregisteredSeiTimecodeAsString() {
        return unregisteredSeiTimecode;
    }

    /**
     * If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this setting
     * only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs). Choose HVC1
     * to mark your output as HVC1. This makes your output compliant with the following specification: ISO IECJTC1 SC29
     * N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores parameter set NAL units in
     * the sample headers but not in the samples directly. For MP4 outputs, when you choose HVC1, your output video
     * might not work properly with some downstream systems and video players. The service defaults to marking your
     * output as HEV1. For these outputs, the service writes parameter set NAL units directly into the samples.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeMp4PackagingType} will return {@link H265WriteMp4PackagingType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #writeMp4PackagingTypeAsString}.
     * </p>
     * 
     * @return If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this
     *         setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4
     *         outputs). Choose HVC1 to mark your output as HVC1. This makes your output compliant with the following
     *         specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the
     *         service stores parameter set NAL units in the sample headers but not in the samples directly. For MP4
     *         outputs, when you choose HVC1, your output video might not work properly with some downstream systems and
     *         video players. The service defaults to marking your output as HEV1. For these outputs, the service writes
     *         parameter set NAL units directly into the samples.
     * @see H265WriteMp4PackagingType
     */
    public final H265WriteMp4PackagingType writeMp4PackagingType() {
        return H265WriteMp4PackagingType.fromValue(writeMp4PackagingType);
    }

    /**
     * If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this setting
     * only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs). Choose HVC1
     * to mark your output as HVC1. This makes your output compliant with the following specification: ISO IECJTC1 SC29
     * N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores parameter set NAL units in
     * the sample headers but not in the samples directly. For MP4 outputs, when you choose HVC1, your output video
     * might not work properly with some downstream systems and video players. The service defaults to marking your
     * output as HEV1. For these outputs, the service writes parameter set NAL units directly into the samples.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeMp4PackagingType} will return {@link H265WriteMp4PackagingType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #writeMp4PackagingTypeAsString}.
     * </p>
     * 
     * @return If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this
     *         setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4
     *         outputs). Choose HVC1 to mark your output as HVC1. This makes your output compliant with the following
     *         specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the
     *         service stores parameter set NAL units in the sample headers but not in the samples directly. For MP4
     *         outputs, when you choose HVC1, your output video might not work properly with some downstream systems and
     *         video players. The service defaults to marking your output as HEV1. For these outputs, the service writes
     *         parameter set NAL units directly into the samples.
     * @see H265WriteMp4PackagingType
     */
    public final String writeMp4PackagingTypeAsString() {
        return writeMp4PackagingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(alternateTransferFunctionSeiAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(codecLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicSubGopAsString());
        hashCode = 31 * hashCode + Objects.hashCode(flickerAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(gopBReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hrdBufferInitialFillPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(numberBFramesBetweenReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(numberReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(qvbrSettings());
        hashCode = 31 * hashCode + Objects.hashCode(rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sampleAdaptiveOffsetFilterModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanTypeConversionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slices());
        hashCode = 31 * hashCode + Objects.hashCode(slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spatialAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(telecineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(temporalAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(temporalIdsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tilesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unregisteredSeiTimecodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(writeMp4PackagingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H265Settings)) {
            return false;
        }
        H265Settings other = (H265Settings) obj;
        return Objects.equals(adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString())
                && Objects.equals(alternateTransferFunctionSeiAsString(), other.alternateTransferFunctionSeiAsString())
                && Objects.equals(bitrate(), other.bitrate()) && Objects.equals(codecLevelAsString(), other.codecLevelAsString())
                && Objects.equals(codecProfileAsString(), other.codecProfileAsString())
                && Objects.equals(dynamicSubGopAsString(), other.dynamicSubGopAsString())
                && Objects.equals(flickerAdaptiveQuantizationAsString(), other.flickerAdaptiveQuantizationAsString())
                && Objects.equals(framerateControlAsString(), other.framerateControlAsString())
                && Objects.equals(framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator())
                && Objects.equals(gopBReferenceAsString(), other.gopBReferenceAsString())
                && Objects.equals(gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(gopSize(), other.gopSize())
                && Objects.equals(gopSizeUnitsAsString(), other.gopSizeUnitsAsString())
                && Objects.equals(hrdBufferInitialFillPercentage(), other.hrdBufferInitialFillPercentage())
                && Objects.equals(hrdBufferSize(), other.hrdBufferSize())
                && Objects.equals(interlaceModeAsString(), other.interlaceModeAsString())
                && Objects.equals(maxBitrate(), other.maxBitrate()) && Objects.equals(minIInterval(), other.minIInterval())
                && Objects.equals(numberBFramesBetweenReferenceFrames(), other.numberBFramesBetweenReferenceFrames())
                && Objects.equals(numberReferenceFrames(), other.numberReferenceFrames())
                && Objects.equals(parControlAsString(), other.parControlAsString())
                && Objects.equals(parDenominator(), other.parDenominator())
                && Objects.equals(parNumerator(), other.parNumerator())
                && Objects.equals(qualityTuningLevelAsString(), other.qualityTuningLevelAsString())
                && Objects.equals(qvbrSettings(), other.qvbrSettings())
                && Objects.equals(rateControlModeAsString(), other.rateControlModeAsString())
                && Objects.equals(sampleAdaptiveOffsetFilterModeAsString(), other.sampleAdaptiveOffsetFilterModeAsString())
                && Objects.equals(scanTypeConversionModeAsString(), other.scanTypeConversionModeAsString())
                && Objects.equals(sceneChangeDetectAsString(), other.sceneChangeDetectAsString())
                && Objects.equals(slices(), other.slices()) && Objects.equals(slowPalAsString(), other.slowPalAsString())
                && Objects.equals(spatialAdaptiveQuantizationAsString(), other.spatialAdaptiveQuantizationAsString())
                && Objects.equals(telecineAsString(), other.telecineAsString())
                && Objects.equals(temporalAdaptiveQuantizationAsString(), other.temporalAdaptiveQuantizationAsString())
                && Objects.equals(temporalIdsAsString(), other.temporalIdsAsString())
                && Objects.equals(tilesAsString(), other.tilesAsString())
                && Objects.equals(unregisteredSeiTimecodeAsString(), other.unregisteredSeiTimecodeAsString())
                && Objects.equals(writeMp4PackagingTypeAsString(), other.writeMp4PackagingTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("H265Settings").add("AdaptiveQuantization", adaptiveQuantizationAsString())
                .add("AlternateTransferFunctionSei", alternateTransferFunctionSeiAsString()).add("Bitrate", bitrate())
                .add("CodecLevel", codecLevelAsString()).add("CodecProfile", codecProfileAsString())
                .add("DynamicSubGop", dynamicSubGopAsString())
                .add("FlickerAdaptiveQuantization", flickerAdaptiveQuantizationAsString())
                .add("FramerateControl", framerateControlAsString())
                .add("FramerateConversionAlgorithm", framerateConversionAlgorithmAsString())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("GopBReference", gopBReferenceAsString()).add("GopClosedCadence", gopClosedCadence())
                .add("GopSize", gopSize()).add("GopSizeUnits", gopSizeUnitsAsString())
                .add("HrdBufferInitialFillPercentage", hrdBufferInitialFillPercentage()).add("HrdBufferSize", hrdBufferSize())
                .add("InterlaceMode", interlaceModeAsString()).add("MaxBitrate", maxBitrate())
                .add("MinIInterval", minIInterval())
                .add("NumberBFramesBetweenReferenceFrames", numberBFramesBetweenReferenceFrames())
                .add("NumberReferenceFrames", numberReferenceFrames()).add("ParControl", parControlAsString())
                .add("ParDenominator", parDenominator()).add("ParNumerator", parNumerator())
                .add("QualityTuningLevel", qualityTuningLevelAsString()).add("QvbrSettings", qvbrSettings())
                .add("RateControlMode", rateControlModeAsString())
                .add("SampleAdaptiveOffsetFilterMode", sampleAdaptiveOffsetFilterModeAsString())
                .add("ScanTypeConversionMode", scanTypeConversionModeAsString())
                .add("SceneChangeDetect", sceneChangeDetectAsString()).add("Slices", slices()).add("SlowPal", slowPalAsString())
                .add("SpatialAdaptiveQuantization", spatialAdaptiveQuantizationAsString()).add("Telecine", telecineAsString())
                .add("TemporalAdaptiveQuantization", temporalAdaptiveQuantizationAsString())
                .add("TemporalIds", temporalIdsAsString()).add("Tiles", tilesAsString())
                .add("UnregisteredSeiTimecode", unregisteredSeiTimecodeAsString())
                .add("WriteMp4PackagingType", writeMp4PackagingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(adaptiveQuantizationAsString()));
        case "AlternateTransferFunctionSei":
            return Optional.ofNullable(clazz.cast(alternateTransferFunctionSeiAsString()));
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "CodecLevel":
            return Optional.ofNullable(clazz.cast(codecLevelAsString()));
        case "CodecProfile":
            return Optional.ofNullable(clazz.cast(codecProfileAsString()));
        case "DynamicSubGop":
            return Optional.ofNullable(clazz.cast(dynamicSubGopAsString()));
        case "FlickerAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(flickerAdaptiveQuantizationAsString()));
        case "FramerateControl":
            return Optional.ofNullable(clazz.cast(framerateControlAsString()));
        case "FramerateConversionAlgorithm":
            return Optional.ofNullable(clazz.cast(framerateConversionAlgorithmAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "GopBReference":
            return Optional.ofNullable(clazz.cast(gopBReferenceAsString()));
        case "GopClosedCadence":
            return Optional.ofNullable(clazz.cast(gopClosedCadence()));
        case "GopSize":
            return Optional.ofNullable(clazz.cast(gopSize()));
        case "GopSizeUnits":
            return Optional.ofNullable(clazz.cast(gopSizeUnitsAsString()));
        case "HrdBufferInitialFillPercentage":
            return Optional.ofNullable(clazz.cast(hrdBufferInitialFillPercentage()));
        case "HrdBufferSize":
            return Optional.ofNullable(clazz.cast(hrdBufferSize()));
        case "InterlaceMode":
            return Optional.ofNullable(clazz.cast(interlaceModeAsString()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "MinIInterval":
            return Optional.ofNullable(clazz.cast(minIInterval()));
        case "NumberBFramesBetweenReferenceFrames":
            return Optional.ofNullable(clazz.cast(numberBFramesBetweenReferenceFrames()));
        case "NumberReferenceFrames":
            return Optional.ofNullable(clazz.cast(numberReferenceFrames()));
        case "ParControl":
            return Optional.ofNullable(clazz.cast(parControlAsString()));
        case "ParDenominator":
            return Optional.ofNullable(clazz.cast(parDenominator()));
        case "ParNumerator":
            return Optional.ofNullable(clazz.cast(parNumerator()));
        case "QualityTuningLevel":
            return Optional.ofNullable(clazz.cast(qualityTuningLevelAsString()));
        case "QvbrSettings":
            return Optional.ofNullable(clazz.cast(qvbrSettings()));
        case "RateControlMode":
            return Optional.ofNullable(clazz.cast(rateControlModeAsString()));
        case "SampleAdaptiveOffsetFilterMode":
            return Optional.ofNullable(clazz.cast(sampleAdaptiveOffsetFilterModeAsString()));
        case "ScanTypeConversionMode":
            return Optional.ofNullable(clazz.cast(scanTypeConversionModeAsString()));
        case "SceneChangeDetect":
            return Optional.ofNullable(clazz.cast(sceneChangeDetectAsString()));
        case "Slices":
            return Optional.ofNullable(clazz.cast(slices()));
        case "SlowPal":
            return Optional.ofNullable(clazz.cast(slowPalAsString()));
        case "SpatialAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(spatialAdaptiveQuantizationAsString()));
        case "Telecine":
            return Optional.ofNullable(clazz.cast(telecineAsString()));
        case "TemporalAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(temporalAdaptiveQuantizationAsString()));
        case "TemporalIds":
            return Optional.ofNullable(clazz.cast(temporalIdsAsString()));
        case "Tiles":
            return Optional.ofNullable(clazz.cast(tilesAsString()));
        case "UnregisteredSeiTimecode":
            return Optional.ofNullable(clazz.cast(unregisteredSeiTimecodeAsString()));
        case "WriteMp4PackagingType":
            return Optional.ofNullable(clazz.cast(writeMp4PackagingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H265Settings, T> g) {
        return obj -> g.apply((H265Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, H265Settings> {
        /**
         * Specify the strength of any adaptive quantization filters that you enable. The value that you choose here
         * applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial
         * adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization
         * (temporalAdaptiveQuantization).
         * 
         * @param adaptiveQuantization
         *        Specify the strength of any adaptive quantization filters that you enable. The value that you choose
         *        here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization),
         *        Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization
         *        (temporalAdaptiveQuantization).
         * @see H265AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265AdaptiveQuantization
         */
        Builder adaptiveQuantization(String adaptiveQuantization);

        /**
         * Specify the strength of any adaptive quantization filters that you enable. The value that you choose here
         * applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial
         * adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization
         * (temporalAdaptiveQuantization).
         * 
         * @param adaptiveQuantization
         *        Specify the strength of any adaptive quantization filters that you enable. The value that you choose
         *        here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization),
         *        Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization
         *        (temporalAdaptiveQuantization).
         * @see H265AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265AdaptiveQuantization
         */
        Builder adaptiveQuantization(H265AdaptiveQuantization adaptiveQuantization);

        /**
         * Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical
         * Transfer Function (EOTF).
         * 
         * @param alternateTransferFunctionSei
         *        Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG)
         *        Electro-Optical Transfer Function (EOTF).
         * @see H265AlternateTransferFunctionSei
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265AlternateTransferFunctionSei
         */
        Builder alternateTransferFunctionSei(String alternateTransferFunctionSei);

        /**
         * Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical
         * Transfer Function (EOTF).
         * 
         * @param alternateTransferFunctionSei
         *        Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG)
         *        Electro-Optical Transfer Function (EOTF).
         * @see H265AlternateTransferFunctionSei
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265AlternateTransferFunctionSei
         */
        Builder alternateTransferFunctionSei(H265AlternateTransferFunctionSei alternateTransferFunctionSei);

        /**
         * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates
         * must be unique when rounded down to the nearest multiple of 1000.
         * 
         * @param bitrate
         *        Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs,
         *        bitrates must be unique when rounded down to the nearest multiple of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * H.265 Level.
         * 
         * @param codecLevel
         *        H.265 Level.
         * @see H265CodecLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265CodecLevel
         */
        Builder codecLevel(String codecLevel);

        /**
         * H.265 Level.
         * 
         * @param codecLevel
         *        H.265 Level.
         * @see H265CodecLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265CodecLevel
         */
        Builder codecLevel(H265CodecLevel codecLevel);

        /**
         * Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as [Profile] /
         * [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with the
         * HEVC 4:2:2 License.
         * 
         * @param codecProfile
         *        Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as
         *        [Profile] / [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only
         *        available with the HEVC 4:2:2 License.
         * @see H265CodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265CodecProfile
         */
        Builder codecProfile(String codecProfile);

        /**
         * Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as [Profile] /
         * [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with the
         * HEVC 4:2:2 License.
         * 
         * @param codecProfile
         *        Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as
         *        [Profile] / [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only
         *        available with the HEVC 4:2:2 License.
         * @see H265CodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265CodecProfile
         */
        Builder codecProfile(H265CodecProfile codecProfile);

        /**
         * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to
         * use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and
         * more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for
         * the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
         * 
         * @param dynamicSubGop
         *        Choose Adaptive to improve subjective video quality for high-motion content. This will cause the
         *        service to use fewer B-frames (which infer information based on other frames) for high-motion portions
         *        of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by
         *        the value you provide for the setting B frames between reference frames
         *        (numberBFramesBetweenReferenceFrames).
         * @see H265DynamicSubGop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265DynamicSubGop
         */
        Builder dynamicSubGop(String dynamicSubGop);

        /**
         * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to
         * use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and
         * more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for
         * the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
         * 
         * @param dynamicSubGop
         *        Choose Adaptive to improve subjective video quality for high-motion content. This will cause the
         *        service to use fewer B-frames (which infer information based on other frames) for high-motion portions
         *        of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by
         *        the value you provide for the setting B frames between reference frames
         *        (numberBFramesBetweenReferenceFrames).
         * @see H265DynamicSubGop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265DynamicSubGop
         */
        Builder dynamicSubGop(H265DynamicSubGop dynamicSubGop);

        /**
         * Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can
         * arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then
         * refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly
         * more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to
         * enabling this setting, you must also set adaptiveQuantization to a value other than Off (OFF).
         * 
         * @param flickerAdaptiveQuantization
         *        Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker
         *        that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame,
         *        and then refreshes them at the I-frame. When you enable this setting, the encoder updates these
         *        macroblocks slightly more often to smooth out the flicker. This setting is disabled by default.
         *        Related setting: In addition to enabling this setting, you must also set adaptiveQuantization to a
         *        value other than Off (OFF).
         * @see H265FlickerAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265FlickerAdaptiveQuantization
         */
        Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization);

        /**
         * Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can
         * arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then
         * refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly
         * more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to
         * enabling this setting, you must also set adaptiveQuantization to a value other than Off (OFF).
         * 
         * @param flickerAdaptiveQuantization
         *        Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker
         *        that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame,
         *        and then refreshes them at the I-frame. When you enable this setting, the encoder updates these
         *        macroblocks slightly more often to smooth out the flicker. This setting is disabled by default.
         *        Related setting: In addition to enabling this setting, you must also set adaptiveQuantization to a
         *        value other than Off (OFF).
         * @see H265FlickerAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265FlickerAdaptiveQuantization
         */
        Builder flickerAdaptiveQuantization(H265FlickerAdaptiveQuantization flickerAdaptiveQuantization);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see H265FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265FramerateControl
         */
        Builder framerateControl(String framerateControl);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see H265FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265FramerateControl
         */
        Builder framerateControl(H265FramerateControl framerateControl);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         * recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps.
         * For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in
         * a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence, use FrameFormer
         * (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by
         * frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         *        recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
         *        30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter.
         *        This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame
         *        rate conversions, especially if your source video has already been converted from its original
         *        cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the
         *        best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and
         *        incurs a significant add-on cost.
         * @see H265FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(String framerateConversionAlgorithm);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         * recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps.
         * For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in
         * a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence, use FrameFormer
         * (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by
         * frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         *        recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
         *        30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter.
         *        This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame
         *        rate conversions, especially if your source video has already been converted from its original
         *        cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the
         *        best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and
         *        incurs a significant add-on cost.
         * @see H265FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(H265FramerateConversionAlgorithm framerateConversionAlgorithm);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction.
         * In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs
         * that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateDenominator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator
         *        of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In
         * this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that
         * use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateNumerator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of
         *        this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * If enable, use reference B frames for GOP structures that have B frames > 1.
         * 
         * @param gopBReference
         *        If enable, use reference B frames for GOP structures that have B frames > 1.
         * @see H265GopBReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265GopBReference
         */
        Builder gopBReference(String gopBReference);

        /**
         * If enable, use reference B frames for GOP structures that have B frames > 1.
         * 
         * @param gopBReference
         *        If enable, use reference B frames for GOP structures that have B frames > 1.
         * @see H265GopBReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265GopBReference
         */
        Builder gopBReference(H265GopBReference gopBReference);

        /**
         * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
         * joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
         * output segmenting.
         * 
         * @param gopClosedCadence
         *        Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a
         *        decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0
         *        will break output segmenting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopClosedCadence(Integer gopClosedCadence);

        /**
         * GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
         * 
         * @param gopSize
         *        GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopSize(Double gopSize);

        /**
         * Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will convert the
         * GOP Size into a frame count at run time.
         * 
         * @param gopSizeUnits
         *        Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will
         *        convert the GOP Size into a frame count at run time.
         * @see H265GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265GopSizeUnits
         */
        Builder gopSizeUnits(String gopSizeUnits);

        /**
         * Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will convert the
         * GOP Size into a frame count at run time.
         * 
         * @param gopSizeUnits
         *        Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will
         *        convert the GOP Size into a frame count at run time.
         * @see H265GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265GopSizeUnits
         */
        Builder gopSizeUnits(H265GopSizeUnits gopSizeUnits);

        /**
         * Percentage of the buffer that should initially be filled (HRD buffer model).
         * 
         * @param hrdBufferInitialFillPercentage
         *        Percentage of the buffer that should initially be filled (HRD buffer model).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage);

        /**
         * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         * 
         * @param hrdBufferSize
         *        Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hrdBufferSize(Integer hrdBufferSize);

        /**
         * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
         * progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
         * field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use
         * Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs
         * with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity
         * might change over the course of the output. Follow behavior depends on the input scan type. If the source is
         * interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive,
         * the output will be interlaced with top field bottom field first, depending on which of the Follow options you
         * choose.
         * 
         * @param interlaceMode
         *        Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create
         *        a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or
         *        Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity
         *        throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD)
         *        to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the
         *        output field polarity might change over the course of the output. Follow behavior depends on the input
         *        scan type. If the source is interlaced, the output will be interlaced with the same polarity as the
         *        source. If the source is progressive, the output will be interlaced with top field bottom field first,
         *        depending on which of the Follow options you choose.
         * @see H265InterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265InterlaceMode
         */
        Builder interlaceMode(String interlaceMode);

        /**
         * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
         * progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
         * field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use
         * Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs
         * with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity
         * might change over the course of the output. Follow behavior depends on the input scan type. If the source is
         * interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive,
         * the output will be interlaced with top field bottom field first, depending on which of the Follow options you
         * choose.
         * 
         * @param interlaceMode
         *        Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create
         *        a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or
         *        Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity
         *        throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD)
         *        to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the
         *        output field polarity might change over the course of the output. Follow behavior depends on the input
         *        scan type. If the source is interlaced, the output will be interlaced with the same polarity as the
         *        source. If the source is progressive, the output will be interlaced with top field bottom field first,
         *        depending on which of the Follow options you choose.
         * @see H265InterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265InterlaceMode
         */
        Builder interlaceMode(H265InterlaceMode interlaceMode);

        /**
         * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate
         * control mode is QVBR.
         * 
         * @param maxBitrate
         *        Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when
         *        Rate control mode is QVBR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a
         * scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to
         * the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal
         * cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note:
         * Maximum GOP stretch = GOP size + Min-I-interval - 1
         * 
         * @param minIInterval
         *        Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change
         *        Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is
         *        shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well
         *        as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when
         *        Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minIInterval(Integer minIInterval);

        /**
         * Number of B-frames between reference frames.
         * 
         * @param numberBFramesBetweenReferenceFrames
         *        Number of B-frames between reference frames.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames);

        /**
         * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or
         * interlaced encoding.
         * 
         * @param numberReferenceFrames
         *        Number of reference frames to use. The encoder may use more than requested if using B-frames and/or
         *        interlaced encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberReferenceFrames(Integer numberReferenceFrames);

        /**
         * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         * behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
         * specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR
         * by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must
         * also specify values for the parNumerator and parDenominator settings.
         * 
         * @param parControl
         *        Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         *        behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output.
         *        To specify a different PAR in the console, choose any value other than Follow source. To specify a
         *        different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for
         *        this setting, you must also specify values for the parNumerator and parDenominator settings.
         * @see H265ParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265ParControl
         */
        Builder parControl(String parControl);

        /**
         * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         * behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
         * specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR
         * by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must
         * also specify values for the parNumerator and parDenominator settings.
         * 
         * @param parControl
         *        Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         *        behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output.
         *        To specify a different PAR in the console, choose any value other than Follow source. To specify a
         *        different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for
         *        this setting, you must also specify values for the parNumerator and parDenominator settings.
         * @see H265ParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265ParControl
         */
        Builder parControl(H265ParControl parControl);

        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any
         * value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from
         * your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would
         * specify the ratio 40:33. In this example, the value for parDenominator is 33.
         * 
         * @param parDenominator
         *        Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds
         *        to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is
         *        different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC
         *        widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parDenominator(Integer parDenominator);

        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any
         * value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from
         * your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would
         * specify the ratio 40:33. In this example, the value for parNumerator is 40.
         * 
         * @param parNumerator
         *        Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds
         *        to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is
         *        different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC
         *        widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parNumerator(Integer parNumerator);

        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed
         * for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         * 
         * @param qualityTuningLevel
         *        Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
         *        speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         * @see H265QualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265QualityTuningLevel
         */
        Builder qualityTuningLevel(String qualityTuningLevel);

        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed
         * for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         * 
         * @param qualityTuningLevel
         *        Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
         *        speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         * @see H265QualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265QualityTuningLevel
         */
        Builder qualityTuningLevel(H265QualityTuningLevel qualityTuningLevel);

        /**
         * Settings for quality-defined variable bitrate encoding with the H.265 codec. Required when you set Rate
         * control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don't
         * define Rate control mode.
         * 
         * @param qvbrSettings
         *        Settings for quality-defined variable bitrate encoding with the H.265 codec. Required when you set
         *        Rate control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or
         *        when you don't define Rate control mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qvbrSettings(H265QvbrSettings qvbrSettings);

        /**
         * Settings for quality-defined variable bitrate encoding with the H.265 codec. Required when you set Rate
         * control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don't
         * define Rate control mode. This is a convenience that creates an instance of the
         * {@link H265QvbrSettings.Builder} avoiding the need to create one manually via
         * {@link H265QvbrSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link H265QvbrSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #qvbrSettings(H265QvbrSettings)}.
         * 
         * @param qvbrSettings
         *        a consumer that will call methods on {@link H265QvbrSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qvbrSettings(H265QvbrSettings)
         */
        default Builder qvbrSettings(Consumer<H265QvbrSettings.Builder> qvbrSettings) {
            return qvbrSettings(H265QvbrSettings.builder().applyMutation(qvbrSettings).build());
        }

        /**
         * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
         * quality-defined variable bitrate (QVBR).
         * 
         * @param rateControlMode
         *        Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR)
         *        or quality-defined variable bitrate (QVBR).
         * @see H265RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265RateControlMode
         */
        Builder rateControlMode(String rateControlMode);

        /**
         * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
         * quality-defined variable bitrate (QVBR).
         * 
         * @param rateControlMode
         *        Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR)
         *        or quality-defined variable bitrate (QVBR).
         * @see H265RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265RateControlMode
         */
        Builder rateControlMode(H265RateControlMode rateControlMode);

        /**
         * Specify Sample Adaptive Offset (SAO) filter strength. Adaptive mode dynamically selects best strength based
         * on content
         * 
         * @param sampleAdaptiveOffsetFilterMode
         *        Specify Sample Adaptive Offset (SAO) filter strength. Adaptive mode dynamically selects best strength
         *        based on content
         * @see H265SampleAdaptiveOffsetFilterMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265SampleAdaptiveOffsetFilterMode
         */
        Builder sampleAdaptiveOffsetFilterMode(String sampleAdaptiveOffsetFilterMode);

        /**
         * Specify Sample Adaptive Offset (SAO) filter strength. Adaptive mode dynamically selects best strength based
         * on content
         * 
         * @param sampleAdaptiveOffsetFilterMode
         *        Specify Sample Adaptive Offset (SAO) filter strength. Adaptive mode dynamically selects best strength
         *        based on content
         * @see H265SampleAdaptiveOffsetFilterMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265SampleAdaptiveOffsetFilterMode
         */
        Builder sampleAdaptiveOffsetFilterMode(H265SampleAdaptiveOffsetFilterMode sampleAdaptiveOffsetFilterMode);

        /**
         * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
         * this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
         * output. In this case, each progressive frame from the input corresponds to an interlaced field in the output.
         * Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic
         * interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you
         * choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized
         * interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized
         * interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized
         * interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than
         * Progressive (PROGRESSIVE).
         * 
         * @param scanTypeConversionMode
         *        Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate.
         *        In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality
         *        interlaced output. In this case, each progressive frame from the input corresponds to an interlaced
         *        field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output
         *        frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then
         *        interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a
         *        value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic
         *        interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None
         *        (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also
         *        set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
         * @see H265ScanTypeConversionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265ScanTypeConversionMode
         */
        Builder scanTypeConversionMode(String scanTypeConversionMode);

        /**
         * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
         * this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
         * output. In this case, each progressive frame from the input corresponds to an interlaced field in the output.
         * Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic
         * interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you
         * choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized
         * interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized
         * interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized
         * interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than
         * Progressive (PROGRESSIVE).
         * 
         * @param scanTypeConversionMode
         *        Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate.
         *        In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality
         *        interlaced output. In this case, each progressive frame from the input corresponds to an interlaced
         *        field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output
         *        frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then
         *        interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a
         *        value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic
         *        interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None
         *        (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also
         *        set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
         * @see H265ScanTypeConversionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265ScanTypeConversionMode
         */
        Builder scanTypeConversionMode(H265ScanTypeConversionMode scanTypeConversionMode);

        /**
         * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
         * video quality and is enabled by default. If this output uses QVBR, choose Transition detection
         * (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
         * https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         * 
         * @param sceneChangeDetect
         *        Enable this setting to insert I-frames at scene changes that the service automatically detects. This
         *        improves video quality and is enabled by default. If this output uses QVBR, choose Transition
         *        detection (TRANSITION_DETECTION) for further video quality improvement. For more information about
         *        QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         * @see H265SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265SceneChangeDetect
         */
        Builder sceneChangeDetect(String sceneChangeDetect);

        /**
         * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
         * video quality and is enabled by default. If this output uses QVBR, choose Transition detection
         * (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
         * https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         * 
         * @param sceneChangeDetect
         *        Enable this setting to insert I-frames at scene changes that the service automatically detects. This
         *        improves video quality and is enabled by default. If this output uses QVBR, choose Transition
         *        detection (TRANSITION_DETECTION) for further video quality improvement. For more information about
         *        QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         * @see H265SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265SceneChangeDetect
         */
        Builder sceneChangeDetect(H265SceneChangeDetect sceneChangeDetect);

        /**
         * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
         * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
         * 
         * @param slices
         *        Number of slices per picture. Must be less than or equal to the number of macroblock rows for
         *        progressive pictures, and less than or equal to half the number of macroblock rows for interlaced
         *        pictures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slices(Integer slices);

        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
         * create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and
         * resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly
         * reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job
         * specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator)
         * to 1.
         * 
         * @param slowPal
         *        Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow
         *        PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25
         *        fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting
         *        will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25.
         *        In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
         *        (framerateDenominator) to 1.
         * @see H265SlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265SlowPal
         */
        Builder slowPal(String slowPal);

        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
         * create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and
         * resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly
         * reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job
         * specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator)
         * to 1.
         * 
         * @param slowPal
         *        Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow
         *        PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25
         *        fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting
         *        will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25.
         *        In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
         *        (framerateDenominator) to 1.
         * @see H265SlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265SlowPal
         */
        Builder slowPal(H265SlowPal slowPal);

        /**
         * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial
         * variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can
         * sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small
         * distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth
         * textured blocks are encoded with more bits. Enabling this feature will almost always improve your video
         * quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to
         * be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex
         * texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive
         * quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For
         * homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of
         * textures, set it to High or Higher.
         * 
         * @param spatialAdaptiveQuantization
         *        Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial
         *        variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas
         *        that can sustain more distortion with no noticeable visual degradation and uses more bits on areas
         *        where any small distortion will be noticeable. For example, complex textured blocks are encoded with
         *        fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost
         *        always improve your video quality. Note, though, that this feature doesn't take into account where the
         *        viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of
         *        the screen with a lot of complex texture, you might choose to disable this feature. Related setting:
         *        When you enable spatial adaptive quantization, set the value for Adaptive quantization
         *        (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video
         *        games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
         * @see H265SpatialAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265SpatialAdaptiveQuantization
         */
        Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization);

        /**
         * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial
         * variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can
         * sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small
         * distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth
         * textured blocks are encoded with more bits. Enabling this feature will almost always improve your video
         * quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to
         * be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex
         * texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive
         * quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For
         * homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of
         * textures, set it to High or Higher.
         * 
         * @param spatialAdaptiveQuantization
         *        Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial
         *        variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas
         *        that can sustain more distortion with no noticeable visual degradation and uses more bits on areas
         *        where any small distortion will be noticeable. For example, complex textured blocks are encoded with
         *        fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost
         *        always improve your video quality. Note, though, that this feature doesn't take into account where the
         *        viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of
         *        the screen with a lot of complex texture, you might choose to disable this feature. Related setting:
         *        When you enable spatial adaptive quantization, set the value for Adaptive quantization
         *        (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video
         *        games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
         * @see H265SpatialAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265SpatialAdaptiveQuantization
         */
        Builder spatialAdaptiveQuantization(H265SpatialAdaptiveQuantization spatialAdaptiveQuantization);

        /**
         * This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field
         * works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams >
         * Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive,
         * Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft:
         * produces 23.976; the player converts this output to 29.97i.
         * 
         * @param telecine
         *        This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This
         *        field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and
         *        the Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the
         *        output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from
         *        23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.
         * @see H265Telecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265Telecine
         */
        Builder telecine(String telecine);

        /**
         * This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field
         * works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams >
         * Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive,
         * Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft:
         * produces 23.976; the player converts this output to 29.97i.
         * 
         * @param telecine
         *        This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This
         *        field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and
         *        the Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the
         *        output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from
         *        23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.
         * @see H265Telecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265Telecine
         */
        Builder telecine(H265Telecine telecine);

        /**
         * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal
         * variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the
         * frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example,
         * this feature improves the readability of text tickers on newscasts and scoreboards on sports matches.
         * Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't
         * take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their
         * attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes'
         * faces, you might choose to disable this feature. Related setting: When you enable temporal quantization,
         * adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
         * 
         * @param temporalAdaptiveQuantization
         *        Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal
         *        variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of
         *        the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot.
         *        For example, this feature improves the readability of text tickers on newscasts and scoreboards on
         *        sports matches. Enabling this feature will almost always improve your video quality. Note, though,
         *        that this feature doesn't take into account where the viewer's attention is likely to be. If viewers
         *        are likely to be focusing their attention on a part of the screen that doesn't have moving objects
         *        with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related
         *        setting: When you enable temporal quantization, adjust the strength of the filter with the setting
         *        Adaptive quantization (adaptiveQuantization).
         * @see H265TemporalAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265TemporalAdaptiveQuantization
         */
        Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization);

        /**
         * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal
         * variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the
         * frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example,
         * this feature improves the readability of text tickers on newscasts and scoreboards on sports matches.
         * Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't
         * take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their
         * attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes'
         * faces, you might choose to disable this feature. Related setting: When you enable temporal quantization,
         * adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
         * 
         * @param temporalAdaptiveQuantization
         *        Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal
         *        variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of
         *        the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot.
         *        For example, this feature improves the readability of text tickers on newscasts and scoreboards on
         *        sports matches. Enabling this feature will almost always improve your video quality. Note, though,
         *        that this feature doesn't take into account where the viewer's attention is likely to be. If viewers
         *        are likely to be focusing their attention on a part of the screen that doesn't have moving objects
         *        with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related
         *        setting: When you enable temporal quantization, adjust the strength of the filter with the setting
         *        Adaptive quantization (adaptiveQuantization).
         * @see H265TemporalAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265TemporalAdaptiveQuantization
         */
        Builder temporalAdaptiveQuantization(H265TemporalAdaptiveQuantization temporalAdaptiveQuantization);

        /**
         * Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on GOP
         * structure: I- and P-frames form one layer, reference B-frames can form a second layer and non-reference
         * b-frames can form a third layer. Decoders can optionally decode only the lower temporal layers to generate a
         * lower frame rate output. For example, given a bitstream with temporal IDs and with b-frames = 1 (i.e. IbPbPb
         * display order), a decoder could decode all the frames for full frame rate output or only the I and P frames
         * (lowest temporal layer) for a half frame rate output.
         * 
         * @param temporalIds
         *        Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on
         *        GOP structure: I- and P-frames form one layer, reference B-frames can form a second layer and
         *        non-reference b-frames can form a third layer. Decoders can optionally decode only the lower temporal
         *        layers to generate a lower frame rate output. For example, given a bitstream with temporal IDs and
         *        with b-frames = 1 (i.e. IbPbPb display order), a decoder could decode all the frames for full frame
         *        rate output or only the I and P frames (lowest temporal layer) for a half frame rate output.
         * @see H265TemporalIds
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265TemporalIds
         */
        Builder temporalIds(String temporalIds);

        /**
         * Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on GOP
         * structure: I- and P-frames form one layer, reference B-frames can form a second layer and non-reference
         * b-frames can form a third layer. Decoders can optionally decode only the lower temporal layers to generate a
         * lower frame rate output. For example, given a bitstream with temporal IDs and with b-frames = 1 (i.e. IbPbPb
         * display order), a decoder could decode all the frames for full frame rate output or only the I and P frames
         * (lowest temporal layer) for a half frame rate output.
         * 
         * @param temporalIds
         *        Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on
         *        GOP structure: I- and P-frames form one layer, reference B-frames can form a second layer and
         *        non-reference b-frames can form a third layer. Decoders can optionally decode only the lower temporal
         *        layers to generate a lower frame rate output. For example, given a bitstream with temporal IDs and
         *        with b-frames = 1 (i.e. IbPbPb display order), a decoder could decode all the frames for full frame
         *        rate output or only the I and P frames (lowest temporal layer) for a half frame rate output.
         * @see H265TemporalIds
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265TemporalIds
         */
        Builder temporalIds(H265TemporalIds temporalIds);

        /**
         * Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
         * 
         * @param tiles
         *        Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
         * @see H265Tiles
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265Tiles
         */
        Builder tiles(String tiles);

        /**
         * Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
         * 
         * @param tiles
         *        Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
         * @see H265Tiles
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265Tiles
         */
        Builder tiles(H265Tiles tiles);

        /**
         * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         * 
         * @param unregisteredSeiTimecode
         *        Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         * @see H265UnregisteredSeiTimecode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265UnregisteredSeiTimecode
         */
        Builder unregisteredSeiTimecode(String unregisteredSeiTimecode);

        /**
         * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         * 
         * @param unregisteredSeiTimecode
         *        Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         * @see H265UnregisteredSeiTimecode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265UnregisteredSeiTimecode
         */
        Builder unregisteredSeiTimecode(H265UnregisteredSeiTimecode unregisteredSeiTimecode);

        /**
         * If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this
         * setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs).
         * Choose HVC1 to mark your output as HVC1. This makes your output compliant with the following specification:
         * ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores
         * parameter set NAL units in the sample headers but not in the samples directly. For MP4 outputs, when you
         * choose HVC1, your output video might not work properly with some downstream systems and video players. The
         * service defaults to marking your output as HEV1. For these outputs, the service writes parameter set NAL
         * units directly into the samples.
         * 
         * @param writeMp4PackagingType
         *        If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use
         *        this setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container
         *        (MP4 outputs). Choose HVC1 to mark your output as HVC1. This makes your output compliant with the
         *        following specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these
         *        outputs, the service stores parameter set NAL units in the sample headers but not in the samples
         *        directly. For MP4 outputs, when you choose HVC1, your output video might not work properly with some
         *        downstream systems and video players. The service defaults to marking your output as HEV1. For these
         *        outputs, the service writes parameter set NAL units directly into the samples.
         * @see H265WriteMp4PackagingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265WriteMp4PackagingType
         */
        Builder writeMp4PackagingType(String writeMp4PackagingType);

        /**
         * If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this
         * setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs).
         * Choose HVC1 to mark your output as HVC1. This makes your output compliant with the following specification:
         * ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores
         * parameter set NAL units in the sample headers but not in the samples directly. For MP4 outputs, when you
         * choose HVC1, your output video might not work properly with some downstream systems and video players. The
         * service defaults to marking your output as HEV1. For these outputs, the service writes parameter set NAL
         * units directly into the samples.
         * 
         * @param writeMp4PackagingType
         *        If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use
         *        this setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container
         *        (MP4 outputs). Choose HVC1 to mark your output as HVC1. This makes your output compliant with the
         *        following specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these
         *        outputs, the service stores parameter set NAL units in the sample headers but not in the samples
         *        directly. For MP4 outputs, when you choose HVC1, your output video might not work properly with some
         *        downstream systems and video players. The service defaults to marking your output as HEV1. For these
         *        outputs, the service writes parameter set NAL units directly into the samples.
         * @see H265WriteMp4PackagingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265WriteMp4PackagingType
         */
        Builder writeMp4PackagingType(H265WriteMp4PackagingType writeMp4PackagingType);
    }

    static final class BuilderImpl implements Builder {
        private String adaptiveQuantization;

        private String alternateTransferFunctionSei;

        private Integer bitrate;

        private String codecLevel;

        private String codecProfile;

        private String dynamicSubGop;

        private String flickerAdaptiveQuantization;

        private String framerateControl;

        private String framerateConversionAlgorithm;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private String gopBReference;

        private Integer gopClosedCadence;

        private Double gopSize;

        private String gopSizeUnits;

        private Integer hrdBufferInitialFillPercentage;

        private Integer hrdBufferSize;

        private String interlaceMode;

        private Integer maxBitrate;

        private Integer minIInterval;

        private Integer numberBFramesBetweenReferenceFrames;

        private Integer numberReferenceFrames;

        private String parControl;

        private Integer parDenominator;

        private Integer parNumerator;

        private String qualityTuningLevel;

        private H265QvbrSettings qvbrSettings;

        private String rateControlMode;

        private String sampleAdaptiveOffsetFilterMode;

        private String scanTypeConversionMode;

        private String sceneChangeDetect;

        private Integer slices;

        private String slowPal;

        private String spatialAdaptiveQuantization;

        private String telecine;

        private String temporalAdaptiveQuantization;

        private String temporalIds;

        private String tiles;

        private String unregisteredSeiTimecode;

        private String writeMp4PackagingType;

        private BuilderImpl() {
        }

        private BuilderImpl(H265Settings model) {
            adaptiveQuantization(model.adaptiveQuantization);
            alternateTransferFunctionSei(model.alternateTransferFunctionSei);
            bitrate(model.bitrate);
            codecLevel(model.codecLevel);
            codecProfile(model.codecProfile);
            dynamicSubGop(model.dynamicSubGop);
            flickerAdaptiveQuantization(model.flickerAdaptiveQuantization);
            framerateControl(model.framerateControl);
            framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            gopBReference(model.gopBReference);
            gopClosedCadence(model.gopClosedCadence);
            gopSize(model.gopSize);
            gopSizeUnits(model.gopSizeUnits);
            hrdBufferInitialFillPercentage(model.hrdBufferInitialFillPercentage);
            hrdBufferSize(model.hrdBufferSize);
            interlaceMode(model.interlaceMode);
            maxBitrate(model.maxBitrate);
            minIInterval(model.minIInterval);
            numberBFramesBetweenReferenceFrames(model.numberBFramesBetweenReferenceFrames);
            numberReferenceFrames(model.numberReferenceFrames);
            parControl(model.parControl);
            parDenominator(model.parDenominator);
            parNumerator(model.parNumerator);
            qualityTuningLevel(model.qualityTuningLevel);
            qvbrSettings(model.qvbrSettings);
            rateControlMode(model.rateControlMode);
            sampleAdaptiveOffsetFilterMode(model.sampleAdaptiveOffsetFilterMode);
            scanTypeConversionMode(model.scanTypeConversionMode);
            sceneChangeDetect(model.sceneChangeDetect);
            slices(model.slices);
            slowPal(model.slowPal);
            spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
            telecine(model.telecine);
            temporalAdaptiveQuantization(model.temporalAdaptiveQuantization);
            temporalIds(model.temporalIds);
            tiles(model.tiles);
            unregisteredSeiTimecode(model.unregisteredSeiTimecode);
            writeMp4PackagingType(model.writeMp4PackagingType);
        }

        public final String getAdaptiveQuantization() {
            return adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(H265AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        public final String getAlternateTransferFunctionSei() {
            return alternateTransferFunctionSei;
        }

        @Override
        public final Builder alternateTransferFunctionSei(String alternateTransferFunctionSei) {
            this.alternateTransferFunctionSei = alternateTransferFunctionSei;
            return this;
        }

        @Override
        public final Builder alternateTransferFunctionSei(H265AlternateTransferFunctionSei alternateTransferFunctionSei) {
            this.alternateTransferFunctionSei(alternateTransferFunctionSei == null ? null : alternateTransferFunctionSei
                    .toString());
            return this;
        }

        public final void setAlternateTransferFunctionSei(String alternateTransferFunctionSei) {
            this.alternateTransferFunctionSei = alternateTransferFunctionSei;
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodecLevel() {
            return codecLevel;
        }

        @Override
        public final Builder codecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
            return this;
        }

        @Override
        public final Builder codecLevel(H265CodecLevel codecLevel) {
            this.codecLevel(codecLevel == null ? null : codecLevel.toString());
            return this;
        }

        public final void setCodecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
        }

        public final String getCodecProfile() {
            return codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(H265CodecProfile codecProfile) {
            this.codecProfile(codecProfile == null ? null : codecProfile.toString());
            return this;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        public final String getDynamicSubGop() {
            return dynamicSubGop;
        }

        @Override
        public final Builder dynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
            return this;
        }

        @Override
        public final Builder dynamicSubGop(H265DynamicSubGop dynamicSubGop) {
            this.dynamicSubGop(dynamicSubGop == null ? null : dynamicSubGop.toString());
            return this;
        }

        public final void setDynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
        }

        public final String getFlickerAdaptiveQuantization() {
            return flickerAdaptiveQuantization;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(H265FlickerAdaptiveQuantization flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization(flickerAdaptiveQuantization == null ? null : flickerAdaptiveQuantization.toString());
            return this;
        }

        public final void setFlickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
        }

        public final String getFramerateControl() {
            return framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(H265FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(H265FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm
                    .toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final String getGopBReference() {
            return gopBReference;
        }

        @Override
        public final Builder gopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
            return this;
        }

        @Override
        public final Builder gopBReference(H265GopBReference gopBReference) {
            this.gopBReference(gopBReference == null ? null : gopBReference.toString());
            return this;
        }

        public final void setGopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
        }

        public final Integer getGopClosedCadence() {
            return gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        public final Double getGopSize() {
            return gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        public final String getGopSizeUnits() {
            return gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(H265GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        public final Integer getHrdBufferInitialFillPercentage() {
            return hrdBufferInitialFillPercentage;
        }

        @Override
        public final Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
            return this;
        }

        public final void setHrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
        }

        public final Integer getHrdBufferSize() {
            return hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        public final String getInterlaceMode() {
            return interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(H265InterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMinIInterval() {
            return minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        public final Integer getNumberBFramesBetweenReferenceFrames() {
            return numberBFramesBetweenReferenceFrames;
        }

        @Override
        public final Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
            return this;
        }

        public final void setNumberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
        }

        public final Integer getNumberReferenceFrames() {
            return numberReferenceFrames;
        }

        @Override
        public final Builder numberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
            return this;
        }

        public final void setNumberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
        }

        public final String getParControl() {
            return parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(H265ParControl parControl) {
            this.parControl(parControl == null ? null : parControl.toString());
            return this;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        public final Integer getParDenominator() {
            return parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        public final Integer getParNumerator() {
            return parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        public final String getQualityTuningLevel() {
            return qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(H265QualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel == null ? null : qualityTuningLevel.toString());
            return this;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        public final H265QvbrSettings.Builder getQvbrSettings() {
            return qvbrSettings != null ? qvbrSettings.toBuilder() : null;
        }

        @Override
        public final Builder qvbrSettings(H265QvbrSettings qvbrSettings) {
            this.qvbrSettings = qvbrSettings;
            return this;
        }

        public final void setQvbrSettings(H265QvbrSettings.BuilderImpl qvbrSettings) {
            this.qvbrSettings = qvbrSettings != null ? qvbrSettings.build() : null;
        }

        public final String getRateControlMode() {
            return rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(H265RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final String getSampleAdaptiveOffsetFilterMode() {
            return sampleAdaptiveOffsetFilterMode;
        }

        @Override
        public final Builder sampleAdaptiveOffsetFilterMode(String sampleAdaptiveOffsetFilterMode) {
            this.sampleAdaptiveOffsetFilterMode = sampleAdaptiveOffsetFilterMode;
            return this;
        }

        @Override
        public final Builder sampleAdaptiveOffsetFilterMode(H265SampleAdaptiveOffsetFilterMode sampleAdaptiveOffsetFilterMode) {
            this.sampleAdaptiveOffsetFilterMode(sampleAdaptiveOffsetFilterMode == null ? null : sampleAdaptiveOffsetFilterMode
                    .toString());
            return this;
        }

        public final void setSampleAdaptiveOffsetFilterMode(String sampleAdaptiveOffsetFilterMode) {
            this.sampleAdaptiveOffsetFilterMode = sampleAdaptiveOffsetFilterMode;
        }

        public final String getScanTypeConversionMode() {
            return scanTypeConversionMode;
        }

        @Override
        public final Builder scanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
            return this;
        }

        @Override
        public final Builder scanTypeConversionMode(H265ScanTypeConversionMode scanTypeConversionMode) {
            this.scanTypeConversionMode(scanTypeConversionMode == null ? null : scanTypeConversionMode.toString());
            return this;
        }

        public final void setScanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
        }

        public final String getSceneChangeDetect() {
            return sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(H265SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect == null ? null : sceneChangeDetect.toString());
            return this;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        public final Integer getSlices() {
            return slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        public final String getSlowPal() {
            return slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(H265SlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        public final String getSpatialAdaptiveQuantization() {
            return spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(H265SpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization == null ? null : spatialAdaptiveQuantization.toString());
            return this;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        public final String getTelecine() {
            return telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(H265Telecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        public final String getTemporalAdaptiveQuantization() {
            return temporalAdaptiveQuantization;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(H265TemporalAdaptiveQuantization temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization(temporalAdaptiveQuantization == null ? null : temporalAdaptiveQuantization
                    .toString());
            return this;
        }

        public final void setTemporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
        }

        public final String getTemporalIds() {
            return temporalIds;
        }

        @Override
        public final Builder temporalIds(String temporalIds) {
            this.temporalIds = temporalIds;
            return this;
        }

        @Override
        public final Builder temporalIds(H265TemporalIds temporalIds) {
            this.temporalIds(temporalIds == null ? null : temporalIds.toString());
            return this;
        }

        public final void setTemporalIds(String temporalIds) {
            this.temporalIds = temporalIds;
        }

        public final String getTiles() {
            return tiles;
        }

        @Override
        public final Builder tiles(String tiles) {
            this.tiles = tiles;
            return this;
        }

        @Override
        public final Builder tiles(H265Tiles tiles) {
            this.tiles(tiles == null ? null : tiles.toString());
            return this;
        }

        public final void setTiles(String tiles) {
            this.tiles = tiles;
        }

        public final String getUnregisteredSeiTimecode() {
            return unregisteredSeiTimecode;
        }

        @Override
        public final Builder unregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
            return this;
        }

        @Override
        public final Builder unregisteredSeiTimecode(H265UnregisteredSeiTimecode unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode(unregisteredSeiTimecode == null ? null : unregisteredSeiTimecode.toString());
            return this;
        }

        public final void setUnregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
        }

        public final String getWriteMp4PackagingType() {
            return writeMp4PackagingType;
        }

        @Override
        public final Builder writeMp4PackagingType(String writeMp4PackagingType) {
            this.writeMp4PackagingType = writeMp4PackagingType;
            return this;
        }

        @Override
        public final Builder writeMp4PackagingType(H265WriteMp4PackagingType writeMp4PackagingType) {
            this.writeMp4PackagingType(writeMp4PackagingType == null ? null : writeMp4PackagingType.toString());
            return this;
        }

        public final void setWriteMp4PackagingType(String writeMp4PackagingType) {
            this.writeMp4PackagingType = writeMp4PackagingType;
        }

        @Override
        public H265Settings build() {
            return new H265Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
