/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of
 * quantization for your video content. When you want to apply your quantization settings manually, you must set
 * H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive
 * quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this
 * transcode, set Adaptive quantization (H264AdaptiveQuantization) to Off (OFF). Related settings: The value that you
 * choose here applies to the following settings: H264FlickerAdaptiveQuantization, H264SpatialAdaptiveQuantization, and
 * H264TemporalAdaptiveQuantization.
 */
@Generated("software.amazon.awssdk:codegen")
public enum H264AdaptiveQuantization {
    OFF("OFF"),

    AUTO("AUTO"),

    LOW("LOW"),

    MEDIUM("MEDIUM"),

    HIGH("HIGH"),

    HIGHER("HIGHER"),

    MAX("MAX"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private H264AdaptiveQuantization(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H264AdaptiveQuantization corresponding to the value
     */
    public static H264AdaptiveQuantization fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(H264AdaptiveQuantization.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H264AdaptiveQuantization}s
     */
    public static Set<H264AdaptiveQuantization> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
