/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FrameCaptureSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<FrameCaptureSettings.Builder, FrameCaptureSettings> {
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(FrameCaptureSettings::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(FrameCaptureSettings::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<Integer> MAX_CAPTURES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCaptures").getter(getter(FrameCaptureSettings::maxCaptures)).setter(setter(Builder::maxCaptures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCaptures").build()).build();

    private static final SdkField<Integer> QUALITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quality").getter(getter(FrameCaptureSettings::quality)).setter(setter(Builder::quality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMERATE_DENOMINATOR_FIELD,
            FRAMERATE_NUMERATOR_FIELD, MAX_CAPTURES_FIELD, QUALITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final Integer maxCaptures;

    private final Integer quality;

    private FrameCaptureSettings(BuilderImpl builder) {
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.maxCaptures = builder.maxCaptures;
        this.quality = builder.quality;
    }

    /**
     * Frame capture will encode the first frame of the output stream, then one frame every
     * framerateDenominator/framerateNumerator seconds. For example, settings of framerateNumerator = 1 and
     * framerateDenominator = 3 (a rate of 1/3 frame per second) will capture the first frame, then 1 frame every 3s.
     * Files will be named as filename.n.jpg where n is the 0-based sequence number of each Capture.
     * 
     * @return Frame capture will encode the first frame of the output stream, then one frame every
     *         framerateDenominator/framerateNumerator seconds. For example, settings of framerateNumerator = 1 and
     *         framerateDenominator = 3 (a rate of 1/3 frame per second) will capture the first frame, then 1 frame
     *         every 3s. Files will be named as filename.n.jpg where n is the 0-based sequence number of each Capture.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * Frame capture will encode the first frame of the output stream, then one frame every
     * framerateDenominator/framerateNumerator seconds. For example, settings of framerateNumerator = 1 and
     * framerateDenominator = 3 (a rate of 1/3 frame per second) will capture the first frame, then 1 frame every 3s.
     * Files will be named as filename.NNNNNNN.jpg where N is the 0-based frame sequence number zero padded to 7 decimal
     * places.
     * 
     * @return Frame capture will encode the first frame of the output stream, then one frame every
     *         framerateDenominator/framerateNumerator seconds. For example, settings of framerateNumerator = 1 and
     *         framerateDenominator = 3 (a rate of 1/3 frame per second) will capture the first frame, then 1 frame
     *         every 3s. Files will be named as filename.NNNNNNN.jpg where N is the 0-based frame sequence number zero
     *         padded to 7 decimal places.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * Maximum number of captures (encoded jpg output files).
     * 
     * @return Maximum number of captures (encoded jpg output files).
     */
    public final Integer maxCaptures() {
        return maxCaptures;
    }

    /**
     * JPEG Quality - a higher value equals higher quality.
     * 
     * @return JPEG Quality - a higher value equals higher quality.
     */
    public final Integer quality() {
        return quality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(maxCaptures());
        hashCode = 31 * hashCode + Objects.hashCode(quality());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameCaptureSettings)) {
            return false;
        }
        FrameCaptureSettings other = (FrameCaptureSettings) obj;
        return Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator())
                && Objects.equals(maxCaptures(), other.maxCaptures()) && Objects.equals(quality(), other.quality());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FrameCaptureSettings").add("FramerateDenominator", framerateDenominator())
                .add("FramerateNumerator", framerateNumerator()).add("MaxCaptures", maxCaptures()).add("Quality", quality())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "MaxCaptures":
            return Optional.ofNullable(clazz.cast(maxCaptures()));
        case "Quality":
            return Optional.ofNullable(clazz.cast(quality()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrameCaptureSettings, T> g) {
        return obj -> g.apply((FrameCaptureSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FrameCaptureSettings> {
        /**
         * Frame capture will encode the first frame of the output stream, then one frame every
         * framerateDenominator/framerateNumerator seconds. For example, settings of framerateNumerator = 1 and
         * framerateDenominator = 3 (a rate of 1/3 frame per second) will capture the first frame, then 1 frame every
         * 3s. Files will be named as filename.n.jpg where n is the 0-based sequence number of each Capture.
         * 
         * @param framerateDenominator
         *        Frame capture will encode the first frame of the output stream, then one frame every
         *        framerateDenominator/framerateNumerator seconds. For example, settings of framerateNumerator = 1 and
         *        framerateDenominator = 3 (a rate of 1/3 frame per second) will capture the first frame, then 1 frame
         *        every 3s. Files will be named as filename.n.jpg where n is the 0-based sequence number of each
         *        Capture.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * Frame capture will encode the first frame of the output stream, then one frame every
         * framerateDenominator/framerateNumerator seconds. For example, settings of framerateNumerator = 1 and
         * framerateDenominator = 3 (a rate of 1/3 frame per second) will capture the first frame, then 1 frame every
         * 3s. Files will be named as filename.NNNNNNN.jpg where N is the 0-based frame sequence number zero padded to 7
         * decimal places.
         * 
         * @param framerateNumerator
         *        Frame capture will encode the first frame of the output stream, then one frame every
         *        framerateDenominator/framerateNumerator seconds. For example, settings of framerateNumerator = 1 and
         *        framerateDenominator = 3 (a rate of 1/3 frame per second) will capture the first frame, then 1 frame
         *        every 3s. Files will be named as filename.NNNNNNN.jpg where N is the 0-based frame sequence number
         *        zero padded to 7 decimal places.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * Maximum number of captures (encoded jpg output files).
         * 
         * @param maxCaptures
         *        Maximum number of captures (encoded jpg output files).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCaptures(Integer maxCaptures);

        /**
         * JPEG Quality - a higher value equals higher quality.
         * 
         * @param quality
         *        JPEG Quality - a higher value equals higher quality.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quality(Integer quality);
    }

    static final class BuilderImpl implements Builder {
        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private Integer maxCaptures;

        private Integer quality;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameCaptureSettings model) {
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            maxCaptures(model.maxCaptures);
            quality(model.quality);
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final Integer getMaxCaptures() {
            return maxCaptures;
        }

        @Override
        public final Builder maxCaptures(Integer maxCaptures) {
            this.maxCaptures = maxCaptures;
            return this;
        }

        public final void setMaxCaptures(Integer maxCaptures) {
            this.maxCaptures = maxCaptures;
        }

        public final Integer getQuality() {
            return quality;
        }

        @Override
        public final Builder quality(Integer quality) {
            this.quality = quality;
            return this;
        }

        public final void setQuality(Integer quality) {
            this.quality = quality;
        }

        @Override
        public FrameCaptureSettings build() {
            return new FrameCaptureSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
