/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Type) under (OutputGroups)>(OutputGroupSettings) to CMAF_GROUP_SETTINGS. Each output in a CMAF
 * Output Group may only contain a single video, audio, or caption output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CmafGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<CmafGroupSettings.Builder, CmafGroupSettings> {
    private static final SdkField<List<CmafAdditionalManifest>> ADDITIONAL_MANIFESTS_FIELD = SdkField
            .<List<CmafAdditionalManifest>> builder(MarshallingType.LIST)
            .memberName("AdditionalManifests")
            .getter(getter(CmafGroupSettings::additionalManifests))
            .setter(setter(Builder::additionalManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CmafAdditionalManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(CmafAdditionalManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BASE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseUrl").getter(getter(CmafGroupSettings::baseUrl)).setter(setter(Builder::baseUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrl").build()).build();

    private static final SdkField<String> CLIENT_CACHE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientCache").getter(getter(CmafGroupSettings::clientCacheAsString))
            .setter(setter(Builder::clientCache))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCache").build()).build();

    private static final SdkField<String> CODEC_SPECIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodecSpecification").getter(getter(CmafGroupSettings::codecSpecificationAsString))
            .setter(setter(Builder::codecSpecification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSpecification").build())
            .build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(CmafGroupSettings::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField
            .<DestinationSettings> builder(MarshallingType.SDK_POJO).memberName("DestinationSettings")
            .getter(getter(CmafGroupSettings::destinationSettings)).setter(setter(Builder::destinationSettings))
            .constructor(DestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build())
            .build();

    private static final SdkField<CmafEncryptionSettings> ENCRYPTION_FIELD = SdkField
            .<CmafEncryptionSettings> builder(MarshallingType.SDK_POJO).memberName("Encryption")
            .getter(getter(CmafGroupSettings::encryption)).setter(setter(Builder::encryption))
            .constructor(CmafEncryptionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<Integer> FRAGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FragmentLength").getter(getter(CmafGroupSettings::fragmentLength))
            .setter(setter(Builder::fragmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentLength").build()).build();

    private static final SdkField<String> MANIFEST_COMPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestCompression").getter(getter(CmafGroupSettings::manifestCompressionAsString))
            .setter(setter(Builder::manifestCompression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestCompression").build())
            .build();

    private static final SdkField<String> MANIFEST_DURATION_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestDurationFormat").getter(getter(CmafGroupSettings::manifestDurationFormatAsString))
            .setter(setter(Builder::manifestDurationFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestDurationFormat").build())
            .build();

    private static final SdkField<Integer> MIN_BUFFER_TIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinBufferTime").getter(getter(CmafGroupSettings::minBufferTime)).setter(setter(Builder::minBufferTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBufferTime").build()).build();

    private static final SdkField<Double> MIN_FINAL_SEGMENT_LENGTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinFinalSegmentLength").getter(getter(CmafGroupSettings::minFinalSegmentLength))
            .setter(setter(Builder::minFinalSegmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minFinalSegmentLength").build())
            .build();

    private static final SdkField<String> MPD_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MpdProfile").getter(getter(CmafGroupSettings::mpdProfileAsString)).setter(setter(Builder::mpdProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpdProfile").build()).build();

    private static final SdkField<String> SEGMENT_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentControl").getter(getter(CmafGroupSettings::segmentControlAsString))
            .setter(setter(Builder::segmentControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentControl").build()).build();

    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentLength").getter(getter(CmafGroupSettings::segmentLength)).setter(setter(Builder::segmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()).build();

    private static final SdkField<String> STREAM_INF_RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamInfResolution").getter(getter(CmafGroupSettings::streamInfResolutionAsString))
            .setter(setter(Builder::streamInfResolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamInfResolution").build())
            .build();

    private static final SdkField<String> WRITE_DASH_MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WriteDashManifest").getter(getter(CmafGroupSettings::writeDashManifestAsString))
            .setter(setter(Builder::writeDashManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeDashManifest").build()).build();

    private static final SdkField<String> WRITE_HLS_MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WriteHlsManifest").getter(getter(CmafGroupSettings::writeHlsManifestAsString))
            .setter(setter(Builder::writeHlsManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeHlsManifest").build()).build();

    private static final SdkField<String> WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WriteSegmentTimelineInRepresentation")
            .getter(getter(CmafGroupSettings::writeSegmentTimelineInRepresentationAsString))
            .setter(setter(Builder::writeSegmentTimelineInRepresentation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("writeSegmentTimelineInRepresentation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_MANIFESTS_FIELD,
            BASE_URL_FIELD, CLIENT_CACHE_FIELD, CODEC_SPECIFICATION_FIELD, DESTINATION_FIELD, DESTINATION_SETTINGS_FIELD,
            ENCRYPTION_FIELD, FRAGMENT_LENGTH_FIELD, MANIFEST_COMPRESSION_FIELD, MANIFEST_DURATION_FORMAT_FIELD,
            MIN_BUFFER_TIME_FIELD, MIN_FINAL_SEGMENT_LENGTH_FIELD, MPD_PROFILE_FIELD, SEGMENT_CONTROL_FIELD,
            SEGMENT_LENGTH_FIELD, STREAM_INF_RESOLUTION_FIELD, WRITE_DASH_MANIFEST_FIELD, WRITE_HLS_MANIFEST_FIELD,
            WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CmafAdditionalManifest> additionalManifests;

    private final String baseUrl;

    private final String clientCache;

    private final String codecSpecification;

    private final String destination;

    private final DestinationSettings destinationSettings;

    private final CmafEncryptionSettings encryption;

    private final Integer fragmentLength;

    private final String manifestCompression;

    private final String manifestDurationFormat;

    private final Integer minBufferTime;

    private final Double minFinalSegmentLength;

    private final String mpdProfile;

    private final String segmentControl;

    private final Integer segmentLength;

    private final String streamInfResolution;

    private final String writeDashManifest;

    private final String writeHlsManifest;

    private final String writeSegmentTimelineInRepresentation;

    private CmafGroupSettings(BuilderImpl builder) {
        this.additionalManifests = builder.additionalManifests;
        this.baseUrl = builder.baseUrl;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
        this.encryption = builder.encryption;
        this.fragmentLength = builder.fragmentLength;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minBufferTime = builder.minBufferTime;
        this.minFinalSegmentLength = builder.minFinalSegmentLength;
        this.mpdProfile = builder.mpdProfile;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.streamInfResolution = builder.streamInfResolution;
        this.writeDashManifest = builder.writeDashManifest;
        this.writeHlsManifest = builder.writeHlsManifest;
        this.writeSegmentTimelineInRepresentation = builder.writeSegmentTimelineInRepresentation;
    }

    /**
     * Returns true if the AdditionalManifests property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAdditionalManifests() {
        return additionalManifests != null && !(additionalManifests instanceof SdkAutoConstructList);
    }

    /**
     * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for each
     * CMAF output group in your job. These default manifests reference every output in the output group. To create
     * additional top-level manifests that reference a subset of the outputs in the output group, specify a list of them
     * here. For each additional manifest that you specify, the service creates one HLS manifest and one DASH manifest.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalManifests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest
     *         for each CMAF output group in your job. These default manifests reference every output in the output
     *         group. To create additional top-level manifests that reference a subset of the outputs in the output
     *         group, specify a list of them here. For each additional manifest that you specify, the service creates
     *         one HLS manifest and one DASH manifest.
     */
    public final List<CmafAdditionalManifest> additionalManifests() {
        return additionalManifests;
    }

    /**
     * A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used if
     * streams are delivered from a different URL than the manifest file.
     * 
     * @return A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used
     *         if streams are delivered from a different URL than the manifest file.
     */
    public final String baseUrl() {
        return baseUrl;
    }

    /**
     * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default
     * value Enabled (ENABLED) and control caching in your video distribution set up. For example, use the Cache-Control
     * http header.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientCache} will
     * return {@link CmafClientCache#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientCacheAsString}.
     * </p>
     * 
     * @return Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
     *         default value Enabled (ENABLED) and control caching in your video distribution set up. For example, use
     *         the Cache-Control http header.
     * @see CmafClientCache
     */
    public final CmafClientCache clientCache() {
        return CmafClientCache.fromValue(clientCache);
    }

    /**
     * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default
     * value Enabled (ENABLED) and control caching in your video distribution set up. For example, use the Cache-Control
     * http header.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientCache} will
     * return {@link CmafClientCache#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientCacheAsString}.
     * </p>
     * 
     * @return Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
     *         default value Enabled (ENABLED) and control caching in your video distribution set up. For example, use
     *         the Cache-Control http header.
     * @see CmafClientCache
     */
    public final String clientCacheAsString() {
        return clientCache;
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #codecSpecification} will return {@link CmafCodecSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #codecSpecificationAsString}.
     * </p>
     * 
     * @return Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @see CmafCodecSpecification
     */
    public final CmafCodecSpecification codecSpecification() {
        return CmafCodecSpecification.fromValue(codecSpecification);
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #codecSpecification} will return {@link CmafCodecSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #codecSpecificationAsString}.
     * </p>
     * 
     * @return Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @see CmafCodecSpecification
     */
    public final String codecSpecificationAsString() {
        return codecSpecification;
    }

    /**
     * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts
     * format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the
     * input file. If your job has multiple inputs, the service uses the filename of the first input file.
     * 
     * @return Use Destination (Destination) to specify the S3 output location and the output filename base. Destination
     *         accepts format identifiers. If you do not specify the base filename in the URI, the service will use the
     *         filename of the input file. If your job has multiple inputs, the service uses the filename of the first
     *         input file.
     */
    public final String destination() {
        return destination;
    }

    /**
     * Settings associated with the destination. Will vary based on the type of destination
     * 
     * @return Settings associated with the destination. Will vary based on the type of destination
     */
    public final DestinationSettings destinationSettings() {
        return destinationSettings;
    }

    /**
     * DRM settings.
     * 
     * @return DRM settings.
     */
    public final CmafEncryptionSettings encryption() {
        return encryption;
    }

    /**
     * Length of fragments to generate (in seconds). Fragment length must be compatible with GOP size and Framerate.
     * Note that fragments will end on the next keyframe after this number of seconds, so actual fragment length may be
     * longer. When Emit Single File is checked, the fragmentation is internal to a single output file and it does not
     * cause the creation of many output files as in other output types.
     * 
     * @return Length of fragments to generate (in seconds). Fragment length must be compatible with GOP size and
     *         Framerate. Note that fragments will end on the next keyframe after this number of seconds, so actual
     *         fragment length may be longer. When Emit Single File is checked, the fragmentation is internal to a
     *         single output file and it does not cause the creation of many output files as in other output types.
     */
    public final Integer fragmentLength() {
        return fragmentLength;
    }

    /**
     * When set to GZIP, compresses HLS playlist.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestCompression} will return {@link CmafManifestCompression#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #manifestCompressionAsString}.
     * </p>
     * 
     * @return When set to GZIP, compresses HLS playlist.
     * @see CmafManifestCompression
     */
    public final CmafManifestCompression manifestCompression() {
        return CmafManifestCompression.fromValue(manifestCompression);
    }

    /**
     * When set to GZIP, compresses HLS playlist.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestCompression} will return {@link CmafManifestCompression#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #manifestCompressionAsString}.
     * </p>
     * 
     * @return When set to GZIP, compresses HLS playlist.
     * @see CmafManifestCompression
     */
    public final String manifestCompressionAsString() {
        return manifestCompression;
    }

    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestDurationFormat} will return {@link CmafManifestDurationFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #manifestDurationFormatAsString}.
     * </p>
     * 
     * @return Indicates whether the output manifest should use floating point values for segment duration.
     * @see CmafManifestDurationFormat
     */
    public final CmafManifestDurationFormat manifestDurationFormat() {
        return CmafManifestDurationFormat.fromValue(manifestDurationFormat);
    }

    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestDurationFormat} will return {@link CmafManifestDurationFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #manifestDurationFormatAsString}.
     * </p>
     * 
     * @return Indicates whether the output manifest should use floating point values for segment duration.
     * @see CmafManifestDurationFormat
     */
    public final String manifestDurationFormatAsString() {
        return manifestDurationFormat;
    }

    /**
     * Minimum time of initially buffered media that is needed to ensure smooth playout.
     * 
     * @return Minimum time of initially buffered media that is needed to ensure smooth playout.
     */
    public final Integer minBufferTime() {
        return minBufferTime;
    }

    /**
     * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back
     * the end of your video asset. If you know that player devices are hanging on the final segment of your video
     * because the length of your final segment is too short, use this setting to specify a minimum final segment
     * length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you
     * specify a value for this setting, the encoder will combine any final segment that is shorter than the length that
     * you specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5
     * seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final
     * segment is 3.5 seconds.
     * 
     * @return Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices
     *         play back the end of your video asset. If you know that player devices are hanging on the final segment
     *         of your video because the length of your final segment is too short, use this setting to specify a
     *         minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than
     *         your segment length. When you specify a value for this setting, the encoder will combine any final
     *         segment that is shorter than the length that you specify with the previous segment. For example, your
     *         segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length;
     *         when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
     */
    public final Double minFinalSegmentLength() {
        return minFinalSegmentLength;
    }

    /**
     * Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the service
     * signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand
     * (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose
     * On-demand, you must also set the output group setting Segment control (SegmentControl) to Single file
     * (SINGLE_FILE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mpdProfile} will
     * return {@link CmafMpdProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mpdProfileAsString}.
     * </p>
     * 
     * @return Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the
     *         service signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose
     *         On-demand (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your
     *         .mpd. When you choose On-demand, you must also set the output group setting Segment control
     *         (SegmentControl) to Single file (SINGLE_FILE).
     * @see CmafMpdProfile
     */
    public final CmafMpdProfile mpdProfile() {
        return CmafMpdProfile.fromValue(mpdProfile);
    }

    /**
     * Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the service
     * signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand
     * (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose
     * On-demand, you must also set the output group setting Segment control (SegmentControl) to Single file
     * (SINGLE_FILE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mpdProfile} will
     * return {@link CmafMpdProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mpdProfileAsString}.
     * </p>
     * 
     * @return Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the
     *         service signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose
     *         On-demand (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your
     *         .mpd. When you choose On-demand, you must also set the output group setting Segment control
     *         (SegmentControl) to Single file (SINGLE_FILE).
     * @see CmafMpdProfile
     */
    public final String mpdProfileAsString() {
        return mpdProfile;
    }

    /**
     * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
     * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentControl}
     * will return {@link CmafSegmentControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #segmentControlAsString}.
     * </p>
     * 
     * @return When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
     *         Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * @see CmafSegmentControl
     */
    public final CmafSegmentControl segmentControl() {
        return CmafSegmentControl.fromValue(segmentControl);
    }

    /**
     * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
     * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentControl}
     * will return {@link CmafSegmentControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #segmentControlAsString}.
     * </p>
     * 
     * @return When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
     *         Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * @see CmafSegmentControl
     */
    public final String segmentControlAsString() {
        return segmentControl;
    }

    /**
     * Use this setting to specify the length, in seconds, of each individual CMAF segment. This value applies to the
     * whole package; that is, to every output in the output group. Note that segments end on the first keyframe after
     * this number of seconds, so the actual segment length might be slightly longer. If you set Segment control
     * (CmafSegmentControl) to single file, the service puts the content of each output in a single file that has
     * metadata that marks these segments. If you set it to segmented files, the service creates multiple files for each
     * output, each with the content of one segment.
     * 
     * @return Use this setting to specify the length, in seconds, of each individual CMAF segment. This value applies
     *         to the whole package; that is, to every output in the output group. Note that segments end on the first
     *         keyframe after this number of seconds, so the actual segment length might be slightly longer. If you set
     *         Segment control (CmafSegmentControl) to single file, the service puts the content of each output in a
     *         single file that has metadata that marks these segments. If you set it to segmented files, the service
     *         creates multiple files for each output, each with the content of one segment.
     */
    public final Integer segmentLength() {
        return segmentLength;
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamInfResolution} will return {@link CmafStreamInfResolution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamInfResolutionAsString}.
     * </p>
     * 
     * @return Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @see CmafStreamInfResolution
     */
    public final CmafStreamInfResolution streamInfResolution() {
        return CmafStreamInfResolution.fromValue(streamInfResolution);
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamInfResolution} will return {@link CmafStreamInfResolution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamInfResolutionAsString}.
     * </p>
     * 
     * @return Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @see CmafStreamInfResolution
     */
    public final String streamInfResolutionAsString() {
        return streamInfResolution;
    }

    /**
     * When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #writeDashManifest}
     * will return {@link CmafWriteDASHManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #writeDashManifestAsString}.
     * </p>
     * 
     * @return When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * @see CmafWriteDASHManifest
     */
    public final CmafWriteDASHManifest writeDashManifest() {
        return CmafWriteDASHManifest.fromValue(writeDashManifest);
    }

    /**
     * When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #writeDashManifest}
     * will return {@link CmafWriteDASHManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #writeDashManifestAsString}.
     * </p>
     * 
     * @return When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * @see CmafWriteDASHManifest
     */
    public final String writeDashManifestAsString() {
        return writeDashManifest;
    }

    /**
     * When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #writeHlsManifest}
     * will return {@link CmafWriteHLSManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #writeHlsManifestAsString}.
     * </p>
     * 
     * @return When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * @see CmafWriteHLSManifest
     */
    public final CmafWriteHLSManifest writeHlsManifest() {
        return CmafWriteHLSManifest.fromValue(writeHlsManifest);
    }

    /**
     * When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #writeHlsManifest}
     * will return {@link CmafWriteHLSManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #writeHlsManifestAsString}.
     * </p>
     * 
     * @return When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * @see CmafWriteHLSManifest
     */
    public final String writeHlsManifestAsString() {
        return writeHlsManifest;
    }

    /**
     * When you enable Precise segment duration in DASH manifests (writeSegmentTimelineInRepresentation), your DASH
     * manifest shows precise segment durations. The segment duration information appears inside the SegmentTimeline
     * element, inside SegmentTemplate at the Representation level. When this feature isn't enabled, the segment
     * durations in your DASH manifest are approximate. The segment duration information appears in the duration
     * attribute of the SegmentTemplate element.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeSegmentTimelineInRepresentation} will return
     * {@link CmafWriteSegmentTimelineInRepresentation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #writeSegmentTimelineInRepresentationAsString}.
     * </p>
     * 
     * @return When you enable Precise segment duration in DASH manifests (writeSegmentTimelineInRepresentation), your
     *         DASH manifest shows precise segment durations. The segment duration information appears inside the
     *         SegmentTimeline element, inside SegmentTemplate at the Representation level. When this feature isn't
     *         enabled, the segment durations in your DASH manifest are approximate. The segment duration information
     *         appears in the duration attribute of the SegmentTemplate element.
     * @see CmafWriteSegmentTimelineInRepresentation
     */
    public final CmafWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation() {
        return CmafWriteSegmentTimelineInRepresentation.fromValue(writeSegmentTimelineInRepresentation);
    }

    /**
     * When you enable Precise segment duration in DASH manifests (writeSegmentTimelineInRepresentation), your DASH
     * manifest shows precise segment durations. The segment duration information appears inside the SegmentTimeline
     * element, inside SegmentTemplate at the Representation level. When this feature isn't enabled, the segment
     * durations in your DASH manifest are approximate. The segment duration information appears in the duration
     * attribute of the SegmentTemplate element.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeSegmentTimelineInRepresentation} will return
     * {@link CmafWriteSegmentTimelineInRepresentation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #writeSegmentTimelineInRepresentationAsString}.
     * </p>
     * 
     * @return When you enable Precise segment duration in DASH manifests (writeSegmentTimelineInRepresentation), your
     *         DASH manifest shows precise segment durations. The segment duration information appears inside the
     *         SegmentTimeline element, inside SegmentTemplate at the Representation level. When this feature isn't
     *         enabled, the segment durations in your DASH manifest are approximate. The segment duration information
     *         appears in the duration attribute of the SegmentTemplate element.
     * @see CmafWriteSegmentTimelineInRepresentation
     */
    public final String writeSegmentTimelineInRepresentationAsString() {
        return writeSegmentTimelineInRepresentation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalManifests() ? additionalManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(clientCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codecSpecificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(manifestCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(manifestDurationFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minBufferTime());
        hashCode = 31 * hashCode + Objects.hashCode(minFinalSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(mpdProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(streamInfResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(writeDashManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(writeHlsManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(writeSegmentTimelineInRepresentationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafGroupSettings)) {
            return false;
        }
        CmafGroupSettings other = (CmafGroupSettings) obj;
        return hasAdditionalManifests() == other.hasAdditionalManifests()
                && Objects.equals(additionalManifests(), other.additionalManifests())
                && Objects.equals(baseUrl(), other.baseUrl())
                && Objects.equals(clientCacheAsString(), other.clientCacheAsString())
                && Objects.equals(codecSpecificationAsString(), other.codecSpecificationAsString())
                && Objects.equals(destination(), other.destination())
                && Objects.equals(destinationSettings(), other.destinationSettings())
                && Objects.equals(encryption(), other.encryption())
                && Objects.equals(fragmentLength(), other.fragmentLength())
                && Objects.equals(manifestCompressionAsString(), other.manifestCompressionAsString())
                && Objects.equals(manifestDurationFormatAsString(), other.manifestDurationFormatAsString())
                && Objects.equals(minBufferTime(), other.minBufferTime())
                && Objects.equals(minFinalSegmentLength(), other.minFinalSegmentLength())
                && Objects.equals(mpdProfileAsString(), other.mpdProfileAsString())
                && Objects.equals(segmentControlAsString(), other.segmentControlAsString())
                && Objects.equals(segmentLength(), other.segmentLength())
                && Objects.equals(streamInfResolutionAsString(), other.streamInfResolutionAsString())
                && Objects.equals(writeDashManifestAsString(), other.writeDashManifestAsString())
                && Objects.equals(writeHlsManifestAsString(), other.writeHlsManifestAsString())
                && Objects.equals(writeSegmentTimelineInRepresentationAsString(),
                        other.writeSegmentTimelineInRepresentationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CmafGroupSettings")
                .add("AdditionalManifests", hasAdditionalManifests() ? additionalManifests() : null).add("BaseUrl", baseUrl())
                .add("ClientCache", clientCacheAsString()).add("CodecSpecification", codecSpecificationAsString())
                .add("Destination", destination()).add("DestinationSettings", destinationSettings())
                .add("Encryption", encryption()).add("FragmentLength", fragmentLength())
                .add("ManifestCompression", manifestCompressionAsString())
                .add("ManifestDurationFormat", manifestDurationFormatAsString()).add("MinBufferTime", minBufferTime())
                .add("MinFinalSegmentLength", minFinalSegmentLength()).add("MpdProfile", mpdProfileAsString())
                .add("SegmentControl", segmentControlAsString()).add("SegmentLength", segmentLength())
                .add("StreamInfResolution", streamInfResolutionAsString()).add("WriteDashManifest", writeDashManifestAsString())
                .add("WriteHlsManifest", writeHlsManifestAsString())
                .add("WriteSegmentTimelineInRepresentation", writeSegmentTimelineInRepresentationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalManifests":
            return Optional.ofNullable(clazz.cast(additionalManifests()));
        case "BaseUrl":
            return Optional.ofNullable(clazz.cast(baseUrl()));
        case "ClientCache":
            return Optional.ofNullable(clazz.cast(clientCacheAsString()));
        case "CodecSpecification":
            return Optional.ofNullable(clazz.cast(codecSpecificationAsString()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DestinationSettings":
            return Optional.ofNullable(clazz.cast(destinationSettings()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "FragmentLength":
            return Optional.ofNullable(clazz.cast(fragmentLength()));
        case "ManifestCompression":
            return Optional.ofNullable(clazz.cast(manifestCompressionAsString()));
        case "ManifestDurationFormat":
            return Optional.ofNullable(clazz.cast(manifestDurationFormatAsString()));
        case "MinBufferTime":
            return Optional.ofNullable(clazz.cast(minBufferTime()));
        case "MinFinalSegmentLength":
            return Optional.ofNullable(clazz.cast(minFinalSegmentLength()));
        case "MpdProfile":
            return Optional.ofNullable(clazz.cast(mpdProfileAsString()));
        case "SegmentControl":
            return Optional.ofNullable(clazz.cast(segmentControlAsString()));
        case "SegmentLength":
            return Optional.ofNullable(clazz.cast(segmentLength()));
        case "StreamInfResolution":
            return Optional.ofNullable(clazz.cast(streamInfResolutionAsString()));
        case "WriteDashManifest":
            return Optional.ofNullable(clazz.cast(writeDashManifestAsString()));
        case "WriteHlsManifest":
            return Optional.ofNullable(clazz.cast(writeHlsManifestAsString()));
        case "WriteSegmentTimelineInRepresentation":
            return Optional.ofNullable(clazz.cast(writeSegmentTimelineInRepresentationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmafGroupSettings, T> g) {
        return obj -> g.apply((CmafGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CmafGroupSettings> {
        /**
         * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for
         * each CMAF output group in your job. These default manifests reference every output in the output group. To
         * create additional top-level manifests that reference a subset of the outputs in the output group, specify a
         * list of them here. For each additional manifest that you specify, the service creates one HLS manifest and
         * one DASH manifest.
         * 
         * @param additionalManifests
         *        By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest
         *        for each CMAF output group in your job. These default manifests reference every output in the output
         *        group. To create additional top-level manifests that reference a subset of the outputs in the output
         *        group, specify a list of them here. For each additional manifest that you specify, the service creates
         *        one HLS manifest and one DASH manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalManifests(Collection<CmafAdditionalManifest> additionalManifests);

        /**
         * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for
         * each CMAF output group in your job. These default manifests reference every output in the output group. To
         * create additional top-level manifests that reference a subset of the outputs in the output group, specify a
         * list of them here. For each additional manifest that you specify, the service creates one HLS manifest and
         * one DASH manifest.
         * 
         * @param additionalManifests
         *        By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest
         *        for each CMAF output group in your job. These default manifests reference every output in the output
         *        group. To create additional top-level manifests that reference a subset of the outputs in the output
         *        group, specify a list of them here. For each additional manifest that you specify, the service creates
         *        one HLS manifest and one DASH manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalManifests(CmafAdditionalManifest... additionalManifests);

        /**
         * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for
         * each CMAF output group in your job. These default manifests reference every output in the output group. To
         * create additional top-level manifests that reference a subset of the outputs in the output group, specify a
         * list of them here. For each additional manifest that you specify, the service creates one HLS manifest and
         * one DASH manifest. This is a convenience that creates an instance of the {@link List
         * <CmafAdditionalManifest>.Builder} avoiding the need to create one manually via {@link List
         * <CmafAdditionalManifest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CmafAdditionalManifest>.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalManifests(List<CmafAdditionalManifest>)}.
         * 
         * @param additionalManifests
         *        a consumer that will call methods on {@link List<CmafAdditionalManifest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalManifests(List<CmafAdditionalManifest>)
         */
        Builder additionalManifests(Consumer<CmafAdditionalManifest.Builder>... additionalManifests);

        /**
         * A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used if
         * streams are delivered from a different URL than the manifest file.
         * 
         * @param baseUrl
         *        A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be
         *        used if streams are delivered from a different URL than the manifest file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrl(String baseUrl);

        /**
         * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
         * default value Enabled (ENABLED) and control caching in your video distribution set up. For example, use the
         * Cache-Control http header.
         * 
         * @param clientCache
         *        Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep
         *        the default value Enabled (ENABLED) and control caching in your video distribution set up. For
         *        example, use the Cache-Control http header.
         * @see CmafClientCache
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafClientCache
         */
        Builder clientCache(String clientCache);

        /**
         * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
         * default value Enabled (ENABLED) and control caching in your video distribution set up. For example, use the
         * Cache-Control http header.
         * 
         * @param clientCache
         *        Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep
         *        the default value Enabled (ENABLED) and control caching in your video distribution set up. For
         *        example, use the Cache-Control http header.
         * @see CmafClientCache
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafClientCache
         */
        Builder clientCache(CmafClientCache clientCache);

        /**
         * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * 
         * @param codecSpecification
         *        Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * @see CmafCodecSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafCodecSpecification
         */
        Builder codecSpecification(String codecSpecification);

        /**
         * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * 
         * @param codecSpecification
         *        Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * @see CmafCodecSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafCodecSpecification
         */
        Builder codecSpecification(CmafCodecSpecification codecSpecification);

        /**
         * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination
         * accepts format identifiers. If you do not specify the base filename in the URI, the service will use the
         * filename of the input file. If your job has multiple inputs, the service uses the filename of the first input
         * file.
         * 
         * @param destination
         *        Use Destination (Destination) to specify the S3 output location and the output filename base.
         *        Destination accepts format identifiers. If you do not specify the base filename in the URI, the
         *        service will use the filename of the input file. If your job has multiple inputs, the service uses the
         *        filename of the first input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * Settings associated with the destination. Will vary based on the type of destination
         * 
         * @param destinationSettings
         *        Settings associated with the destination. Will vary based on the type of destination
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSettings(DestinationSettings destinationSettings);

        /**
         * Settings associated with the destination. Will vary based on the type of destination This is a convenience
         * that creates an instance of the {@link DestinationSettings.Builder} avoiding the need to create one manually
         * via {@link DestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationSettings(DestinationSettings)}.
         * 
         * @param destinationSettings
         *        a consumer that will call methods on {@link DestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSettings(DestinationSettings)
         */
        default Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return destinationSettings(DestinationSettings.builder().applyMutation(destinationSettings).build());
        }

        /**
         * DRM settings.
         * 
         * @param encryption
         *        DRM settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(CmafEncryptionSettings encryption);

        /**
         * DRM settings. This is a convenience that creates an instance of the {@link CmafEncryptionSettings.Builder}
         * avoiding the need to create one manually via {@link CmafEncryptionSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link CmafEncryptionSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #encryption(CmafEncryptionSettings)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link CmafEncryptionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(CmafEncryptionSettings)
         */
        default Builder encryption(Consumer<CmafEncryptionSettings.Builder> encryption) {
            return encryption(CmafEncryptionSettings.builder().applyMutation(encryption).build());
        }

        /**
         * Length of fragments to generate (in seconds). Fragment length must be compatible with GOP size and Framerate.
         * Note that fragments will end on the next keyframe after this number of seconds, so actual fragment length may
         * be longer. When Emit Single File is checked, the fragmentation is internal to a single output file and it
         * does not cause the creation of many output files as in other output types.
         * 
         * @param fragmentLength
         *        Length of fragments to generate (in seconds). Fragment length must be compatible with GOP size and
         *        Framerate. Note that fragments will end on the next keyframe after this number of seconds, so actual
         *        fragment length may be longer. When Emit Single File is checked, the fragmentation is internal to a
         *        single output file and it does not cause the creation of many output files as in other output types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentLength(Integer fragmentLength);

        /**
         * When set to GZIP, compresses HLS playlist.
         * 
         * @param manifestCompression
         *        When set to GZIP, compresses HLS playlist.
         * @see CmafManifestCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafManifestCompression
         */
        Builder manifestCompression(String manifestCompression);

        /**
         * When set to GZIP, compresses HLS playlist.
         * 
         * @param manifestCompression
         *        When set to GZIP, compresses HLS playlist.
         * @see CmafManifestCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafManifestCompression
         */
        Builder manifestCompression(CmafManifestCompression manifestCompression);

        /**
         * Indicates whether the output manifest should use floating point values for segment duration.
         * 
         * @param manifestDurationFormat
         *        Indicates whether the output manifest should use floating point values for segment duration.
         * @see CmafManifestDurationFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafManifestDurationFormat
         */
        Builder manifestDurationFormat(String manifestDurationFormat);

        /**
         * Indicates whether the output manifest should use floating point values for segment duration.
         * 
         * @param manifestDurationFormat
         *        Indicates whether the output manifest should use floating point values for segment duration.
         * @see CmafManifestDurationFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafManifestDurationFormat
         */
        Builder manifestDurationFormat(CmafManifestDurationFormat manifestDurationFormat);

        /**
         * Minimum time of initially buffered media that is needed to ensure smooth playout.
         * 
         * @param minBufferTime
         *        Minimum time of initially buffered media that is needed to ensure smooth playout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minBufferTime(Integer minBufferTime);

        /**
         * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play
         * back the end of your video asset. If you know that player devices are hanging on the final segment of your
         * video because the length of your final segment is too short, use this setting to specify a minimum final
         * segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment
         * length. When you specify a value for this setting, the encoder will combine any final segment that is shorter
         * than the length that you specify with the previous segment. For example, your segment length is 3 seconds and
         * your final segment is .5 seconds without a minimum final segment length; when you set the minimum final
         * segment length to 1, your final segment is 3.5 seconds.
         * 
         * @param minFinalSegmentLength
         *        Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices
         *        play back the end of your video asset. If you know that player devices are hanging on the final
         *        segment of your video because the length of your final segment is too short, use this setting to
         *        specify a minimum final segment length, in seconds. Choose a value that is greater than or equal to 1
         *        and less than your segment length. When you specify a value for this setting, the encoder will combine
         *        any final segment that is shorter than the length that you specify with the previous segment. For
         *        example, your segment length is 3 seconds and your final segment is .5 seconds without a minimum final
         *        segment length; when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minFinalSegmentLength(Double minFinalSegmentLength);

        /**
         * Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the
         * service signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand
         * (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you
         * choose On-demand, you must also set the output group setting Segment control (SegmentControl) to Single file
         * (SINGLE_FILE).
         * 
         * @param mpdProfile
         *        Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE),
         *        the service signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose
         *        On-demand (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your
         *        .mpd. When you choose On-demand, you must also set the output group setting Segment control
         *        (SegmentControl) to Single file (SINGLE_FILE).
         * @see CmafMpdProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafMpdProfile
         */
        Builder mpdProfile(String mpdProfile);

        /**
         * Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the
         * service signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand
         * (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you
         * choose On-demand, you must also set the output group setting Segment control (SegmentControl) to Single file
         * (SINGLE_FILE).
         * 
         * @param mpdProfile
         *        Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE),
         *        the service signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose
         *        On-demand (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your
         *        .mpd. When you choose On-demand, you must also set the output group setting Segment control
         *        (SegmentControl) to Single file (SINGLE_FILE).
         * @see CmafMpdProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafMpdProfile
         */
        Builder mpdProfile(CmafMpdProfile mpdProfile);

        /**
         * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
         * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
         * 
         * @param segmentControl
         *        When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
         *        Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be
         *        created.
         * @see CmafSegmentControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafSegmentControl
         */
        Builder segmentControl(String segmentControl);

        /**
         * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
         * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
         * 
         * @param segmentControl
         *        When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
         *        Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be
         *        created.
         * @see CmafSegmentControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafSegmentControl
         */
        Builder segmentControl(CmafSegmentControl segmentControl);

        /**
         * Use this setting to specify the length, in seconds, of each individual CMAF segment. This value applies to
         * the whole package; that is, to every output in the output group. Note that segments end on the first keyframe
         * after this number of seconds, so the actual segment length might be slightly longer. If you set Segment
         * control (CmafSegmentControl) to single file, the service puts the content of each output in a single file
         * that has metadata that marks these segments. If you set it to segmented files, the service creates multiple
         * files for each output, each with the content of one segment.
         * 
         * @param segmentLength
         *        Use this setting to specify the length, in seconds, of each individual CMAF segment. This value
         *        applies to the whole package; that is, to every output in the output group. Note that segments end on
         *        the first keyframe after this number of seconds, so the actual segment length might be slightly
         *        longer. If you set Segment control (CmafSegmentControl) to single file, the service puts the content
         *        of each output in a single file that has metadata that marks these segments. If you set it to
         *        segmented files, the service creates multiple files for each output, each with the content of one
         *        segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentLength(Integer segmentLength);

        /**
         * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * 
         * @param streamInfResolution
         *        Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * @see CmafStreamInfResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafStreamInfResolution
         */
        Builder streamInfResolution(String streamInfResolution);

        /**
         * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * 
         * @param streamInfResolution
         *        Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * @see CmafStreamInfResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafStreamInfResolution
         */
        Builder streamInfResolution(CmafStreamInfResolution streamInfResolution);

        /**
         * When set to ENABLED, a DASH MPD manifest will be generated for this output.
         * 
         * @param writeDashManifest
         *        When set to ENABLED, a DASH MPD manifest will be generated for this output.
         * @see CmafWriteDASHManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafWriteDASHManifest
         */
        Builder writeDashManifest(String writeDashManifest);

        /**
         * When set to ENABLED, a DASH MPD manifest will be generated for this output.
         * 
         * @param writeDashManifest
         *        When set to ENABLED, a DASH MPD manifest will be generated for this output.
         * @see CmafWriteDASHManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafWriteDASHManifest
         */
        Builder writeDashManifest(CmafWriteDASHManifest writeDashManifest);

        /**
         * When set to ENABLED, an Apple HLS manifest will be generated for this output.
         * 
         * @param writeHlsManifest
         *        When set to ENABLED, an Apple HLS manifest will be generated for this output.
         * @see CmafWriteHLSManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafWriteHLSManifest
         */
        Builder writeHlsManifest(String writeHlsManifest);

        /**
         * When set to ENABLED, an Apple HLS manifest will be generated for this output.
         * 
         * @param writeHlsManifest
         *        When set to ENABLED, an Apple HLS manifest will be generated for this output.
         * @see CmafWriteHLSManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafWriteHLSManifest
         */
        Builder writeHlsManifest(CmafWriteHLSManifest writeHlsManifest);

        /**
         * When you enable Precise segment duration in DASH manifests (writeSegmentTimelineInRepresentation), your DASH
         * manifest shows precise segment durations. The segment duration information appears inside the SegmentTimeline
         * element, inside SegmentTemplate at the Representation level. When this feature isn't enabled, the segment
         * durations in your DASH manifest are approximate. The segment duration information appears in the duration
         * attribute of the SegmentTemplate element.
         * 
         * @param writeSegmentTimelineInRepresentation
         *        When you enable Precise segment duration in DASH manifests (writeSegmentTimelineInRepresentation),
         *        your DASH manifest shows precise segment durations. The segment duration information appears inside
         *        the SegmentTimeline element, inside SegmentTemplate at the Representation level. When this feature
         *        isn't enabled, the segment durations in your DASH manifest are approximate. The segment duration
         *        information appears in the duration attribute of the SegmentTemplate element.
         * @see CmafWriteSegmentTimelineInRepresentation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafWriteSegmentTimelineInRepresentation
         */
        Builder writeSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation);

        /**
         * When you enable Precise segment duration in DASH manifests (writeSegmentTimelineInRepresentation), your DASH
         * manifest shows precise segment durations. The segment duration information appears inside the SegmentTimeline
         * element, inside SegmentTemplate at the Representation level. When this feature isn't enabled, the segment
         * durations in your DASH manifest are approximate. The segment duration information appears in the duration
         * attribute of the SegmentTemplate element.
         * 
         * @param writeSegmentTimelineInRepresentation
         *        When you enable Precise segment duration in DASH manifests (writeSegmentTimelineInRepresentation),
         *        your DASH manifest shows precise segment durations. The segment duration information appears inside
         *        the SegmentTimeline element, inside SegmentTemplate at the Representation level. When this feature
         *        isn't enabled, the segment durations in your DASH manifest are approximate. The segment duration
         *        information appears in the duration attribute of the SegmentTemplate element.
         * @see CmafWriteSegmentTimelineInRepresentation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafWriteSegmentTimelineInRepresentation
         */
        Builder writeSegmentTimelineInRepresentation(CmafWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation);
    }

    static final class BuilderImpl implements Builder {
        private List<CmafAdditionalManifest> additionalManifests = DefaultSdkAutoConstructList.getInstance();

        private String baseUrl;

        private String clientCache;

        private String codecSpecification;

        private String destination;

        private DestinationSettings destinationSettings;

        private CmafEncryptionSettings encryption;

        private Integer fragmentLength;

        private String manifestCompression;

        private String manifestDurationFormat;

        private Integer minBufferTime;

        private Double minFinalSegmentLength;

        private String mpdProfile;

        private String segmentControl;

        private Integer segmentLength;

        private String streamInfResolution;

        private String writeDashManifest;

        private String writeHlsManifest;

        private String writeSegmentTimelineInRepresentation;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafGroupSettings model) {
            additionalManifests(model.additionalManifests);
            baseUrl(model.baseUrl);
            clientCache(model.clientCache);
            codecSpecification(model.codecSpecification);
            destination(model.destination);
            destinationSettings(model.destinationSettings);
            encryption(model.encryption);
            fragmentLength(model.fragmentLength);
            manifestCompression(model.manifestCompression);
            manifestDurationFormat(model.manifestDurationFormat);
            minBufferTime(model.minBufferTime);
            minFinalSegmentLength(model.minFinalSegmentLength);
            mpdProfile(model.mpdProfile);
            segmentControl(model.segmentControl);
            segmentLength(model.segmentLength);
            streamInfResolution(model.streamInfResolution);
            writeDashManifest(model.writeDashManifest);
            writeHlsManifest(model.writeHlsManifest);
            writeSegmentTimelineInRepresentation(model.writeSegmentTimelineInRepresentation);
        }

        public final Collection<CmafAdditionalManifest.Builder> getAdditionalManifests() {
            if (additionalManifests instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalManifests != null ? additionalManifests.stream().map(CmafAdditionalManifest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalManifests(Collection<CmafAdditionalManifest> additionalManifests) {
            this.additionalManifests = ___listOfCmafAdditionalManifestCopier.copy(additionalManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(CmafAdditionalManifest... additionalManifests) {
            additionalManifests(Arrays.asList(additionalManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(Consumer<CmafAdditionalManifest.Builder>... additionalManifests) {
            additionalManifests(Stream.of(additionalManifests)
                    .map(c -> CmafAdditionalManifest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalManifests(Collection<CmafAdditionalManifest.BuilderImpl> additionalManifests) {
            this.additionalManifests = ___listOfCmafAdditionalManifestCopier.copyFromBuilder(additionalManifests);
        }

        public final String getBaseUrl() {
            return baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public final String getClientCache() {
            return clientCache;
        }

        @Override
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        public final Builder clientCache(CmafClientCache clientCache) {
            this.clientCache(clientCache == null ? null : clientCache.toString());
            return this;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        public final String getCodecSpecification() {
            return codecSpecification;
        }

        @Override
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        public final Builder codecSpecification(CmafCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification == null ? null : codecSpecification.toString());
            return this;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        public final String getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return destinationSettings != null ? destinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        public final CmafEncryptionSettings.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(CmafEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(CmafEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getFragmentLength() {
            return fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        public final String getManifestCompression() {
            return manifestCompression;
        }

        @Override
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        public final Builder manifestCompression(CmafManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression == null ? null : manifestCompression.toString());
            return this;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        public final String getManifestDurationFormat() {
            return manifestDurationFormat;
        }

        @Override
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        public final Builder manifestDurationFormat(CmafManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat == null ? null : manifestDurationFormat.toString());
            return this;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        public final Integer getMinBufferTime() {
            return minBufferTime;
        }

        @Override
        public final Builder minBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
            return this;
        }

        public final void setMinBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
        }

        public final Double getMinFinalSegmentLength() {
            return minFinalSegmentLength;
        }

        @Override
        public final Builder minFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
            return this;
        }

        public final void setMinFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
        }

        public final String getMpdProfile() {
            return mpdProfile;
        }

        @Override
        public final Builder mpdProfile(String mpdProfile) {
            this.mpdProfile = mpdProfile;
            return this;
        }

        @Override
        public final Builder mpdProfile(CmafMpdProfile mpdProfile) {
            this.mpdProfile(mpdProfile == null ? null : mpdProfile.toString());
            return this;
        }

        public final void setMpdProfile(String mpdProfile) {
            this.mpdProfile = mpdProfile;
        }

        public final String getSegmentControl() {
            return segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(CmafSegmentControl segmentControl) {
            this.segmentControl(segmentControl == null ? null : segmentControl.toString());
            return this;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        public final Integer getSegmentLength() {
            return segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        public final String getStreamInfResolution() {
            return streamInfResolution;
        }

        @Override
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        public final Builder streamInfResolution(CmafStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution == null ? null : streamInfResolution.toString());
            return this;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        public final String getWriteDashManifest() {
            return writeDashManifest;
        }

        @Override
        public final Builder writeDashManifest(String writeDashManifest) {
            this.writeDashManifest = writeDashManifest;
            return this;
        }

        @Override
        public final Builder writeDashManifest(CmafWriteDASHManifest writeDashManifest) {
            this.writeDashManifest(writeDashManifest == null ? null : writeDashManifest.toString());
            return this;
        }

        public final void setWriteDashManifest(String writeDashManifest) {
            this.writeDashManifest = writeDashManifest;
        }

        public final String getWriteHlsManifest() {
            return writeHlsManifest;
        }

        @Override
        public final Builder writeHlsManifest(String writeHlsManifest) {
            this.writeHlsManifest = writeHlsManifest;
            return this;
        }

        @Override
        public final Builder writeHlsManifest(CmafWriteHLSManifest writeHlsManifest) {
            this.writeHlsManifest(writeHlsManifest == null ? null : writeHlsManifest.toString());
            return this;
        }

        public final void setWriteHlsManifest(String writeHlsManifest) {
            this.writeHlsManifest = writeHlsManifest;
        }

        public final String getWriteSegmentTimelineInRepresentation() {
            return writeSegmentTimelineInRepresentation;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
            return this;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(
                CmafWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation(writeSegmentTimelineInRepresentation == null ? null
                    : writeSegmentTimelineInRepresentation.toString());
            return this;
        }

        public final void setWriteSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
        }

        @Override
        public CmafGroupSettings build() {
            return new CmafGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
