/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Ignore this setting unless your input captions format is SCC. To have the service compensate for differing frame
 * rates between your input captions and input video, specify the frame rate of the captions file. Specify this value as
 * a fraction, using the settings Framerate numerator (framerateNumerator) and Framerate denominator
 * (framerateDenominator). For example, you might specify 24 / 1 for 24 fps, 25 / 1 for 25 fps, 24000 / 1001 for 23.976
 * fps, or 30000 / 1001 for 29.97 fps.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionSourceFramerate implements SdkPojo, Serializable,
        ToCopyableBuilder<CaptionSourceFramerate.Builder, CaptionSourceFramerate> {
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(CaptionSourceFramerate::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(CaptionSourceFramerate::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMERATE_DENOMINATOR_FIELD,
            FRAMERATE_NUMERATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private CaptionSourceFramerate(BuilderImpl builder) {
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
    }

    /**
     * Specify the denominator of the fraction that represents the frame rate for the setting Caption source frame rate
     * (CaptionSourceFramerate). Use this setting along with the setting Framerate numerator (framerateNumerator).
     * 
     * @return Specify the denominator of the fraction that represents the frame rate for the setting Caption source
     *         frame rate (CaptionSourceFramerate). Use this setting along with the setting Framerate numerator
     *         (framerateNumerator).
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * Specify the numerator of the fraction that represents the frame rate for the setting Caption source frame rate
     * (CaptionSourceFramerate). Use this setting along with the setting Framerate denominator (framerateDenominator).
     * 
     * @return Specify the numerator of the fraction that represents the frame rate for the setting Caption source frame
     *         rate (CaptionSourceFramerate). Use this setting along with the setting Framerate denominator
     *         (framerateDenominator).
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionSourceFramerate)) {
            return false;
        }
        CaptionSourceFramerate other = (CaptionSourceFramerate) obj;
        return Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptionSourceFramerate").add("FramerateDenominator", framerateDenominator())
                .add("FramerateNumerator", framerateNumerator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionSourceFramerate, T> g) {
        return obj -> g.apply((CaptionSourceFramerate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionSourceFramerate> {
        /**
         * Specify the denominator of the fraction that represents the frame rate for the setting Caption source frame
         * rate (CaptionSourceFramerate). Use this setting along with the setting Framerate numerator
         * (framerateNumerator).
         * 
         * @param framerateDenominator
         *        Specify the denominator of the fraction that represents the frame rate for the setting Caption source
         *        frame rate (CaptionSourceFramerate). Use this setting along with the setting Framerate numerator
         *        (framerateNumerator).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * Specify the numerator of the fraction that represents the frame rate for the setting Caption source frame
         * rate (CaptionSourceFramerate). Use this setting along with the setting Framerate denominator
         * (framerateDenominator).
         * 
         * @param framerateNumerator
         *        Specify the numerator of the fraction that represents the frame rate for the setting Caption source
         *        frame rate (CaptionSourceFramerate). Use this setting along with the setting Framerate denominator
         *        (framerateDenominator).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);
    }

    static final class BuilderImpl implements Builder {
        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionSourceFramerate model) {
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public CaptionSourceFramerate build() {
            return new CaptionSourceFramerate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
