/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * When set to FOLLOW_INPUT, if the input contains an ISO 639 audio_type, then that value is passed through to the
 * output. If the input contains no ISO 639 audio_type, the value in Audio Type is included in the output. Otherwise the
 * value in Audio Type is included in the output. Note that this field and audioType are both ignored if
 * audioDescriptionBroadcasterMix is set to BROADCASTER_MIXED_AD.
 */
@Generated("software.amazon.awssdk:codegen")
public enum AudioTypeControl {
    FOLLOW_INPUT("FOLLOW_INPUT"),

    USE_CONFIGURED("USE_CONFIGURED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AudioTypeControl(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AudioTypeControl corresponding to the value
     */
    public static AudioTypeControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AudioTypeControl.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AudioTypeControl}s
     */
    public static Set<AudioTypeControl> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
