/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * You can add a tag for this mono-channel audio track to mimic its placement in a multi-channel layout. For example, if
 * this track is the left surround channel, choose Left surround (LS).
 */
@Generated("software.amazon.awssdk:codegen")
public enum AudioChannelTag {
    L("L"),

    R("R"),

    C("C"),

    LFE("LFE"),

    LS("LS"),

    RS("RS"),

    LC("LC"),

    RC("RC"),

    CS("CS"),

    LSD("LSD"),

    RSD("RSD"),

    TCS("TCS"),

    VHL("VHL"),

    VHC("VHC"),

    VHR("VHR"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AudioChannelTag(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AudioChannelTag corresponding to the value
     */
    public static AudioChannelTag fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AudioChannelTag.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AudioChannelTag}s
     */
    public static Set<AudioChannelTag> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
