/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Describes whether the current job is running with accelerated transcoding. For jobs that have Acceleration
 * (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs that have Acceleration
 * (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of the other states. AccelerationStatus is
 * IN_PROGRESS initially, while the service determines whether the input files and job settings are compatible with
 * accelerated transcoding. If they are, AcclerationStatus is ACCELERATED. If your input files and job settings aren't
 * compatible with accelerated transcoding, the service either fails your job or runs it without accelerated
 * transcoding, depending on how you set Acceleration (AccelerationMode). When the service runs your job without
 * accelerated transcoding, AccelerationStatus is NOT_ACCELERATED.
 */
@Generated("software.amazon.awssdk:codegen")
public enum AccelerationStatus {
    NOT_APPLICABLE("NOT_APPLICABLE"),

    IN_PROGRESS("IN_PROGRESS"),

    ACCELERATED("ACCELERATED"),

    NOT_ACCELERATED("NOT_ACCELERATED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AccelerationStatus(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AccelerationStatus corresponding to the value
     */
    public static AccelerationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AccelerationStatus.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AccelerationStatus}s
     */
    public static Set<AccelerationStatus> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
