/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum H265CodecLevel {
    AUTO("AUTO"),
    LEVEL_1("LEVEL_1"),
    LEVEL_2("LEVEL_2"),
    LEVEL_2_1("LEVEL_2_1"),
    LEVEL_3("LEVEL_3"),
    LEVEL_3_1("LEVEL_3_1"),
    LEVEL_4("LEVEL_4"),
    LEVEL_4_1("LEVEL_4_1"),
    LEVEL_5("LEVEL_5"),
    LEVEL_5_1("LEVEL_5_1"),
    LEVEL_5_2("LEVEL_5_2"),
    LEVEL_6("LEVEL_6"),
    LEVEL_6_1("LEVEL_6_1"),
    LEVEL_6_2("LEVEL_6_2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private H265CodecLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H265CodecLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(H265CodecLevel.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H265CodecLevel> knownValues() {
        return Stream.of(H265CodecLevel.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

