/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.CmfcAudioDuration;
import software.amazon.awssdk.services.mediaconvert.model.Mp4CslgAtom;
import software.amazon.awssdk.services.mediaconvert.model.Mp4FreeSpaceBox;
import software.amazon.awssdk.services.mediaconvert.model.Mp4MoovPlacement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Mp4Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Mp4Settings> {
    private static final SdkField<String> AUDIO_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioDuration").getter(Mp4Settings.getter(Mp4Settings::audioDurationAsString)).setter(Mp4Settings.setter(Builder::audioDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDuration").build()}).build();
    private static final SdkField<String> CSLG_ATOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CslgAtom").getter(Mp4Settings.getter(Mp4Settings::cslgAtomAsString)).setter(Mp4Settings.setter(Builder::cslgAtom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cslgAtom").build()}).build();
    private static final SdkField<Integer> CTTS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CttsVersion").getter(Mp4Settings.getter(Mp4Settings::cttsVersion)).setter(Mp4Settings.setter(Builder::cttsVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cttsVersion").build()}).build();
    private static final SdkField<String> FREE_SPACE_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FreeSpaceBox").getter(Mp4Settings.getter(Mp4Settings::freeSpaceBoxAsString)).setter(Mp4Settings.setter(Builder::freeSpaceBox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeSpaceBox").build()}).build();
    private static final SdkField<String> MOOV_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MoovPlacement").getter(Mp4Settings.getter(Mp4Settings::moovPlacementAsString)).setter(Mp4Settings.setter(Builder::moovPlacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moovPlacement").build()}).build();
    private static final SdkField<String> MP4_MAJOR_BRAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mp4MajorBrand").getter(Mp4Settings.getter(Mp4Settings::mp4MajorBrand)).setter(Mp4Settings.setter(Builder::mp4MajorBrand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mp4MajorBrand").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DURATION_FIELD, CSLG_ATOM_FIELD, CTTS_VERSION_FIELD, FREE_SPACE_BOX_FIELD, MOOV_PLACEMENT_FIELD, MP4_MAJOR_BRAND_FIELD));
    private static final long serialVersionUID = 1L;
    private final String audioDuration;
    private final String cslgAtom;
    private final Integer cttsVersion;
    private final String freeSpaceBox;
    private final String moovPlacement;
    private final String mp4MajorBrand;

    private Mp4Settings(BuilderImpl builder) {
        this.audioDuration = builder.audioDuration;
        this.cslgAtom = builder.cslgAtom;
        this.cttsVersion = builder.cttsVersion;
        this.freeSpaceBox = builder.freeSpaceBox;
        this.moovPlacement = builder.moovPlacement;
        this.mp4MajorBrand = builder.mp4MajorBrand;
    }

    public CmfcAudioDuration audioDuration() {
        return CmfcAudioDuration.fromValue(this.audioDuration);
    }

    public String audioDurationAsString() {
        return this.audioDuration;
    }

    public Mp4CslgAtom cslgAtom() {
        return Mp4CslgAtom.fromValue(this.cslgAtom);
    }

    public String cslgAtomAsString() {
        return this.cslgAtom;
    }

    public Integer cttsVersion() {
        return this.cttsVersion;
    }

    public Mp4FreeSpaceBox freeSpaceBox() {
        return Mp4FreeSpaceBox.fromValue(this.freeSpaceBox);
    }

    public String freeSpaceBoxAsString() {
        return this.freeSpaceBox;
    }

    public Mp4MoovPlacement moovPlacement() {
        return Mp4MoovPlacement.fromValue(this.moovPlacement);
    }

    public String moovPlacementAsString() {
        return this.moovPlacement;
    }

    public String mp4MajorBrand() {
        return this.mp4MajorBrand;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cslgAtomAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cttsVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.freeSpaceBoxAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.moovPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mp4MajorBrand());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mp4Settings)) {
            return false;
        }
        Mp4Settings other = (Mp4Settings)obj;
        return Objects.equals(this.audioDurationAsString(), other.audioDurationAsString()) && Objects.equals(this.cslgAtomAsString(), other.cslgAtomAsString()) && Objects.equals(this.cttsVersion(), other.cttsVersion()) && Objects.equals(this.freeSpaceBoxAsString(), other.freeSpaceBoxAsString()) && Objects.equals(this.moovPlacementAsString(), other.moovPlacementAsString()) && Objects.equals(this.mp4MajorBrand(), other.mp4MajorBrand());
    }

    public String toString() {
        return ToString.builder((String)"Mp4Settings").add("AudioDuration", (Object)this.audioDurationAsString()).add("CslgAtom", (Object)this.cslgAtomAsString()).add("CttsVersion", (Object)this.cttsVersion()).add("FreeSpaceBox", (Object)this.freeSpaceBoxAsString()).add("MoovPlacement", (Object)this.moovPlacementAsString()).add("Mp4MajorBrand", (Object)this.mp4MajorBrand()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDuration": {
                return Optional.ofNullable(clazz.cast(this.audioDurationAsString()));
            }
            case "CslgAtom": {
                return Optional.ofNullable(clazz.cast(this.cslgAtomAsString()));
            }
            case "CttsVersion": {
                return Optional.ofNullable(clazz.cast(this.cttsVersion()));
            }
            case "FreeSpaceBox": {
                return Optional.ofNullable(clazz.cast(this.freeSpaceBoxAsString()));
            }
            case "MoovPlacement": {
                return Optional.ofNullable(clazz.cast(this.moovPlacementAsString()));
            }
            case "Mp4MajorBrand": {
                return Optional.ofNullable(clazz.cast(this.mp4MajorBrand()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Mp4Settings, T> g) {
        return obj -> g.apply((Mp4Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioDuration;
        private String cslgAtom;
        private Integer cttsVersion;
        private String freeSpaceBox;
        private String moovPlacement;
        private String mp4MajorBrand;

        private BuilderImpl() {
        }

        private BuilderImpl(Mp4Settings model) {
            this.audioDuration(model.audioDuration);
            this.cslgAtom(model.cslgAtom);
            this.cttsVersion(model.cttsVersion);
            this.freeSpaceBox(model.freeSpaceBox);
            this.moovPlacement(model.moovPlacement);
            this.mp4MajorBrand(model.mp4MajorBrand);
        }

        public final String getAudioDuration() {
            return this.audioDuration;
        }

        @Override
        public final Builder audioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
            return this;
        }

        @Override
        public final Builder audioDuration(CmfcAudioDuration audioDuration) {
            this.audioDuration(audioDuration == null ? null : audioDuration.toString());
            return this;
        }

        public final void setAudioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
        }

        public final String getCslgAtom() {
            return this.cslgAtom;
        }

        @Override
        public final Builder cslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
            return this;
        }

        @Override
        public final Builder cslgAtom(Mp4CslgAtom cslgAtom) {
            this.cslgAtom(cslgAtom == null ? null : cslgAtom.toString());
            return this;
        }

        public final void setCslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
        }

        public final Integer getCttsVersion() {
            return this.cttsVersion;
        }

        @Override
        public final Builder cttsVersion(Integer cttsVersion) {
            this.cttsVersion = cttsVersion;
            return this;
        }

        public final void setCttsVersion(Integer cttsVersion) {
            this.cttsVersion = cttsVersion;
        }

        public final String getFreeSpaceBox() {
            return this.freeSpaceBox;
        }

        @Override
        public final Builder freeSpaceBox(String freeSpaceBox) {
            this.freeSpaceBox = freeSpaceBox;
            return this;
        }

        @Override
        public final Builder freeSpaceBox(Mp4FreeSpaceBox freeSpaceBox) {
            this.freeSpaceBox(freeSpaceBox == null ? null : freeSpaceBox.toString());
            return this;
        }

        public final void setFreeSpaceBox(String freeSpaceBox) {
            this.freeSpaceBox = freeSpaceBox;
        }

        public final String getMoovPlacement() {
            return this.moovPlacement;
        }

        @Override
        public final Builder moovPlacement(String moovPlacement) {
            this.moovPlacement = moovPlacement;
            return this;
        }

        @Override
        public final Builder moovPlacement(Mp4MoovPlacement moovPlacement) {
            this.moovPlacement(moovPlacement == null ? null : moovPlacement.toString());
            return this;
        }

        public final void setMoovPlacement(String moovPlacement) {
            this.moovPlacement = moovPlacement;
        }

        public final String getMp4MajorBrand() {
            return this.mp4MajorBrand;
        }

        @Override
        public final Builder mp4MajorBrand(String mp4MajorBrand) {
            this.mp4MajorBrand = mp4MajorBrand;
            return this;
        }

        public final void setMp4MajorBrand(String mp4MajorBrand) {
            this.mp4MajorBrand = mp4MajorBrand;
        }

        public Mp4Settings build() {
            return new Mp4Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Mp4Settings> {
        public Builder audioDuration(String var1);

        public Builder audioDuration(CmfcAudioDuration var1);

        public Builder cslgAtom(String var1);

        public Builder cslgAtom(Mp4CslgAtom var1);

        public Builder cttsVersion(Integer var1);

        public Builder freeSpaceBox(String var1);

        public Builder freeSpaceBox(Mp4FreeSpaceBox var1);

        public Builder moovPlacement(String var1);

        public Builder moovPlacement(Mp4MoovPlacement var1);

        public Builder mp4MajorBrand(String var1);
    }
}

