/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DvbNitSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DvbNitSettings> {
    private static final SdkField<Integer> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetworkId").getter(DvbNitSettings.getter(DvbNitSettings::networkId)).setter(DvbNitSettings.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkId").build()}).build();
    private static final SdkField<String> NETWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkName").getter(DvbNitSettings.getter(DvbNitSettings::networkName)).setter(DvbNitSettings.setter(Builder::networkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkName").build()}).build();
    private static final SdkField<Integer> NIT_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NitInterval").getter(DvbNitSettings.getter(DvbNitSettings::nitInterval)).setter(DvbNitSettings.setter(Builder::nitInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nitInterval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, NETWORK_NAME_FIELD, NIT_INTERVAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer networkId;
    private final String networkName;
    private final Integer nitInterval;

    private DvbNitSettings(BuilderImpl builder) {
        this.networkId = builder.networkId;
        this.networkName = builder.networkName;
        this.nitInterval = builder.nitInterval;
    }

    public Integer networkId() {
        return this.networkId;
    }

    public String networkName() {
        return this.networkName;
    }

    public Integer nitInterval() {
        return this.nitInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nitInterval());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbNitSettings)) {
            return false;
        }
        DvbNitSettings other = (DvbNitSettings)obj;
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.networkName(), other.networkName()) && Objects.equals(this.nitInterval(), other.nitInterval());
    }

    public String toString() {
        return ToString.builder((String)"DvbNitSettings").add("NetworkId", (Object)this.networkId()).add("NetworkName", (Object)this.networkName()).add("NitInterval", (Object)this.nitInterval()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "NetworkName": {
                return Optional.ofNullable(clazz.cast(this.networkName()));
            }
            case "NitInterval": {
                return Optional.ofNullable(clazz.cast(this.nitInterval()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DvbNitSettings, T> g) {
        return obj -> g.apply((DvbNitSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer networkId;
        private String networkName;
        private Integer nitInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbNitSettings model) {
            this.networkId(model.networkId);
            this.networkName(model.networkName);
            this.nitInterval(model.nitInterval);
        }

        public final Integer getNetworkId() {
            return this.networkId;
        }

        @Override
        public final Builder networkId(Integer networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(Integer networkId) {
            this.networkId = networkId;
        }

        public final String getNetworkName() {
            return this.networkName;
        }

        @Override
        public final Builder networkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public final void setNetworkName(String networkName) {
            this.networkName = networkName;
        }

        public final Integer getNitInterval() {
            return this.nitInterval;
        }

        @Override
        public final Builder nitInterval(Integer nitInterval) {
            this.nitInterval = nitInterval;
            return this;
        }

        public final void setNitInterval(Integer nitInterval) {
            this.nitInterval = nitInterval;
        }

        public DvbNitSettings build() {
            return new DvbNitSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DvbNitSettings> {
        public Builder networkId(Integer var1);

        public Builder networkName(String var1);

        public Builder nitInterval(Integer var1);
    }
}

