/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.H265AdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H265AlternateTransferFunctionSei;
import software.amazon.awssdk.services.mediaconvert.model.H265CodecLevel;
import software.amazon.awssdk.services.mediaconvert.model.H265CodecProfile;
import software.amazon.awssdk.services.mediaconvert.model.H265DynamicSubGop;
import software.amazon.awssdk.services.mediaconvert.model.H265FlickerAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H265FramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.H265FramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.H265GopBReference;
import software.amazon.awssdk.services.mediaconvert.model.H265GopSizeUnits;
import software.amazon.awssdk.services.mediaconvert.model.H265InterlaceMode;
import software.amazon.awssdk.services.mediaconvert.model.H265ParControl;
import software.amazon.awssdk.services.mediaconvert.model.H265QualityTuningLevel;
import software.amazon.awssdk.services.mediaconvert.model.H265QvbrSettings;
import software.amazon.awssdk.services.mediaconvert.model.H265RateControlMode;
import software.amazon.awssdk.services.mediaconvert.model.H265SampleAdaptiveOffsetFilterMode;
import software.amazon.awssdk.services.mediaconvert.model.H265SceneChangeDetect;
import software.amazon.awssdk.services.mediaconvert.model.H265SlowPal;
import software.amazon.awssdk.services.mediaconvert.model.H265SpatialAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H265Telecine;
import software.amazon.awssdk.services.mediaconvert.model.H265TemporalAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H265TemporalIds;
import software.amazon.awssdk.services.mediaconvert.model.H265Tiles;
import software.amazon.awssdk.services.mediaconvert.model.H265UnregisteredSeiTimecode;
import software.amazon.awssdk.services.mediaconvert.model.H265WriteMp4PackagingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class H265Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, H265Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::adaptiveQuantizationAsString)).setter(H265Settings.setter(Builder::adaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build()}).build();
    private static final SdkField<String> ALTERNATE_TRANSFER_FUNCTION_SEI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::alternateTransferFunctionSeiAsString)).setter(H265Settings.setter(Builder::alternateTransferFunctionSei)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternateTransferFunctionSei").build()}).build();
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H265Settings.getter(H265Settings::bitrate)).setter(H265Settings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<String> CODEC_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::codecLevelAsString)).setter(H265Settings.setter(Builder::codecLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecLevel").build()}).build();
    private static final SdkField<String> CODEC_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::codecProfileAsString)).setter(H265Settings.setter(Builder::codecProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecProfile").build()}).build();
    private static final SdkField<String> DYNAMIC_SUB_GOP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::dynamicSubGopAsString)).setter(H265Settings.setter(Builder::dynamicSubGop)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicSubGop").build()}).build();
    private static final SdkField<String> FLICKER_ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::flickerAdaptiveQuantizationAsString)).setter(H265Settings.setter(Builder::flickerAdaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flickerAdaptiveQuantization").build()}).build();
    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::framerateControlAsString)).setter(H265Settings.setter(Builder::framerateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()}).build();
    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::framerateConversionAlgorithmAsString)).setter(H265Settings.setter(Builder::framerateConversionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H265Settings.getter(H265Settings::framerateDenominator)).setter(H265Settings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H265Settings.getter(H265Settings::framerateNumerator)).setter(H265Settings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<String> GOP_B_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::gopBReferenceAsString)).setter(H265Settings.setter(Builder::gopBReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopBReference").build()}).build();
    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H265Settings.getter(H265Settings::gopClosedCadence)).setter(H265Settings.setter(Builder::gopClosedCadence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()}).build();
    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(H265Settings.getter(H265Settings::gopSize)).setter(H265Settings.setter(Builder::gopSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()}).build();
    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::gopSizeUnitsAsString)).setter(H265Settings.setter(Builder::gopSizeUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()}).build();
    private static final SdkField<Integer> HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H265Settings.getter(H265Settings::hrdBufferInitialFillPercentage)).setter(H265Settings.setter(Builder::hrdBufferInitialFillPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferInitialFillPercentage").build()}).build();
    private static final SdkField<Integer> HRD_BUFFER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H265Settings.getter(H265Settings::hrdBufferSize)).setter(H265Settings.setter(Builder::hrdBufferSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferSize").build()}).build();
    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::interlaceModeAsString)).setter(H265Settings.setter(Builder::interlaceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H265Settings.getter(H265Settings::maxBitrate)).setter(H265Settings.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H265Settings.getter(H265Settings::minIInterval)).setter(H265Settings.setter(Builder::minIInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()}).build();
    private static final SdkField<Integer> NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H265Settings.getter(H265Settings::numberBFramesBetweenReferenceFrames)).setter(H265Settings.setter(Builder::numberBFramesBetweenReferenceFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberBFramesBetweenReferenceFrames").build()}).build();
    private static final SdkField<Integer> NUMBER_REFERENCE_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H265Settings.getter(H265Settings::numberReferenceFrames)).setter(H265Settings.setter(Builder::numberReferenceFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberReferenceFrames").build()}).build();
    private static final SdkField<String> PAR_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::parControlAsString)).setter(H265Settings.setter(Builder::parControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parControl").build()}).build();
    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H265Settings.getter(H265Settings::parDenominator)).setter(H265Settings.setter(Builder::parDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()}).build();
    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H265Settings.getter(H265Settings::parNumerator)).setter(H265Settings.setter(Builder::parNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()}).build();
    private static final SdkField<String> QUALITY_TUNING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::qualityTuningLevelAsString)).setter(H265Settings.setter(Builder::qualityTuningLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityTuningLevel").build()}).build();
    private static final SdkField<H265QvbrSettings> QVBR_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(H265Settings.getter(H265Settings::qvbrSettings)).setter(H265Settings.setter(Builder::qvbrSettings)).constructor(H265QvbrSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrSettings").build()}).build();
    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::rateControlModeAsString)).setter(H265Settings.setter(Builder::rateControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()}).build();
    private static final SdkField<String> SAMPLE_ADAPTIVE_OFFSET_FILTER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::sampleAdaptiveOffsetFilterModeAsString)).setter(H265Settings.setter(Builder::sampleAdaptiveOffsetFilterMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleAdaptiveOffsetFilterMode").build()}).build();
    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::sceneChangeDetectAsString)).setter(H265Settings.setter(Builder::sceneChangeDetect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()}).build();
    private static final SdkField<Integer> SLICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H265Settings.getter(H265Settings::slices)).setter(H265Settings.setter(Builder::slices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()}).build();
    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::slowPalAsString)).setter(H265Settings.setter(Builder::slowPal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()}).build();
    private static final SdkField<String> SPATIAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::spatialAdaptiveQuantizationAsString)).setter(H265Settings.setter(Builder::spatialAdaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialAdaptiveQuantization").build()}).build();
    private static final SdkField<String> TELECINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::telecineAsString)).setter(H265Settings.setter(Builder::telecine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()}).build();
    private static final SdkField<String> TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::temporalAdaptiveQuantizationAsString)).setter(H265Settings.setter(Builder::temporalAdaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalAdaptiveQuantization").build()}).build();
    private static final SdkField<String> TEMPORAL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::temporalIdsAsString)).setter(H265Settings.setter(Builder::temporalIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalIds").build()}).build();
    private static final SdkField<String> TILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::tilesAsString)).setter(H265Settings.setter(Builder::tiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tiles").build()}).build();
    private static final SdkField<String> UNREGISTERED_SEI_TIMECODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::unregisteredSeiTimecodeAsString)).setter(H265Settings.setter(Builder::unregisteredSeiTimecode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unregisteredSeiTimecode").build()}).build();
    private static final SdkField<String> WRITE_MP4_PACKAGING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H265Settings.getter(H265Settings::writeMp4PackagingTypeAsString)).setter(H265Settings.setter(Builder::writeMp4PackagingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeMp4PackagingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD, ALTERNATE_TRANSFER_FUNCTION_SEI_FIELD, BITRATE_FIELD, CODEC_LEVEL_FIELD, CODEC_PROFILE_FIELD, DYNAMIC_SUB_GOP_FIELD, FLICKER_ADAPTIVE_QUANTIZATION_FIELD, FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_B_REFERENCE_FIELD, GOP_CLOSED_CADENCE_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD, HRD_BUFFER_SIZE_FIELD, INTERLACE_MODE_FIELD, MAX_BITRATE_FIELD, MIN_I_INTERVAL_FIELD, NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD, NUMBER_REFERENCE_FRAMES_FIELD, PAR_CONTROL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, QUALITY_TUNING_LEVEL_FIELD, QVBR_SETTINGS_FIELD, RATE_CONTROL_MODE_FIELD, SAMPLE_ADAPTIVE_OFFSET_FILTER_MODE_FIELD, SCENE_CHANGE_DETECT_FIELD, SLICES_FIELD, SLOW_PAL_FIELD, SPATIAL_ADAPTIVE_QUANTIZATION_FIELD, TELECINE_FIELD, TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD, TEMPORAL_IDS_FIELD, TILES_FIELD, UNREGISTERED_SEI_TIMECODE_FIELD, WRITE_MP4_PACKAGING_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adaptiveQuantization;
    private final String alternateTransferFunctionSei;
    private final Integer bitrate;
    private final String codecLevel;
    private final String codecProfile;
    private final String dynamicSubGop;
    private final String flickerAdaptiveQuantization;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final String gopBReference;
    private final Integer gopClosedCadence;
    private final Double gopSize;
    private final String gopSizeUnits;
    private final Integer hrdBufferInitialFillPercentage;
    private final Integer hrdBufferSize;
    private final String interlaceMode;
    private final Integer maxBitrate;
    private final Integer minIInterval;
    private final Integer numberBFramesBetweenReferenceFrames;
    private final Integer numberReferenceFrames;
    private final String parControl;
    private final Integer parDenominator;
    private final Integer parNumerator;
    private final String qualityTuningLevel;
    private final H265QvbrSettings qvbrSettings;
    private final String rateControlMode;
    private final String sampleAdaptiveOffsetFilterMode;
    private final String sceneChangeDetect;
    private final Integer slices;
    private final String slowPal;
    private final String spatialAdaptiveQuantization;
    private final String telecine;
    private final String temporalAdaptiveQuantization;
    private final String temporalIds;
    private final String tiles;
    private final String unregisteredSeiTimecode;
    private final String writeMp4PackagingType;

    private H265Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.alternateTransferFunctionSei = builder.alternateTransferFunctionSei;
        this.bitrate = builder.bitrate;
        this.codecLevel = builder.codecLevel;
        this.codecProfile = builder.codecProfile;
        this.dynamicSubGop = builder.dynamicSubGop;
        this.flickerAdaptiveQuantization = builder.flickerAdaptiveQuantization;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopBReference = builder.gopBReference;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.hrdBufferInitialFillPercentage = builder.hrdBufferInitialFillPercentage;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.interlaceMode = builder.interlaceMode;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.numberBFramesBetweenReferenceFrames = builder.numberBFramesBetweenReferenceFrames;
        this.numberReferenceFrames = builder.numberReferenceFrames;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.qvbrSettings = builder.qvbrSettings;
        this.rateControlMode = builder.rateControlMode;
        this.sampleAdaptiveOffsetFilterMode = builder.sampleAdaptiveOffsetFilterMode;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slices = builder.slices;
        this.slowPal = builder.slowPal;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
        this.telecine = builder.telecine;
        this.temporalAdaptiveQuantization = builder.temporalAdaptiveQuantization;
        this.temporalIds = builder.temporalIds;
        this.tiles = builder.tiles;
        this.unregisteredSeiTimecode = builder.unregisteredSeiTimecode;
        this.writeMp4PackagingType = builder.writeMp4PackagingType;
    }

    public H265AdaptiveQuantization adaptiveQuantization() {
        return H265AdaptiveQuantization.fromValue(this.adaptiveQuantization);
    }

    public String adaptiveQuantizationAsString() {
        return this.adaptiveQuantization;
    }

    public H265AlternateTransferFunctionSei alternateTransferFunctionSei() {
        return H265AlternateTransferFunctionSei.fromValue(this.alternateTransferFunctionSei);
    }

    public String alternateTransferFunctionSeiAsString() {
        return this.alternateTransferFunctionSei;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public H265CodecLevel codecLevel() {
        return H265CodecLevel.fromValue(this.codecLevel);
    }

    public String codecLevelAsString() {
        return this.codecLevel;
    }

    public H265CodecProfile codecProfile() {
        return H265CodecProfile.fromValue(this.codecProfile);
    }

    public String codecProfileAsString() {
        return this.codecProfile;
    }

    public H265DynamicSubGop dynamicSubGop() {
        return H265DynamicSubGop.fromValue(this.dynamicSubGop);
    }

    public String dynamicSubGopAsString() {
        return this.dynamicSubGop;
    }

    public H265FlickerAdaptiveQuantization flickerAdaptiveQuantization() {
        return H265FlickerAdaptiveQuantization.fromValue(this.flickerAdaptiveQuantization);
    }

    public String flickerAdaptiveQuantizationAsString() {
        return this.flickerAdaptiveQuantization;
    }

    public H265FramerateControl framerateControl() {
        return H265FramerateControl.fromValue(this.framerateControl);
    }

    public String framerateControlAsString() {
        return this.framerateControl;
    }

    public H265FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return H265FramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public String framerateConversionAlgorithmAsString() {
        return this.framerateConversionAlgorithm;
    }

    public Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public H265GopBReference gopBReference() {
        return H265GopBReference.fromValue(this.gopBReference);
    }

    public String gopBReferenceAsString() {
        return this.gopBReference;
    }

    public Integer gopClosedCadence() {
        return this.gopClosedCadence;
    }

    public Double gopSize() {
        return this.gopSize;
    }

    public H265GopSizeUnits gopSizeUnits() {
        return H265GopSizeUnits.fromValue(this.gopSizeUnits);
    }

    public String gopSizeUnitsAsString() {
        return this.gopSizeUnits;
    }

    public Integer hrdBufferInitialFillPercentage() {
        return this.hrdBufferInitialFillPercentage;
    }

    public Integer hrdBufferSize() {
        return this.hrdBufferSize;
    }

    public H265InterlaceMode interlaceMode() {
        return H265InterlaceMode.fromValue(this.interlaceMode);
    }

    public String interlaceModeAsString() {
        return this.interlaceMode;
    }

    public Integer maxBitrate() {
        return this.maxBitrate;
    }

    public Integer minIInterval() {
        return this.minIInterval;
    }

    public Integer numberBFramesBetweenReferenceFrames() {
        return this.numberBFramesBetweenReferenceFrames;
    }

    public Integer numberReferenceFrames() {
        return this.numberReferenceFrames;
    }

    public H265ParControl parControl() {
        return H265ParControl.fromValue(this.parControl);
    }

    public String parControlAsString() {
        return this.parControl;
    }

    public Integer parDenominator() {
        return this.parDenominator;
    }

    public Integer parNumerator() {
        return this.parNumerator;
    }

    public H265QualityTuningLevel qualityTuningLevel() {
        return H265QualityTuningLevel.fromValue(this.qualityTuningLevel);
    }

    public String qualityTuningLevelAsString() {
        return this.qualityTuningLevel;
    }

    public H265QvbrSettings qvbrSettings() {
        return this.qvbrSettings;
    }

    public H265RateControlMode rateControlMode() {
        return H265RateControlMode.fromValue(this.rateControlMode);
    }

    public String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public H265SampleAdaptiveOffsetFilterMode sampleAdaptiveOffsetFilterMode() {
        return H265SampleAdaptiveOffsetFilterMode.fromValue(this.sampleAdaptiveOffsetFilterMode);
    }

    public String sampleAdaptiveOffsetFilterModeAsString() {
        return this.sampleAdaptiveOffsetFilterMode;
    }

    public H265SceneChangeDetect sceneChangeDetect() {
        return H265SceneChangeDetect.fromValue(this.sceneChangeDetect);
    }

    public String sceneChangeDetectAsString() {
        return this.sceneChangeDetect;
    }

    public Integer slices() {
        return this.slices;
    }

    public H265SlowPal slowPal() {
        return H265SlowPal.fromValue(this.slowPal);
    }

    public String slowPalAsString() {
        return this.slowPal;
    }

    public H265SpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return H265SpatialAdaptiveQuantization.fromValue(this.spatialAdaptiveQuantization);
    }

    public String spatialAdaptiveQuantizationAsString() {
        return this.spatialAdaptiveQuantization;
    }

    public H265Telecine telecine() {
        return H265Telecine.fromValue(this.telecine);
    }

    public String telecineAsString() {
        return this.telecine;
    }

    public H265TemporalAdaptiveQuantization temporalAdaptiveQuantization() {
        return H265TemporalAdaptiveQuantization.fromValue(this.temporalAdaptiveQuantization);
    }

    public String temporalAdaptiveQuantizationAsString() {
        return this.temporalAdaptiveQuantization;
    }

    public H265TemporalIds temporalIds() {
        return H265TemporalIds.fromValue(this.temporalIds);
    }

    public String temporalIdsAsString() {
        return this.temporalIds;
    }

    public H265Tiles tiles() {
        return H265Tiles.fromValue(this.tiles);
    }

    public String tilesAsString() {
        return this.tiles;
    }

    public H265UnregisteredSeiTimecode unregisteredSeiTimecode() {
        return H265UnregisteredSeiTimecode.fromValue(this.unregisteredSeiTimecode);
    }

    public String unregisteredSeiTimecodeAsString() {
        return this.unregisteredSeiTimecode;
    }

    public H265WriteMp4PackagingType writeMp4PackagingType() {
        return H265WriteMp4PackagingType.fromValue(this.writeMp4PackagingType);
    }

    public String writeMp4PackagingTypeAsString() {
        return this.writeMp4PackagingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternateTransferFunctionSeiAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicSubGopAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flickerAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopBReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferInitialFillPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberBFramesBetweenReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.qvbrSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleAdaptiveOffsetFilterModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slices());
        hashCode = 31 * hashCode + Objects.hashCode(this.slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.telecineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporalAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporalIdsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tilesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unregisteredSeiTimecodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeMp4PackagingTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H265Settings)) {
            return false;
        }
        H265Settings other = (H265Settings)obj;
        return Objects.equals(this.adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString()) && Objects.equals(this.alternateTransferFunctionSeiAsString(), other.alternateTransferFunctionSeiAsString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.codecLevelAsString(), other.codecLevelAsString()) && Objects.equals(this.codecProfileAsString(), other.codecProfileAsString()) && Objects.equals(this.dynamicSubGopAsString(), other.dynamicSubGopAsString()) && Objects.equals(this.flickerAdaptiveQuantizationAsString(), other.flickerAdaptiveQuantizationAsString()) && Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.gopBReferenceAsString(), other.gopBReferenceAsString()) && Objects.equals(this.gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(this.gopSize(), other.gopSize()) && Objects.equals(this.gopSizeUnitsAsString(), other.gopSizeUnitsAsString()) && Objects.equals(this.hrdBufferInitialFillPercentage(), other.hrdBufferInitialFillPercentage()) && Objects.equals(this.hrdBufferSize(), other.hrdBufferSize()) && Objects.equals(this.interlaceModeAsString(), other.interlaceModeAsString()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.minIInterval(), other.minIInterval()) && Objects.equals(this.numberBFramesBetweenReferenceFrames(), other.numberBFramesBetweenReferenceFrames()) && Objects.equals(this.numberReferenceFrames(), other.numberReferenceFrames()) && Objects.equals(this.parControlAsString(), other.parControlAsString()) && Objects.equals(this.parDenominator(), other.parDenominator()) && Objects.equals(this.parNumerator(), other.parNumerator()) && Objects.equals(this.qualityTuningLevelAsString(), other.qualityTuningLevelAsString()) && Objects.equals(this.qvbrSettings(), other.qvbrSettings()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString()) && Objects.equals(this.sampleAdaptiveOffsetFilterModeAsString(), other.sampleAdaptiveOffsetFilterModeAsString()) && Objects.equals(this.sceneChangeDetectAsString(), other.sceneChangeDetectAsString()) && Objects.equals(this.slices(), other.slices()) && Objects.equals(this.slowPalAsString(), other.slowPalAsString()) && Objects.equals(this.spatialAdaptiveQuantizationAsString(), other.spatialAdaptiveQuantizationAsString()) && Objects.equals(this.telecineAsString(), other.telecineAsString()) && Objects.equals(this.temporalAdaptiveQuantizationAsString(), other.temporalAdaptiveQuantizationAsString()) && Objects.equals(this.temporalIdsAsString(), other.temporalIdsAsString()) && Objects.equals(this.tilesAsString(), other.tilesAsString()) && Objects.equals(this.unregisteredSeiTimecodeAsString(), other.unregisteredSeiTimecodeAsString()) && Objects.equals(this.writeMp4PackagingTypeAsString(), other.writeMp4PackagingTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"H265Settings").add("AdaptiveQuantization", (Object)this.adaptiveQuantizationAsString()).add("AlternateTransferFunctionSei", (Object)this.alternateTransferFunctionSeiAsString()).add("Bitrate", (Object)this.bitrate()).add("CodecLevel", (Object)this.codecLevelAsString()).add("CodecProfile", (Object)this.codecProfileAsString()).add("DynamicSubGop", (Object)this.dynamicSubGopAsString()).add("FlickerAdaptiveQuantization", (Object)this.flickerAdaptiveQuantizationAsString()).add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("GopBReference", (Object)this.gopBReferenceAsString()).add("GopClosedCadence", (Object)this.gopClosedCadence()).add("GopSize", (Object)this.gopSize()).add("GopSizeUnits", (Object)this.gopSizeUnitsAsString()).add("HrdBufferInitialFillPercentage", (Object)this.hrdBufferInitialFillPercentage()).add("HrdBufferSize", (Object)this.hrdBufferSize()).add("InterlaceMode", (Object)this.interlaceModeAsString()).add("MaxBitrate", (Object)this.maxBitrate()).add("MinIInterval", (Object)this.minIInterval()).add("NumberBFramesBetweenReferenceFrames", (Object)this.numberBFramesBetweenReferenceFrames()).add("NumberReferenceFrames", (Object)this.numberReferenceFrames()).add("ParControl", (Object)this.parControlAsString()).add("ParDenominator", (Object)this.parDenominator()).add("ParNumerator", (Object)this.parNumerator()).add("QualityTuningLevel", (Object)this.qualityTuningLevelAsString()).add("QvbrSettings", (Object)this.qvbrSettings()).add("RateControlMode", (Object)this.rateControlModeAsString()).add("SampleAdaptiveOffsetFilterMode", (Object)this.sampleAdaptiveOffsetFilterModeAsString()).add("SceneChangeDetect", (Object)this.sceneChangeDetectAsString()).add("Slices", (Object)this.slices()).add("SlowPal", (Object)this.slowPalAsString()).add("SpatialAdaptiveQuantization", (Object)this.spatialAdaptiveQuantizationAsString()).add("Telecine", (Object)this.telecineAsString()).add("TemporalAdaptiveQuantization", (Object)this.temporalAdaptiveQuantizationAsString()).add("TemporalIds", (Object)this.temporalIdsAsString()).add("Tiles", (Object)this.tilesAsString()).add("UnregisteredSeiTimecode", (Object)this.unregisteredSeiTimecodeAsString()).add("WriteMp4PackagingType", (Object)this.writeMp4PackagingTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.adaptiveQuantizationAsString()));
            }
            case "AlternateTransferFunctionSei": {
                return Optional.ofNullable(clazz.cast(this.alternateTransferFunctionSeiAsString()));
            }
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "CodecLevel": {
                return Optional.ofNullable(clazz.cast(this.codecLevelAsString()));
            }
            case "CodecProfile": {
                return Optional.ofNullable(clazz.cast(this.codecProfileAsString()));
            }
            case "DynamicSubGop": {
                return Optional.ofNullable(clazz.cast(this.dynamicSubGopAsString()));
            }
            case "FlickerAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.flickerAdaptiveQuantizationAsString()));
            }
            case "FramerateControl": {
                return Optional.ofNullable(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.framerateConversionAlgorithmAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "GopBReference": {
                return Optional.ofNullable(clazz.cast(this.gopBReferenceAsString()));
            }
            case "GopClosedCadence": {
                return Optional.ofNullable(clazz.cast(this.gopClosedCadence()));
            }
            case "GopSize": {
                return Optional.ofNullable(clazz.cast(this.gopSize()));
            }
            case "GopSizeUnits": {
                return Optional.ofNullable(clazz.cast(this.gopSizeUnitsAsString()));
            }
            case "HrdBufferInitialFillPercentage": {
                return Optional.ofNullable(clazz.cast(this.hrdBufferInitialFillPercentage()));
            }
            case "HrdBufferSize": {
                return Optional.ofNullable(clazz.cast(this.hrdBufferSize()));
            }
            case "InterlaceMode": {
                return Optional.ofNullable(clazz.cast(this.interlaceModeAsString()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MinIInterval": {
                return Optional.ofNullable(clazz.cast(this.minIInterval()));
            }
            case "NumberBFramesBetweenReferenceFrames": {
                return Optional.ofNullable(clazz.cast(this.numberBFramesBetweenReferenceFrames()));
            }
            case "NumberReferenceFrames": {
                return Optional.ofNullable(clazz.cast(this.numberReferenceFrames()));
            }
            case "ParControl": {
                return Optional.ofNullable(clazz.cast(this.parControlAsString()));
            }
            case "ParDenominator": {
                return Optional.ofNullable(clazz.cast(this.parDenominator()));
            }
            case "ParNumerator": {
                return Optional.ofNullable(clazz.cast(this.parNumerator()));
            }
            case "QualityTuningLevel": {
                return Optional.ofNullable(clazz.cast(this.qualityTuningLevelAsString()));
            }
            case "QvbrSettings": {
                return Optional.ofNullable(clazz.cast(this.qvbrSettings()));
            }
            case "RateControlMode": {
                return Optional.ofNullable(clazz.cast(this.rateControlModeAsString()));
            }
            case "SampleAdaptiveOffsetFilterMode": {
                return Optional.ofNullable(clazz.cast(this.sampleAdaptiveOffsetFilterModeAsString()));
            }
            case "SceneChangeDetect": {
                return Optional.ofNullable(clazz.cast(this.sceneChangeDetectAsString()));
            }
            case "Slices": {
                return Optional.ofNullable(clazz.cast(this.slices()));
            }
            case "SlowPal": {
                return Optional.ofNullable(clazz.cast(this.slowPalAsString()));
            }
            case "SpatialAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.spatialAdaptiveQuantizationAsString()));
            }
            case "Telecine": {
                return Optional.ofNullable(clazz.cast(this.telecineAsString()));
            }
            case "TemporalAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.temporalAdaptiveQuantizationAsString()));
            }
            case "TemporalIds": {
                return Optional.ofNullable(clazz.cast(this.temporalIdsAsString()));
            }
            case "Tiles": {
                return Optional.ofNullable(clazz.cast(this.tilesAsString()));
            }
            case "UnregisteredSeiTimecode": {
                return Optional.ofNullable(clazz.cast(this.unregisteredSeiTimecodeAsString()));
            }
            case "WriteMp4PackagingType": {
                return Optional.ofNullable(clazz.cast(this.writeMp4PackagingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H265Settings, T> g) {
        return obj -> g.apply((H265Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adaptiveQuantization;
        private String alternateTransferFunctionSei;
        private Integer bitrate;
        private String codecLevel;
        private String codecProfile;
        private String dynamicSubGop;
        private String flickerAdaptiveQuantization;
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private String gopBReference;
        private Integer gopClosedCadence;
        private Double gopSize;
        private String gopSizeUnits;
        private Integer hrdBufferInitialFillPercentage;
        private Integer hrdBufferSize;
        private String interlaceMode;
        private Integer maxBitrate;
        private Integer minIInterval;
        private Integer numberBFramesBetweenReferenceFrames;
        private Integer numberReferenceFrames;
        private String parControl;
        private Integer parDenominator;
        private Integer parNumerator;
        private String qualityTuningLevel;
        private H265QvbrSettings qvbrSettings;
        private String rateControlMode;
        private String sampleAdaptiveOffsetFilterMode;
        private String sceneChangeDetect;
        private Integer slices;
        private String slowPal;
        private String spatialAdaptiveQuantization;
        private String telecine;
        private String temporalAdaptiveQuantization;
        private String temporalIds;
        private String tiles;
        private String unregisteredSeiTimecode;
        private String writeMp4PackagingType;

        private BuilderImpl() {
        }

        private BuilderImpl(H265Settings model) {
            this.adaptiveQuantization(model.adaptiveQuantization);
            this.alternateTransferFunctionSei(model.alternateTransferFunctionSei);
            this.bitrate(model.bitrate);
            this.codecLevel(model.codecLevel);
            this.codecProfile(model.codecProfile);
            this.dynamicSubGop(model.dynamicSubGop);
            this.flickerAdaptiveQuantization(model.flickerAdaptiveQuantization);
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.gopBReference(model.gopBReference);
            this.gopClosedCadence(model.gopClosedCadence);
            this.gopSize(model.gopSize);
            this.gopSizeUnits(model.gopSizeUnits);
            this.hrdBufferInitialFillPercentage(model.hrdBufferInitialFillPercentage);
            this.hrdBufferSize(model.hrdBufferSize);
            this.interlaceMode(model.interlaceMode);
            this.maxBitrate(model.maxBitrate);
            this.minIInterval(model.minIInterval);
            this.numberBFramesBetweenReferenceFrames(model.numberBFramesBetweenReferenceFrames);
            this.numberReferenceFrames(model.numberReferenceFrames);
            this.parControl(model.parControl);
            this.parDenominator(model.parDenominator);
            this.parNumerator(model.parNumerator);
            this.qualityTuningLevel(model.qualityTuningLevel);
            this.qvbrSettings(model.qvbrSettings);
            this.rateControlMode(model.rateControlMode);
            this.sampleAdaptiveOffsetFilterMode(model.sampleAdaptiveOffsetFilterMode);
            this.sceneChangeDetect(model.sceneChangeDetect);
            this.slices(model.slices);
            this.slowPal(model.slowPal);
            this.spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
            this.telecine(model.telecine);
            this.temporalAdaptiveQuantization(model.temporalAdaptiveQuantization);
            this.temporalIds(model.temporalIds);
            this.tiles(model.tiles);
            this.unregisteredSeiTimecode(model.unregisteredSeiTimecode);
            this.writeMp4PackagingType(model.writeMp4PackagingType);
        }

        public final String getAdaptiveQuantization() {
            return this.adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(H265AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        public final String getAlternateTransferFunctionSei() {
            return this.alternateTransferFunctionSei;
        }

        @Override
        public final Builder alternateTransferFunctionSei(String alternateTransferFunctionSei) {
            this.alternateTransferFunctionSei = alternateTransferFunctionSei;
            return this;
        }

        @Override
        public final Builder alternateTransferFunctionSei(H265AlternateTransferFunctionSei alternateTransferFunctionSei) {
            this.alternateTransferFunctionSei(alternateTransferFunctionSei == null ? null : alternateTransferFunctionSei.toString());
            return this;
        }

        public final void setAlternateTransferFunctionSei(String alternateTransferFunctionSei) {
            this.alternateTransferFunctionSei = alternateTransferFunctionSei;
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodecLevel() {
            return this.codecLevel;
        }

        @Override
        public final Builder codecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
            return this;
        }

        @Override
        public final Builder codecLevel(H265CodecLevel codecLevel) {
            this.codecLevel(codecLevel == null ? null : codecLevel.toString());
            return this;
        }

        public final void setCodecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
        }

        public final String getCodecProfile() {
            return this.codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(H265CodecProfile codecProfile) {
            this.codecProfile(codecProfile == null ? null : codecProfile.toString());
            return this;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        public final String getDynamicSubGop() {
            return this.dynamicSubGop;
        }

        @Override
        public final Builder dynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
            return this;
        }

        @Override
        public final Builder dynamicSubGop(H265DynamicSubGop dynamicSubGop) {
            this.dynamicSubGop(dynamicSubGop == null ? null : dynamicSubGop.toString());
            return this;
        }

        public final void setDynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
        }

        public final String getFlickerAdaptiveQuantization() {
            return this.flickerAdaptiveQuantization;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(H265FlickerAdaptiveQuantization flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization(flickerAdaptiveQuantization == null ? null : flickerAdaptiveQuantization.toString());
            return this;
        }

        public final void setFlickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(H265FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(H265FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm.toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final String getGopBReference() {
            return this.gopBReference;
        }

        @Override
        public final Builder gopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
            return this;
        }

        @Override
        public final Builder gopBReference(H265GopBReference gopBReference) {
            this.gopBReference(gopBReference == null ? null : gopBReference.toString());
            return this;
        }

        public final void setGopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
        }

        public final Integer getGopClosedCadence() {
            return this.gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        public final Double getGopSize() {
            return this.gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        public final String getGopSizeUnits() {
            return this.gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(H265GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        public final Integer getHrdBufferInitialFillPercentage() {
            return this.hrdBufferInitialFillPercentage;
        }

        @Override
        public final Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
            return this;
        }

        public final void setHrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
        }

        public final Integer getHrdBufferSize() {
            return this.hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        public final String getInterlaceMode() {
            return this.interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(H265InterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMinIInterval() {
            return this.minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        public final Integer getNumberBFramesBetweenReferenceFrames() {
            return this.numberBFramesBetweenReferenceFrames;
        }

        @Override
        public final Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
            return this;
        }

        public final void setNumberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
        }

        public final Integer getNumberReferenceFrames() {
            return this.numberReferenceFrames;
        }

        @Override
        public final Builder numberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
            return this;
        }

        public final void setNumberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
        }

        public final String getParControl() {
            return this.parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(H265ParControl parControl) {
            this.parControl(parControl == null ? null : parControl.toString());
            return this;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        public final Integer getParDenominator() {
            return this.parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        public final Integer getParNumerator() {
            return this.parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        public final String getQualityTuningLevel() {
            return this.qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(H265QualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel == null ? null : qualityTuningLevel.toString());
            return this;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        public final H265QvbrSettings.Builder getQvbrSettings() {
            return this.qvbrSettings != null ? this.qvbrSettings.toBuilder() : null;
        }

        @Override
        public final Builder qvbrSettings(H265QvbrSettings qvbrSettings) {
            this.qvbrSettings = qvbrSettings;
            return this;
        }

        public final void setQvbrSettings(H265QvbrSettings.BuilderImpl qvbrSettings) {
            this.qvbrSettings = qvbrSettings != null ? qvbrSettings.build() : null;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(H265RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final String getSampleAdaptiveOffsetFilterMode() {
            return this.sampleAdaptiveOffsetFilterMode;
        }

        @Override
        public final Builder sampleAdaptiveOffsetFilterMode(String sampleAdaptiveOffsetFilterMode) {
            this.sampleAdaptiveOffsetFilterMode = sampleAdaptiveOffsetFilterMode;
            return this;
        }

        @Override
        public final Builder sampleAdaptiveOffsetFilterMode(H265SampleAdaptiveOffsetFilterMode sampleAdaptiveOffsetFilterMode) {
            this.sampleAdaptiveOffsetFilterMode(sampleAdaptiveOffsetFilterMode == null ? null : sampleAdaptiveOffsetFilterMode.toString());
            return this;
        }

        public final void setSampleAdaptiveOffsetFilterMode(String sampleAdaptiveOffsetFilterMode) {
            this.sampleAdaptiveOffsetFilterMode = sampleAdaptiveOffsetFilterMode;
        }

        public final String getSceneChangeDetect() {
            return this.sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(H265SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect == null ? null : sceneChangeDetect.toString());
            return this;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        public final Integer getSlices() {
            return this.slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        public final String getSlowPal() {
            return this.slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(H265SlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        public final String getSpatialAdaptiveQuantization() {
            return this.spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(H265SpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization == null ? null : spatialAdaptiveQuantization.toString());
            return this;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        public final String getTelecine() {
            return this.telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(H265Telecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        public final String getTemporalAdaptiveQuantization() {
            return this.temporalAdaptiveQuantization;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(H265TemporalAdaptiveQuantization temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization(temporalAdaptiveQuantization == null ? null : temporalAdaptiveQuantization.toString());
            return this;
        }

        public final void setTemporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
        }

        public final String getTemporalIds() {
            return this.temporalIds;
        }

        @Override
        public final Builder temporalIds(String temporalIds) {
            this.temporalIds = temporalIds;
            return this;
        }

        @Override
        public final Builder temporalIds(H265TemporalIds temporalIds) {
            this.temporalIds(temporalIds == null ? null : temporalIds.toString());
            return this;
        }

        public final void setTemporalIds(String temporalIds) {
            this.temporalIds = temporalIds;
        }

        public final String getTiles() {
            return this.tiles;
        }

        @Override
        public final Builder tiles(String tiles) {
            this.tiles = tiles;
            return this;
        }

        @Override
        public final Builder tiles(H265Tiles tiles) {
            this.tiles(tiles == null ? null : tiles.toString());
            return this;
        }

        public final void setTiles(String tiles) {
            this.tiles = tiles;
        }

        public final String getUnregisteredSeiTimecode() {
            return this.unregisteredSeiTimecode;
        }

        @Override
        public final Builder unregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
            return this;
        }

        @Override
        public final Builder unregisteredSeiTimecode(H265UnregisteredSeiTimecode unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode(unregisteredSeiTimecode == null ? null : unregisteredSeiTimecode.toString());
            return this;
        }

        public final void setUnregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
        }

        public final String getWriteMp4PackagingType() {
            return this.writeMp4PackagingType;
        }

        @Override
        public final Builder writeMp4PackagingType(String writeMp4PackagingType) {
            this.writeMp4PackagingType = writeMp4PackagingType;
            return this;
        }

        @Override
        public final Builder writeMp4PackagingType(H265WriteMp4PackagingType writeMp4PackagingType) {
            this.writeMp4PackagingType(writeMp4PackagingType == null ? null : writeMp4PackagingType.toString());
            return this;
        }

        public final void setWriteMp4PackagingType(String writeMp4PackagingType) {
            this.writeMp4PackagingType = writeMp4PackagingType;
        }

        public H265Settings build() {
            return new H265Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, H265Settings> {
        public Builder adaptiveQuantization(String var1);

        public Builder adaptiveQuantization(H265AdaptiveQuantization var1);

        public Builder alternateTransferFunctionSei(String var1);

        public Builder alternateTransferFunctionSei(H265AlternateTransferFunctionSei var1);

        public Builder bitrate(Integer var1);

        public Builder codecLevel(String var1);

        public Builder codecLevel(H265CodecLevel var1);

        public Builder codecProfile(String var1);

        public Builder codecProfile(H265CodecProfile var1);

        public Builder dynamicSubGop(String var1);

        public Builder dynamicSubGop(H265DynamicSubGop var1);

        public Builder flickerAdaptiveQuantization(String var1);

        public Builder flickerAdaptiveQuantization(H265FlickerAdaptiveQuantization var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(H265FramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(H265FramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder gopBReference(String var1);

        public Builder gopBReference(H265GopBReference var1);

        public Builder gopClosedCadence(Integer var1);

        public Builder gopSize(Double var1);

        public Builder gopSizeUnits(String var1);

        public Builder gopSizeUnits(H265GopSizeUnits var1);

        public Builder hrdBufferInitialFillPercentage(Integer var1);

        public Builder hrdBufferSize(Integer var1);

        public Builder interlaceMode(String var1);

        public Builder interlaceMode(H265InterlaceMode var1);

        public Builder maxBitrate(Integer var1);

        public Builder minIInterval(Integer var1);

        public Builder numberBFramesBetweenReferenceFrames(Integer var1);

        public Builder numberReferenceFrames(Integer var1);

        public Builder parControl(String var1);

        public Builder parControl(H265ParControl var1);

        public Builder parDenominator(Integer var1);

        public Builder parNumerator(Integer var1);

        public Builder qualityTuningLevel(String var1);

        public Builder qualityTuningLevel(H265QualityTuningLevel var1);

        public Builder qvbrSettings(H265QvbrSettings var1);

        default public Builder qvbrSettings(Consumer<H265QvbrSettings.Builder> qvbrSettings) {
            return this.qvbrSettings((H265QvbrSettings)((H265QvbrSettings.Builder)H265QvbrSettings.builder().applyMutation(qvbrSettings)).build());
        }

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(H265RateControlMode var1);

        public Builder sampleAdaptiveOffsetFilterMode(String var1);

        public Builder sampleAdaptiveOffsetFilterMode(H265SampleAdaptiveOffsetFilterMode var1);

        public Builder sceneChangeDetect(String var1);

        public Builder sceneChangeDetect(H265SceneChangeDetect var1);

        public Builder slices(Integer var1);

        public Builder slowPal(String var1);

        public Builder slowPal(H265SlowPal var1);

        public Builder spatialAdaptiveQuantization(String var1);

        public Builder spatialAdaptiveQuantization(H265SpatialAdaptiveQuantization var1);

        public Builder telecine(String var1);

        public Builder telecine(H265Telecine var1);

        public Builder temporalAdaptiveQuantization(String var1);

        public Builder temporalAdaptiveQuantization(H265TemporalAdaptiveQuantization var1);

        public Builder temporalIds(String var1);

        public Builder temporalIds(H265TemporalIds var1);

        public Builder tiles(String var1);

        public Builder tiles(H265Tiles var1);

        public Builder unregisteredSeiTimecode(String var1);

        public Builder unregisteredSeiTimecode(H265UnregisteredSeiTimecode var1);

        public Builder writeMp4PackagingType(String var1);

        public Builder writeMp4PackagingType(H265WriteMp4PackagingType var1);
    }
}

