/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.Av1Settings;
import software.amazon.awssdk.services.mediaconvert.model.FrameCaptureSettings;
import software.amazon.awssdk.services.mediaconvert.model.H264Settings;
import software.amazon.awssdk.services.mediaconvert.model.H265Settings;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2Settings;
import software.amazon.awssdk.services.mediaconvert.model.ProresSettings;
import software.amazon.awssdk.services.mediaconvert.model.VideoCodec;
import software.amazon.awssdk.services.mediaconvert.model.Vp8Settings;
import software.amazon.awssdk.services.mediaconvert.model.Vp9Settings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoCodecSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoCodecSettings> {
    private static final SdkField<Av1Settings> AV1_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoCodecSettings.getter(VideoCodecSettings::av1Settings)).setter(VideoCodecSettings.setter(Builder::av1Settings)).constructor(Av1Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("av1Settings").build()}).build();
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VideoCodecSettings.getter(VideoCodecSettings::codecAsString)).setter(VideoCodecSettings.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()}).build();
    private static final SdkField<FrameCaptureSettings> FRAME_CAPTURE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoCodecSettings.getter(VideoCodecSettings::frameCaptureSettings)).setter(VideoCodecSettings.setter(Builder::frameCaptureSettings)).constructor(FrameCaptureSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureSettings").build()}).build();
    private static final SdkField<H264Settings> H264_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoCodecSettings.getter(VideoCodecSettings::h264Settings)).setter(VideoCodecSettings.setter(Builder::h264Settings)).constructor(H264Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h264Settings").build()}).build();
    private static final SdkField<H265Settings> H265_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoCodecSettings.getter(VideoCodecSettings::h265Settings)).setter(VideoCodecSettings.setter(Builder::h265Settings)).constructor(H265Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h265Settings").build()}).build();
    private static final SdkField<Mpeg2Settings> MPEG2_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoCodecSettings.getter(VideoCodecSettings::mpeg2Settings)).setter(VideoCodecSettings.setter(Builder::mpeg2Settings)).constructor(Mpeg2Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpeg2Settings").build()}).build();
    private static final SdkField<ProresSettings> PRORES_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoCodecSettings.getter(VideoCodecSettings::proresSettings)).setter(VideoCodecSettings.setter(Builder::proresSettings)).constructor(ProresSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proresSettings").build()}).build();
    private static final SdkField<Vp8Settings> VP8_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoCodecSettings.getter(VideoCodecSettings::vp8Settings)).setter(VideoCodecSettings.setter(Builder::vp8Settings)).constructor(Vp8Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vp8Settings").build()}).build();
    private static final SdkField<Vp9Settings> VP9_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoCodecSettings.getter(VideoCodecSettings::vp9Settings)).setter(VideoCodecSettings.setter(Builder::vp9Settings)).constructor(Vp9Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vp9Settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AV1_SETTINGS_FIELD, CODEC_FIELD, FRAME_CAPTURE_SETTINGS_FIELD, H264_SETTINGS_FIELD, H265_SETTINGS_FIELD, MPEG2_SETTINGS_FIELD, PRORES_SETTINGS_FIELD, VP8_SETTINGS_FIELD, VP9_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Av1Settings av1Settings;
    private final String codec;
    private final FrameCaptureSettings frameCaptureSettings;
    private final H264Settings h264Settings;
    private final H265Settings h265Settings;
    private final Mpeg2Settings mpeg2Settings;
    private final ProresSettings proresSettings;
    private final Vp8Settings vp8Settings;
    private final Vp9Settings vp9Settings;

    private VideoCodecSettings(BuilderImpl builder) {
        this.av1Settings = builder.av1Settings;
        this.codec = builder.codec;
        this.frameCaptureSettings = builder.frameCaptureSettings;
        this.h264Settings = builder.h264Settings;
        this.h265Settings = builder.h265Settings;
        this.mpeg2Settings = builder.mpeg2Settings;
        this.proresSettings = builder.proresSettings;
        this.vp8Settings = builder.vp8Settings;
        this.vp9Settings = builder.vp9Settings;
    }

    public Av1Settings av1Settings() {
        return this.av1Settings;
    }

    public VideoCodec codec() {
        return VideoCodec.fromValue(this.codec);
    }

    public String codecAsString() {
        return this.codec;
    }

    public FrameCaptureSettings frameCaptureSettings() {
        return this.frameCaptureSettings;
    }

    public H264Settings h264Settings() {
        return this.h264Settings;
    }

    public H265Settings h265Settings() {
        return this.h265Settings;
    }

    public Mpeg2Settings mpeg2Settings() {
        return this.mpeg2Settings;
    }

    public ProresSettings proresSettings() {
        return this.proresSettings;
    }

    public Vp8Settings vp8Settings() {
        return this.vp8Settings;
    }

    public Vp9Settings vp9Settings() {
        return this.vp9Settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.av1Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameCaptureSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.h264Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.h265Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mpeg2Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.proresSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.vp8Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.vp9Settings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoCodecSettings)) {
            return false;
        }
        VideoCodecSettings other = (VideoCodecSettings)obj;
        return Objects.equals(this.av1Settings(), other.av1Settings()) && Objects.equals(this.codecAsString(), other.codecAsString()) && Objects.equals(this.frameCaptureSettings(), other.frameCaptureSettings()) && Objects.equals(this.h264Settings(), other.h264Settings()) && Objects.equals(this.h265Settings(), other.h265Settings()) && Objects.equals(this.mpeg2Settings(), other.mpeg2Settings()) && Objects.equals(this.proresSettings(), other.proresSettings()) && Objects.equals(this.vp8Settings(), other.vp8Settings()) && Objects.equals(this.vp9Settings(), other.vp9Settings());
    }

    public String toString() {
        return ToString.builder((String)"VideoCodecSettings").add("Av1Settings", (Object)this.av1Settings()).add("Codec", (Object)this.codecAsString()).add("FrameCaptureSettings", (Object)this.frameCaptureSettings()).add("H264Settings", (Object)this.h264Settings()).add("H265Settings", (Object)this.h265Settings()).add("Mpeg2Settings", (Object)this.mpeg2Settings()).add("ProresSettings", (Object)this.proresSettings()).add("Vp8Settings", (Object)this.vp8Settings()).add("Vp9Settings", (Object)this.vp9Settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Av1Settings": {
                return Optional.ofNullable(clazz.cast(this.av1Settings()));
            }
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codecAsString()));
            }
            case "FrameCaptureSettings": {
                return Optional.ofNullable(clazz.cast(this.frameCaptureSettings()));
            }
            case "H264Settings": {
                return Optional.ofNullable(clazz.cast(this.h264Settings()));
            }
            case "H265Settings": {
                return Optional.ofNullable(clazz.cast(this.h265Settings()));
            }
            case "Mpeg2Settings": {
                return Optional.ofNullable(clazz.cast(this.mpeg2Settings()));
            }
            case "ProresSettings": {
                return Optional.ofNullable(clazz.cast(this.proresSettings()));
            }
            case "Vp8Settings": {
                return Optional.ofNullable(clazz.cast(this.vp8Settings()));
            }
            case "Vp9Settings": {
                return Optional.ofNullable(clazz.cast(this.vp9Settings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoCodecSettings, T> g) {
        return obj -> g.apply((VideoCodecSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Av1Settings av1Settings;
        private String codec;
        private FrameCaptureSettings frameCaptureSettings;
        private H264Settings h264Settings;
        private H265Settings h265Settings;
        private Mpeg2Settings mpeg2Settings;
        private ProresSettings proresSettings;
        private Vp8Settings vp8Settings;
        private Vp9Settings vp9Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoCodecSettings model) {
            this.av1Settings(model.av1Settings);
            this.codec(model.codec);
            this.frameCaptureSettings(model.frameCaptureSettings);
            this.h264Settings(model.h264Settings);
            this.h265Settings(model.h265Settings);
            this.mpeg2Settings(model.mpeg2Settings);
            this.proresSettings(model.proresSettings);
            this.vp8Settings(model.vp8Settings);
            this.vp9Settings(model.vp9Settings);
        }

        public final Av1Settings.Builder getAv1Settings() {
            return this.av1Settings != null ? this.av1Settings.toBuilder() : null;
        }

        @Override
        public final Builder av1Settings(Av1Settings av1Settings) {
            this.av1Settings = av1Settings;
            return this;
        }

        public final void setAv1Settings(Av1Settings.BuilderImpl av1Settings) {
            this.av1Settings = av1Settings != null ? av1Settings.build() : null;
        }

        public final String getCodec() {
            return this.codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(VideoCodec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final FrameCaptureSettings.Builder getFrameCaptureSettings() {
            return this.frameCaptureSettings != null ? this.frameCaptureSettings.toBuilder() : null;
        }

        @Override
        public final Builder frameCaptureSettings(FrameCaptureSettings frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings;
            return this;
        }

        public final void setFrameCaptureSettings(FrameCaptureSettings.BuilderImpl frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings != null ? frameCaptureSettings.build() : null;
        }

        public final H264Settings.Builder getH264Settings() {
            return this.h264Settings != null ? this.h264Settings.toBuilder() : null;
        }

        @Override
        public final Builder h264Settings(H264Settings h264Settings) {
            this.h264Settings = h264Settings;
            return this;
        }

        public final void setH264Settings(H264Settings.BuilderImpl h264Settings) {
            this.h264Settings = h264Settings != null ? h264Settings.build() : null;
        }

        public final H265Settings.Builder getH265Settings() {
            return this.h265Settings != null ? this.h265Settings.toBuilder() : null;
        }

        @Override
        public final Builder h265Settings(H265Settings h265Settings) {
            this.h265Settings = h265Settings;
            return this;
        }

        public final void setH265Settings(H265Settings.BuilderImpl h265Settings) {
            this.h265Settings = h265Settings != null ? h265Settings.build() : null;
        }

        public final Mpeg2Settings.Builder getMpeg2Settings() {
            return this.mpeg2Settings != null ? this.mpeg2Settings.toBuilder() : null;
        }

        @Override
        public final Builder mpeg2Settings(Mpeg2Settings mpeg2Settings) {
            this.mpeg2Settings = mpeg2Settings;
            return this;
        }

        public final void setMpeg2Settings(Mpeg2Settings.BuilderImpl mpeg2Settings) {
            this.mpeg2Settings = mpeg2Settings != null ? mpeg2Settings.build() : null;
        }

        public final ProresSettings.Builder getProresSettings() {
            return this.proresSettings != null ? this.proresSettings.toBuilder() : null;
        }

        @Override
        public final Builder proresSettings(ProresSettings proresSettings) {
            this.proresSettings = proresSettings;
            return this;
        }

        public final void setProresSettings(ProresSettings.BuilderImpl proresSettings) {
            this.proresSettings = proresSettings != null ? proresSettings.build() : null;
        }

        public final Vp8Settings.Builder getVp8Settings() {
            return this.vp8Settings != null ? this.vp8Settings.toBuilder() : null;
        }

        @Override
        public final Builder vp8Settings(Vp8Settings vp8Settings) {
            this.vp8Settings = vp8Settings;
            return this;
        }

        public final void setVp8Settings(Vp8Settings.BuilderImpl vp8Settings) {
            this.vp8Settings = vp8Settings != null ? vp8Settings.build() : null;
        }

        public final Vp9Settings.Builder getVp9Settings() {
            return this.vp9Settings != null ? this.vp9Settings.toBuilder() : null;
        }

        @Override
        public final Builder vp9Settings(Vp9Settings vp9Settings) {
            this.vp9Settings = vp9Settings;
            return this;
        }

        public final void setVp9Settings(Vp9Settings.BuilderImpl vp9Settings) {
            this.vp9Settings = vp9Settings != null ? vp9Settings.build() : null;
        }

        public VideoCodecSettings build() {
            return new VideoCodecSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoCodecSettings> {
        public Builder av1Settings(Av1Settings var1);

        default public Builder av1Settings(Consumer<Av1Settings.Builder> av1Settings) {
            return this.av1Settings((Av1Settings)((Av1Settings.Builder)Av1Settings.builder().applyMutation(av1Settings)).build());
        }

        public Builder codec(String var1);

        public Builder codec(VideoCodec var1);

        public Builder frameCaptureSettings(FrameCaptureSettings var1);

        default public Builder frameCaptureSettings(Consumer<FrameCaptureSettings.Builder> frameCaptureSettings) {
            return this.frameCaptureSettings((FrameCaptureSettings)((FrameCaptureSettings.Builder)FrameCaptureSettings.builder().applyMutation(frameCaptureSettings)).build());
        }

        public Builder h264Settings(H264Settings var1);

        default public Builder h264Settings(Consumer<H264Settings.Builder> h264Settings) {
            return this.h264Settings((H264Settings)((H264Settings.Builder)H264Settings.builder().applyMutation(h264Settings)).build());
        }

        public Builder h265Settings(H265Settings var1);

        default public Builder h265Settings(Consumer<H265Settings.Builder> h265Settings) {
            return this.h265Settings((H265Settings)((H265Settings.Builder)H265Settings.builder().applyMutation(h265Settings)).build());
        }

        public Builder mpeg2Settings(Mpeg2Settings var1);

        default public Builder mpeg2Settings(Consumer<Mpeg2Settings.Builder> mpeg2Settings) {
            return this.mpeg2Settings((Mpeg2Settings)((Mpeg2Settings.Builder)Mpeg2Settings.builder().applyMutation(mpeg2Settings)).build());
        }

        public Builder proresSettings(ProresSettings var1);

        default public Builder proresSettings(Consumer<ProresSettings.Builder> proresSettings) {
            return this.proresSettings((ProresSettings)((ProresSettings.Builder)ProresSettings.builder().applyMutation(proresSettings)).build());
        }

        public Builder vp8Settings(Vp8Settings var1);

        default public Builder vp8Settings(Consumer<Vp8Settings.Builder> vp8Settings) {
            return this.vp8Settings((Vp8Settings)((Vp8Settings.Builder)Vp8Settings.builder().applyMutation(vp8Settings)).build());
        }

        public Builder vp9Settings(Vp9Settings var1);

        default public Builder vp9Settings(Consumer<Vp9Settings.Builder> vp9Settings) {
            return this.vp9Settings((Vp9Settings)((Vp9Settings.Builder)Vp9Settings.builder().applyMutation(vp9Settings)).build());
        }
    }
}

