/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Mpeg2Settings implements SdkPojo, Serializable, ToCopyableBuilder<Mpeg2Settings.Builder, Mpeg2Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::adaptiveQuantizationAsString)).setter(setter(Builder::adaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build())
            .build();

    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mpeg2Settings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> CODEC_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::codecLevelAsString)).setter(setter(Builder::codecLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecLevel").build()).build();

    private static final SdkField<String> CODEC_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::codecProfileAsString)).setter(setter(Builder::codecProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecProfile").build()).build();

    private static final SdkField<String> DYNAMIC_SUB_GOP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::dynamicSubGopAsString)).setter(setter(Builder::dynamicSubGop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicSubGop").build()).build();

    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::framerateControlAsString)).setter(setter(Builder::framerateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()).build();

    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::framerateConversionAlgorithmAsString))
            .setter(setter(Builder::framerateConversionAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm")
                    .build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mpeg2Settings::framerateDenominator)).setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mpeg2Settings::framerateNumerator)).setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mpeg2Settings::gopClosedCadence)).setter(setter(Builder::gopClosedCadence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()).build();

    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Mpeg2Settings::gopSize)).setter(setter(Builder::gopSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()).build();

    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::gopSizeUnitsAsString)).setter(setter(Builder::gopSizeUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()).build();

    private static final SdkField<Integer> HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mpeg2Settings::hrdBufferInitialFillPercentage))
            .setter(setter(Builder::hrdBufferInitialFillPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferInitialFillPercentage")
                    .build()).build();

    private static final SdkField<Integer> HRD_BUFFER_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mpeg2Settings::hrdBufferSize)).setter(setter(Builder::hrdBufferSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferSize").build()).build();

    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::interlaceModeAsString)).setter(setter(Builder::interlaceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()).build();

    private static final SdkField<String> INTRA_DC_PRECISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::intraDcPrecisionAsString)).setter(setter(Builder::intraDcPrecision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intraDcPrecision").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mpeg2Settings::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mpeg2Settings::minIInterval)).setter(setter(Builder::minIInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()).build();

    private static final SdkField<Integer> NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mpeg2Settings::numberBFramesBetweenReferenceFrames))
            .setter(setter(Builder::numberBFramesBetweenReferenceFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("numberBFramesBetweenReferenceFrames").build()).build();

    private static final SdkField<String> PAR_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::parControlAsString)).setter(setter(Builder::parControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parControl").build()).build();

    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mpeg2Settings::parDenominator)).setter(setter(Builder::parDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()).build();

    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mpeg2Settings::parNumerator)).setter(setter(Builder::parNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()).build();

    private static final SdkField<String> QUALITY_TUNING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::qualityTuningLevelAsString)).setter(setter(Builder::qualityTuningLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityTuningLevel").build())
            .build();

    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::rateControlModeAsString)).setter(setter(Builder::rateControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()).build();

    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::sceneChangeDetectAsString)).setter(setter(Builder::sceneChangeDetect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()).build();

    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::slowPalAsString)).setter(setter(Builder::slowPal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()).build();

    private static final SdkField<Integer> SOFTNESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mpeg2Settings::softness)).setter(setter(Builder::softness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softness").build()).build();

    private static final SdkField<String> SPATIAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::spatialAdaptiveQuantizationAsString))
            .setter(setter(Builder::spatialAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<String> SYNTAX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::syntaxAsString)).setter(setter(Builder::syntax))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syntax").build()).build();

    private static final SdkField<String> TELECINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::telecineAsString)).setter(setter(Builder::telecine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()).build();

    private static final SdkField<String> TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Mpeg2Settings::temporalAdaptiveQuantizationAsString))
            .setter(setter(Builder::temporalAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalAdaptiveQuantization")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD,
            BITRATE_FIELD, CODEC_LEVEL_FIELD, CODEC_PROFILE_FIELD, DYNAMIC_SUB_GOP_FIELD, FRAMERATE_CONTROL_FIELD,
            FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD,
            GOP_CLOSED_CADENCE_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD,
            HRD_BUFFER_SIZE_FIELD, INTERLACE_MODE_FIELD, INTRA_DC_PRECISION_FIELD, MAX_BITRATE_FIELD, MIN_I_INTERVAL_FIELD,
            NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD, PAR_CONTROL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD,
            QUALITY_TUNING_LEVEL_FIELD, RATE_CONTROL_MODE_FIELD, SCENE_CHANGE_DETECT_FIELD, SLOW_PAL_FIELD, SOFTNESS_FIELD,
            SPATIAL_ADAPTIVE_QUANTIZATION_FIELD, SYNTAX_FIELD, TELECINE_FIELD, TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adaptiveQuantization;

    private final Integer bitrate;

    private final String codecLevel;

    private final String codecProfile;

    private final String dynamicSubGop;

    private final String framerateControl;

    private final String framerateConversionAlgorithm;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final Integer gopClosedCadence;

    private final Double gopSize;

    private final String gopSizeUnits;

    private final Integer hrdBufferInitialFillPercentage;

    private final Integer hrdBufferSize;

    private final String interlaceMode;

    private final String intraDcPrecision;

    private final Integer maxBitrate;

    private final Integer minIInterval;

    private final Integer numberBFramesBetweenReferenceFrames;

    private final String parControl;

    private final Integer parDenominator;

    private final Integer parNumerator;

    private final String qualityTuningLevel;

    private final String rateControlMode;

    private final String sceneChangeDetect;

    private final String slowPal;

    private final Integer softness;

    private final String spatialAdaptiveQuantization;

    private final String syntax;

    private final String telecine;

    private final String temporalAdaptiveQuantization;

    private Mpeg2Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.bitrate = builder.bitrate;
        this.codecLevel = builder.codecLevel;
        this.codecProfile = builder.codecProfile;
        this.dynamicSubGop = builder.dynamicSubGop;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.hrdBufferInitialFillPercentage = builder.hrdBufferInitialFillPercentage;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.interlaceMode = builder.interlaceMode;
        this.intraDcPrecision = builder.intraDcPrecision;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.numberBFramesBetweenReferenceFrames = builder.numberBFramesBetweenReferenceFrames;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.rateControlMode = builder.rateControlMode;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slowPal = builder.slowPal;
        this.softness = builder.softness;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
        this.syntax = builder.syntax;
        this.telecine = builder.telecine;
        this.temporalAdaptiveQuantization = builder.temporalAdaptiveQuantization;
    }

    /**
     * Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link Mpeg2AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
     * @see Mpeg2AdaptiveQuantization
     */
    public Mpeg2AdaptiveQuantization adaptiveQuantization() {
        return Mpeg2AdaptiveQuantization.fromValue(adaptiveQuantization);
    }

    /**
     * Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link Mpeg2AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
     * @see Mpeg2AdaptiveQuantization
     */
    public String adaptiveQuantizationAsString() {
        return adaptiveQuantization;
    }

    /**
     * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be
     * unique when rounded down to the nearest multiple of 1000.
     * 
     * @return Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates
     *         must be unique when rounded down to the nearest multiple of 1000.
     */
    public Integer bitrate() {
        return bitrate;
    }

    /**
     * Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecLevel} will
     * return {@link Mpeg2CodecLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecLevelAsString}.
     * </p>
     * 
     * @return Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
     * @see Mpeg2CodecLevel
     */
    public Mpeg2CodecLevel codecLevel() {
        return Mpeg2CodecLevel.fromValue(codecLevel);
    }

    /**
     * Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecLevel} will
     * return {@link Mpeg2CodecLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecLevelAsString}.
     * </p>
     * 
     * @return Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
     * @see Mpeg2CodecLevel
     */
    public String codecLevelAsString() {
        return codecLevel;
    }

    /**
     * Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link Mpeg2CodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecProfileAsString}.
     * </p>
     * 
     * @return Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
     * @see Mpeg2CodecProfile
     */
    public Mpeg2CodecProfile codecProfile() {
        return Mpeg2CodecProfile.fromValue(codecProfile);
    }

    /**
     * Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link Mpeg2CodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecProfileAsString}.
     * </p>
     * 
     * @return Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
     * @see Mpeg2CodecProfile
     */
    public String codecProfileAsString() {
        return codecProfile;
    }

    /**
     * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use
     * fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more
     * B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the
     * setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynamicSubGop}
     * will return {@link Mpeg2DynamicSubGop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dynamicSubGopAsString}.
     * </p>
     * 
     * @return Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service
     *         to use fewer B-frames (which infer information based on other frames) for high-motion portions of the
     *         video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value
     *         you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     * @see Mpeg2DynamicSubGop
     */
    public Mpeg2DynamicSubGop dynamicSubGop() {
        return Mpeg2DynamicSubGop.fromValue(dynamicSubGop);
    }

    /**
     * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use
     * fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more
     * B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the
     * setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynamicSubGop}
     * will return {@link Mpeg2DynamicSubGop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dynamicSubGopAsString}.
     * </p>
     * 
     * @return Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service
     *         to use fewer B-frames (which infer information based on other frames) for high-motion portions of the
     *         video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value
     *         you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     * @see Mpeg2DynamicSubGop
     */
    public String dynamicSubGopAsString() {
        return dynamicSubGop;
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link Mpeg2FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see Mpeg2FramerateControl
     */
    public Mpeg2FramerateControl framerateControl() {
        return Mpeg2FramerateControl.fromValue(framerateControl);
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link Mpeg2FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see Mpeg2FramerateControl
     */
    public String framerateControlAsString() {
        return framerateControl;
    }

    /**
     * Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop
     * conversion.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return
     * {@link Mpeg2FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use
     *         duplicate drop conversion.
     * @see Mpeg2FramerateConversionAlgorithm
     */
    public Mpeg2FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return Mpeg2FramerateConversionAlgorithm.fromValue(framerateConversionAlgorithm);
    }

    /**
     * Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop
     * conversion.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return
     * {@link Mpeg2FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use
     *         duplicate drop conversion.
     * @see Mpeg2FramerateConversionAlgorithm
     */
    public String framerateConversionAlgorithmAsString() {
        return framerateConversionAlgorithm;
    }

    /**
     * Frame rate denominator.
     * 
     * @return Frame rate denominator.
     */
    public Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * Frame rate numerator - frame rate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
     * 
     * @return Frame rate numerator - frame rate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
     */
    public Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining
     * mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output
     * segmenting.
     * 
     * @return Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
     *         joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
     *         output segmenting.
     */
    public Integer gopClosedCadence() {
        return gopClosedCadence;
    }

    /**
     * GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
     * 
     * @return GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
     */
    public Double gopSize() {
        return gopSize;
    }

    /**
     * Indicates if the GOP Size in MPEG2 is specified in frames or seconds. If seconds the system will convert the GOP
     * Size into a frame count at run time.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link Mpeg2GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Indicates if the GOP Size in MPEG2 is specified in frames or seconds. If seconds the system will convert
     *         the GOP Size into a frame count at run time.
     * @see Mpeg2GopSizeUnits
     */
    public Mpeg2GopSizeUnits gopSizeUnits() {
        return Mpeg2GopSizeUnits.fromValue(gopSizeUnits);
    }

    /**
     * Indicates if the GOP Size in MPEG2 is specified in frames or seconds. If seconds the system will convert the GOP
     * Size into a frame count at run time.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link Mpeg2GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Indicates if the GOP Size in MPEG2 is specified in frames or seconds. If seconds the system will convert
     *         the GOP Size into a frame count at run time.
     * @see Mpeg2GopSizeUnits
     */
    public String gopSizeUnitsAsString() {
        return gopSizeUnits;
    }

    /**
     * Percentage of the buffer that should initially be filled (HRD buffer model).
     * 
     * @return Percentage of the buffer that should initially be filled (HRD buffer model).
     */
    public Integer hrdBufferInitialFillPercentage() {
        return hrdBufferInitialFillPercentage;
    }

    /**
     * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     * 
     * @return Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     */
    public Integer hrdBufferSize() {
        return hrdBufferSize;
    }

    /**
     * Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD) and
     * Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field polarity
     * (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom (FOLLOW_BOTTOM_FIELD)
     * use the same field polarity as the source. Therefore, behavior depends on the input scan type. - If the source is
     * interlaced, the output will be interlaced with the same polarity as the source (it will follow the source). The
     * output could therefore be a mix of "top field first" and "bottom field first". - If the source is progressive,
     * the output will be interlaced with "top field first" or "bottom field first" polarity, depending on which of the
     * Follow options you chose.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link Mpeg2InterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First
     *         (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having
     *         the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow,
     *         Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior
     *         depends on the input scan type. - If the source is interlaced, the output will be interlaced with the
     *         same polarity as the source (it will follow the source). The output could therefore be a mix of
     *         "top field first" and "bottom field first". - If the source is progressive, the output will be interlaced
     *         with "top field first" or "bottom field first" polarity, depending on which of the Follow options you
     *         chose.
     * @see Mpeg2InterlaceMode
     */
    public Mpeg2InterlaceMode interlaceMode() {
        return Mpeg2InterlaceMode.fromValue(interlaceMode);
    }

    /**
     * Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD) and
     * Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field polarity
     * (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom (FOLLOW_BOTTOM_FIELD)
     * use the same field polarity as the source. Therefore, behavior depends on the input scan type. - If the source is
     * interlaced, the output will be interlaced with the same polarity as the source (it will follow the source). The
     * output could therefore be a mix of "top field first" and "bottom field first". - If the source is progressive,
     * the output will be interlaced with "top field first" or "bottom field first" polarity, depending on which of the
     * Follow options you chose.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link Mpeg2InterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First
     *         (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having
     *         the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow,
     *         Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior
     *         depends on the input scan type. - If the source is interlaced, the output will be interlaced with the
     *         same polarity as the source (it will follow the source). The output could therefore be a mix of
     *         "top field first" and "bottom field first". - If the source is progressive, the output will be interlaced
     *         with "top field first" or "bottom field first" polarity, depending on which of the Follow options you
     *         chose.
     * @see Mpeg2InterlaceMode
     */
    public String interlaceModeAsString() {
        return interlaceMode;
    }

    /**
     * Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC coefficients. If
     * you choose the value auto, the service will automatically select the precision based on the per-frame compression
     * ratio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intraDcPrecision}
     * will return {@link Mpeg2IntraDcPrecision#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #intraDcPrecisionAsString}.
     * </p>
     * 
     * @return Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC
     *         coefficients. If you choose the value auto, the service will automatically select the precision based on
     *         the per-frame compression ratio.
     * @see Mpeg2IntraDcPrecision
     */
    public Mpeg2IntraDcPrecision intraDcPrecision() {
        return Mpeg2IntraDcPrecision.fromValue(intraDcPrecision);
    }

    /**
     * Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC coefficients. If
     * you choose the value auto, the service will automatically select the precision based on the per-frame compression
     * ratio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intraDcPrecision}
     * will return {@link Mpeg2IntraDcPrecision#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #intraDcPrecisionAsString}.
     * </p>
     * 
     * @return Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC
     *         coefficients. If you choose the value auto, the service will automatically select the precision based on
     *         the per-frame compression ratio.
     * @see Mpeg2IntraDcPrecision
     */
    public String intraDcPrecisionAsString() {
        return intraDcPrecision;
    }

    /**
     * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000.
     * 
     * @return Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000.
     */
    public Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a
     * scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the
     * scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence
     * resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP
     * stretch = GOP size + Min-I-interval - 1
     * 
     * @return Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection.
     *         If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or
     *         stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting
     *         I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change
     *         Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
     */
    public Integer minIInterval() {
        return minIInterval;
    }

    /**
     * Number of B-frames between reference frames.
     * 
     * @return Number of B-frames between reference frames.
     */
    public Integer numberBFramesBetweenReferenceFrames() {
        return numberBFramesBetweenReferenceFrames;
    }

    /**
     * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior,
     * Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To use a different
     * PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other than Follow source. When you
     * choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link Mpeg2ParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
     *         behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
     *         use a different PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other than
     *         Follow source. When you choose SPECIFIED for this setting, you must also specify values for the
     *         parNumerator and parDenominator settings.
     * @see Mpeg2ParControl
     */
    public Mpeg2ParControl parControl() {
        return Mpeg2ParControl.fromValue(parControl);
    }

    /**
     * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior,
     * Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To use a different
     * PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other than Follow source. When you
     * choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link Mpeg2ParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
     *         behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
     *         use a different PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other than
     *         Follow source. When you choose SPECIFIED for this setting, you must also specify values for the
     *         parNumerator and parDenominator settings.
     * @see Mpeg2ParControl
     */
    public String parControlAsString() {
        return parControl;
    }

    /**
     * Pixel Aspect Ratio denominator.
     * 
     * @return Pixel Aspect Ratio denominator.
     */
    public Integer parDenominator() {
        return parDenominator;
    }

    /**
     * Pixel Aspect Ratio numerator.
     * 
     * @return Pixel Aspect Ratio numerator.
     */
    public Integer parNumerator() {
        return parNumerator;
    }

    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for
     * output video quality. The default behavior is faster, lower quality, single-pass encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link Mpeg2QualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
     *         speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
     * @see Mpeg2QualityTuningLevel
     */
    public Mpeg2QualityTuningLevel qualityTuningLevel() {
        return Mpeg2QualityTuningLevel.fromValue(qualityTuningLevel);
    }

    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for
     * output video quality. The default behavior is faster, lower quality, single-pass encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link Mpeg2QualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
     *         speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
     * @see Mpeg2QualityTuningLevel
     */
    public String qualityTuningLevelAsString() {
        return qualityTuningLevel;
    }

    /**
     * Use Rate control mode (Mpeg2RateControlMode) to specifiy whether the bitrate is variable (vbr) or constant (cbr).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link Mpeg2RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Use Rate control mode (Mpeg2RateControlMode) to specifiy whether the bitrate is variable (vbr) or
     *         constant (cbr).
     * @see Mpeg2RateControlMode
     */
    public Mpeg2RateControlMode rateControlMode() {
        return Mpeg2RateControlMode.fromValue(rateControlMode);
    }

    /**
     * Use Rate control mode (Mpeg2RateControlMode) to specifiy whether the bitrate is variable (vbr) or constant (cbr).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link Mpeg2RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Use Rate control mode (Mpeg2RateControlMode) to specifiy whether the bitrate is variable (vbr) or
     *         constant (cbr).
     * @see Mpeg2RateControlMode
     */
    public String rateControlModeAsString() {
        return rateControlMode;
    }

    /**
     * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
     * video quality and is enabled by default.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link Mpeg2SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Enable this setting to insert I-frames at scene changes that the service automatically detects. This
     *         improves video quality and is enabled by default.
     * @see Mpeg2SceneChangeDetect
     */
    public Mpeg2SceneChangeDetect sceneChangeDetect() {
        return Mpeg2SceneChangeDetect.fromValue(sceneChangeDetect);
    }

    /**
     * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
     * video quality and is enabled by default.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link Mpeg2SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Enable this setting to insert I-frames at scene changes that the service automatically detects. This
     *         improves video quality and is enabled by default.
     * @see Mpeg2SceneChangeDetect
     */
    public String sceneChangeDetectAsString() {
        return sceneChangeDetect;
    }

    /**
     * Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up
     * correspondingly.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link Mpeg2SlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up
     *         correspondingly.
     * @see Mpeg2SlowPal
     */
    public Mpeg2SlowPal slowPal() {
        return Mpeg2SlowPal.fromValue(slowPal);
    }

    /**
     * Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up
     * correspondingly.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link Mpeg2SlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up
     *         correspondingly.
     * @see Mpeg2SlowPal
     */
    public String slowPalAsString() {
        return slowPal;
    }

    /**
     * Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.
     * 
     * @return Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.
     */
    public Integer softness() {
        return softness;
    }

    /**
     * Adjust quantization within each frame based on spatial variation of content complexity.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spatialAdaptiveQuantization} will return {@link Mpeg2SpatialAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #spatialAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adjust quantization within each frame based on spatial variation of content complexity.
     * @see Mpeg2SpatialAdaptiveQuantization
     */
    public Mpeg2SpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return Mpeg2SpatialAdaptiveQuantization.fromValue(spatialAdaptiveQuantization);
    }

    /**
     * Adjust quantization within each frame based on spatial variation of content complexity.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spatialAdaptiveQuantization} will return {@link Mpeg2SpatialAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #spatialAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adjust quantization within each frame based on spatial variation of content complexity.
     * @see Mpeg2SpatialAdaptiveQuantization
     */
    public String spatialAdaptiveQuantizationAsString() {
        return spatialAdaptiveQuantization;
    }

    /**
     * Produces a Type D-10 compatible bitstream (SMPTE 356M-2001).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syntax} will
     * return {@link Mpeg2Syntax#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #syntaxAsString}.
     * </p>
     * 
     * @return Produces a Type D-10 compatible bitstream (SMPTE 356M-2001).
     * @see Mpeg2Syntax
     */
    public Mpeg2Syntax syntax() {
        return Mpeg2Syntax.fromValue(syntax);
    }

    /**
     * Produces a Type D-10 compatible bitstream (SMPTE 356M-2001).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syntax} will
     * return {@link Mpeg2Syntax#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #syntaxAsString}.
     * </p>
     * 
     * @return Produces a Type D-10 compatible bitstream (SMPTE 356M-2001).
     * @see Mpeg2Syntax
     */
    public String syntaxAsString() {
        return syntax;
    }

    /**
     * Only use Telecine (Mpeg2Telecine) when you set Framerate (Framerate) to 29.970. Set Telecine (Mpeg2Telecine) to
     * Hard (hard) to produce a 29.97i output from a 23.976 input. Set it to Soft (soft) to produce 23.976 output and
     * leave converstion to the player.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link Mpeg2Telecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telecineAsString}.
     * </p>
     * 
     * @return Only use Telecine (Mpeg2Telecine) when you set Framerate (Framerate) to 29.970. Set Telecine
     *         (Mpeg2Telecine) to Hard (hard) to produce a 29.97i output from a 23.976 input. Set it to Soft (soft) to
     *         produce 23.976 output and leave converstion to the player.
     * @see Mpeg2Telecine
     */
    public Mpeg2Telecine telecine() {
        return Mpeg2Telecine.fromValue(telecine);
    }

    /**
     * Only use Telecine (Mpeg2Telecine) when you set Framerate (Framerate) to 29.970. Set Telecine (Mpeg2Telecine) to
     * Hard (hard) to produce a 29.97i output from a 23.976 input. Set it to Soft (soft) to produce 23.976 output and
     * leave converstion to the player.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link Mpeg2Telecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telecineAsString}.
     * </p>
     * 
     * @return Only use Telecine (Mpeg2Telecine) when you set Framerate (Framerate) to 29.970. Set Telecine
     *         (Mpeg2Telecine) to Hard (hard) to produce a 29.97i output from a 23.976 input. Set it to Soft (soft) to
     *         produce 23.976 output and leave converstion to the player.
     * @see Mpeg2Telecine
     */
    public String telecineAsString() {
        return telecine;
    }

    /**
     * Adjust quantization within each frame based on temporal variation of content complexity.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #temporalAdaptiveQuantization} will return
     * {@link Mpeg2TemporalAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #temporalAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adjust quantization within each frame based on temporal variation of content complexity.
     * @see Mpeg2TemporalAdaptiveQuantization
     */
    public Mpeg2TemporalAdaptiveQuantization temporalAdaptiveQuantization() {
        return Mpeg2TemporalAdaptiveQuantization.fromValue(temporalAdaptiveQuantization);
    }

    /**
     * Adjust quantization within each frame based on temporal variation of content complexity.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #temporalAdaptiveQuantization} will return
     * {@link Mpeg2TemporalAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #temporalAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adjust quantization within each frame based on temporal variation of content complexity.
     * @see Mpeg2TemporalAdaptiveQuantization
     */
    public String temporalAdaptiveQuantizationAsString() {
        return temporalAdaptiveQuantization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(codecLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicSubGopAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hrdBufferInitialFillPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(intraDcPrecisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(numberBFramesBetweenReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(softness());
        hashCode = 31 * hashCode + Objects.hashCode(spatialAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(syntaxAsString());
        hashCode = 31 * hashCode + Objects.hashCode(telecineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(temporalAdaptiveQuantizationAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mpeg2Settings)) {
            return false;
        }
        Mpeg2Settings other = (Mpeg2Settings) obj;
        return Objects.equals(adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString())
                && Objects.equals(bitrate(), other.bitrate()) && Objects.equals(codecLevelAsString(), other.codecLevelAsString())
                && Objects.equals(codecProfileAsString(), other.codecProfileAsString())
                && Objects.equals(dynamicSubGopAsString(), other.dynamicSubGopAsString())
                && Objects.equals(framerateControlAsString(), other.framerateControlAsString())
                && Objects.equals(framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator())
                && Objects.equals(gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(gopSize(), other.gopSize())
                && Objects.equals(gopSizeUnitsAsString(), other.gopSizeUnitsAsString())
                && Objects.equals(hrdBufferInitialFillPercentage(), other.hrdBufferInitialFillPercentage())
                && Objects.equals(hrdBufferSize(), other.hrdBufferSize())
                && Objects.equals(interlaceModeAsString(), other.interlaceModeAsString())
                && Objects.equals(intraDcPrecisionAsString(), other.intraDcPrecisionAsString())
                && Objects.equals(maxBitrate(), other.maxBitrate()) && Objects.equals(minIInterval(), other.minIInterval())
                && Objects.equals(numberBFramesBetweenReferenceFrames(), other.numberBFramesBetweenReferenceFrames())
                && Objects.equals(parControlAsString(), other.parControlAsString())
                && Objects.equals(parDenominator(), other.parDenominator())
                && Objects.equals(parNumerator(), other.parNumerator())
                && Objects.equals(qualityTuningLevelAsString(), other.qualityTuningLevelAsString())
                && Objects.equals(rateControlModeAsString(), other.rateControlModeAsString())
                && Objects.equals(sceneChangeDetectAsString(), other.sceneChangeDetectAsString())
                && Objects.equals(slowPalAsString(), other.slowPalAsString()) && Objects.equals(softness(), other.softness())
                && Objects.equals(spatialAdaptiveQuantizationAsString(), other.spatialAdaptiveQuantizationAsString())
                && Objects.equals(syntaxAsString(), other.syntaxAsString())
                && Objects.equals(telecineAsString(), other.telecineAsString())
                && Objects.equals(temporalAdaptiveQuantizationAsString(), other.temporalAdaptiveQuantizationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Mpeg2Settings").add("AdaptiveQuantization", adaptiveQuantizationAsString())
                .add("Bitrate", bitrate()).add("CodecLevel", codecLevelAsString()).add("CodecProfile", codecProfileAsString())
                .add("DynamicSubGop", dynamicSubGopAsString()).add("FramerateControl", framerateControlAsString())
                .add("FramerateConversionAlgorithm", framerateConversionAlgorithmAsString())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("GopClosedCadence", gopClosedCadence()).add("GopSize", gopSize())
                .add("GopSizeUnits", gopSizeUnitsAsString())
                .add("HrdBufferInitialFillPercentage", hrdBufferInitialFillPercentage()).add("HrdBufferSize", hrdBufferSize())
                .add("InterlaceMode", interlaceModeAsString()).add("IntraDcPrecision", intraDcPrecisionAsString())
                .add("MaxBitrate", maxBitrate()).add("MinIInterval", minIInterval())
                .add("NumberBFramesBetweenReferenceFrames", numberBFramesBetweenReferenceFrames())
                .add("ParControl", parControlAsString()).add("ParDenominator", parDenominator())
                .add("ParNumerator", parNumerator()).add("QualityTuningLevel", qualityTuningLevelAsString())
                .add("RateControlMode", rateControlModeAsString()).add("SceneChangeDetect", sceneChangeDetectAsString())
                .add("SlowPal", slowPalAsString()).add("Softness", softness())
                .add("SpatialAdaptiveQuantization", spatialAdaptiveQuantizationAsString()).add("Syntax", syntaxAsString())
                .add("Telecine", telecineAsString()).add("TemporalAdaptiveQuantization", temporalAdaptiveQuantizationAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(adaptiveQuantizationAsString()));
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "CodecLevel":
            return Optional.ofNullable(clazz.cast(codecLevelAsString()));
        case "CodecProfile":
            return Optional.ofNullable(clazz.cast(codecProfileAsString()));
        case "DynamicSubGop":
            return Optional.ofNullable(clazz.cast(dynamicSubGopAsString()));
        case "FramerateControl":
            return Optional.ofNullable(clazz.cast(framerateControlAsString()));
        case "FramerateConversionAlgorithm":
            return Optional.ofNullable(clazz.cast(framerateConversionAlgorithmAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "GopClosedCadence":
            return Optional.ofNullable(clazz.cast(gopClosedCadence()));
        case "GopSize":
            return Optional.ofNullable(clazz.cast(gopSize()));
        case "GopSizeUnits":
            return Optional.ofNullable(clazz.cast(gopSizeUnitsAsString()));
        case "HrdBufferInitialFillPercentage":
            return Optional.ofNullable(clazz.cast(hrdBufferInitialFillPercentage()));
        case "HrdBufferSize":
            return Optional.ofNullable(clazz.cast(hrdBufferSize()));
        case "InterlaceMode":
            return Optional.ofNullable(clazz.cast(interlaceModeAsString()));
        case "IntraDcPrecision":
            return Optional.ofNullable(clazz.cast(intraDcPrecisionAsString()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "MinIInterval":
            return Optional.ofNullable(clazz.cast(minIInterval()));
        case "NumberBFramesBetweenReferenceFrames":
            return Optional.ofNullable(clazz.cast(numberBFramesBetweenReferenceFrames()));
        case "ParControl":
            return Optional.ofNullable(clazz.cast(parControlAsString()));
        case "ParDenominator":
            return Optional.ofNullable(clazz.cast(parDenominator()));
        case "ParNumerator":
            return Optional.ofNullable(clazz.cast(parNumerator()));
        case "QualityTuningLevel":
            return Optional.ofNullable(clazz.cast(qualityTuningLevelAsString()));
        case "RateControlMode":
            return Optional.ofNullable(clazz.cast(rateControlModeAsString()));
        case "SceneChangeDetect":
            return Optional.ofNullable(clazz.cast(sceneChangeDetectAsString()));
        case "SlowPal":
            return Optional.ofNullable(clazz.cast(slowPalAsString()));
        case "Softness":
            return Optional.ofNullable(clazz.cast(softness()));
        case "SpatialAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(spatialAdaptiveQuantizationAsString()));
        case "Syntax":
            return Optional.ofNullable(clazz.cast(syntaxAsString()));
        case "Telecine":
            return Optional.ofNullable(clazz.cast(telecineAsString()));
        case "TemporalAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(temporalAdaptiveQuantizationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Mpeg2Settings, T> g) {
        return obj -> g.apply((Mpeg2Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Mpeg2Settings> {
        /**
         * Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
         * 
         * @param adaptiveQuantization
         *        Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
         * @see Mpeg2AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2AdaptiveQuantization
         */
        Builder adaptiveQuantization(String adaptiveQuantization);

        /**
         * Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
         * 
         * @param adaptiveQuantization
         *        Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
         * @see Mpeg2AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2AdaptiveQuantization
         */
        Builder adaptiveQuantization(Mpeg2AdaptiveQuantization adaptiveQuantization);

        /**
         * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates
         * must be unique when rounded down to the nearest multiple of 1000.
         * 
         * @param bitrate
         *        Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs,
         *        bitrates must be unique when rounded down to the nearest multiple of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
         * 
         * @param codecLevel
         *        Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
         * @see Mpeg2CodecLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2CodecLevel
         */
        Builder codecLevel(String codecLevel);

        /**
         * Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
         * 
         * @param codecLevel
         *        Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
         * @see Mpeg2CodecLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2CodecLevel
         */
        Builder codecLevel(Mpeg2CodecLevel codecLevel);

        /**
         * Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
         * 
         * @param codecProfile
         *        Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
         * @see Mpeg2CodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2CodecProfile
         */
        Builder codecProfile(String codecProfile);

        /**
         * Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
         * 
         * @param codecProfile
         *        Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
         * @see Mpeg2CodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2CodecProfile
         */
        Builder codecProfile(Mpeg2CodecProfile codecProfile);

        /**
         * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to
         * use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and
         * more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for
         * the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
         * 
         * @param dynamicSubGop
         *        Choose Adaptive to improve subjective video quality for high-motion content. This will cause the
         *        service to use fewer B-frames (which infer information based on other frames) for high-motion portions
         *        of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by
         *        the value you provide for the setting B frames between reference frames
         *        (numberBFramesBetweenReferenceFrames).
         * @see Mpeg2DynamicSubGop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2DynamicSubGop
         */
        Builder dynamicSubGop(String dynamicSubGop);

        /**
         * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to
         * use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and
         * more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for
         * the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
         * 
         * @param dynamicSubGop
         *        Choose Adaptive to improve subjective video quality for high-motion content. This will cause the
         *        service to use fewer B-frames (which infer information based on other frames) for high-motion portions
         *        of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by
         *        the value you provide for the setting B frames between reference frames
         *        (numberBFramesBetweenReferenceFrames).
         * @see Mpeg2DynamicSubGop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2DynamicSubGop
         */
        Builder dynamicSubGop(Mpeg2DynamicSubGop dynamicSubGop);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see Mpeg2FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2FramerateControl
         */
        Builder framerateControl(String framerateControl);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see Mpeg2FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2FramerateControl
         */
        Builder framerateControl(Mpeg2FramerateControl framerateControl);

        /**
         * Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate
         * drop conversion.
         * 
         * @param framerateConversionAlgorithm
         *        Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use
         *        duplicate drop conversion.
         * @see Mpeg2FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(String framerateConversionAlgorithm);

        /**
         * Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate
         * drop conversion.
         * 
         * @param framerateConversionAlgorithm
         *        Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use
         *        duplicate drop conversion.
         * @see Mpeg2FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(Mpeg2FramerateConversionAlgorithm framerateConversionAlgorithm);

        /**
         * Frame rate denominator.
         * 
         * @param framerateDenominator
         *        Frame rate denominator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * Frame rate numerator - frame rate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
         * 
         * @param framerateNumerator
         *        Frame rate numerator - frame rate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
         * joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
         * output segmenting.
         * 
         * @param gopClosedCadence
         *        Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a
         *        decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0
         *        will break output segmenting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopClosedCadence(Integer gopClosedCadence);

        /**
         * GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
         * 
         * @param gopSize
         *        GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopSize(Double gopSize);

        /**
         * Indicates if the GOP Size in MPEG2 is specified in frames or seconds. If seconds the system will convert the
         * GOP Size into a frame count at run time.
         * 
         * @param gopSizeUnits
         *        Indicates if the GOP Size in MPEG2 is specified in frames or seconds. If seconds the system will
         *        convert the GOP Size into a frame count at run time.
         * @see Mpeg2GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2GopSizeUnits
         */
        Builder gopSizeUnits(String gopSizeUnits);

        /**
         * Indicates if the GOP Size in MPEG2 is specified in frames or seconds. If seconds the system will convert the
         * GOP Size into a frame count at run time.
         * 
         * @param gopSizeUnits
         *        Indicates if the GOP Size in MPEG2 is specified in frames or seconds. If seconds the system will
         *        convert the GOP Size into a frame count at run time.
         * @see Mpeg2GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2GopSizeUnits
         */
        Builder gopSizeUnits(Mpeg2GopSizeUnits gopSizeUnits);

        /**
         * Percentage of the buffer that should initially be filled (HRD buffer model).
         * 
         * @param hrdBufferInitialFillPercentage
         *        Percentage of the buffer that should initially be filled (HRD buffer model).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage);

        /**
         * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         * 
         * @param hrdBufferSize
         *        Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hrdBufferSize(Integer hrdBufferSize);

        /**
         * Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD)
         * and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field
         * polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom
         * (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior depends on the input
         * scan type. - If the source is interlaced, the output will be interlaced with the same polarity as the source
         * (it will follow the source). The output could therefore be a mix of "top field first" and
         * "bottom field first". - If the source is progressive, the output will be interlaced with "top field first" or
         * "bottom field first" polarity, depending on which of the Follow options you chose.
         * 
         * @param interlaceMode
         *        Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First
         *        (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output
         *        having the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and
         *        Follow, Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore,
         *        behavior depends on the input scan type. - If the source is interlaced, the output will be interlaced
         *        with the same polarity as the source (it will follow the source). The output could therefore be a mix
         *        of "top field first" and "bottom field first". - If the source is progressive, the output will be
         *        interlaced with "top field first" or "bottom field first" polarity, depending on which of the Follow
         *        options you chose.
         * @see Mpeg2InterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2InterlaceMode
         */
        Builder interlaceMode(String interlaceMode);

        /**
         * Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD)
         * and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field
         * polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom
         * (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior depends on the input
         * scan type. - If the source is interlaced, the output will be interlaced with the same polarity as the source
         * (it will follow the source). The output could therefore be a mix of "top field first" and
         * "bottom field first". - If the source is progressive, the output will be interlaced with "top field first" or
         * "bottom field first" polarity, depending on which of the Follow options you chose.
         * 
         * @param interlaceMode
         *        Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First
         *        (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output
         *        having the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and
         *        Follow, Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore,
         *        behavior depends on the input scan type. - If the source is interlaced, the output will be interlaced
         *        with the same polarity as the source (it will follow the source). The output could therefore be a mix
         *        of "top field first" and "bottom field first". - If the source is progressive, the output will be
         *        interlaced with "top field first" or "bottom field first" polarity, depending on which of the Follow
         *        options you chose.
         * @see Mpeg2InterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2InterlaceMode
         */
        Builder interlaceMode(Mpeg2InterlaceMode interlaceMode);

        /**
         * Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC coefficients.
         * If you choose the value auto, the service will automatically select the precision based on the per-frame
         * compression ratio.
         * 
         * @param intraDcPrecision
         *        Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC
         *        coefficients. If you choose the value auto, the service will automatically select the precision based
         *        on the per-frame compression ratio.
         * @see Mpeg2IntraDcPrecision
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2IntraDcPrecision
         */
        Builder intraDcPrecision(String intraDcPrecision);

        /**
         * Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC coefficients.
         * If you choose the value auto, the service will automatically select the precision based on the per-frame
         * compression ratio.
         * 
         * @param intraDcPrecision
         *        Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC
         *        coefficients. If you choose the value auto, the service will automatically select the precision based
         *        on the per-frame compression ratio.
         * @see Mpeg2IntraDcPrecision
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2IntraDcPrecision
         */
        Builder intraDcPrecision(Mpeg2IntraDcPrecision intraDcPrecision);

        /**
         * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000.
         * 
         * @param maxBitrate
         *        Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a
         * scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to
         * the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal
         * cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note:
         * Maximum GOP stretch = GOP size + Min-I-interval - 1
         * 
         * @param minIInterval
         *        Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change
         *        Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is
         *        shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well
         *        as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when
         *        Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minIInterval(Integer minIInterval);

        /**
         * Number of B-frames between reference frames.
         * 
         * @param numberBFramesBetweenReferenceFrames
         *        Number of B-frames between reference frames.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames);

        /**
         * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         * behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To use
         * a different PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other than Follow
         * source. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and
         * parDenominator settings.
         * 
         * @param parControl
         *        Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         *        behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output.
         *        To use a different PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other
         *        than Follow source. When you choose SPECIFIED for this setting, you must also specify values for the
         *        parNumerator and parDenominator settings.
         * @see Mpeg2ParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2ParControl
         */
        Builder parControl(String parControl);

        /**
         * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         * behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To use
         * a different PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other than Follow
         * source. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and
         * parDenominator settings.
         * 
         * @param parControl
         *        Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         *        behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output.
         *        To use a different PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other
         *        than Follow source. When you choose SPECIFIED for this setting, you must also specify values for the
         *        parNumerator and parDenominator settings.
         * @see Mpeg2ParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2ParControl
         */
        Builder parControl(Mpeg2ParControl parControl);

        /**
         * Pixel Aspect Ratio denominator.
         * 
         * @param parDenominator
         *        Pixel Aspect Ratio denominator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parDenominator(Integer parDenominator);

        /**
         * Pixel Aspect Ratio numerator.
         * 
         * @param parNumerator
         *        Pixel Aspect Ratio numerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parNumerator(Integer parNumerator);

        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed
         * for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         * 
         * @param qualityTuningLevel
         *        Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
         *        speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         * @see Mpeg2QualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2QualityTuningLevel
         */
        Builder qualityTuningLevel(String qualityTuningLevel);

        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed
         * for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         * 
         * @param qualityTuningLevel
         *        Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
         *        speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         * @see Mpeg2QualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2QualityTuningLevel
         */
        Builder qualityTuningLevel(Mpeg2QualityTuningLevel qualityTuningLevel);

        /**
         * Use Rate control mode (Mpeg2RateControlMode) to specifiy whether the bitrate is variable (vbr) or constant
         * (cbr).
         * 
         * @param rateControlMode
         *        Use Rate control mode (Mpeg2RateControlMode) to specifiy whether the bitrate is variable (vbr) or
         *        constant (cbr).
         * @see Mpeg2RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2RateControlMode
         */
        Builder rateControlMode(String rateControlMode);

        /**
         * Use Rate control mode (Mpeg2RateControlMode) to specifiy whether the bitrate is variable (vbr) or constant
         * (cbr).
         * 
         * @param rateControlMode
         *        Use Rate control mode (Mpeg2RateControlMode) to specifiy whether the bitrate is variable (vbr) or
         *        constant (cbr).
         * @see Mpeg2RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2RateControlMode
         */
        Builder rateControlMode(Mpeg2RateControlMode rateControlMode);

        /**
         * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
         * video quality and is enabled by default.
         * 
         * @param sceneChangeDetect
         *        Enable this setting to insert I-frames at scene changes that the service automatically detects. This
         *        improves video quality and is enabled by default.
         * @see Mpeg2SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2SceneChangeDetect
         */
        Builder sceneChangeDetect(String sceneChangeDetect);

        /**
         * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
         * video quality and is enabled by default.
         * 
         * @param sceneChangeDetect
         *        Enable this setting to insert I-frames at scene changes that the service automatically detects. This
         *        improves video quality and is enabled by default.
         * @see Mpeg2SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2SceneChangeDetect
         */
        Builder sceneChangeDetect(Mpeg2SceneChangeDetect sceneChangeDetect);

        /**
         * Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up
         * correspondingly.
         * 
         * @param slowPal
         *        Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped
         *        up correspondingly.
         * @see Mpeg2SlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2SlowPal
         */
        Builder slowPal(String slowPal);

        /**
         * Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up
         * correspondingly.
         * 
         * @param slowPal
         *        Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped
         *        up correspondingly.
         * @see Mpeg2SlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2SlowPal
         */
        Builder slowPal(Mpeg2SlowPal slowPal);

        /**
         * Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.
         * 
         * @param softness
         *        Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softness(Integer softness);

        /**
         * Adjust quantization within each frame based on spatial variation of content complexity.
         * 
         * @param spatialAdaptiveQuantization
         *        Adjust quantization within each frame based on spatial variation of content complexity.
         * @see Mpeg2SpatialAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2SpatialAdaptiveQuantization
         */
        Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization);

        /**
         * Adjust quantization within each frame based on spatial variation of content complexity.
         * 
         * @param spatialAdaptiveQuantization
         *        Adjust quantization within each frame based on spatial variation of content complexity.
         * @see Mpeg2SpatialAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2SpatialAdaptiveQuantization
         */
        Builder spatialAdaptiveQuantization(Mpeg2SpatialAdaptiveQuantization spatialAdaptiveQuantization);

        /**
         * Produces a Type D-10 compatible bitstream (SMPTE 356M-2001).
         * 
         * @param syntax
         *        Produces a Type D-10 compatible bitstream (SMPTE 356M-2001).
         * @see Mpeg2Syntax
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2Syntax
         */
        Builder syntax(String syntax);

        /**
         * Produces a Type D-10 compatible bitstream (SMPTE 356M-2001).
         * 
         * @param syntax
         *        Produces a Type D-10 compatible bitstream (SMPTE 356M-2001).
         * @see Mpeg2Syntax
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2Syntax
         */
        Builder syntax(Mpeg2Syntax syntax);

        /**
         * Only use Telecine (Mpeg2Telecine) when you set Framerate (Framerate) to 29.970. Set Telecine (Mpeg2Telecine)
         * to Hard (hard) to produce a 29.97i output from a 23.976 input. Set it to Soft (soft) to produce 23.976 output
         * and leave converstion to the player.
         * 
         * @param telecine
         *        Only use Telecine (Mpeg2Telecine) when you set Framerate (Framerate) to 29.970. Set Telecine
         *        (Mpeg2Telecine) to Hard (hard) to produce a 29.97i output from a 23.976 input. Set it to Soft (soft)
         *        to produce 23.976 output and leave converstion to the player.
         * @see Mpeg2Telecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2Telecine
         */
        Builder telecine(String telecine);

        /**
         * Only use Telecine (Mpeg2Telecine) when you set Framerate (Framerate) to 29.970. Set Telecine (Mpeg2Telecine)
         * to Hard (hard) to produce a 29.97i output from a 23.976 input. Set it to Soft (soft) to produce 23.976 output
         * and leave converstion to the player.
         * 
         * @param telecine
         *        Only use Telecine (Mpeg2Telecine) when you set Framerate (Framerate) to 29.970. Set Telecine
         *        (Mpeg2Telecine) to Hard (hard) to produce a 29.97i output from a 23.976 input. Set it to Soft (soft)
         *        to produce 23.976 output and leave converstion to the player.
         * @see Mpeg2Telecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2Telecine
         */
        Builder telecine(Mpeg2Telecine telecine);

        /**
         * Adjust quantization within each frame based on temporal variation of content complexity.
         * 
         * @param temporalAdaptiveQuantization
         *        Adjust quantization within each frame based on temporal variation of content complexity.
         * @see Mpeg2TemporalAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2TemporalAdaptiveQuantization
         */
        Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization);

        /**
         * Adjust quantization within each frame based on temporal variation of content complexity.
         * 
         * @param temporalAdaptiveQuantization
         *        Adjust quantization within each frame based on temporal variation of content complexity.
         * @see Mpeg2TemporalAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2TemporalAdaptiveQuantization
         */
        Builder temporalAdaptiveQuantization(Mpeg2TemporalAdaptiveQuantization temporalAdaptiveQuantization);
    }

    static final class BuilderImpl implements Builder {
        private String adaptiveQuantization;

        private Integer bitrate;

        private String codecLevel;

        private String codecProfile;

        private String dynamicSubGop;

        private String framerateControl;

        private String framerateConversionAlgorithm;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private Integer gopClosedCadence;

        private Double gopSize;

        private String gopSizeUnits;

        private Integer hrdBufferInitialFillPercentage;

        private Integer hrdBufferSize;

        private String interlaceMode;

        private String intraDcPrecision;

        private Integer maxBitrate;

        private Integer minIInterval;

        private Integer numberBFramesBetweenReferenceFrames;

        private String parControl;

        private Integer parDenominator;

        private Integer parNumerator;

        private String qualityTuningLevel;

        private String rateControlMode;

        private String sceneChangeDetect;

        private String slowPal;

        private Integer softness;

        private String spatialAdaptiveQuantization;

        private String syntax;

        private String telecine;

        private String temporalAdaptiveQuantization;

        private BuilderImpl() {
        }

        private BuilderImpl(Mpeg2Settings model) {
            adaptiveQuantization(model.adaptiveQuantization);
            bitrate(model.bitrate);
            codecLevel(model.codecLevel);
            codecProfile(model.codecProfile);
            dynamicSubGop(model.dynamicSubGop);
            framerateControl(model.framerateControl);
            framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            gopClosedCadence(model.gopClosedCadence);
            gopSize(model.gopSize);
            gopSizeUnits(model.gopSizeUnits);
            hrdBufferInitialFillPercentage(model.hrdBufferInitialFillPercentage);
            hrdBufferSize(model.hrdBufferSize);
            interlaceMode(model.interlaceMode);
            intraDcPrecision(model.intraDcPrecision);
            maxBitrate(model.maxBitrate);
            minIInterval(model.minIInterval);
            numberBFramesBetweenReferenceFrames(model.numberBFramesBetweenReferenceFrames);
            parControl(model.parControl);
            parDenominator(model.parDenominator);
            parNumerator(model.parNumerator);
            qualityTuningLevel(model.qualityTuningLevel);
            rateControlMode(model.rateControlMode);
            sceneChangeDetect(model.sceneChangeDetect);
            slowPal(model.slowPal);
            softness(model.softness);
            spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
            syntax(model.syntax);
            telecine(model.telecine);
            temporalAdaptiveQuantization(model.temporalAdaptiveQuantization);
        }

        public final String getAdaptiveQuantization() {
            return adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(Mpeg2AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodecLevel() {
            return codecLevel;
        }

        @Override
        public final Builder codecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
            return this;
        }

        @Override
        public final Builder codecLevel(Mpeg2CodecLevel codecLevel) {
            this.codecLevel(codecLevel == null ? null : codecLevel.toString());
            return this;
        }

        public final void setCodecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
        }

        public final String getCodecProfile() {
            return codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(Mpeg2CodecProfile codecProfile) {
            this.codecProfile(codecProfile == null ? null : codecProfile.toString());
            return this;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        public final String getDynamicSubGop() {
            return dynamicSubGop;
        }

        @Override
        public final Builder dynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
            return this;
        }

        @Override
        public final Builder dynamicSubGop(Mpeg2DynamicSubGop dynamicSubGop) {
            this.dynamicSubGop(dynamicSubGop == null ? null : dynamicSubGop.toString());
            return this;
        }

        public final void setDynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
        }

        public final String getFramerateControl() {
            return framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(Mpeg2FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(Mpeg2FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm
                    .toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final Integer getGopClosedCadence() {
            return gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        public final Double getGopSize() {
            return gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        public final String getGopSizeUnits() {
            return gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(Mpeg2GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        public final Integer getHrdBufferInitialFillPercentage() {
            return hrdBufferInitialFillPercentage;
        }

        @Override
        public final Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
            return this;
        }

        public final void setHrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
        }

        public final Integer getHrdBufferSize() {
            return hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        public final String getInterlaceMode() {
            return interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(Mpeg2InterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        public final String getIntraDcPrecision() {
            return intraDcPrecision;
        }

        @Override
        public final Builder intraDcPrecision(String intraDcPrecision) {
            this.intraDcPrecision = intraDcPrecision;
            return this;
        }

        @Override
        public final Builder intraDcPrecision(Mpeg2IntraDcPrecision intraDcPrecision) {
            this.intraDcPrecision(intraDcPrecision == null ? null : intraDcPrecision.toString());
            return this;
        }

        public final void setIntraDcPrecision(String intraDcPrecision) {
            this.intraDcPrecision = intraDcPrecision;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMinIInterval() {
            return minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        public final Integer getNumberBFramesBetweenReferenceFrames() {
            return numberBFramesBetweenReferenceFrames;
        }

        @Override
        public final Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
            return this;
        }

        public final void setNumberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
        }

        public final String getParControl() {
            return parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(Mpeg2ParControl parControl) {
            this.parControl(parControl == null ? null : parControl.toString());
            return this;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        public final Integer getParDenominator() {
            return parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        public final Integer getParNumerator() {
            return parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        public final String getQualityTuningLevel() {
            return qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(Mpeg2QualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel == null ? null : qualityTuningLevel.toString());
            return this;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        public final String getRateControlMode() {
            return rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(Mpeg2RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final String getSceneChangeDetect() {
            return sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(Mpeg2SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect == null ? null : sceneChangeDetect.toString());
            return this;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        public final String getSlowPal() {
            return slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(Mpeg2SlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        public final Integer getSoftness() {
            return softness;
        }

        @Override
        public final Builder softness(Integer softness) {
            this.softness = softness;
            return this;
        }

        public final void setSoftness(Integer softness) {
            this.softness = softness;
        }

        public final String getSpatialAdaptiveQuantization() {
            return spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(Mpeg2SpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization == null ? null : spatialAdaptiveQuantization.toString());
            return this;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        public final String getSyntax() {
            return syntax;
        }

        @Override
        public final Builder syntax(String syntax) {
            this.syntax = syntax;
            return this;
        }

        @Override
        public final Builder syntax(Mpeg2Syntax syntax) {
            this.syntax(syntax == null ? null : syntax.toString());
            return this;
        }

        public final void setSyntax(String syntax) {
            this.syntax = syntax;
        }

        public final String getTelecine() {
            return telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(Mpeg2Telecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        public final String getTemporalAdaptiveQuantization() {
            return temporalAdaptiveQuantization;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(Mpeg2TemporalAdaptiveQuantization temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization(temporalAdaptiveQuantization == null ? null : temporalAdaptiveQuantization
                    .toString());
            return this;
        }

        public final void setTemporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
        }

        @Override
        public Mpeg2Settings build() {
            return new Mpeg2Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
