/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings that specify how your still graphic overlay appears.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsertableImage implements SdkPojo, Serializable, ToCopyableBuilder<InsertableImage.Builder, InsertableImage> {
    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InsertableImage::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<Integer> FADE_IN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InsertableImage::fadeIn)).setter(setter(Builder::fadeIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fadeIn").build()).build();

    private static final SdkField<Integer> FADE_OUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InsertableImage::fadeOut)).setter(setter(Builder::fadeOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fadeOut").build()).build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InsertableImage::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final SdkField<String> IMAGE_INSERTER_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InsertableImage::imageInserterInput)).setter(setter(Builder::imageInserterInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageInserterInput").build())
            .build();

    private static final SdkField<Integer> IMAGEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InsertableImage::imageX)).setter(setter(Builder::imageX))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageX").build()).build();

    private static final SdkField<Integer> IMAGEY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InsertableImage::imageY)).setter(setter(Builder::imageY))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageY").build()).build();

    private static final SdkField<Integer> LAYER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InsertableImage::layer)).setter(setter(Builder::layer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layer").build()).build();

    private static final SdkField<Integer> OPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InsertableImage::opacity)).setter(setter(Builder::opacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("opacity").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InsertableImage::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InsertableImage::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD, FADE_IN_FIELD,
            FADE_OUT_FIELD, HEIGHT_FIELD, IMAGE_INSERTER_INPUT_FIELD, IMAGEX_FIELD, IMAGEY_FIELD, LAYER_FIELD, OPACITY_FIELD,
            START_TIME_FIELD, WIDTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer duration;

    private final Integer fadeIn;

    private final Integer fadeOut;

    private final Integer height;

    private final String imageInserterInput;

    private final Integer imageX;

    private final Integer imageY;

    private final Integer layer;

    private final Integer opacity;

    private final String startTime;

    private final Integer width;

    private InsertableImage(BuilderImpl builder) {
        this.duration = builder.duration;
        this.fadeIn = builder.fadeIn;
        this.fadeOut = builder.fadeOut;
        this.height = builder.height;
        this.imageInserterInput = builder.imageInserterInput;
        this.imageX = builder.imageX;
        this.imageY = builder.imageY;
        this.layer = builder.layer;
        this.opacity = builder.opacity;
        this.startTime = builder.startTime;
        this.width = builder.width;
    }

    /**
     * Specify the time, in milliseconds, for the image to remain on the output video. This duration includes fade-in
     * time but not fade-out time.
     * 
     * @return Specify the time, in milliseconds, for the image to remain on the output video. This duration includes
     *         fade-in time but not fade-out time.
     */
    public Integer duration() {
        return duration;
    }

    /**
     * Specify the length of time, in milliseconds, between the Start time that you specify for the image insertion and
     * the time that the image appears at full opacity. Full opacity is the level that you specify for the opacity
     * setting. If you don't specify a value for Fade-in, the image will appear abruptly at the overlay start time.
     * 
     * @return Specify the length of time, in milliseconds, between the Start time that you specify for the image
     *         insertion and the time that the image appears at full opacity. Full opacity is the level that you specify
     *         for the opacity setting. If you don't specify a value for Fade-in, the image will appear abruptly at the
     *         overlay start time.
     */
    public Integer fadeIn() {
        return fadeIn;
    }

    /**
     * Specify the length of time, in milliseconds, between the end of the time that you have specified for the image
     * overlay Duration and when the overlaid image has faded to total transparency. If you don't specify a value for
     * Fade-out, the image will disappear abruptly at the end of the inserted image duration.
     * 
     * @return Specify the length of time, in milliseconds, between the end of the time that you have specified for the
     *         image overlay Duration and when the overlaid image has faded to total transparency. If you don't specify
     *         a value for Fade-out, the image will disappear abruptly at the end of the inserted image duration.
     */
    public Integer fadeOut() {
        return fadeOut;
    }

    /**
     * Specify the height of the inserted image in pixels. If you specify a value that's larger than the video
     * resolution height, the service will crop your overlaid image to fit. To use the native height of the image, keep
     * this setting blank.
     * 
     * @return Specify the height of the inserted image in pixels. If you specify a value that's larger than the video
     *         resolution height, the service will crop your overlaid image to fit. To use the native height of the
     *         image, keep this setting blank.
     */
    public Integer height() {
        return height;
    }

    /**
     * Specify the HTTP, HTTPS, or Amazon S3 location of the image that you want to overlay on the video. Use a PNG or
     * TGA file.
     * 
     * @return Specify the HTTP, HTTPS, or Amazon S3 location of the image that you want to overlay on the video. Use a
     *         PNG or TGA file.
     */
    public String imageInserterInput() {
        return imageInserterInput;
    }

    /**
     * Specify the distance, in pixels, between the inserted image and the left edge of the video frame. Required for
     * any image overlay that you specify.
     * 
     * @return Specify the distance, in pixels, between the inserted image and the left edge of the video frame.
     *         Required for any image overlay that you specify.
     */
    public Integer imageX() {
        return imageX;
    }

    /**
     * Specify the distance, in pixels, between the overlaid image and the top edge of the video frame. Required for any
     * image overlay that you specify.
     * 
     * @return Specify the distance, in pixels, between the overlaid image and the top edge of the video frame. Required
     *         for any image overlay that you specify.
     */
    public Integer imageY() {
        return imageY;
    }

    /**
     * Specify how overlapping inserted images appear. Images with higher values for Layer appear on top of images with
     * lower values for Layer.
     * 
     * @return Specify how overlapping inserted images appear. Images with higher values for Layer appear on top of
     *         images with lower values for Layer.
     */
    public Integer layer() {
        return layer;
    }

    /**
     * Use Opacity (Opacity) to specify how much of the underlying video shows through the inserted image. 0 is
     * transparent and 100 is fully opaque. Default is 50.
     * 
     * @return Use Opacity (Opacity) to specify how much of the underlying video shows through the inserted image. 0 is
     *         transparent and 100 is fully opaque. Default is 50.
     */
    public Integer opacity() {
        return opacity;
    }

    /**
     * Specify the timecode of the frame that you want the overlay to first appear on. This must be in timecode
     * (HH:MM:SS:FF or HH:MM:SS;FF) format. Remember to take into account your timecode source settings.
     * 
     * @return Specify the timecode of the frame that you want the overlay to first appear on. This must be in timecode
     *         (HH:MM:SS:FF or HH:MM:SS;FF) format. Remember to take into account your timecode source settings.
     */
    public String startTime() {
        return startTime;
    }

    /**
     * Specify the width of the inserted image in pixels. If you specify a value that's larger than the video resolution
     * width, the service will crop your overlaid image to fit. To use the native width of the image, keep this setting
     * blank.
     * 
     * @return Specify the width of the inserted image in pixels. If you specify a value that's larger than the video
     *         resolution width, the service will crop your overlaid image to fit. To use the native width of the image,
     *         keep this setting blank.
     */
    public Integer width() {
        return width;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(fadeIn());
        hashCode = 31 * hashCode + Objects.hashCode(fadeOut());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(imageInserterInput());
        hashCode = 31 * hashCode + Objects.hashCode(imageX());
        hashCode = 31 * hashCode + Objects.hashCode(imageY());
        hashCode = 31 * hashCode + Objects.hashCode(layer());
        hashCode = 31 * hashCode + Objects.hashCode(opacity());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsertableImage)) {
            return false;
        }
        InsertableImage other = (InsertableImage) obj;
        return Objects.equals(duration(), other.duration()) && Objects.equals(fadeIn(), other.fadeIn())
                && Objects.equals(fadeOut(), other.fadeOut()) && Objects.equals(height(), other.height())
                && Objects.equals(imageInserterInput(), other.imageInserterInput()) && Objects.equals(imageX(), other.imageX())
                && Objects.equals(imageY(), other.imageY()) && Objects.equals(layer(), other.layer())
                && Objects.equals(opacity(), other.opacity()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(width(), other.width());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InsertableImage").add("Duration", duration()).add("FadeIn", fadeIn()).add("FadeOut", fadeOut())
                .add("Height", height()).add("ImageInserterInput", imageInserterInput()).add("ImageX", imageX())
                .add("ImageY", imageY()).add("Layer", layer()).add("Opacity", opacity()).add("StartTime", startTime())
                .add("Width", width()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "FadeIn":
            return Optional.ofNullable(clazz.cast(fadeIn()));
        case "FadeOut":
            return Optional.ofNullable(clazz.cast(fadeOut()));
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "ImageInserterInput":
            return Optional.ofNullable(clazz.cast(imageInserterInput()));
        case "ImageX":
            return Optional.ofNullable(clazz.cast(imageX()));
        case "ImageY":
            return Optional.ofNullable(clazz.cast(imageY()));
        case "Layer":
            return Optional.ofNullable(clazz.cast(layer()));
        case "Opacity":
            return Optional.ofNullable(clazz.cast(opacity()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsertableImage, T> g) {
        return obj -> g.apply((InsertableImage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsertableImage> {
        /**
         * Specify the time, in milliseconds, for the image to remain on the output video. This duration includes
         * fade-in time but not fade-out time.
         * 
         * @param duration
         *        Specify the time, in milliseconds, for the image to remain on the output video. This duration includes
         *        fade-in time but not fade-out time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * Specify the length of time, in milliseconds, between the Start time that you specify for the image insertion
         * and the time that the image appears at full opacity. Full opacity is the level that you specify for the
         * opacity setting. If you don't specify a value for Fade-in, the image will appear abruptly at the overlay
         * start time.
         * 
         * @param fadeIn
         *        Specify the length of time, in milliseconds, between the Start time that you specify for the image
         *        insertion and the time that the image appears at full opacity. Full opacity is the level that you
         *        specify for the opacity setting. If you don't specify a value for Fade-in, the image will appear
         *        abruptly at the overlay start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fadeIn(Integer fadeIn);

        /**
         * Specify the length of time, in milliseconds, between the end of the time that you have specified for the
         * image overlay Duration and when the overlaid image has faded to total transparency. If you don't specify a
         * value for Fade-out, the image will disappear abruptly at the end of the inserted image duration.
         * 
         * @param fadeOut
         *        Specify the length of time, in milliseconds, between the end of the time that you have specified for
         *        the image overlay Duration and when the overlaid image has faded to total transparency. If you don't
         *        specify a value for Fade-out, the image will disappear abruptly at the end of the inserted image
         *        duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fadeOut(Integer fadeOut);

        /**
         * Specify the height of the inserted image in pixels. If you specify a value that's larger than the video
         * resolution height, the service will crop your overlaid image to fit. To use the native height of the image,
         * keep this setting blank.
         * 
         * @param height
         *        Specify the height of the inserted image in pixels. If you specify a value that's larger than the
         *        video resolution height, the service will crop your overlaid image to fit. To use the native height of
         *        the image, keep this setting blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * Specify the HTTP, HTTPS, or Amazon S3 location of the image that you want to overlay on the video. Use a PNG
         * or TGA file.
         * 
         * @param imageInserterInput
         *        Specify the HTTP, HTTPS, or Amazon S3 location of the image that you want to overlay on the video. Use
         *        a PNG or TGA file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageInserterInput(String imageInserterInput);

        /**
         * Specify the distance, in pixels, between the inserted image and the left edge of the video frame. Required
         * for any image overlay that you specify.
         * 
         * @param imageX
         *        Specify the distance, in pixels, between the inserted image and the left edge of the video frame.
         *        Required for any image overlay that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageX(Integer imageX);

        /**
         * Specify the distance, in pixels, between the overlaid image and the top edge of the video frame. Required for
         * any image overlay that you specify.
         * 
         * @param imageY
         *        Specify the distance, in pixels, between the overlaid image and the top edge of the video frame.
         *        Required for any image overlay that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageY(Integer imageY);

        /**
         * Specify how overlapping inserted images appear. Images with higher values for Layer appear on top of images
         * with lower values for Layer.
         * 
         * @param layer
         *        Specify how overlapping inserted images appear. Images with higher values for Layer appear on top of
         *        images with lower values for Layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layer(Integer layer);

        /**
         * Use Opacity (Opacity) to specify how much of the underlying video shows through the inserted image. 0 is
         * transparent and 100 is fully opaque. Default is 50.
         * 
         * @param opacity
         *        Use Opacity (Opacity) to specify how much of the underlying video shows through the inserted image. 0
         *        is transparent and 100 is fully opaque. Default is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opacity(Integer opacity);

        /**
         * Specify the timecode of the frame that you want the overlay to first appear on. This must be in timecode
         * (HH:MM:SS:FF or HH:MM:SS;FF) format. Remember to take into account your timecode source settings.
         * 
         * @param startTime
         *        Specify the timecode of the frame that you want the overlay to first appear on. This must be in
         *        timecode (HH:MM:SS:FF or HH:MM:SS;FF) format. Remember to take into account your timecode source
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * Specify the width of the inserted image in pixels. If you specify a value that's larger than the video
         * resolution width, the service will crop your overlaid image to fit. To use the native width of the image,
         * keep this setting blank.
         * 
         * @param width
         *        Specify the width of the inserted image in pixels. If you specify a value that's larger than the video
         *        resolution width, the service will crop your overlaid image to fit. To use the native width of the
         *        image, keep this setting blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);
    }

    static final class BuilderImpl implements Builder {
        private Integer duration;

        private Integer fadeIn;

        private Integer fadeOut;

        private Integer height;

        private String imageInserterInput;

        private Integer imageX;

        private Integer imageY;

        private Integer layer;

        private Integer opacity;

        private String startTime;

        private Integer width;

        private BuilderImpl() {
        }

        private BuilderImpl(InsertableImage model) {
            duration(model.duration);
            fadeIn(model.fadeIn);
            fadeOut(model.fadeOut);
            height(model.height);
            imageInserterInput(model.imageInserterInput);
            imageX(model.imageX);
            imageY(model.imageY);
            layer(model.layer);
            opacity(model.opacity);
            startTime(model.startTime);
            width(model.width);
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getFadeIn() {
            return fadeIn;
        }

        @Override
        public final Builder fadeIn(Integer fadeIn) {
            this.fadeIn = fadeIn;
            return this;
        }

        public final void setFadeIn(Integer fadeIn) {
            this.fadeIn = fadeIn;
        }

        public final Integer getFadeOut() {
            return fadeOut;
        }

        @Override
        public final Builder fadeOut(Integer fadeOut) {
            this.fadeOut = fadeOut;
            return this;
        }

        public final void setFadeOut(Integer fadeOut) {
            this.fadeOut = fadeOut;
        }

        public final Integer getHeight() {
            return height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        public final String getImageInserterInput() {
            return imageInserterInput;
        }

        @Override
        public final Builder imageInserterInput(String imageInserterInput) {
            this.imageInserterInput = imageInserterInput;
            return this;
        }

        public final void setImageInserterInput(String imageInserterInput) {
            this.imageInserterInput = imageInserterInput;
        }

        public final Integer getImageX() {
            return imageX;
        }

        @Override
        public final Builder imageX(Integer imageX) {
            this.imageX = imageX;
            return this;
        }

        public final void setImageX(Integer imageX) {
            this.imageX = imageX;
        }

        public final Integer getImageY() {
            return imageY;
        }

        @Override
        public final Builder imageY(Integer imageY) {
            this.imageY = imageY;
            return this;
        }

        public final void setImageY(Integer imageY) {
            this.imageY = imageY;
        }

        public final Integer getLayer() {
            return layer;
        }

        @Override
        public final Builder layer(Integer layer) {
            this.layer = layer;
            return this;
        }

        public final void setLayer(Integer layer) {
            this.layer = layer;
        }

        public final Integer getOpacity() {
            return opacity;
        }

        @Override
        public final Builder opacity(Integer opacity) {
            this.opacity = opacity;
            return this;
        }

        public final void setOpacity(Integer opacity) {
            this.opacity = opacity;
        }

        public final String getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public final Integer getWidth() {
            return width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public InsertableImage build() {
            return new InsertableImage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
