/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at least
 * one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you specify.
 * Make sure to specify the languages in the order in which they appear in the original source (if the source is
 * embedded format) or the order of the caption selectors (if the source is other than embedded). Otherwise, languages
 * in the manifest will not match up properly with the output captions. None: Include CLOSED-CAPTIONS=NONE line in the
 * manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.
 */
@Generated("software.amazon.awssdk:codegen")
public enum HlsCaptionLanguageSetting {
    INSERT("INSERT"),

    OMIT("OMIT"),

    NONE("NONE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HlsCaptionLanguageSetting(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return HlsCaptionLanguageSetting corresponding to the value
     */
    public static HlsCaptionLanguageSetting fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HlsCaptionLanguageSetting.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link HlsCaptionLanguageSetting}s
     */
    public static Set<HlsCaptionLanguageSetting> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
