/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use these settings to specify static color calibration metadata, as defined by SMPTE ST 2086. These values don't
 * affect the pixel values that are encoded in the video stream. They are intended to help the downstream video player
 * display content in a way that reflects the intentions of the the content creator.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Hdr10Metadata implements SdkPojo, Serializable, ToCopyableBuilder<Hdr10Metadata.Builder, Hdr10Metadata> {
    private static final SdkField<Integer> BLUE_PRIMARYX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Hdr10Metadata::bluePrimaryX)).setter(setter(Builder::bluePrimaryX))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bluePrimaryX").build()).build();

    private static final SdkField<Integer> BLUE_PRIMARYY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Hdr10Metadata::bluePrimaryY)).setter(setter(Builder::bluePrimaryY))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bluePrimaryY").build()).build();

    private static final SdkField<Integer> GREEN_PRIMARYX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Hdr10Metadata::greenPrimaryX)).setter(setter(Builder::greenPrimaryX))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greenPrimaryX").build()).build();

    private static final SdkField<Integer> GREEN_PRIMARYY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Hdr10Metadata::greenPrimaryY)).setter(setter(Builder::greenPrimaryY))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greenPrimaryY").build()).build();

    private static final SdkField<Integer> MAX_CONTENT_LIGHT_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Hdr10Metadata::maxContentLightLevel)).setter(setter(Builder::maxContentLightLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxContentLightLevel").build())
            .build();

    private static final SdkField<Integer> MAX_FRAME_AVERAGE_LIGHT_LEVEL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(Hdr10Metadata::maxFrameAverageLightLevel))
            .setter(setter(Builder::maxFrameAverageLightLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFrameAverageLightLevel").build())
            .build();

    private static final SdkField<Integer> MAX_LUMINANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Hdr10Metadata::maxLuminance)).setter(setter(Builder::maxLuminance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLuminance").build()).build();

    private static final SdkField<Integer> MIN_LUMINANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Hdr10Metadata::minLuminance)).setter(setter(Builder::minLuminance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minLuminance").build()).build();

    private static final SdkField<Integer> RED_PRIMARYX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Hdr10Metadata::redPrimaryX)).setter(setter(Builder::redPrimaryX))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redPrimaryX").build()).build();

    private static final SdkField<Integer> RED_PRIMARYY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Hdr10Metadata::redPrimaryY)).setter(setter(Builder::redPrimaryY))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redPrimaryY").build()).build();

    private static final SdkField<Integer> WHITE_POINTX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Hdr10Metadata::whitePointX)).setter(setter(Builder::whitePointX))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitePointX").build()).build();

    private static final SdkField<Integer> WHITE_POINTY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Hdr10Metadata::whitePointY)).setter(setter(Builder::whitePointY))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitePointY").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUE_PRIMARYX_FIELD,
            BLUE_PRIMARYY_FIELD, GREEN_PRIMARYX_FIELD, GREEN_PRIMARYY_FIELD, MAX_CONTENT_LIGHT_LEVEL_FIELD,
            MAX_FRAME_AVERAGE_LIGHT_LEVEL_FIELD, MAX_LUMINANCE_FIELD, MIN_LUMINANCE_FIELD, RED_PRIMARYX_FIELD,
            RED_PRIMARYY_FIELD, WHITE_POINTX_FIELD, WHITE_POINTY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer bluePrimaryX;

    private final Integer bluePrimaryY;

    private final Integer greenPrimaryX;

    private final Integer greenPrimaryY;

    private final Integer maxContentLightLevel;

    private final Integer maxFrameAverageLightLevel;

    private final Integer maxLuminance;

    private final Integer minLuminance;

    private final Integer redPrimaryX;

    private final Integer redPrimaryY;

    private final Integer whitePointX;

    private final Integer whitePointY;

    private Hdr10Metadata(BuilderImpl builder) {
        this.bluePrimaryX = builder.bluePrimaryX;
        this.bluePrimaryY = builder.bluePrimaryY;
        this.greenPrimaryX = builder.greenPrimaryX;
        this.greenPrimaryY = builder.greenPrimaryY;
        this.maxContentLightLevel = builder.maxContentLightLevel;
        this.maxFrameAverageLightLevel = builder.maxFrameAverageLightLevel;
        this.maxLuminance = builder.maxLuminance;
        this.minLuminance = builder.minLuminance;
        this.redPrimaryX = builder.redPrimaryX;
        this.redPrimaryY = builder.redPrimaryY;
        this.whitePointX = builder.whitePointX;
        this.whitePointY = builder.whitePointY;
    }

    /**
     * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
     * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color
     * correction.
     * 
     * @return HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0
     *         to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not
     *         for color correction.
     */
    public Integer bluePrimaryX() {
        return bluePrimaryX;
    }

    /**
     * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
     * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color
     * correction.
     * 
     * @return HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0
     *         to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not
     *         for color correction.
     */
    public Integer bluePrimaryY() {
        return bluePrimaryY;
    }

    /**
     * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
     * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color
     * correction.
     * 
     * @return HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0
     *         to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not
     *         for color correction.
     */
    public Integer greenPrimaryX() {
        return greenPrimaryX;
    }

    /**
     * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
     * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color
     * correction.
     * 
     * @return HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0
     *         to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not
     *         for color correction.
     */
    public Integer greenPrimaryY() {
        return greenPrimaryY;
    }

    /**
     * Maximum light level among all samples in the coded video sequence, in units of candelas per square meter. This
     * setting doesn't have a default value; you must specify a value that is suitable for the content.
     * 
     * @return Maximum light level among all samples in the coded video sequence, in units of candelas per square meter.
     *         This setting doesn't have a default value; you must specify a value that is suitable for the content.
     */
    public Integer maxContentLightLevel() {
        return maxContentLightLevel;
    }

    /**
     * Maximum average light level of any frame in the coded video sequence, in units of candelas per square meter. This
     * setting doesn't have a default value; you must specify a value that is suitable for the content.
     * 
     * @return Maximum average light level of any frame in the coded video sequence, in units of candelas per square
     *         meter. This setting doesn't have a default value; you must specify a value that is suitable for the
     *         content.
     */
    public Integer maxFrameAverageLightLevel() {
        return maxFrameAverageLightLevel;
    }

    /**
     * Nominal maximum mastering display luminance in units of of 0.0001 candelas per square meter.
     * 
     * @return Nominal maximum mastering display luminance in units of of 0.0001 candelas per square meter.
     */
    public Integer maxLuminance() {
        return maxLuminance;
    }

    /**
     * Nominal minimum mastering display luminance in units of of 0.0001 candelas per square meter
     * 
     * @return Nominal minimum mastering display luminance in units of of 0.0001 candelas per square meter
     */
    public Integer minLuminance() {
        return minLuminance;
    }

    /**
     * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
     * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color
     * correction.
     * 
     * @return HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0
     *         to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not
     *         for color correction.
     */
    public Integer redPrimaryX() {
        return redPrimaryX;
    }

    /**
     * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
     * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color
     * correction.
     * 
     * @return HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0
     *         to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not
     *         for color correction.
     */
    public Integer redPrimaryY() {
        return redPrimaryY;
    }

    /**
     * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
     * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color
     * correction.
     * 
     * @return HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0
     *         to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not
     *         for color correction.
     */
    public Integer whitePointX() {
        return whitePointX;
    }

    /**
     * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
     * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color
     * correction.
     * 
     * @return HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0
     *         to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not
     *         for color correction.
     */
    public Integer whitePointY() {
        return whitePointY;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bluePrimaryX());
        hashCode = 31 * hashCode + Objects.hashCode(bluePrimaryY());
        hashCode = 31 * hashCode + Objects.hashCode(greenPrimaryX());
        hashCode = 31 * hashCode + Objects.hashCode(greenPrimaryY());
        hashCode = 31 * hashCode + Objects.hashCode(maxContentLightLevel());
        hashCode = 31 * hashCode + Objects.hashCode(maxFrameAverageLightLevel());
        hashCode = 31 * hashCode + Objects.hashCode(maxLuminance());
        hashCode = 31 * hashCode + Objects.hashCode(minLuminance());
        hashCode = 31 * hashCode + Objects.hashCode(redPrimaryX());
        hashCode = 31 * hashCode + Objects.hashCode(redPrimaryY());
        hashCode = 31 * hashCode + Objects.hashCode(whitePointX());
        hashCode = 31 * hashCode + Objects.hashCode(whitePointY());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hdr10Metadata)) {
            return false;
        }
        Hdr10Metadata other = (Hdr10Metadata) obj;
        return Objects.equals(bluePrimaryX(), other.bluePrimaryX()) && Objects.equals(bluePrimaryY(), other.bluePrimaryY())
                && Objects.equals(greenPrimaryX(), other.greenPrimaryX())
                && Objects.equals(greenPrimaryY(), other.greenPrimaryY())
                && Objects.equals(maxContentLightLevel(), other.maxContentLightLevel())
                && Objects.equals(maxFrameAverageLightLevel(), other.maxFrameAverageLightLevel())
                && Objects.equals(maxLuminance(), other.maxLuminance()) && Objects.equals(minLuminance(), other.minLuminance())
                && Objects.equals(redPrimaryX(), other.redPrimaryX()) && Objects.equals(redPrimaryY(), other.redPrimaryY())
                && Objects.equals(whitePointX(), other.whitePointX()) && Objects.equals(whitePointY(), other.whitePointY());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Hdr10Metadata").add("BluePrimaryX", bluePrimaryX()).add("BluePrimaryY", bluePrimaryY())
                .add("GreenPrimaryX", greenPrimaryX()).add("GreenPrimaryY", greenPrimaryY())
                .add("MaxContentLightLevel", maxContentLightLevel())
                .add("MaxFrameAverageLightLevel", maxFrameAverageLightLevel()).add("MaxLuminance", maxLuminance())
                .add("MinLuminance", minLuminance()).add("RedPrimaryX", redPrimaryX()).add("RedPrimaryY", redPrimaryY())
                .add("WhitePointX", whitePointX()).add("WhitePointY", whitePointY()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BluePrimaryX":
            return Optional.ofNullable(clazz.cast(bluePrimaryX()));
        case "BluePrimaryY":
            return Optional.ofNullable(clazz.cast(bluePrimaryY()));
        case "GreenPrimaryX":
            return Optional.ofNullable(clazz.cast(greenPrimaryX()));
        case "GreenPrimaryY":
            return Optional.ofNullable(clazz.cast(greenPrimaryY()));
        case "MaxContentLightLevel":
            return Optional.ofNullable(clazz.cast(maxContentLightLevel()));
        case "MaxFrameAverageLightLevel":
            return Optional.ofNullable(clazz.cast(maxFrameAverageLightLevel()));
        case "MaxLuminance":
            return Optional.ofNullable(clazz.cast(maxLuminance()));
        case "MinLuminance":
            return Optional.ofNullable(clazz.cast(minLuminance()));
        case "RedPrimaryX":
            return Optional.ofNullable(clazz.cast(redPrimaryX()));
        case "RedPrimaryY":
            return Optional.ofNullable(clazz.cast(redPrimaryY()));
        case "WhitePointX":
            return Optional.ofNullable(clazz.cast(whitePointX()));
        case "WhitePointY":
            return Optional.ofNullable(clazz.cast(whitePointY()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Hdr10Metadata, T> g) {
        return obj -> g.apply((Hdr10Metadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Hdr10Metadata> {
        /**
         * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
         * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for
         * color correction.
         * 
         * @param bluePrimaryX
         *        HDR Master Display Information must be provided by a color grader, using color grading tools. Range is
         *        0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is
         *        not for color correction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bluePrimaryX(Integer bluePrimaryX);

        /**
         * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
         * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for
         * color correction.
         * 
         * @param bluePrimaryY
         *        HDR Master Display Information must be provided by a color grader, using color grading tools. Range is
         *        0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is
         *        not for color correction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bluePrimaryY(Integer bluePrimaryY);

        /**
         * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
         * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for
         * color correction.
         * 
         * @param greenPrimaryX
         *        HDR Master Display Information must be provided by a color grader, using color grading tools. Range is
         *        0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is
         *        not for color correction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greenPrimaryX(Integer greenPrimaryX);

        /**
         * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
         * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for
         * color correction.
         * 
         * @param greenPrimaryY
         *        HDR Master Display Information must be provided by a color grader, using color grading tools. Range is
         *        0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is
         *        not for color correction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greenPrimaryY(Integer greenPrimaryY);

        /**
         * Maximum light level among all samples in the coded video sequence, in units of candelas per square meter.
         * This setting doesn't have a default value; you must specify a value that is suitable for the content.
         * 
         * @param maxContentLightLevel
         *        Maximum light level among all samples in the coded video sequence, in units of candelas per square
         *        meter. This setting doesn't have a default value; you must specify a value that is suitable for the
         *        content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxContentLightLevel(Integer maxContentLightLevel);

        /**
         * Maximum average light level of any frame in the coded video sequence, in units of candelas per square meter.
         * This setting doesn't have a default value; you must specify a value that is suitable for the content.
         * 
         * @param maxFrameAverageLightLevel
         *        Maximum average light level of any frame in the coded video sequence, in units of candelas per square
         *        meter. This setting doesn't have a default value; you must specify a value that is suitable for the
         *        content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFrameAverageLightLevel(Integer maxFrameAverageLightLevel);

        /**
         * Nominal maximum mastering display luminance in units of of 0.0001 candelas per square meter.
         * 
         * @param maxLuminance
         *        Nominal maximum mastering display luminance in units of of 0.0001 candelas per square meter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLuminance(Integer maxLuminance);

        /**
         * Nominal minimum mastering display luminance in units of of 0.0001 candelas per square meter
         * 
         * @param minLuminance
         *        Nominal minimum mastering display luminance in units of of 0.0001 candelas per square meter
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minLuminance(Integer minLuminance);

        /**
         * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
         * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for
         * color correction.
         * 
         * @param redPrimaryX
         *        HDR Master Display Information must be provided by a color grader, using color grading tools. Range is
         *        0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is
         *        not for color correction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redPrimaryX(Integer redPrimaryX);

        /**
         * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
         * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for
         * color correction.
         * 
         * @param redPrimaryY
         *        HDR Master Display Information must be provided by a color grader, using color grading tools. Range is
         *        0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is
         *        not for color correction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redPrimaryY(Integer redPrimaryY);

        /**
         * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
         * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for
         * color correction.
         * 
         * @param whitePointX
         *        HDR Master Display Information must be provided by a color grader, using color grading tools. Range is
         *        0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is
         *        not for color correction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitePointX(Integer whitePointX);

        /**
         * HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to
         * 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for
         * color correction.
         * 
         * @param whitePointY
         *        HDR Master Display Information must be provided by a color grader, using color grading tools. Range is
         *        0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is
         *        not for color correction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitePointY(Integer whitePointY);
    }

    static final class BuilderImpl implements Builder {
        private Integer bluePrimaryX;

        private Integer bluePrimaryY;

        private Integer greenPrimaryX;

        private Integer greenPrimaryY;

        private Integer maxContentLightLevel;

        private Integer maxFrameAverageLightLevel;

        private Integer maxLuminance;

        private Integer minLuminance;

        private Integer redPrimaryX;

        private Integer redPrimaryY;

        private Integer whitePointX;

        private Integer whitePointY;

        private BuilderImpl() {
        }

        private BuilderImpl(Hdr10Metadata model) {
            bluePrimaryX(model.bluePrimaryX);
            bluePrimaryY(model.bluePrimaryY);
            greenPrimaryX(model.greenPrimaryX);
            greenPrimaryY(model.greenPrimaryY);
            maxContentLightLevel(model.maxContentLightLevel);
            maxFrameAverageLightLevel(model.maxFrameAverageLightLevel);
            maxLuminance(model.maxLuminance);
            minLuminance(model.minLuminance);
            redPrimaryX(model.redPrimaryX);
            redPrimaryY(model.redPrimaryY);
            whitePointX(model.whitePointX);
            whitePointY(model.whitePointY);
        }

        public final Integer getBluePrimaryX() {
            return bluePrimaryX;
        }

        @Override
        public final Builder bluePrimaryX(Integer bluePrimaryX) {
            this.bluePrimaryX = bluePrimaryX;
            return this;
        }

        public final void setBluePrimaryX(Integer bluePrimaryX) {
            this.bluePrimaryX = bluePrimaryX;
        }

        public final Integer getBluePrimaryY() {
            return bluePrimaryY;
        }

        @Override
        public final Builder bluePrimaryY(Integer bluePrimaryY) {
            this.bluePrimaryY = bluePrimaryY;
            return this;
        }

        public final void setBluePrimaryY(Integer bluePrimaryY) {
            this.bluePrimaryY = bluePrimaryY;
        }

        public final Integer getGreenPrimaryX() {
            return greenPrimaryX;
        }

        @Override
        public final Builder greenPrimaryX(Integer greenPrimaryX) {
            this.greenPrimaryX = greenPrimaryX;
            return this;
        }

        public final void setGreenPrimaryX(Integer greenPrimaryX) {
            this.greenPrimaryX = greenPrimaryX;
        }

        public final Integer getGreenPrimaryY() {
            return greenPrimaryY;
        }

        @Override
        public final Builder greenPrimaryY(Integer greenPrimaryY) {
            this.greenPrimaryY = greenPrimaryY;
            return this;
        }

        public final void setGreenPrimaryY(Integer greenPrimaryY) {
            this.greenPrimaryY = greenPrimaryY;
        }

        public final Integer getMaxContentLightLevel() {
            return maxContentLightLevel;
        }

        @Override
        public final Builder maxContentLightLevel(Integer maxContentLightLevel) {
            this.maxContentLightLevel = maxContentLightLevel;
            return this;
        }

        public final void setMaxContentLightLevel(Integer maxContentLightLevel) {
            this.maxContentLightLevel = maxContentLightLevel;
        }

        public final Integer getMaxFrameAverageLightLevel() {
            return maxFrameAverageLightLevel;
        }

        @Override
        public final Builder maxFrameAverageLightLevel(Integer maxFrameAverageLightLevel) {
            this.maxFrameAverageLightLevel = maxFrameAverageLightLevel;
            return this;
        }

        public final void setMaxFrameAverageLightLevel(Integer maxFrameAverageLightLevel) {
            this.maxFrameAverageLightLevel = maxFrameAverageLightLevel;
        }

        public final Integer getMaxLuminance() {
            return maxLuminance;
        }

        @Override
        public final Builder maxLuminance(Integer maxLuminance) {
            this.maxLuminance = maxLuminance;
            return this;
        }

        public final void setMaxLuminance(Integer maxLuminance) {
            this.maxLuminance = maxLuminance;
        }

        public final Integer getMinLuminance() {
            return minLuminance;
        }

        @Override
        public final Builder minLuminance(Integer minLuminance) {
            this.minLuminance = minLuminance;
            return this;
        }

        public final void setMinLuminance(Integer minLuminance) {
            this.minLuminance = minLuminance;
        }

        public final Integer getRedPrimaryX() {
            return redPrimaryX;
        }

        @Override
        public final Builder redPrimaryX(Integer redPrimaryX) {
            this.redPrimaryX = redPrimaryX;
            return this;
        }

        public final void setRedPrimaryX(Integer redPrimaryX) {
            this.redPrimaryX = redPrimaryX;
        }

        public final Integer getRedPrimaryY() {
            return redPrimaryY;
        }

        @Override
        public final Builder redPrimaryY(Integer redPrimaryY) {
            this.redPrimaryY = redPrimaryY;
            return this;
        }

        public final void setRedPrimaryY(Integer redPrimaryY) {
            this.redPrimaryY = redPrimaryY;
        }

        public final Integer getWhitePointX() {
            return whitePointX;
        }

        @Override
        public final Builder whitePointX(Integer whitePointX) {
            this.whitePointX = whitePointX;
            return this;
        }

        public final void setWhitePointX(Integer whitePointX) {
            this.whitePointX = whitePointX;
        }

        public final Integer getWhitePointY() {
            return whitePointY;
        }

        @Override
        public final Builder whitePointY(Integer whitePointY) {
            this.whitePointY = whitePointY;
            return this;
        }

        public final void setWhitePointY(Integer whitePointY) {
            this.whitePointY = whitePointY;
        }

        @Override
        public Hdr10Metadata build() {
            return new Hdr10Metadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
