/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3_ATMOS.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Eac3AtmosSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<Eac3AtmosSettings.Builder, Eac3AtmosSettings> {
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Eac3AtmosSettings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> BITSTREAM_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Eac3AtmosSettings::bitstreamModeAsString)).setter(setter(Builder::bitstreamMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitstreamMode").build()).build();

    private static final SdkField<String> CODING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Eac3AtmosSettings::codingModeAsString)).setter(setter(Builder::codingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()).build();

    private static final SdkField<String> DIALOGUE_INTELLIGENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Eac3AtmosSettings::dialogueIntelligenceAsString)).setter(setter(Builder::dialogueIntelligence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogueIntelligence").build())
            .build();

    private static final SdkField<String> DYNAMIC_RANGE_COMPRESSION_LINE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Eac3AtmosSettings::dynamicRangeCompressionLineAsString))
            .setter(setter(Builder::dynamicRangeCompressionLine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeCompressionLine")
                    .build()).build();

    private static final SdkField<String> DYNAMIC_RANGE_COMPRESSION_RF_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Eac3AtmosSettings::dynamicRangeCompressionRfAsString))
            .setter(setter(Builder::dynamicRangeCompressionRf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeCompressionRf").build())
            .build();

    private static final SdkField<Double> LO_RO_CENTER_MIX_LEVEL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Eac3AtmosSettings::loRoCenterMixLevel)).setter(setter(Builder::loRoCenterMixLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loRoCenterMixLevel").build())
            .build();

    private static final SdkField<Double> LO_RO_SURROUND_MIX_LEVEL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Eac3AtmosSettings::loRoSurroundMixLevel)).setter(setter(Builder::loRoSurroundMixLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loRoSurroundMixLevel").build())
            .build();

    private static final SdkField<Double> LT_RT_CENTER_MIX_LEVEL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Eac3AtmosSettings::ltRtCenterMixLevel)).setter(setter(Builder::ltRtCenterMixLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ltRtCenterMixLevel").build())
            .build();

    private static final SdkField<Double> LT_RT_SURROUND_MIX_LEVEL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Eac3AtmosSettings::ltRtSurroundMixLevel)).setter(setter(Builder::ltRtSurroundMixLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ltRtSurroundMixLevel").build())
            .build();

    private static final SdkField<String> METERING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Eac3AtmosSettings::meteringModeAsString)).setter(setter(Builder::meteringMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meteringMode").build()).build();

    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Eac3AtmosSettings::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final SdkField<Integer> SPEECH_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Eac3AtmosSettings::speechThreshold)).setter(setter(Builder::speechThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechThreshold").build()).build();

    private static final SdkField<String> STEREO_DOWNMIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Eac3AtmosSettings::stereoDownmixAsString)).setter(setter(Builder::stereoDownmix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stereoDownmix").build()).build();

    private static final SdkField<String> SURROUND_EX_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Eac3AtmosSettings::surroundExModeAsString)).setter(setter(Builder::surroundExMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("surroundExMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD,
            BITSTREAM_MODE_FIELD, CODING_MODE_FIELD, DIALOGUE_INTELLIGENCE_FIELD, DYNAMIC_RANGE_COMPRESSION_LINE_FIELD,
            DYNAMIC_RANGE_COMPRESSION_RF_FIELD, LO_RO_CENTER_MIX_LEVEL_FIELD, LO_RO_SURROUND_MIX_LEVEL_FIELD,
            LT_RT_CENTER_MIX_LEVEL_FIELD, LT_RT_SURROUND_MIX_LEVEL_FIELD, METERING_MODE_FIELD, SAMPLE_RATE_FIELD,
            SPEECH_THRESHOLD_FIELD, STEREO_DOWNMIX_FIELD, SURROUND_EX_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer bitrate;

    private final String bitstreamMode;

    private final String codingMode;

    private final String dialogueIntelligence;

    private final String dynamicRangeCompressionLine;

    private final String dynamicRangeCompressionRf;

    private final Double loRoCenterMixLevel;

    private final Double loRoSurroundMixLevel;

    private final Double ltRtCenterMixLevel;

    private final Double ltRtSurroundMixLevel;

    private final String meteringMode;

    private final Integer sampleRate;

    private final Integer speechThreshold;

    private final String stereoDownmix;

    private final String surroundExMode;

    private Eac3AtmosSettings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.bitstreamMode = builder.bitstreamMode;
        this.codingMode = builder.codingMode;
        this.dialogueIntelligence = builder.dialogueIntelligence;
        this.dynamicRangeCompressionLine = builder.dynamicRangeCompressionLine;
        this.dynamicRangeCompressionRf = builder.dynamicRangeCompressionRf;
        this.loRoCenterMixLevel = builder.loRoCenterMixLevel;
        this.loRoSurroundMixLevel = builder.loRoSurroundMixLevel;
        this.ltRtCenterMixLevel = builder.ltRtCenterMixLevel;
        this.ltRtSurroundMixLevel = builder.ltRtSurroundMixLevel;
        this.meteringMode = builder.meteringMode;
        this.sampleRate = builder.sampleRate;
        this.speechThreshold = builder.speechThreshold;
        this.stereoDownmix = builder.stereoDownmix;
        this.surroundExMode = builder.surroundExMode;
    }

    /**
     * Specify the average bitrate in bits per second. Valid values: 384k, 448k, 640k, 768k
     * 
     * @return Specify the average bitrate in bits per second. Valid values: 384k, 448k, 640k, 768k
     */
    public Integer bitrate() {
        return bitrate;
    }

    /**
     * Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3
     * bitstream mode, see ATSC A/52-2012 (Annex E).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitstreamMode}
     * will return {@link Eac3AtmosBitstreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #bitstreamModeAsString}.
     * </p>
     * 
     * @return Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the
     *         EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).
     * @see Eac3AtmosBitstreamMode
     */
    public Eac3AtmosBitstreamMode bitstreamMode() {
        return Eac3AtmosBitstreamMode.fromValue(bitstreamMode);
    }

    /**
     * Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3
     * bitstream mode, see ATSC A/52-2012 (Annex E).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitstreamMode}
     * will return {@link Eac3AtmosBitstreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #bitstreamModeAsString}.
     * </p>
     * 
     * @return Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the
     *         EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).
     * @see Eac3AtmosBitstreamMode
     */
    public String bitstreamModeAsString() {
        return bitstreamMode;
    }

    /**
     * The coding mode for Dolby Digital Plus JOC (Atmos) is always 9.1.6 (CODING_MODE_9_1_6).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Eac3AtmosCodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codingModeAsString}.
     * </p>
     * 
     * @return The coding mode for Dolby Digital Plus JOC (Atmos) is always 9.1.6 (CODING_MODE_9_1_6).
     * @see Eac3AtmosCodingMode
     */
    public Eac3AtmosCodingMode codingMode() {
        return Eac3AtmosCodingMode.fromValue(codingMode);
    }

    /**
     * The coding mode for Dolby Digital Plus JOC (Atmos) is always 9.1.6 (CODING_MODE_9_1_6).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Eac3AtmosCodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codingModeAsString}.
     * </p>
     * 
     * @return The coding mode for Dolby Digital Plus JOC (Atmos) is always 9.1.6 (CODING_MODE_9_1_6).
     * @see Eac3AtmosCodingMode
     */
    public String codingModeAsString() {
        return codingMode;
    }

    /**
     * Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dialogueIntelligence} will return {@link Eac3AtmosDialogueIntelligence#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dialogueIntelligenceAsString}.
     * </p>
     * 
     * @return Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
     * @see Eac3AtmosDialogueIntelligence
     */
    public Eac3AtmosDialogueIntelligence dialogueIntelligence() {
        return Eac3AtmosDialogueIntelligence.fromValue(dialogueIntelligence);
    }

    /**
     * Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dialogueIntelligence} will return {@link Eac3AtmosDialogueIntelligence#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dialogueIntelligenceAsString}.
     * </p>
     * 
     * @return Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
     * @see Eac3AtmosDialogueIntelligence
     */
    public String dialogueIntelligenceAsString() {
        return dialogueIntelligence;
    }

    /**
     * Specify the absolute peak level for a signal with dynamic range compression.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionLine} will return
     * {@link Eac3AtmosDynamicRangeCompressionLine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dynamicRangeCompressionLineAsString}.
     * </p>
     * 
     * @return Specify the absolute peak level for a signal with dynamic range compression.
     * @see Eac3AtmosDynamicRangeCompressionLine
     */
    public Eac3AtmosDynamicRangeCompressionLine dynamicRangeCompressionLine() {
        return Eac3AtmosDynamicRangeCompressionLine.fromValue(dynamicRangeCompressionLine);
    }

    /**
     * Specify the absolute peak level for a signal with dynamic range compression.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionLine} will return
     * {@link Eac3AtmosDynamicRangeCompressionLine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dynamicRangeCompressionLineAsString}.
     * </p>
     * 
     * @return Specify the absolute peak level for a signal with dynamic range compression.
     * @see Eac3AtmosDynamicRangeCompressionLine
     */
    public String dynamicRangeCompressionLineAsString() {
        return dynamicRangeCompressionLine;
    }

    /**
     * Specify how the service limits the audio dynamic range when compressing the audio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionRf} will return {@link Eac3AtmosDynamicRangeCompressionRf#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dynamicRangeCompressionRfAsString}.
     * </p>
     * 
     * @return Specify how the service limits the audio dynamic range when compressing the audio.
     * @see Eac3AtmosDynamicRangeCompressionRf
     */
    public Eac3AtmosDynamicRangeCompressionRf dynamicRangeCompressionRf() {
        return Eac3AtmosDynamicRangeCompressionRf.fromValue(dynamicRangeCompressionRf);
    }

    /**
     * Specify how the service limits the audio dynamic range when compressing the audio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionRf} will return {@link Eac3AtmosDynamicRangeCompressionRf#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dynamicRangeCompressionRfAsString}.
     * </p>
     * 
     * @return Specify how the service limits the audio dynamic range when compressing the audio.
     * @see Eac3AtmosDynamicRangeCompressionRf
     */
    public String dynamicRangeCompressionRfAsString() {
        return dynamicRangeCompressionRf;
    }

    /**
     * Specify a value for the following Dolby Atmos setting: Left only/Right only center mix (Lo/Ro center).
     * MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose
     * for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0.
     * 
     * @return Specify a value for the following Dolby Atmos setting: Left only/Right only center mix (Lo/Ro center).
     *         MediaConvert uses this value for downmixing. How the service uses this value depends on the value that
     *         you choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5,
     *         and -6.0.
     */
    public Double loRoCenterMixLevel() {
        return loRoCenterMixLevel;
    }

    /**
     * Specify a value for the following Dolby Atmos setting: Left only/Right only (Lo/Ro surround). MediaConvert uses
     * this value for downmixing. How the service uses this value depends on the value that you choose for Stereo
     * downmix (Eac3AtmosStereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel.
     * 
     * @return Specify a value for the following Dolby Atmos setting: Left only/Right only (Lo/Ro surround).
     *         MediaConvert uses this value for downmixing. How the service uses this value depends on the value that
     *         you choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60.
     *         The value -60 mutes the channel.
     */
    public Double loRoSurroundMixLevel() {
        return loRoSurroundMixLevel;
    }

    /**
     * Specify a value for the following Dolby Atmos setting: Left total/Right total center mix (Lt/Rt center).
     * MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose
     * for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0.
     * 
     * @return Specify a value for the following Dolby Atmos setting: Left total/Right total center mix (Lt/Rt center).
     *         MediaConvert uses this value for downmixing. How the service uses this value depends on the value that
     *         you choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5,
     *         and -6.0.
     */
    public Double ltRtCenterMixLevel() {
        return ltRtCenterMixLevel;
    }

    /**
     * Specify a value for the following Dolby Atmos setting: Left total/Right total surround mix (Lt/Rt surround).
     * MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose
     * for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes
     * the channel.
     * 
     * @return Specify a value for the following Dolby Atmos setting: Left total/Right total surround mix (Lt/Rt
     *         surround). MediaConvert uses this value for downmixing. How the service uses this value depends on the
     *         value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0,
     *         and -60. The value -60 mutes the channel.
     */
    public Double ltRtSurroundMixLevel() {
        return ltRtSurroundMixLevel;
    }

    /**
     * Choose how the service meters the loudness of your audio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #meteringMode} will
     * return {@link Eac3AtmosMeteringMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #meteringModeAsString}.
     * </p>
     * 
     * @return Choose how the service meters the loudness of your audio.
     * @see Eac3AtmosMeteringMode
     */
    public Eac3AtmosMeteringMode meteringMode() {
        return Eac3AtmosMeteringMode.fromValue(meteringMode);
    }

    /**
     * Choose how the service meters the loudness of your audio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #meteringMode} will
     * return {@link Eac3AtmosMeteringMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #meteringModeAsString}.
     * </p>
     * 
     * @return Choose how the service meters the loudness of your audio.
     * @see Eac3AtmosMeteringMode
     */
    public String meteringModeAsString() {
        return meteringMode;
    }

    /**
     * This value is always 48000. It represents the sample rate in Hz.
     * 
     * @return This value is always 48000. It represents the sample rate in Hz.
     */
    public Integer sampleRate() {
        return sampleRate;
    }

    /**
     * Specify the percentage of audio content that must be speech before the encoder uses the measured speech loudness
     * as the overall program loudness.
     * 
     * @return Specify the percentage of audio content that must be speech before the encoder uses the measured speech
     *         loudness as the overall program loudness.
     */
    public Integer speechThreshold() {
        return speechThreshold;
    }

    /**
     * Choose how the service does stereo downmixing.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stereoDownmix}
     * will return {@link Eac3AtmosStereoDownmix#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stereoDownmixAsString}.
     * </p>
     * 
     * @return Choose how the service does stereo downmixing.
     * @see Eac3AtmosStereoDownmix
     */
    public Eac3AtmosStereoDownmix stereoDownmix() {
        return Eac3AtmosStereoDownmix.fromValue(stereoDownmix);
    }

    /**
     * Choose how the service does stereo downmixing.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stereoDownmix}
     * will return {@link Eac3AtmosStereoDownmix#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stereoDownmixAsString}.
     * </p>
     * 
     * @return Choose how the service does stereo downmixing.
     * @see Eac3AtmosStereoDownmix
     */
    public String stereoDownmixAsString() {
        return stereoDownmix;
    }

    /**
     * Specify whether your input audio has an additional center rear surround channel matrix encoded into your left and
     * right surround channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #surroundExMode}
     * will return {@link Eac3AtmosSurroundExMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #surroundExModeAsString}.
     * </p>
     * 
     * @return Specify whether your input audio has an additional center rear surround channel matrix encoded into your
     *         left and right surround channels.
     * @see Eac3AtmosSurroundExMode
     */
    public Eac3AtmosSurroundExMode surroundExMode() {
        return Eac3AtmosSurroundExMode.fromValue(surroundExMode);
    }

    /**
     * Specify whether your input audio has an additional center rear surround channel matrix encoded into your left and
     * right surround channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #surroundExMode}
     * will return {@link Eac3AtmosSurroundExMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #surroundExModeAsString}.
     * </p>
     * 
     * @return Specify whether your input audio has an additional center rear surround channel matrix encoded into your
     *         left and right surround channels.
     * @see Eac3AtmosSurroundExMode
     */
    public String surroundExModeAsString() {
        return surroundExMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(bitstreamModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dialogueIntelligenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicRangeCompressionLineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicRangeCompressionRfAsString());
        hashCode = 31 * hashCode + Objects.hashCode(loRoCenterMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(loRoSurroundMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(ltRtCenterMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(ltRtSurroundMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(meteringModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(speechThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(stereoDownmixAsString());
        hashCode = 31 * hashCode + Objects.hashCode(surroundExModeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Eac3AtmosSettings)) {
            return false;
        }
        Eac3AtmosSettings other = (Eac3AtmosSettings) obj;
        return Objects.equals(bitrate(), other.bitrate())
                && Objects.equals(bitstreamModeAsString(), other.bitstreamModeAsString())
                && Objects.equals(codingModeAsString(), other.codingModeAsString())
                && Objects.equals(dialogueIntelligenceAsString(), other.dialogueIntelligenceAsString())
                && Objects.equals(dynamicRangeCompressionLineAsString(), other.dynamicRangeCompressionLineAsString())
                && Objects.equals(dynamicRangeCompressionRfAsString(), other.dynamicRangeCompressionRfAsString())
                && Objects.equals(loRoCenterMixLevel(), other.loRoCenterMixLevel())
                && Objects.equals(loRoSurroundMixLevel(), other.loRoSurroundMixLevel())
                && Objects.equals(ltRtCenterMixLevel(), other.ltRtCenterMixLevel())
                && Objects.equals(ltRtSurroundMixLevel(), other.ltRtSurroundMixLevel())
                && Objects.equals(meteringModeAsString(), other.meteringModeAsString())
                && Objects.equals(sampleRate(), other.sampleRate()) && Objects.equals(speechThreshold(), other.speechThreshold())
                && Objects.equals(stereoDownmixAsString(), other.stereoDownmixAsString())
                && Objects.equals(surroundExModeAsString(), other.surroundExModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Eac3AtmosSettings").add("Bitrate", bitrate()).add("BitstreamMode", bitstreamModeAsString())
                .add("CodingMode", codingModeAsString()).add("DialogueIntelligence", dialogueIntelligenceAsString())
                .add("DynamicRangeCompressionLine", dynamicRangeCompressionLineAsString())
                .add("DynamicRangeCompressionRf", dynamicRangeCompressionRfAsString())
                .add("LoRoCenterMixLevel", loRoCenterMixLevel()).add("LoRoSurroundMixLevel", loRoSurroundMixLevel())
                .add("LtRtCenterMixLevel", ltRtCenterMixLevel()).add("LtRtSurroundMixLevel", ltRtSurroundMixLevel())
                .add("MeteringMode", meteringModeAsString()).add("SampleRate", sampleRate())
                .add("SpeechThreshold", speechThreshold()).add("StereoDownmix", stereoDownmixAsString())
                .add("SurroundExMode", surroundExModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "BitstreamMode":
            return Optional.ofNullable(clazz.cast(bitstreamModeAsString()));
        case "CodingMode":
            return Optional.ofNullable(clazz.cast(codingModeAsString()));
        case "DialogueIntelligence":
            return Optional.ofNullable(clazz.cast(dialogueIntelligenceAsString()));
        case "DynamicRangeCompressionLine":
            return Optional.ofNullable(clazz.cast(dynamicRangeCompressionLineAsString()));
        case "DynamicRangeCompressionRf":
            return Optional.ofNullable(clazz.cast(dynamicRangeCompressionRfAsString()));
        case "LoRoCenterMixLevel":
            return Optional.ofNullable(clazz.cast(loRoCenterMixLevel()));
        case "LoRoSurroundMixLevel":
            return Optional.ofNullable(clazz.cast(loRoSurroundMixLevel()));
        case "LtRtCenterMixLevel":
            return Optional.ofNullable(clazz.cast(ltRtCenterMixLevel()));
        case "LtRtSurroundMixLevel":
            return Optional.ofNullable(clazz.cast(ltRtSurroundMixLevel()));
        case "MeteringMode":
            return Optional.ofNullable(clazz.cast(meteringModeAsString()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        case "SpeechThreshold":
            return Optional.ofNullable(clazz.cast(speechThreshold()));
        case "StereoDownmix":
            return Optional.ofNullable(clazz.cast(stereoDownmixAsString()));
        case "SurroundExMode":
            return Optional.ofNullable(clazz.cast(surroundExModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Eac3AtmosSettings, T> g) {
        return obj -> g.apply((Eac3AtmosSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Eac3AtmosSettings> {
        /**
         * Specify the average bitrate in bits per second. Valid values: 384k, 448k, 640k, 768k
         * 
         * @param bitrate
         *        Specify the average bitrate in bits per second. Valid values: 384k, 448k, 640k, 768k
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3
         * bitstream mode, see ATSC A/52-2012 (Annex E).
         * 
         * @param bitstreamMode
         *        Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about
         *        the EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).
         * @see Eac3AtmosBitstreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosBitstreamMode
         */
        Builder bitstreamMode(String bitstreamMode);

        /**
         * Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3
         * bitstream mode, see ATSC A/52-2012 (Annex E).
         * 
         * @param bitstreamMode
         *        Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about
         *        the EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).
         * @see Eac3AtmosBitstreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosBitstreamMode
         */
        Builder bitstreamMode(Eac3AtmosBitstreamMode bitstreamMode);

        /**
         * The coding mode for Dolby Digital Plus JOC (Atmos) is always 9.1.6 (CODING_MODE_9_1_6).
         * 
         * @param codingMode
         *        The coding mode for Dolby Digital Plus JOC (Atmos) is always 9.1.6 (CODING_MODE_9_1_6).
         * @see Eac3AtmosCodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosCodingMode
         */
        Builder codingMode(String codingMode);

        /**
         * The coding mode for Dolby Digital Plus JOC (Atmos) is always 9.1.6 (CODING_MODE_9_1_6).
         * 
         * @param codingMode
         *        The coding mode for Dolby Digital Plus JOC (Atmos) is always 9.1.6 (CODING_MODE_9_1_6).
         * @see Eac3AtmosCodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosCodingMode
         */
        Builder codingMode(Eac3AtmosCodingMode codingMode);

        /**
         * Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
         * 
         * @param dialogueIntelligence
         *        Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
         * @see Eac3AtmosDialogueIntelligence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDialogueIntelligence
         */
        Builder dialogueIntelligence(String dialogueIntelligence);

        /**
         * Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
         * 
         * @param dialogueIntelligence
         *        Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
         * @see Eac3AtmosDialogueIntelligence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDialogueIntelligence
         */
        Builder dialogueIntelligence(Eac3AtmosDialogueIntelligence dialogueIntelligence);

        /**
         * Specify the absolute peak level for a signal with dynamic range compression.
         * 
         * @param dynamicRangeCompressionLine
         *        Specify the absolute peak level for a signal with dynamic range compression.
         * @see Eac3AtmosDynamicRangeCompressionLine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDynamicRangeCompressionLine
         */
        Builder dynamicRangeCompressionLine(String dynamicRangeCompressionLine);

        /**
         * Specify the absolute peak level for a signal with dynamic range compression.
         * 
         * @param dynamicRangeCompressionLine
         *        Specify the absolute peak level for a signal with dynamic range compression.
         * @see Eac3AtmosDynamicRangeCompressionLine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDynamicRangeCompressionLine
         */
        Builder dynamicRangeCompressionLine(Eac3AtmosDynamicRangeCompressionLine dynamicRangeCompressionLine);

        /**
         * Specify how the service limits the audio dynamic range when compressing the audio.
         * 
         * @param dynamicRangeCompressionRf
         *        Specify how the service limits the audio dynamic range when compressing the audio.
         * @see Eac3AtmosDynamicRangeCompressionRf
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDynamicRangeCompressionRf
         */
        Builder dynamicRangeCompressionRf(String dynamicRangeCompressionRf);

        /**
         * Specify how the service limits the audio dynamic range when compressing the audio.
         * 
         * @param dynamicRangeCompressionRf
         *        Specify how the service limits the audio dynamic range when compressing the audio.
         * @see Eac3AtmosDynamicRangeCompressionRf
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDynamicRangeCompressionRf
         */
        Builder dynamicRangeCompressionRf(Eac3AtmosDynamicRangeCompressionRf dynamicRangeCompressionRf);

        /**
         * Specify a value for the following Dolby Atmos setting: Left only/Right only center mix (Lo/Ro center).
         * MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you
         * choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0.
         * 
         * @param loRoCenterMixLevel
         *        Specify a value for the following Dolby Atmos setting: Left only/Right only center mix (Lo/Ro center).
         *        MediaConvert uses this value for downmixing. How the service uses this value depends on the value that
         *        you choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5,
         *        and -6.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRoCenterMixLevel(Double loRoCenterMixLevel);

        /**
         * Specify a value for the following Dolby Atmos setting: Left only/Right only (Lo/Ro surround). MediaConvert
         * uses this value for downmixing. How the service uses this value depends on the value that you choose for
         * Stereo downmix (Eac3AtmosStereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes
         * the channel.
         * 
         * @param loRoSurroundMixLevel
         *        Specify a value for the following Dolby Atmos setting: Left only/Right only (Lo/Ro surround).
         *        MediaConvert uses this value for downmixing. How the service uses this value depends on the value that
         *        you choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60.
         *        The value -60 mutes the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRoSurroundMixLevel(Double loRoSurroundMixLevel);

        /**
         * Specify a value for the following Dolby Atmos setting: Left total/Right total center mix (Lt/Rt center).
         * MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you
         * choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0.
         * 
         * @param ltRtCenterMixLevel
         *        Specify a value for the following Dolby Atmos setting: Left total/Right total center mix (Lt/Rt
         *        center). MediaConvert uses this value for downmixing. How the service uses this value depends on the
         *        value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5,
         *        -3.0, -4.5, and -6.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ltRtCenterMixLevel(Double ltRtCenterMixLevel);

        /**
         * Specify a value for the following Dolby Atmos setting: Left total/Right total surround mix (Lt/Rt surround).
         * MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you
         * choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value
         * -60 mutes the channel.
         * 
         * @param ltRtSurroundMixLevel
         *        Specify a value for the following Dolby Atmos setting: Left total/Right total surround mix (Lt/Rt
         *        surround). MediaConvert uses this value for downmixing. How the service uses this value depends on the
         *        value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: -1.5, -3.0, -4.5,
         *        -6.0, and -60. The value -60 mutes the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ltRtSurroundMixLevel(Double ltRtSurroundMixLevel);

        /**
         * Choose how the service meters the loudness of your audio.
         * 
         * @param meteringMode
         *        Choose how the service meters the loudness of your audio.
         * @see Eac3AtmosMeteringMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosMeteringMode
         */
        Builder meteringMode(String meteringMode);

        /**
         * Choose how the service meters the loudness of your audio.
         * 
         * @param meteringMode
         *        Choose how the service meters the loudness of your audio.
         * @see Eac3AtmosMeteringMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosMeteringMode
         */
        Builder meteringMode(Eac3AtmosMeteringMode meteringMode);

        /**
         * This value is always 48000. It represents the sample rate in Hz.
         * 
         * @param sampleRate
         *        This value is always 48000. It represents the sample rate in Hz.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Integer sampleRate);

        /**
         * Specify the percentage of audio content that must be speech before the encoder uses the measured speech
         * loudness as the overall program loudness.
         * 
         * @param speechThreshold
         *        Specify the percentage of audio content that must be speech before the encoder uses the measured
         *        speech loudness as the overall program loudness.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechThreshold(Integer speechThreshold);

        /**
         * Choose how the service does stereo downmixing.
         * 
         * @param stereoDownmix
         *        Choose how the service does stereo downmixing.
         * @see Eac3AtmosStereoDownmix
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosStereoDownmix
         */
        Builder stereoDownmix(String stereoDownmix);

        /**
         * Choose how the service does stereo downmixing.
         * 
         * @param stereoDownmix
         *        Choose how the service does stereo downmixing.
         * @see Eac3AtmosStereoDownmix
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosStereoDownmix
         */
        Builder stereoDownmix(Eac3AtmosStereoDownmix stereoDownmix);

        /**
         * Specify whether your input audio has an additional center rear surround channel matrix encoded into your left
         * and right surround channels.
         * 
         * @param surroundExMode
         *        Specify whether your input audio has an additional center rear surround channel matrix encoded into
         *        your left and right surround channels.
         * @see Eac3AtmosSurroundExMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosSurroundExMode
         */
        Builder surroundExMode(String surroundExMode);

        /**
         * Specify whether your input audio has an additional center rear surround channel matrix encoded into your left
         * and right surround channels.
         * 
         * @param surroundExMode
         *        Specify whether your input audio has an additional center rear surround channel matrix encoded into
         *        your left and right surround channels.
         * @see Eac3AtmosSurroundExMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosSurroundExMode
         */
        Builder surroundExMode(Eac3AtmosSurroundExMode surroundExMode);
    }

    static final class BuilderImpl implements Builder {
        private Integer bitrate;

        private String bitstreamMode;

        private String codingMode;

        private String dialogueIntelligence;

        private String dynamicRangeCompressionLine;

        private String dynamicRangeCompressionRf;

        private Double loRoCenterMixLevel;

        private Double loRoSurroundMixLevel;

        private Double ltRtCenterMixLevel;

        private Double ltRtSurroundMixLevel;

        private String meteringMode;

        private Integer sampleRate;

        private Integer speechThreshold;

        private String stereoDownmix;

        private String surroundExMode;

        private BuilderImpl() {
        }

        private BuilderImpl(Eac3AtmosSettings model) {
            bitrate(model.bitrate);
            bitstreamMode(model.bitstreamMode);
            codingMode(model.codingMode);
            dialogueIntelligence(model.dialogueIntelligence);
            dynamicRangeCompressionLine(model.dynamicRangeCompressionLine);
            dynamicRangeCompressionRf(model.dynamicRangeCompressionRf);
            loRoCenterMixLevel(model.loRoCenterMixLevel);
            loRoSurroundMixLevel(model.loRoSurroundMixLevel);
            ltRtCenterMixLevel(model.ltRtCenterMixLevel);
            ltRtSurroundMixLevel(model.ltRtSurroundMixLevel);
            meteringMode(model.meteringMode);
            sampleRate(model.sampleRate);
            speechThreshold(model.speechThreshold);
            stereoDownmix(model.stereoDownmix);
            surroundExMode(model.surroundExMode);
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getBitstreamMode() {
            return bitstreamMode;
        }

        @Override
        public final Builder bitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
            return this;
        }

        @Override
        public final Builder bitstreamMode(Eac3AtmosBitstreamMode bitstreamMode) {
            this.bitstreamMode(bitstreamMode == null ? null : bitstreamMode.toString());
            return this;
        }

        public final void setBitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
        }

        public final String getCodingMode() {
            return codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(Eac3AtmosCodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        public final String getDialogueIntelligence() {
            return dialogueIntelligence;
        }

        @Override
        public final Builder dialogueIntelligence(String dialogueIntelligence) {
            this.dialogueIntelligence = dialogueIntelligence;
            return this;
        }

        @Override
        public final Builder dialogueIntelligence(Eac3AtmosDialogueIntelligence dialogueIntelligence) {
            this.dialogueIntelligence(dialogueIntelligence == null ? null : dialogueIntelligence.toString());
            return this;
        }

        public final void setDialogueIntelligence(String dialogueIntelligence) {
            this.dialogueIntelligence = dialogueIntelligence;
        }

        public final String getDynamicRangeCompressionLine() {
            return dynamicRangeCompressionLine;
        }

        @Override
        public final Builder dynamicRangeCompressionLine(String dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine = dynamicRangeCompressionLine;
            return this;
        }

        @Override
        public final Builder dynamicRangeCompressionLine(Eac3AtmosDynamicRangeCompressionLine dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine(dynamicRangeCompressionLine == null ? null : dynamicRangeCompressionLine.toString());
            return this;
        }

        public final void setDynamicRangeCompressionLine(String dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine = dynamicRangeCompressionLine;
        }

        public final String getDynamicRangeCompressionRf() {
            return dynamicRangeCompressionRf;
        }

        @Override
        public final Builder dynamicRangeCompressionRf(String dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf = dynamicRangeCompressionRf;
            return this;
        }

        @Override
        public final Builder dynamicRangeCompressionRf(Eac3AtmosDynamicRangeCompressionRf dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf(dynamicRangeCompressionRf == null ? null : dynamicRangeCompressionRf.toString());
            return this;
        }

        public final void setDynamicRangeCompressionRf(String dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf = dynamicRangeCompressionRf;
        }

        public final Double getLoRoCenterMixLevel() {
            return loRoCenterMixLevel;
        }

        @Override
        public final Builder loRoCenterMixLevel(Double loRoCenterMixLevel) {
            this.loRoCenterMixLevel = loRoCenterMixLevel;
            return this;
        }

        public final void setLoRoCenterMixLevel(Double loRoCenterMixLevel) {
            this.loRoCenterMixLevel = loRoCenterMixLevel;
        }

        public final Double getLoRoSurroundMixLevel() {
            return loRoSurroundMixLevel;
        }

        @Override
        public final Builder loRoSurroundMixLevel(Double loRoSurroundMixLevel) {
            this.loRoSurroundMixLevel = loRoSurroundMixLevel;
            return this;
        }

        public final void setLoRoSurroundMixLevel(Double loRoSurroundMixLevel) {
            this.loRoSurroundMixLevel = loRoSurroundMixLevel;
        }

        public final Double getLtRtCenterMixLevel() {
            return ltRtCenterMixLevel;
        }

        @Override
        public final Builder ltRtCenterMixLevel(Double ltRtCenterMixLevel) {
            this.ltRtCenterMixLevel = ltRtCenterMixLevel;
            return this;
        }

        public final void setLtRtCenterMixLevel(Double ltRtCenterMixLevel) {
            this.ltRtCenterMixLevel = ltRtCenterMixLevel;
        }

        public final Double getLtRtSurroundMixLevel() {
            return ltRtSurroundMixLevel;
        }

        @Override
        public final Builder ltRtSurroundMixLevel(Double ltRtSurroundMixLevel) {
            this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
            return this;
        }

        public final void setLtRtSurroundMixLevel(Double ltRtSurroundMixLevel) {
            this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
        }

        public final String getMeteringMode() {
            return meteringMode;
        }

        @Override
        public final Builder meteringMode(String meteringMode) {
            this.meteringMode = meteringMode;
            return this;
        }

        @Override
        public final Builder meteringMode(Eac3AtmosMeteringMode meteringMode) {
            this.meteringMode(meteringMode == null ? null : meteringMode.toString());
            return this;
        }

        public final void setMeteringMode(String meteringMode) {
            this.meteringMode = meteringMode;
        }

        public final Integer getSampleRate() {
            return sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final Integer getSpeechThreshold() {
            return speechThreshold;
        }

        @Override
        public final Builder speechThreshold(Integer speechThreshold) {
            this.speechThreshold = speechThreshold;
            return this;
        }

        public final void setSpeechThreshold(Integer speechThreshold) {
            this.speechThreshold = speechThreshold;
        }

        public final String getStereoDownmix() {
            return stereoDownmix;
        }

        @Override
        public final Builder stereoDownmix(String stereoDownmix) {
            this.stereoDownmix = stereoDownmix;
            return this;
        }

        @Override
        public final Builder stereoDownmix(Eac3AtmosStereoDownmix stereoDownmix) {
            this.stereoDownmix(stereoDownmix == null ? null : stereoDownmix.toString());
            return this;
        }

        public final void setStereoDownmix(String stereoDownmix) {
            this.stereoDownmix = stereoDownmix;
        }

        public final String getSurroundExMode() {
            return surroundExMode;
        }

        @Override
        public final Builder surroundExMode(String surroundExMode) {
            this.surroundExMode = surroundExMode;
            return this;
        }

        @Override
        public final Builder surroundExMode(Eac3AtmosSurroundExMode surroundExMode) {
            this.surroundExMode(surroundExMode == null ? null : surroundExMode.toString());
            return this;
        }

        public final void setSurroundExMode(String surroundExMode) {
            this.surroundExMode = surroundExMode;
        }

        @Override
        public Eac3AtmosSettings build() {
            return new Eac3AtmosSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
