/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for quality-defined variable bitrate encoding with the AV1 codec. Required when you set Rate control mode to
 * QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don't define Rate control
 * mode.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Av1QvbrSettings implements SdkPojo, Serializable, ToCopyableBuilder<Av1QvbrSettings.Builder, Av1QvbrSettings> {
    private static final SdkField<Integer> QVBR_QUALITY_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Av1QvbrSettings::qvbrQualityLevel)).setter(setter(Builder::qvbrQualityLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrQualityLevel").build()).build();

    private static final SdkField<Double> QVBR_QUALITY_LEVEL_FINE_TUNE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Av1QvbrSettings::qvbrQualityLevelFineTune)).setter(setter(Builder::qvbrQualityLevelFineTune))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrQualityLevelFineTune").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QVBR_QUALITY_LEVEL_FIELD,
            QVBR_QUALITY_LEVEL_FINE_TUNE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer qvbrQualityLevel;

    private final Double qvbrQualityLevelFineTune;

    private Av1QvbrSettings(BuilderImpl builder) {
        this.qvbrQualityLevel = builder.qvbrQualityLevel;
        this.qvbrQualityLevelFineTune = builder.qvbrQualityLevelFineTune;
    }

    /**
     * Required when you use QVBR rate control mode. That is, when you specify qvbrSettings within av1Settings. Specify
     * the general target quality level for this output, from 1 to 10. Use higher numbers for greater quality. Level 10
     * results in nearly lossless compression. The quality level for most broadcast-quality transcodes is between 6 and
     * 9. Optionally, to specify a value between whole numbers, also provide a value for the setting
     * qvbrQualityLevelFineTune. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7
     * and set qvbrQualityLevelFineTune to .33.
     * 
     * @return Required when you use QVBR rate control mode. That is, when you specify qvbrSettings within av1Settings.
     *         Specify the general target quality level for this output, from 1 to 10. Use higher numbers for greater
     *         quality. Level 10 results in nearly lossless compression. The quality level for most broadcast-quality
     *         transcodes is between 6 and 9. Optionally, to specify a value between whole numbers, also provide a value
     *         for the setting qvbrQualityLevelFineTune. For example, if you want your QVBR quality level to be 7.33,
     *         set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33.
     */
    public Integer qvbrQualityLevel() {
        return qvbrQualityLevel;
    }

    /**
     * Optional. Specify a value here to set the QVBR quality to a level that is between whole numbers. For example, if
     * you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33.
     * MediaConvert rounds your QVBR quality level to the nearest third of a whole number. For example, if you set
     * qvbrQualityLevel to 7 and you set qvbrQualityLevelFineTune to .25, your actual QVBR quality level is 7.33.
     * 
     * @return Optional. Specify a value here to set the QVBR quality to a level that is between whole numbers. For
     *         example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set
     *         qvbrQualityLevelFineTune to .33. MediaConvert rounds your QVBR quality level to the nearest third of a
     *         whole number. For example, if you set qvbrQualityLevel to 7 and you set qvbrQualityLevelFineTune to .25,
     *         your actual QVBR quality level is 7.33.
     */
    public Double qvbrQualityLevelFineTune() {
        return qvbrQualityLevelFineTune;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(qvbrQualityLevel());
        hashCode = 31 * hashCode + Objects.hashCode(qvbrQualityLevelFineTune());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Av1QvbrSettings)) {
            return false;
        }
        Av1QvbrSettings other = (Av1QvbrSettings) obj;
        return Objects.equals(qvbrQualityLevel(), other.qvbrQualityLevel())
                && Objects.equals(qvbrQualityLevelFineTune(), other.qvbrQualityLevelFineTune());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Av1QvbrSettings").add("QvbrQualityLevel", qvbrQualityLevel())
                .add("QvbrQualityLevelFineTune", qvbrQualityLevelFineTune()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QvbrQualityLevel":
            return Optional.ofNullable(clazz.cast(qvbrQualityLevel()));
        case "QvbrQualityLevelFineTune":
            return Optional.ofNullable(clazz.cast(qvbrQualityLevelFineTune()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Av1QvbrSettings, T> g) {
        return obj -> g.apply((Av1QvbrSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Av1QvbrSettings> {
        /**
         * Required when you use QVBR rate control mode. That is, when you specify qvbrSettings within av1Settings.
         * Specify the general target quality level for this output, from 1 to 10. Use higher numbers for greater
         * quality. Level 10 results in nearly lossless compression. The quality level for most broadcast-quality
         * transcodes is between 6 and 9. Optionally, to specify a value between whole numbers, also provide a value for
         * the setting qvbrQualityLevelFineTune. For example, if you want your QVBR quality level to be 7.33, set
         * qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33.
         * 
         * @param qvbrQualityLevel
         *        Required when you use QVBR rate control mode. That is, when you specify qvbrSettings within
         *        av1Settings. Specify the general target quality level for this output, from 1 to 10. Use higher
         *        numbers for greater quality. Level 10 results in nearly lossless compression. The quality level for
         *        most broadcast-quality transcodes is between 6 and 9. Optionally, to specify a value between whole
         *        numbers, also provide a value for the setting qvbrQualityLevelFineTune. For example, if you want your
         *        QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qvbrQualityLevel(Integer qvbrQualityLevel);

        /**
         * Optional. Specify a value here to set the QVBR quality to a level that is between whole numbers. For example,
         * if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to
         * .33. MediaConvert rounds your QVBR quality level to the nearest third of a whole number. For example, if you
         * set qvbrQualityLevel to 7 and you set qvbrQualityLevelFineTune to .25, your actual QVBR quality level is
         * 7.33.
         * 
         * @param qvbrQualityLevelFineTune
         *        Optional. Specify a value here to set the QVBR quality to a level that is between whole numbers. For
         *        example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set
         *        qvbrQualityLevelFineTune to .33. MediaConvert rounds your QVBR quality level to the nearest third of a
         *        whole number. For example, if you set qvbrQualityLevel to 7 and you set qvbrQualityLevelFineTune to
         *        .25, your actual QVBR quality level is 7.33.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qvbrQualityLevelFineTune(Double qvbrQualityLevelFineTune);
    }

    static final class BuilderImpl implements Builder {
        private Integer qvbrQualityLevel;

        private Double qvbrQualityLevelFineTune;

        private BuilderImpl() {
        }

        private BuilderImpl(Av1QvbrSettings model) {
            qvbrQualityLevel(model.qvbrQualityLevel);
            qvbrQualityLevelFineTune(model.qvbrQualityLevelFineTune);
        }

        public final Integer getQvbrQualityLevel() {
            return qvbrQualityLevel;
        }

        @Override
        public final Builder qvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
            return this;
        }

        public final void setQvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
        }

        public final Double getQvbrQualityLevelFineTune() {
            return qvbrQualityLevelFineTune;
        }

        @Override
        public final Builder qvbrQualityLevelFineTune(Double qvbrQualityLevelFineTune) {
            this.qvbrQualityLevelFineTune = qvbrQualityLevelFineTune;
            return this;
        }

        public final void setQvbrQualityLevelFineTune(Double qvbrQualityLevelFineTune) {
            this.qvbrQualityLevelFineTune = qvbrQualityLevelFineTune;
        }

        @Override
        public Av1QvbrSettings build() {
            return new Av1QvbrSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
