/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AC3.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ac3Settings implements SdkPojo, Serializable, ToCopyableBuilder<Ac3Settings.Builder, Ac3Settings> {
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Ac3Settings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> BITSTREAM_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Ac3Settings::bitstreamModeAsString)).setter(setter(Builder::bitstreamMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitstreamMode").build()).build();

    private static final SdkField<String> CODING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Ac3Settings::codingModeAsString)).setter(setter(Builder::codingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()).build();

    private static final SdkField<Integer> DIALNORM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Ac3Settings::dialnorm)).setter(setter(Builder::dialnorm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialnorm").build()).build();

    private static final SdkField<String> DYNAMIC_RANGE_COMPRESSION_PROFILE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Ac3Settings::dynamicRangeCompressionProfileAsString))
            .setter(setter(Builder::dynamicRangeCompressionProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeCompressionProfile")
                    .build()).build();

    private static final SdkField<String> LFE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Ac3Settings::lfeFilterAsString)).setter(setter(Builder::lfeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lfeFilter").build()).build();

    private static final SdkField<String> METADATA_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Ac3Settings::metadataControlAsString)).setter(setter(Builder::metadataControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataControl").build()).build();

    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Ac3Settings::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD,
            BITSTREAM_MODE_FIELD, CODING_MODE_FIELD, DIALNORM_FIELD, DYNAMIC_RANGE_COMPRESSION_PROFILE_FIELD, LFE_FILTER_FIELD,
            METADATA_CONTROL_FIELD, SAMPLE_RATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer bitrate;

    private final String bitstreamMode;

    private final String codingMode;

    private final Integer dialnorm;

    private final String dynamicRangeCompressionProfile;

    private final String lfeFilter;

    private final String metadataControl;

    private final Integer sampleRate;

    private Ac3Settings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.bitstreamMode = builder.bitstreamMode;
        this.codingMode = builder.codingMode;
        this.dialnorm = builder.dialnorm;
        this.dynamicRangeCompressionProfile = builder.dynamicRangeCompressionProfile;
        this.lfeFilter = builder.lfeFilter;
        this.metadataControl = builder.metadataControl;
        this.sampleRate = builder.sampleRate;
    }

    /**
     * Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.
     * 
     * @return Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.
     */
    public Integer bitrate() {
        return bitrate;
    }

    /**
     * Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3
     * bitstream mode, see ATSC A/52-2012 (Annex E).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitstreamMode}
     * will return {@link Ac3BitstreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bitstreamModeAsString}.
     * </p>
     * 
     * @return Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3
     *         bitstream mode, see ATSC A/52-2012 (Annex E).
     * @see Ac3BitstreamMode
     */
    public Ac3BitstreamMode bitstreamMode() {
        return Ac3BitstreamMode.fromValue(bitstreamMode);
    }

    /**
     * Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3
     * bitstream mode, see ATSC A/52-2012 (Annex E).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitstreamMode}
     * will return {@link Ac3BitstreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bitstreamModeAsString}.
     * </p>
     * 
     * @return Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3
     *         bitstream mode, see ATSC A/52-2012 (Annex E).
     * @see Ac3BitstreamMode
     */
    public String bitstreamModeAsString() {
        return bitstreamMode;
    }

    /**
     * Dolby Digital coding mode. Determines number of channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Ac3CodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return Dolby Digital coding mode. Determines number of channels.
     * @see Ac3CodingMode
     */
    public Ac3CodingMode codingMode() {
        return Ac3CodingMode.fromValue(codingMode);
    }

    /**
     * Dolby Digital coding mode. Determines number of channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Ac3CodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return Dolby Digital coding mode. Determines number of channels.
     * @see Ac3CodingMode
     */
    public String codingModeAsString() {
        return codingMode;
    }

    /**
     * Sets the dialnorm for the output. If blank and input audio is Dolby Digital, dialnorm will be passed through.
     * 
     * @return Sets the dialnorm for the output. If blank and input audio is Dolby Digital, dialnorm will be passed
     *         through.
     */
    public Integer dialnorm() {
        return dialnorm;
    }

    /**
     * If set to FILM_STANDARD, adds dynamic range compression signaling to the output bitstream as defined in the Dolby
     * Digital specification.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionProfile} will return
     * {@link Ac3DynamicRangeCompressionProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dynamicRangeCompressionProfileAsString}.
     * </p>
     * 
     * @return If set to FILM_STANDARD, adds dynamic range compression signaling to the output bitstream as defined in
     *         the Dolby Digital specification.
     * @see Ac3DynamicRangeCompressionProfile
     */
    public Ac3DynamicRangeCompressionProfile dynamicRangeCompressionProfile() {
        return Ac3DynamicRangeCompressionProfile.fromValue(dynamicRangeCompressionProfile);
    }

    /**
     * If set to FILM_STANDARD, adds dynamic range compression signaling to the output bitstream as defined in the Dolby
     * Digital specification.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionProfile} will return
     * {@link Ac3DynamicRangeCompressionProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dynamicRangeCompressionProfileAsString}.
     * </p>
     * 
     * @return If set to FILM_STANDARD, adds dynamic range compression signaling to the output bitstream as defined in
     *         the Dolby Digital specification.
     * @see Ac3DynamicRangeCompressionProfile
     */
    public String dynamicRangeCompressionProfileAsString() {
        return dynamicRangeCompressionProfile;
    }

    /**
     * Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lfeFilter} will
     * return {@link Ac3LfeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lfeFilterAsString}.
     * </p>
     * 
     * @return Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
     * @see Ac3LfeFilter
     */
    public Ac3LfeFilter lfeFilter() {
        return Ac3LfeFilter.fromValue(lfeFilter);
    }

    /**
     * Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lfeFilter} will
     * return {@link Ac3LfeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lfeFilterAsString}.
     * </p>
     * 
     * @return Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
     * @see Ac3LfeFilter
     */
    public String lfeFilterAsString() {
        return lfeFilter;
    }

    /**
     * When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this
     * audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metadataControl}
     * will return {@link Ac3MetadataControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metadataControlAsString}.
     * </p>
     * 
     * @return When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that
     *         supplied this audio data. If audio was not supplied from one of these streams, then the static metadata
     *         settings will be used.
     * @see Ac3MetadataControl
     */
    public Ac3MetadataControl metadataControl() {
        return Ac3MetadataControl.fromValue(metadataControl);
    }

    /**
     * When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this
     * audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metadataControl}
     * will return {@link Ac3MetadataControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metadataControlAsString}.
     * </p>
     * 
     * @return When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that
     *         supplied this audio data. If audio was not supplied from one of these streams, then the static metadata
     *         settings will be used.
     * @see Ac3MetadataControl
     */
    public String metadataControlAsString() {
        return metadataControl;
    }

    /**
     * This value is always 48000. It represents the sample rate in Hz.
     * 
     * @return This value is always 48000. It represents the sample rate in Hz.
     */
    public Integer sampleRate() {
        return sampleRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(bitstreamModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dialnorm());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicRangeCompressionProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lfeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadataControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ac3Settings)) {
            return false;
        }
        Ac3Settings other = (Ac3Settings) obj;
        return Objects.equals(bitrate(), other.bitrate())
                && Objects.equals(bitstreamModeAsString(), other.bitstreamModeAsString())
                && Objects.equals(codingModeAsString(), other.codingModeAsString())
                && Objects.equals(dialnorm(), other.dialnorm())
                && Objects.equals(dynamicRangeCompressionProfileAsString(), other.dynamicRangeCompressionProfileAsString())
                && Objects.equals(lfeFilterAsString(), other.lfeFilterAsString())
                && Objects.equals(metadataControlAsString(), other.metadataControlAsString())
                && Objects.equals(sampleRate(), other.sampleRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Ac3Settings").add("Bitrate", bitrate()).add("BitstreamMode", bitstreamModeAsString())
                .add("CodingMode", codingModeAsString()).add("Dialnorm", dialnorm())
                .add("DynamicRangeCompressionProfile", dynamicRangeCompressionProfileAsString())
                .add("LfeFilter", lfeFilterAsString()).add("MetadataControl", metadataControlAsString())
                .add("SampleRate", sampleRate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "BitstreamMode":
            return Optional.ofNullable(clazz.cast(bitstreamModeAsString()));
        case "CodingMode":
            return Optional.ofNullable(clazz.cast(codingModeAsString()));
        case "Dialnorm":
            return Optional.ofNullable(clazz.cast(dialnorm()));
        case "DynamicRangeCompressionProfile":
            return Optional.ofNullable(clazz.cast(dynamicRangeCompressionProfileAsString()));
        case "LfeFilter":
            return Optional.ofNullable(clazz.cast(lfeFilterAsString()));
        case "MetadataControl":
            return Optional.ofNullable(clazz.cast(metadataControlAsString()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ac3Settings, T> g) {
        return obj -> g.apply((Ac3Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ac3Settings> {
        /**
         * Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.
         * 
         * @param bitrate
         *        Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3
         * bitstream mode, see ATSC A/52-2012 (Annex E).
         * 
         * @param bitstreamMode
         *        Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the
         *        AC3 bitstream mode, see ATSC A/52-2012 (Annex E).
         * @see Ac3BitstreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3BitstreamMode
         */
        Builder bitstreamMode(String bitstreamMode);

        /**
         * Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3
         * bitstream mode, see ATSC A/52-2012 (Annex E).
         * 
         * @param bitstreamMode
         *        Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the
         *        AC3 bitstream mode, see ATSC A/52-2012 (Annex E).
         * @see Ac3BitstreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3BitstreamMode
         */
        Builder bitstreamMode(Ac3BitstreamMode bitstreamMode);

        /**
         * Dolby Digital coding mode. Determines number of channels.
         * 
         * @param codingMode
         *        Dolby Digital coding mode. Determines number of channels.
         * @see Ac3CodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3CodingMode
         */
        Builder codingMode(String codingMode);

        /**
         * Dolby Digital coding mode. Determines number of channels.
         * 
         * @param codingMode
         *        Dolby Digital coding mode. Determines number of channels.
         * @see Ac3CodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3CodingMode
         */
        Builder codingMode(Ac3CodingMode codingMode);

        /**
         * Sets the dialnorm for the output. If blank and input audio is Dolby Digital, dialnorm will be passed through.
         * 
         * @param dialnorm
         *        Sets the dialnorm for the output. If blank and input audio is Dolby Digital, dialnorm will be passed
         *        through.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialnorm(Integer dialnorm);

        /**
         * If set to FILM_STANDARD, adds dynamic range compression signaling to the output bitstream as defined in the
         * Dolby Digital specification.
         * 
         * @param dynamicRangeCompressionProfile
         *        If set to FILM_STANDARD, adds dynamic range compression signaling to the output bitstream as defined
         *        in the Dolby Digital specification.
         * @see Ac3DynamicRangeCompressionProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3DynamicRangeCompressionProfile
         */
        Builder dynamicRangeCompressionProfile(String dynamicRangeCompressionProfile);

        /**
         * If set to FILM_STANDARD, adds dynamic range compression signaling to the output bitstream as defined in the
         * Dolby Digital specification.
         * 
         * @param dynamicRangeCompressionProfile
         *        If set to FILM_STANDARD, adds dynamic range compression signaling to the output bitstream as defined
         *        in the Dolby Digital specification.
         * @see Ac3DynamicRangeCompressionProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3DynamicRangeCompressionProfile
         */
        Builder dynamicRangeCompressionProfile(Ac3DynamicRangeCompressionProfile dynamicRangeCompressionProfile);

        /**
         * Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
         * 
         * @param lfeFilter
         *        Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding
         *        mode.
         * @see Ac3LfeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3LfeFilter
         */
        Builder lfeFilter(String lfeFilter);

        /**
         * Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
         * 
         * @param lfeFilter
         *        Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding
         *        mode.
         * @see Ac3LfeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3LfeFilter
         */
        Builder lfeFilter(Ac3LfeFilter lfeFilter);

        /**
         * When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied
         * this audio data. If audio was not supplied from one of these streams, then the static metadata settings will
         * be used.
         * 
         * @param metadataControl
         *        When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that
         *        supplied this audio data. If audio was not supplied from one of these streams, then the static
         *        metadata settings will be used.
         * @see Ac3MetadataControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3MetadataControl
         */
        Builder metadataControl(String metadataControl);

        /**
         * When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied
         * this audio data. If audio was not supplied from one of these streams, then the static metadata settings will
         * be used.
         * 
         * @param metadataControl
         *        When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that
         *        supplied this audio data. If audio was not supplied from one of these streams, then the static
         *        metadata settings will be used.
         * @see Ac3MetadataControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3MetadataControl
         */
        Builder metadataControl(Ac3MetadataControl metadataControl);

        /**
         * This value is always 48000. It represents the sample rate in Hz.
         * 
         * @param sampleRate
         *        This value is always 48000. It represents the sample rate in Hz.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Integer sampleRate);
    }

    static final class BuilderImpl implements Builder {
        private Integer bitrate;

        private String bitstreamMode;

        private String codingMode;

        private Integer dialnorm;

        private String dynamicRangeCompressionProfile;

        private String lfeFilter;

        private String metadataControl;

        private Integer sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(Ac3Settings model) {
            bitrate(model.bitrate);
            bitstreamMode(model.bitstreamMode);
            codingMode(model.codingMode);
            dialnorm(model.dialnorm);
            dynamicRangeCompressionProfile(model.dynamicRangeCompressionProfile);
            lfeFilter(model.lfeFilter);
            metadataControl(model.metadataControl);
            sampleRate(model.sampleRate);
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getBitstreamMode() {
            return bitstreamMode;
        }

        @Override
        public final Builder bitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
            return this;
        }

        @Override
        public final Builder bitstreamMode(Ac3BitstreamMode bitstreamMode) {
            this.bitstreamMode(bitstreamMode == null ? null : bitstreamMode.toString());
            return this;
        }

        public final void setBitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
        }

        public final String getCodingMode() {
            return codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(Ac3CodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        public final Integer getDialnorm() {
            return dialnorm;
        }

        @Override
        public final Builder dialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
            return this;
        }

        public final void setDialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
        }

        public final String getDynamicRangeCompressionProfile() {
            return dynamicRangeCompressionProfile;
        }

        @Override
        public final Builder dynamicRangeCompressionProfile(String dynamicRangeCompressionProfile) {
            this.dynamicRangeCompressionProfile = dynamicRangeCompressionProfile;
            return this;
        }

        @Override
        public final Builder dynamicRangeCompressionProfile(Ac3DynamicRangeCompressionProfile dynamicRangeCompressionProfile) {
            this.dynamicRangeCompressionProfile(dynamicRangeCompressionProfile == null ? null : dynamicRangeCompressionProfile
                    .toString());
            return this;
        }

        public final void setDynamicRangeCompressionProfile(String dynamicRangeCompressionProfile) {
            this.dynamicRangeCompressionProfile = dynamicRangeCompressionProfile;
        }

        public final String getLfeFilter() {
            return lfeFilter;
        }

        @Override
        public final Builder lfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
            return this;
        }

        @Override
        public final Builder lfeFilter(Ac3LfeFilter lfeFilter) {
            this.lfeFilter(lfeFilter == null ? null : lfeFilter.toString());
            return this;
        }

        public final void setLfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
        }

        public final String getMetadataControl() {
            return metadataControl;
        }

        @Override
        public final Builder metadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
            return this;
        }

        @Override
        public final Builder metadataControl(Ac3MetadataControl metadataControl) {
            this.metadataControl(metadataControl == null ? null : metadataControl.toString());
            return this;
        }

        public final void setMetadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
        }

        public final Integer getSampleRate() {
            return sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public Ac3Settings build() {
            return new Ac3Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
