/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the burned-in timecode
 * on output video.
 */
@Generated("software.amazon.awssdk:codegen")
public enum TimecodeBurninPosition {
    TOP_CENTER("TOP_CENTER"),

    TOP_LEFT("TOP_LEFT"),

    TOP_RIGHT("TOP_RIGHT"),

    MIDDLE_LEFT("MIDDLE_LEFT"),

    MIDDLE_CENTER("MIDDLE_CENTER"),

    MIDDLE_RIGHT("MIDDLE_RIGHT"),

    BOTTOM_LEFT("BOTTOM_LEFT"),

    BOTTOM_CENTER("BOTTOM_CENTER"),

    BOTTOM_RIGHT("BOTTOM_RIGHT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TimecodeBurninPosition(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TimecodeBurninPosition corresponding to the value
     */
    public static TimecodeBurninPosition fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TimecodeBurninPosition.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TimecodeBurninPosition}s
     */
    public static Set<TimecodeBurninPosition> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
