/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for preset
 */
@Generated("software.amazon.awssdk:codegen")
public final class PresetSettings implements SdkPojo, Serializable, ToCopyableBuilder<PresetSettings.Builder, PresetSettings> {
    private static final SdkField<List<AudioDescription>> AUDIO_DESCRIPTIONS_FIELD = SdkField
            .<List<AudioDescription>> builder(MarshallingType.LIST)
            .getter(getter(PresetSettings::audioDescriptions))
            .setter(setter(Builder::audioDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudioDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CaptionDescriptionPreset>> CAPTION_DESCRIPTIONS_FIELD = SdkField
            .<List<CaptionDescriptionPreset>> builder(MarshallingType.LIST)
            .getter(getter(PresetSettings::captionDescriptions))
            .setter(setter(Builder::captionDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CaptionDescriptionPreset> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaptionDescriptionPreset::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ContainerSettings> CONTAINER_SETTINGS_FIELD = SdkField
            .<ContainerSettings> builder(MarshallingType.SDK_POJO).getter(getter(PresetSettings::containerSettings))
            .setter(setter(Builder::containerSettings)).constructor(ContainerSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerSettings").build()).build();

    private static final SdkField<VideoDescription> VIDEO_DESCRIPTION_FIELD = SdkField
            .<VideoDescription> builder(MarshallingType.SDK_POJO).getter(getter(PresetSettings::videoDescription))
            .setter(setter(Builder::videoDescription)).constructor(VideoDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DESCRIPTIONS_FIELD,
            CAPTION_DESCRIPTIONS_FIELD, CONTAINER_SETTINGS_FIELD, VIDEO_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AudioDescription> audioDescriptions;

    private final List<CaptionDescriptionPreset> captionDescriptions;

    private final ContainerSettings containerSettings;

    private final VideoDescription videoDescription;

    private PresetSettings(BuilderImpl builder) {
        this.audioDescriptions = builder.audioDescriptions;
        this.captionDescriptions = builder.captionDescriptions;
        this.containerSettings = builder.containerSettings;
        this.videoDescription = builder.videoDescription;
    }

    /**
     * Returns true if the AudioDescriptions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAudioDescriptions() {
        return audioDescriptions != null && !(audioDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance of
     * (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAudioDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one
     *         instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding
     *         settings.
     */
    public List<AudioDescription> audioDescriptions() {
        return audioDescriptions;
    }

    /**
     * Returns true if the CaptionDescriptions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCaptionDescriptions() {
        return captionDescriptions != null && !(captionDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * Caption settings for this preset. There can be multiple caption settings in a single output.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCaptionDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Caption settings for this preset. There can be multiple caption settings in a single output.
     */
    public List<CaptionDescriptionPreset> captionDescriptions() {
        return captionDescriptions;
    }

    /**
     * Container specific settings.
     * 
     * @return Container specific settings.
     */
    public ContainerSettings containerSettings() {
        return containerSettings;
    }

    /**
     * (VideoDescription) contains a group of video encoding settings. The specific video settings depend on the video
     * codec that you choose when you specify a value for Video codec (codec). Include one instance of
     * (VideoDescription) per output.
     * 
     * @return (VideoDescription) contains a group of video encoding settings. The specific video settings depend on the
     *         video codec that you choose when you specify a value for Video codec (codec). Include one instance of
     *         (VideoDescription) per output.
     */
    public VideoDescription videoDescription() {
        return videoDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(captionDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(containerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(videoDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PresetSettings)) {
            return false;
        }
        PresetSettings other = (PresetSettings) obj;
        return Objects.equals(audioDescriptions(), other.audioDescriptions())
                && Objects.equals(captionDescriptions(), other.captionDescriptions())
                && Objects.equals(containerSettings(), other.containerSettings())
                && Objects.equals(videoDescription(), other.videoDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PresetSettings").add("AudioDescriptions", audioDescriptions())
                .add("CaptionDescriptions", captionDescriptions()).add("ContainerSettings", containerSettings())
                .add("VideoDescription", videoDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioDescriptions":
            return Optional.ofNullable(clazz.cast(audioDescriptions()));
        case "CaptionDescriptions":
            return Optional.ofNullable(clazz.cast(captionDescriptions()));
        case "ContainerSettings":
            return Optional.ofNullable(clazz.cast(containerSettings()));
        case "VideoDescription":
            return Optional.ofNullable(clazz.cast(videoDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PresetSettings, T> g) {
        return obj -> g.apply((PresetSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PresetSettings> {
        /**
         * (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance
         * of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.
         * 
         * @param audioDescriptions
         *        (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one
         *        instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of
         *        encoding settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioDescriptions(Collection<AudioDescription> audioDescriptions);

        /**
         * (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance
         * of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.
         * 
         * @param audioDescriptions
         *        (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one
         *        instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of
         *        encoding settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioDescriptions(AudioDescription... audioDescriptions);

        /**
         * (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance
         * of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings. This
         * is a convenience that creates an instance of the {@link List<AudioDescription>.Builder} avoiding the need to
         * create one manually via {@link List<AudioDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AudioDescription>.Builder#build()} is called immediately and
         * its result is passed to {@link #audioDescriptions(List<AudioDescription>)}.
         * 
         * @param audioDescriptions
         *        a consumer that will call methods on {@link List<AudioDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioDescriptions(List<AudioDescription>)
         */
        Builder audioDescriptions(Consumer<AudioDescription.Builder>... audioDescriptions);

        /**
         * Caption settings for this preset. There can be multiple caption settings in a single output.
         * 
         * @param captionDescriptions
         *        Caption settings for this preset. There can be multiple caption settings in a single output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionDescriptions(Collection<CaptionDescriptionPreset> captionDescriptions);

        /**
         * Caption settings for this preset. There can be multiple caption settings in a single output.
         * 
         * @param captionDescriptions
         *        Caption settings for this preset. There can be multiple caption settings in a single output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionDescriptions(CaptionDescriptionPreset... captionDescriptions);

        /**
         * Caption settings for this preset. There can be multiple caption settings in a single output. This is a
         * convenience that creates an instance of the {@link List<CaptionDescriptionPreset>.Builder} avoiding the need
         * to create one manually via {@link List<CaptionDescriptionPreset>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CaptionDescriptionPreset>.Builder#build()} is called
         * immediately and its result is passed to {@link #captionDescriptions(List<CaptionDescriptionPreset>)}.
         * 
         * @param captionDescriptions
         *        a consumer that will call methods on {@link List<CaptionDescriptionPreset>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captionDescriptions(List<CaptionDescriptionPreset>)
         */
        Builder captionDescriptions(Consumer<CaptionDescriptionPreset.Builder>... captionDescriptions);

        /**
         * Container specific settings.
         * 
         * @param containerSettings
         *        Container specific settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerSettings(ContainerSettings containerSettings);

        /**
         * Container specific settings. This is a convenience that creates an instance of the
         * {@link ContainerSettings.Builder} avoiding the need to create one manually via
         * {@link ContainerSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #containerSettings(ContainerSettings)}.
         * 
         * @param containerSettings
         *        a consumer that will call methods on {@link ContainerSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerSettings(ContainerSettings)
         */
        default Builder containerSettings(Consumer<ContainerSettings.Builder> containerSettings) {
            return containerSettings(ContainerSettings.builder().applyMutation(containerSettings).build());
        }

        /**
         * (VideoDescription) contains a group of video encoding settings. The specific video settings depend on the
         * video codec that you choose when you specify a value for Video codec (codec). Include one instance of
         * (VideoDescription) per output.
         * 
         * @param videoDescription
         *        (VideoDescription) contains a group of video encoding settings. The specific video settings depend on
         *        the video codec that you choose when you specify a value for Video codec (codec). Include one instance
         *        of (VideoDescription) per output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoDescription(VideoDescription videoDescription);

        /**
         * (VideoDescription) contains a group of video encoding settings. The specific video settings depend on the
         * video codec that you choose when you specify a value for Video codec (codec). Include one instance of
         * (VideoDescription) per output. This is a convenience that creates an instance of the
         * {@link VideoDescription.Builder} avoiding the need to create one manually via
         * {@link VideoDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link VideoDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #videoDescription(VideoDescription)}.
         * 
         * @param videoDescription
         *        a consumer that will call methods on {@link VideoDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoDescription(VideoDescription)
         */
        default Builder videoDescription(Consumer<VideoDescription.Builder> videoDescription) {
            return videoDescription(VideoDescription.builder().applyMutation(videoDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<AudioDescription> audioDescriptions = DefaultSdkAutoConstructList.getInstance();

        private List<CaptionDescriptionPreset> captionDescriptions = DefaultSdkAutoConstructList.getInstance();

        private ContainerSettings containerSettings;

        private VideoDescription videoDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(PresetSettings model) {
            audioDescriptions(model.audioDescriptions);
            captionDescriptions(model.captionDescriptions);
            containerSettings(model.containerSettings);
            videoDescription(model.videoDescription);
        }

        public final Collection<AudioDescription.Builder> getAudioDescriptions() {
            return audioDescriptions != null ? audioDescriptions.stream().map(AudioDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder audioDescriptions(Collection<AudioDescription> audioDescriptions) {
            this.audioDescriptions = ___listOfAudioDescriptionCopier.copy(audioDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(AudioDescription... audioDescriptions) {
            audioDescriptions(Arrays.asList(audioDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(Consumer<AudioDescription.Builder>... audioDescriptions) {
            audioDescriptions(Stream.of(audioDescriptions).map(c -> AudioDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAudioDescriptions(Collection<AudioDescription.BuilderImpl> audioDescriptions) {
            this.audioDescriptions = ___listOfAudioDescriptionCopier.copyFromBuilder(audioDescriptions);
        }

        public final Collection<CaptionDescriptionPreset.Builder> getCaptionDescriptions() {
            return captionDescriptions != null ? captionDescriptions.stream().map(CaptionDescriptionPreset::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captionDescriptions(Collection<CaptionDescriptionPreset> captionDescriptions) {
            this.captionDescriptions = ___listOfCaptionDescriptionPresetCopier.copy(captionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(CaptionDescriptionPreset... captionDescriptions) {
            captionDescriptions(Arrays.asList(captionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(Consumer<CaptionDescriptionPreset.Builder>... captionDescriptions) {
            captionDescriptions(Stream.of(captionDescriptions)
                    .map(c -> CaptionDescriptionPreset.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionDescriptions(Collection<CaptionDescriptionPreset.BuilderImpl> captionDescriptions) {
            this.captionDescriptions = ___listOfCaptionDescriptionPresetCopier.copyFromBuilder(captionDescriptions);
        }

        public final ContainerSettings.Builder getContainerSettings() {
            return containerSettings != null ? containerSettings.toBuilder() : null;
        }

        @Override
        public final Builder containerSettings(ContainerSettings containerSettings) {
            this.containerSettings = containerSettings;
            return this;
        }

        public final void setContainerSettings(ContainerSettings.BuilderImpl containerSettings) {
            this.containerSettings = containerSettings != null ? containerSettings.build() : null;
        }

        public final VideoDescription.Builder getVideoDescription() {
            return videoDescription != null ? videoDescription.toBuilder() : null;
        }

        @Override
        public final Builder videoDescription(VideoDescription videoDescription) {
            this.videoDescription = videoDescription;
            return this;
        }

        public final void setVideoDescription(VideoDescription.BuilderImpl videoDescription) {
            this.videoDescription = videoDescription != null ? videoDescription.build() : null;
        }

        @Override
        public PresetSettings build() {
            return new PresetSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
