/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Noise reducer filter settings for temporal filter.
 */
@Generated("software.amazon.awssdk:codegen")
public final class NoiseReducerTemporalFilterSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<NoiseReducerTemporalFilterSettings.Builder, NoiseReducerTemporalFilterSettings> {
    private static final SdkField<Integer> AGGRESSIVE_MODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(NoiseReducerTemporalFilterSettings::aggressiveMode)).setter(setter(Builder::aggressiveMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggressiveMode").build()).build();

    private static final SdkField<Integer> SPEED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(NoiseReducerTemporalFilterSettings::speed)).setter(setter(Builder::speed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speed").build()).build();

    private static final SdkField<Integer> STRENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(NoiseReducerTemporalFilterSettings::strength)).setter(setter(Builder::strength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGRESSIVE_MODE_FIELD,
            SPEED_FIELD, STRENGTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer aggressiveMode;

    private final Integer speed;

    private final Integer strength;

    private NoiseReducerTemporalFilterSettings(BuilderImpl builder) {
        this.aggressiveMode = builder.aggressiveMode;
        this.speed = builder.speed;
        this.strength = builder.strength;
    }

    /**
     * Use Aggressive mode for content that has complex motion. Higher values produce stronger temporal filtering. This
     * filters highly complex scenes more aggressively and creates better VQ for low bitrate outputs.
     * 
     * @return Use Aggressive mode for content that has complex motion. Higher values produce stronger temporal
     *         filtering. This filters highly complex scenes more aggressively and creates better VQ for low bitrate
     *         outputs.
     */
    public Integer aggressiveMode() {
        return aggressiveMode;
    }

    /**
     * The speed of the filter (higher number is faster). Low setting reduces bit rate at the cost of transcode time,
     * high setting improves transcode time at the cost of bit rate.
     * 
     * @return The speed of the filter (higher number is faster). Low setting reduces bit rate at the cost of transcode
     *         time, high setting improves transcode time at the cost of bit rate.
     */
    public Integer speed() {
        return speed;
    }

    /**
     * Specify the strength of the noise reducing filter on this output. Higher values produce stronger filtering. We
     * recommend the following value ranges, depending on the result that you want: * 0-2 for complexity reduction with
     * minimal sharpness loss * 2-8 for complexity reduction with image preservation * 8-16 for a high level of
     * complexity reduction
     * 
     * @return Specify the strength of the noise reducing filter on this output. Higher values produce stronger
     *         filtering. We recommend the following value ranges, depending on the result that you want: * 0-2 for
     *         complexity reduction with minimal sharpness loss * 2-8 for complexity reduction with image preservation *
     *         8-16 for a high level of complexity reduction
     */
    public Integer strength() {
        return strength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggressiveMode());
        hashCode = 31 * hashCode + Objects.hashCode(speed());
        hashCode = 31 * hashCode + Objects.hashCode(strength());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NoiseReducerTemporalFilterSettings)) {
            return false;
        }
        NoiseReducerTemporalFilterSettings other = (NoiseReducerTemporalFilterSettings) obj;
        return Objects.equals(aggressiveMode(), other.aggressiveMode()) && Objects.equals(speed(), other.speed())
                && Objects.equals(strength(), other.strength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NoiseReducerTemporalFilterSettings").add("AggressiveMode", aggressiveMode())
                .add("Speed", speed()).add("Strength", strength()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggressiveMode":
            return Optional.ofNullable(clazz.cast(aggressiveMode()));
        case "Speed":
            return Optional.ofNullable(clazz.cast(speed()));
        case "Strength":
            return Optional.ofNullable(clazz.cast(strength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NoiseReducerTemporalFilterSettings, T> g) {
        return obj -> g.apply((NoiseReducerTemporalFilterSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NoiseReducerTemporalFilterSettings> {
        /**
         * Use Aggressive mode for content that has complex motion. Higher values produce stronger temporal filtering.
         * This filters highly complex scenes more aggressively and creates better VQ for low bitrate outputs.
         * 
         * @param aggressiveMode
         *        Use Aggressive mode for content that has complex motion. Higher values produce stronger temporal
         *        filtering. This filters highly complex scenes more aggressively and creates better VQ for low bitrate
         *        outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggressiveMode(Integer aggressiveMode);

        /**
         * The speed of the filter (higher number is faster). Low setting reduces bit rate at the cost of transcode
         * time, high setting improves transcode time at the cost of bit rate.
         * 
         * @param speed
         *        The speed of the filter (higher number is faster). Low setting reduces bit rate at the cost of
         *        transcode time, high setting improves transcode time at the cost of bit rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speed(Integer speed);

        /**
         * Specify the strength of the noise reducing filter on this output. Higher values produce stronger filtering.
         * We recommend the following value ranges, depending on the result that you want: * 0-2 for complexity
         * reduction with minimal sharpness loss * 2-8 for complexity reduction with image preservation * 8-16 for a
         * high level of complexity reduction
         * 
         * @param strength
         *        Specify the strength of the noise reducing filter on this output. Higher values produce stronger
         *        filtering. We recommend the following value ranges, depending on the result that you want: * 0-2 for
         *        complexity reduction with minimal sharpness loss * 2-8 for complexity reduction with image
         *        preservation * 8-16 for a high level of complexity reduction
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strength(Integer strength);
    }

    static final class BuilderImpl implements Builder {
        private Integer aggressiveMode;

        private Integer speed;

        private Integer strength;

        private BuilderImpl() {
        }

        private BuilderImpl(NoiseReducerTemporalFilterSettings model) {
            aggressiveMode(model.aggressiveMode);
            speed(model.speed);
            strength(model.strength);
        }

        public final Integer getAggressiveMode() {
            return aggressiveMode;
        }

        @Override
        public final Builder aggressiveMode(Integer aggressiveMode) {
            this.aggressiveMode = aggressiveMode;
            return this;
        }

        public final void setAggressiveMode(Integer aggressiveMode) {
            this.aggressiveMode = aggressiveMode;
        }

        public final Integer getSpeed() {
            return speed;
        }

        @Override
        public final Builder speed(Integer speed) {
            this.speed = speed;
            return this;
        }

        public final void setSpeed(Integer speed) {
            this.speed = speed;
        }

        public final Integer getStrength() {
            return strength;
        }

        @Override
        public final Builder strength(Integer strength) {
            this.strength = strength;
            return this;
        }

        public final void setStrength(Integer strength) {
            this.strength = strength;
        }

        @Override
        public NoiseReducerTemporalFilterSettings build() {
            return new NoiseReducerTemporalFilterSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
