/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer
 * B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for
 * low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames
 * between reference frames (numberBFramesBetweenReferenceFrames).
 */
@Generated("software.amazon.awssdk:codegen")
public enum H265DynamicSubGop {
    ADAPTIVE("ADAPTIVE"),

    STATIC("STATIC"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private H265DynamicSubGop(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H265DynamicSubGop corresponding to the value
     */
    public static H265DynamicSubGop fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(H265DynamicSubGop.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H265DynamicSubGop}s
     */
    public static Set<H265DynamicSubGop> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
