/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specifies DRM settings for DASH outputs.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashIsoEncryptionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DashIsoEncryptionSettings.Builder, DashIsoEncryptionSettings> {
    private static final SdkField<String> PLAYBACK_DEVICE_COMPATIBILITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DashIsoEncryptionSettings::playbackDeviceCompatibilityAsString))
            .setter(setter(Builder::playbackDeviceCompatibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playbackDeviceCompatibility")
                    .build()).build();

    private static final SdkField<SpekeKeyProvider> SPEKE_KEY_PROVIDER_FIELD = SdkField
            .<SpekeKeyProvider> builder(MarshallingType.SDK_POJO).getter(getter(DashIsoEncryptionSettings::spekeKeyProvider))
            .setter(setter(Builder::spekeKeyProvider)).constructor(SpekeKeyProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spekeKeyProvider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PLAYBACK_DEVICE_COMPATIBILITY_FIELD, SPEKE_KEY_PROVIDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String playbackDeviceCompatibility;

    private final SpekeKeyProvider spekeKeyProvider;

    private DashIsoEncryptionSettings(BuilderImpl builder) {
        this.playbackDeviceCompatibility = builder.playbackDeviceCompatibility;
        this.spekeKeyProvider = builder.spekeKeyProvider;
    }

    /**
     * This setting can improve the compatibility of your output with video players on obsolete devices. It applies only
     * to DASH H.264 outputs with DRM encryption. Choose Unencrypted SEI (UNENCRYPTED_SEI) only to correct problems with
     * playback on older devices. Otherwise, keep the default setting CENC v1 (CENC_V1). If you choose Unencrypted SEI,
     * for that output, the service will exclude the access unit delimiter and will leave the SEI NAL units unencrypted.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #playbackDeviceCompatibility} will return
     * {@link DashIsoPlaybackDeviceCompatibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #playbackDeviceCompatibilityAsString}.
     * </p>
     * 
     * @return This setting can improve the compatibility of your output with video players on obsolete devices. It
     *         applies only to DASH H.264 outputs with DRM encryption. Choose Unencrypted SEI (UNENCRYPTED_SEI) only to
     *         correct problems with playback on older devices. Otherwise, keep the default setting CENC v1 (CENC_V1).
     *         If you choose Unencrypted SEI, for that output, the service will exclude the access unit delimiter and
     *         will leave the SEI NAL units unencrypted.
     * @see DashIsoPlaybackDeviceCompatibility
     */
    public DashIsoPlaybackDeviceCompatibility playbackDeviceCompatibility() {
        return DashIsoPlaybackDeviceCompatibility.fromValue(playbackDeviceCompatibility);
    }

    /**
     * This setting can improve the compatibility of your output with video players on obsolete devices. It applies only
     * to DASH H.264 outputs with DRM encryption. Choose Unencrypted SEI (UNENCRYPTED_SEI) only to correct problems with
     * playback on older devices. Otherwise, keep the default setting CENC v1 (CENC_V1). If you choose Unencrypted SEI,
     * for that output, the service will exclude the access unit delimiter and will leave the SEI NAL units unencrypted.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #playbackDeviceCompatibility} will return
     * {@link DashIsoPlaybackDeviceCompatibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #playbackDeviceCompatibilityAsString}.
     * </p>
     * 
     * @return This setting can improve the compatibility of your output with video players on obsolete devices. It
     *         applies only to DASH H.264 outputs with DRM encryption. Choose Unencrypted SEI (UNENCRYPTED_SEI) only to
     *         correct problems with playback on older devices. Otherwise, keep the default setting CENC v1 (CENC_V1).
     *         If you choose Unencrypted SEI, for that output, the service will exclude the access unit delimiter and
     *         will leave the SEI NAL units unencrypted.
     * @see DashIsoPlaybackDeviceCompatibility
     */
    public String playbackDeviceCompatibilityAsString() {
        return playbackDeviceCompatibility;
    }

    /**
     * If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption with a
     * SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings instead.
     * 
     * @return If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption
     *         with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf
     *         settings instead.
     */
    public SpekeKeyProvider spekeKeyProvider() {
        return spekeKeyProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(playbackDeviceCompatibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spekeKeyProvider());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashIsoEncryptionSettings)) {
            return false;
        }
        DashIsoEncryptionSettings other = (DashIsoEncryptionSettings) obj;
        return Objects.equals(playbackDeviceCompatibilityAsString(), other.playbackDeviceCompatibilityAsString())
                && Objects.equals(spekeKeyProvider(), other.spekeKeyProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DashIsoEncryptionSettings")
                .add("PlaybackDeviceCompatibility", playbackDeviceCompatibilityAsString())
                .add("SpekeKeyProvider", spekeKeyProvider()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlaybackDeviceCompatibility":
            return Optional.ofNullable(clazz.cast(playbackDeviceCompatibilityAsString()));
        case "SpekeKeyProvider":
            return Optional.ofNullable(clazz.cast(spekeKeyProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashIsoEncryptionSettings, T> g) {
        return obj -> g.apply((DashIsoEncryptionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashIsoEncryptionSettings> {
        /**
         * This setting can improve the compatibility of your output with video players on obsolete devices. It applies
         * only to DASH H.264 outputs with DRM encryption. Choose Unencrypted SEI (UNENCRYPTED_SEI) only to correct
         * problems with playback on older devices. Otherwise, keep the default setting CENC v1 (CENC_V1). If you choose
         * Unencrypted SEI, for that output, the service will exclude the access unit delimiter and will leave the SEI
         * NAL units unencrypted.
         * 
         * @param playbackDeviceCompatibility
         *        This setting can improve the compatibility of your output with video players on obsolete devices. It
         *        applies only to DASH H.264 outputs with DRM encryption. Choose Unencrypted SEI (UNENCRYPTED_SEI) only
         *        to correct problems with playback on older devices. Otherwise, keep the default setting CENC v1
         *        (CENC_V1). If you choose Unencrypted SEI, for that output, the service will exclude the access unit
         *        delimiter and will leave the SEI NAL units unencrypted.
         * @see DashIsoPlaybackDeviceCompatibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoPlaybackDeviceCompatibility
         */
        Builder playbackDeviceCompatibility(String playbackDeviceCompatibility);

        /**
         * This setting can improve the compatibility of your output with video players on obsolete devices. It applies
         * only to DASH H.264 outputs with DRM encryption. Choose Unencrypted SEI (UNENCRYPTED_SEI) only to correct
         * problems with playback on older devices. Otherwise, keep the default setting CENC v1 (CENC_V1). If you choose
         * Unencrypted SEI, for that output, the service will exclude the access unit delimiter and will leave the SEI
         * NAL units unencrypted.
         * 
         * @param playbackDeviceCompatibility
         *        This setting can improve the compatibility of your output with video players on obsolete devices. It
         *        applies only to DASH H.264 outputs with DRM encryption. Choose Unencrypted SEI (UNENCRYPTED_SEI) only
         *        to correct problems with playback on older devices. Otherwise, keep the default setting CENC v1
         *        (CENC_V1). If you choose Unencrypted SEI, for that output, the service will exclude the access unit
         *        delimiter and will leave the SEI NAL units unencrypted.
         * @see DashIsoPlaybackDeviceCompatibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoPlaybackDeviceCompatibility
         */
        Builder playbackDeviceCompatibility(DashIsoPlaybackDeviceCompatibility playbackDeviceCompatibility);

        /**
         * If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption
         * with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings
         * instead.
         * 
         * @param spekeKeyProvider
         *        If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM
         *        encryption with a SPEKE-compliant key provider. If your output group type is CMAF, use the
         *        SpekeKeyProviderCmaf settings instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider);

        /**
         * If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption
         * with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings
         * instead. This is a convenience that creates an instance of the {@link SpekeKeyProvider.Builder} avoiding the
         * need to create one manually via {@link SpekeKeyProvider#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpekeKeyProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #spekeKeyProvider(SpekeKeyProvider)}.
         * 
         * @param spekeKeyProvider
         *        a consumer that will call methods on {@link SpekeKeyProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spekeKeyProvider(SpekeKeyProvider)
         */
        default Builder spekeKeyProvider(Consumer<SpekeKeyProvider.Builder> spekeKeyProvider) {
            return spekeKeyProvider(SpekeKeyProvider.builder().applyMutation(spekeKeyProvider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String playbackDeviceCompatibility;

        private SpekeKeyProvider spekeKeyProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(DashIsoEncryptionSettings model) {
            playbackDeviceCompatibility(model.playbackDeviceCompatibility);
            spekeKeyProvider(model.spekeKeyProvider);
        }

        public final String getPlaybackDeviceCompatibilityAsString() {
            return playbackDeviceCompatibility;
        }

        @Override
        public final Builder playbackDeviceCompatibility(String playbackDeviceCompatibility) {
            this.playbackDeviceCompatibility = playbackDeviceCompatibility;
            return this;
        }

        @Override
        public final Builder playbackDeviceCompatibility(DashIsoPlaybackDeviceCompatibility playbackDeviceCompatibility) {
            this.playbackDeviceCompatibility(playbackDeviceCompatibility == null ? null : playbackDeviceCompatibility.toString());
            return this;
        }

        public final void setPlaybackDeviceCompatibility(String playbackDeviceCompatibility) {
            this.playbackDeviceCompatibility = playbackDeviceCompatibility;
        }

        public final SpekeKeyProvider.Builder getSpekeKeyProvider() {
            return spekeKeyProvider != null ? spekeKeyProvider.toBuilder() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        public final void setSpekeKeyProvider(SpekeKeyProvider.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        @Override
        public DashIsoEncryptionSettings build() {
            return new DashIsoEncryptionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
