/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobResponse extends MediaConvertResponse implements
        ToCopyableBuilder<CreateJobResponse.Builder, CreateJobResponse> {
    private static final SdkField<Job> JOB_FIELD = SdkField.<Job> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateJobResponse::job)).setter(setter(Builder::job)).constructor(Job::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("job").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FIELD));

    private final Job job;

    private CreateJobResponse(BuilderImpl builder) {
        super(builder);
        this.job = builder.job;
    }

    /**
     * Each job converts an input file into an output file or files. For more information, see the User Guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     * 
     * @return Each job converts an input file into an output file or files. For more information, see the User Guide at
     *         http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    public Job job() {
        return job;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(job());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobResponse)) {
            return false;
        }
        CreateJobResponse other = (CreateJobResponse) obj;
        return Objects.equals(job(), other.job());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateJobResponse").add("Job", job()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Job":
            return Optional.ofNullable(clazz.cast(job()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobResponse, T> g) {
        return obj -> g.apply((CreateJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobResponse> {
        /**
         * Each job converts an input file into an output file or files. For more information, see the User Guide at
         * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
         * 
         * @param job
         *        Each job converts an input file into an output file or files. For more information, see the User Guide
         *        at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder job(Job job);

        /**
         * Each job converts an input file into an output file or files. For more information, see the User Guide at
         * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html This is a convenience that creates an instance
         * of the {@link Job.Builder} avoiding the need to create one manually via {@link Job#builder()}.
         *
         * When the {@link Consumer} completes, {@link Job.Builder#build()} is called immediately and its result is
         * passed to {@link #job(Job)}.
         * 
         * @param job
         *        a consumer that will call methods on {@link Job.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #job(Job)
         */
        default Builder job(Consumer<Job.Builder> job) {
            return job(Job.builder().applyMutation(job).build());
        }
    }

    static final class BuilderImpl extends MediaConvertResponse.BuilderImpl implements Builder {
        private Job job;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobResponse model) {
            super(model);
            job(model.job);
        }

        public final Job.Builder getJob() {
            return job != null ? job.toBuilder() : null;
        }

        @Override
        public final Builder job(Job job) {
            this.job = job;
            return this;
        }

        public final void setJob(Job.BuilderImpl job) {
            this.job = job != null ? job.build() : null;
        }

        @Override
        public CreateJobResponse build() {
            return new CreateJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
