/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.HlsEncryptionType;
import software.amazon.awssdk.services.mediaconvert.model.HlsInitializationVectorInManifest;
import software.amazon.awssdk.services.mediaconvert.model.HlsKeyProviderType;
import software.amazon.awssdk.services.mediaconvert.model.HlsOfflineEncrypted;
import software.amazon.awssdk.services.mediaconvert.model.SpekeKeyProvider;
import software.amazon.awssdk.services.mediaconvert.model.StaticKeyProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsEncryptionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsEncryptionSettings> {
    private static final SdkField<String> CONSTANT_INITIALIZATION_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsEncryptionSettings.getter(HlsEncryptionSettings::constantInitializationVector)).setter(HlsEncryptionSettings.setter(Builder::constantInitializationVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constantInitializationVector").build()}).build();
    private static final SdkField<String> ENCRYPTION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsEncryptionSettings.getter(HlsEncryptionSettings::encryptionMethodAsString)).setter(HlsEncryptionSettings.setter(Builder::encryptionMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionMethod").build()}).build();
    private static final SdkField<String> INITIALIZATION_VECTOR_IN_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsEncryptionSettings.getter(HlsEncryptionSettings::initializationVectorInManifestAsString)).setter(HlsEncryptionSettings.setter(Builder::initializationVectorInManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationVectorInManifest").build()}).build();
    private static final SdkField<String> OFFLINE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsEncryptionSettings.getter(HlsEncryptionSettings::offlineEncryptedAsString)).setter(HlsEncryptionSettings.setter(Builder::offlineEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offlineEncrypted").build()}).build();
    private static final SdkField<SpekeKeyProvider> SPEKE_KEY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HlsEncryptionSettings.getter(HlsEncryptionSettings::spekeKeyProvider)).setter(HlsEncryptionSettings.setter(Builder::spekeKeyProvider)).constructor(SpekeKeyProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spekeKeyProvider").build()}).build();
    private static final SdkField<StaticKeyProvider> STATIC_KEY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HlsEncryptionSettings.getter(HlsEncryptionSettings::staticKeyProvider)).setter(HlsEncryptionSettings.setter(Builder::staticKeyProvider)).constructor(StaticKeyProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticKeyProvider").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsEncryptionSettings.getter(HlsEncryptionSettings::typeAsString)).setter(HlsEncryptionSettings.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTANT_INITIALIZATION_VECTOR_FIELD, ENCRYPTION_METHOD_FIELD, INITIALIZATION_VECTOR_IN_MANIFEST_FIELD, OFFLINE_ENCRYPTED_FIELD, SPEKE_KEY_PROVIDER_FIELD, STATIC_KEY_PROVIDER_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String constantInitializationVector;
    private final String encryptionMethod;
    private final String initializationVectorInManifest;
    private final String offlineEncrypted;
    private final SpekeKeyProvider spekeKeyProvider;
    private final StaticKeyProvider staticKeyProvider;
    private final String type;

    private HlsEncryptionSettings(BuilderImpl builder) {
        this.constantInitializationVector = builder.constantInitializationVector;
        this.encryptionMethod = builder.encryptionMethod;
        this.initializationVectorInManifest = builder.initializationVectorInManifest;
        this.offlineEncrypted = builder.offlineEncrypted;
        this.spekeKeyProvider = builder.spekeKeyProvider;
        this.staticKeyProvider = builder.staticKeyProvider;
        this.type = builder.type;
    }

    public String constantInitializationVector() {
        return this.constantInitializationVector;
    }

    public HlsEncryptionType encryptionMethod() {
        return HlsEncryptionType.fromValue(this.encryptionMethod);
    }

    public String encryptionMethodAsString() {
        return this.encryptionMethod;
    }

    public HlsInitializationVectorInManifest initializationVectorInManifest() {
        return HlsInitializationVectorInManifest.fromValue(this.initializationVectorInManifest);
    }

    public String initializationVectorInManifestAsString() {
        return this.initializationVectorInManifest;
    }

    public HlsOfflineEncrypted offlineEncrypted() {
        return HlsOfflineEncrypted.fromValue(this.offlineEncrypted);
    }

    public String offlineEncryptedAsString() {
        return this.offlineEncrypted;
    }

    public SpekeKeyProvider spekeKeyProvider() {
        return this.spekeKeyProvider;
    }

    public StaticKeyProvider staticKeyProvider() {
        return this.staticKeyProvider;
    }

    public HlsKeyProviderType type() {
        return HlsKeyProviderType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constantInitializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationVectorInManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offlineEncryptedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spekeKeyProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticKeyProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsEncryptionSettings)) {
            return false;
        }
        HlsEncryptionSettings other = (HlsEncryptionSettings)obj;
        return Objects.equals(this.constantInitializationVector(), other.constantInitializationVector()) && Objects.equals(this.encryptionMethodAsString(), other.encryptionMethodAsString()) && Objects.equals(this.initializationVectorInManifestAsString(), other.initializationVectorInManifestAsString()) && Objects.equals(this.offlineEncryptedAsString(), other.offlineEncryptedAsString()) && Objects.equals(this.spekeKeyProvider(), other.spekeKeyProvider()) && Objects.equals(this.staticKeyProvider(), other.staticKeyProvider()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"HlsEncryptionSettings").add("ConstantInitializationVector", (Object)this.constantInitializationVector()).add("EncryptionMethod", (Object)this.encryptionMethodAsString()).add("InitializationVectorInManifest", (Object)this.initializationVectorInManifestAsString()).add("OfflineEncrypted", (Object)this.offlineEncryptedAsString()).add("SpekeKeyProvider", (Object)this.spekeKeyProvider()).add("StaticKeyProvider", (Object)this.staticKeyProvider()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConstantInitializationVector": {
                return Optional.ofNullable(clazz.cast(this.constantInitializationVector()));
            }
            case "EncryptionMethod": {
                return Optional.ofNullable(clazz.cast(this.encryptionMethodAsString()));
            }
            case "InitializationVectorInManifest": {
                return Optional.ofNullable(clazz.cast(this.initializationVectorInManifestAsString()));
            }
            case "OfflineEncrypted": {
                return Optional.ofNullable(clazz.cast(this.offlineEncryptedAsString()));
            }
            case "SpekeKeyProvider": {
                return Optional.ofNullable(clazz.cast(this.spekeKeyProvider()));
            }
            case "StaticKeyProvider": {
                return Optional.ofNullable(clazz.cast(this.staticKeyProvider()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsEncryptionSettings, T> g) {
        return obj -> g.apply((HlsEncryptionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String constantInitializationVector;
        private String encryptionMethod;
        private String initializationVectorInManifest;
        private String offlineEncrypted;
        private SpekeKeyProvider spekeKeyProvider;
        private StaticKeyProvider staticKeyProvider;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsEncryptionSettings model) {
            this.constantInitializationVector(model.constantInitializationVector);
            this.encryptionMethod(model.encryptionMethod);
            this.initializationVectorInManifest(model.initializationVectorInManifest);
            this.offlineEncrypted(model.offlineEncrypted);
            this.spekeKeyProvider(model.spekeKeyProvider);
            this.staticKeyProvider(model.staticKeyProvider);
            this.type(model.type);
        }

        public final String getConstantInitializationVector() {
            return this.constantInitializationVector;
        }

        @Override
        public final Builder constantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
            return this;
        }

        public final void setConstantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
        }

        public final String getEncryptionMethodAsString() {
            return this.encryptionMethod;
        }

        @Override
        public final Builder encryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
            return this;
        }

        @Override
        public final Builder encryptionMethod(HlsEncryptionType encryptionMethod) {
            this.encryptionMethod(encryptionMethod == null ? null : encryptionMethod.toString());
            return this;
        }

        public final void setEncryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
        }

        public final String getInitializationVectorInManifestAsString() {
            return this.initializationVectorInManifest;
        }

        @Override
        public final Builder initializationVectorInManifest(String initializationVectorInManifest) {
            this.initializationVectorInManifest = initializationVectorInManifest;
            return this;
        }

        @Override
        public final Builder initializationVectorInManifest(HlsInitializationVectorInManifest initializationVectorInManifest) {
            this.initializationVectorInManifest(initializationVectorInManifest == null ? null : initializationVectorInManifest.toString());
            return this;
        }

        public final void setInitializationVectorInManifest(String initializationVectorInManifest) {
            this.initializationVectorInManifest = initializationVectorInManifest;
        }

        public final String getOfflineEncryptedAsString() {
            return this.offlineEncrypted;
        }

        @Override
        public final Builder offlineEncrypted(String offlineEncrypted) {
            this.offlineEncrypted = offlineEncrypted;
            return this;
        }

        @Override
        public final Builder offlineEncrypted(HlsOfflineEncrypted offlineEncrypted) {
            this.offlineEncrypted(offlineEncrypted == null ? null : offlineEncrypted.toString());
            return this;
        }

        public final void setOfflineEncrypted(String offlineEncrypted) {
            this.offlineEncrypted = offlineEncrypted;
        }

        public final SpekeKeyProvider.Builder getSpekeKeyProvider() {
            return this.spekeKeyProvider != null ? this.spekeKeyProvider.toBuilder() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        public final void setSpekeKeyProvider(SpekeKeyProvider.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        public final StaticKeyProvider.Builder getStaticKeyProvider() {
            return this.staticKeyProvider != null ? this.staticKeyProvider.toBuilder() : null;
        }

        @Override
        public final Builder staticKeyProvider(StaticKeyProvider staticKeyProvider) {
            this.staticKeyProvider = staticKeyProvider;
            return this;
        }

        public final void setStaticKeyProvider(StaticKeyProvider.BuilderImpl staticKeyProvider) {
            this.staticKeyProvider = staticKeyProvider != null ? staticKeyProvider.build() : null;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HlsKeyProviderType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public HlsEncryptionSettings build() {
            return new HlsEncryptionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsEncryptionSettings> {
        public Builder constantInitializationVector(String var1);

        public Builder encryptionMethod(String var1);

        public Builder encryptionMethod(HlsEncryptionType var1);

        public Builder initializationVectorInManifest(String var1);

        public Builder initializationVectorInManifest(HlsInitializationVectorInManifest var1);

        public Builder offlineEncrypted(String var1);

        public Builder offlineEncrypted(HlsOfflineEncrypted var1);

        public Builder spekeKeyProvider(SpekeKeyProvider var1);

        default public Builder spekeKeyProvider(Consumer<SpekeKeyProvider.Builder> spekeKeyProvider) {
            return this.spekeKeyProvider((SpekeKeyProvider)((SpekeKeyProvider.Builder)SpekeKeyProvider.builder().applyMutation(spekeKeyProvider)).build());
        }

        public Builder staticKeyProvider(StaticKeyProvider var1);

        default public Builder staticKeyProvider(Consumer<StaticKeyProvider.Builder> staticKeyProvider) {
            return this.staticKeyProvider((StaticKeyProvider)((StaticKeyProvider.Builder)StaticKeyProvider.builder().applyMutation(staticKeyProvider)).build());
        }

        public Builder type(String var1);

        public Builder type(HlsKeyProviderType var1);
    }
}

