/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconvert.model.AudioSelector;
import software.amazon.awssdk.services.mediaconvert.model.AudioSelectorGroup;
import software.amazon.awssdk.services.mediaconvert.model.CaptionSelector;
import software.amazon.awssdk.services.mediaconvert.model.InputClipping;
import software.amazon.awssdk.services.mediaconvert.model.InputDeblockFilter;
import software.amazon.awssdk.services.mediaconvert.model.InputDenoiseFilter;
import software.amazon.awssdk.services.mediaconvert.model.InputFilterEnable;
import software.amazon.awssdk.services.mediaconvert.model.InputPsiControl;
import software.amazon.awssdk.services.mediaconvert.model.InputTimecodeSource;
import software.amazon.awssdk.services.mediaconvert.model.VideoSelector;
import software.amazon.awssdk.services.mediaconvert.model.___listOfInputClippingCopier;
import software.amazon.awssdk.services.mediaconvert.model.___mapOfAudioSelectorCopier;
import software.amazon.awssdk.services.mediaconvert.model.___mapOfAudioSelectorGroupCopier;
import software.amazon.awssdk.services.mediaconvert.model.___mapOfCaptionSelectorCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Input
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Input> {
    private static final SdkField<Map<String, AudioSelectorGroup>> AUDIO_SELECTOR_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Input.getter(Input::audioSelectorGroups)).setter(Input.setter(Builder::audioSelectorGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSelectorGroups").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioSelectorGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AudioSelector>> AUDIO_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Input.getter(Input::audioSelectors)).setter(Input.setter(Builder::audioSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSelectors").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, CaptionSelector>> CAPTION_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Input.getter(Input::captionSelectors)).setter(Input.setter(Builder::captionSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionSelectors").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaptionSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DEBLOCK_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Input.getter(Input::deblockFilterAsString)).setter(Input.setter(Builder::deblockFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deblockFilter").build()}).build();
    private static final SdkField<String> DENOISE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Input.getter(Input::denoiseFilterAsString)).setter(Input.setter(Builder::denoiseFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("denoiseFilter").build()}).build();
    private static final SdkField<String> FILE_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Input.getter(Input::fileInput)).setter(Input.setter(Builder::fileInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileInput").build()}).build();
    private static final SdkField<String> FILTER_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Input.getter(Input::filterEnableAsString)).setter(Input.setter(Builder::filterEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterEnable").build()}).build();
    private static final SdkField<Integer> FILTER_STRENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Input.getter(Input::filterStrength)).setter(Input.setter(Builder::filterStrength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterStrength").build()}).build();
    private static final SdkField<List<InputClipping>> INPUT_CLIPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Input.getter(Input::inputClippings)).setter(Input.setter(Builder::inputClippings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputClippings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputClipping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PROGRAM_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Input.getter(Input::programNumber)).setter(Input.setter(Builder::programNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programNumber").build()}).build();
    private static final SdkField<String> PSI_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Input.getter(Input::psiControlAsString)).setter(Input.setter(Builder::psiControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("psiControl").build()}).build();
    private static final SdkField<String> TIMECODE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Input.getter(Input::timecodeSourceAsString)).setter(Input.setter(Builder::timecodeSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeSource").build()}).build();
    private static final SdkField<VideoSelector> VIDEO_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Input.getter(Input::videoSelector)).setter(Input.setter(Builder::videoSelector)).constructor(VideoSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoSelector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_SELECTOR_GROUPS_FIELD, AUDIO_SELECTORS_FIELD, CAPTION_SELECTORS_FIELD, DEBLOCK_FILTER_FIELD, DENOISE_FILTER_FIELD, FILE_INPUT_FIELD, FILTER_ENABLE_FIELD, FILTER_STRENGTH_FIELD, INPUT_CLIPPINGS_FIELD, PROGRAM_NUMBER_FIELD, PSI_CONTROL_FIELD, TIMECODE_SOURCE_FIELD, VIDEO_SELECTOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, AudioSelectorGroup> audioSelectorGroups;
    private final Map<String, AudioSelector> audioSelectors;
    private final Map<String, CaptionSelector> captionSelectors;
    private final String deblockFilter;
    private final String denoiseFilter;
    private final String fileInput;
    private final String filterEnable;
    private final Integer filterStrength;
    private final List<InputClipping> inputClippings;
    private final Integer programNumber;
    private final String psiControl;
    private final String timecodeSource;
    private final VideoSelector videoSelector;

    private Input(BuilderImpl builder) {
        this.audioSelectorGroups = builder.audioSelectorGroups;
        this.audioSelectors = builder.audioSelectors;
        this.captionSelectors = builder.captionSelectors;
        this.deblockFilter = builder.deblockFilter;
        this.denoiseFilter = builder.denoiseFilter;
        this.fileInput = builder.fileInput;
        this.filterEnable = builder.filterEnable;
        this.filterStrength = builder.filterStrength;
        this.inputClippings = builder.inputClippings;
        this.programNumber = builder.programNumber;
        this.psiControl = builder.psiControl;
        this.timecodeSource = builder.timecodeSource;
        this.videoSelector = builder.videoSelector;
    }

    public Map<String, AudioSelectorGroup> audioSelectorGroups() {
        return this.audioSelectorGroups;
    }

    public Map<String, AudioSelector> audioSelectors() {
        return this.audioSelectors;
    }

    public Map<String, CaptionSelector> captionSelectors() {
        return this.captionSelectors;
    }

    public InputDeblockFilter deblockFilter() {
        return InputDeblockFilter.fromValue(this.deblockFilter);
    }

    public String deblockFilterAsString() {
        return this.deblockFilter;
    }

    public InputDenoiseFilter denoiseFilter() {
        return InputDenoiseFilter.fromValue(this.denoiseFilter);
    }

    public String denoiseFilterAsString() {
        return this.denoiseFilter;
    }

    public String fileInput() {
        return this.fileInput;
    }

    public InputFilterEnable filterEnable() {
        return InputFilterEnable.fromValue(this.filterEnable);
    }

    public String filterEnableAsString() {
        return this.filterEnable;
    }

    public Integer filterStrength() {
        return this.filterStrength;
    }

    public List<InputClipping> inputClippings() {
        return this.inputClippings;
    }

    public Integer programNumber() {
        return this.programNumber;
    }

    public InputPsiControl psiControl() {
        return InputPsiControl.fromValue(this.psiControl);
    }

    public String psiControlAsString() {
        return this.psiControl;
    }

    public InputTimecodeSource timecodeSource() {
        return InputTimecodeSource.fromValue(this.timecodeSource);
    }

    public String timecodeSourceAsString() {
        return this.timecodeSource;
    }

    public VideoSelector videoSelector() {
        return this.videoSelector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSelectorGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSelectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionSelectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.deblockFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.denoiseFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterEnableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterStrength());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputClippings());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.psiControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoSelector());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input)obj;
        return Objects.equals(this.audioSelectorGroups(), other.audioSelectorGroups()) && Objects.equals(this.audioSelectors(), other.audioSelectors()) && Objects.equals(this.captionSelectors(), other.captionSelectors()) && Objects.equals(this.deblockFilterAsString(), other.deblockFilterAsString()) && Objects.equals(this.denoiseFilterAsString(), other.denoiseFilterAsString()) && Objects.equals(this.fileInput(), other.fileInput()) && Objects.equals(this.filterEnableAsString(), other.filterEnableAsString()) && Objects.equals(this.filterStrength(), other.filterStrength()) && Objects.equals(this.inputClippings(), other.inputClippings()) && Objects.equals(this.programNumber(), other.programNumber()) && Objects.equals(this.psiControlAsString(), other.psiControlAsString()) && Objects.equals(this.timecodeSourceAsString(), other.timecodeSourceAsString()) && Objects.equals(this.videoSelector(), other.videoSelector());
    }

    public String toString() {
        return ToString.builder((String)"Input").add("AudioSelectorGroups", this.audioSelectorGroups()).add("AudioSelectors", this.audioSelectors()).add("CaptionSelectors", this.captionSelectors()).add("DeblockFilter", (Object)this.deblockFilterAsString()).add("DenoiseFilter", (Object)this.denoiseFilterAsString()).add("FileInput", (Object)this.fileInput()).add("FilterEnable", (Object)this.filterEnableAsString()).add("FilterStrength", (Object)this.filterStrength()).add("InputClippings", this.inputClippings()).add("ProgramNumber", (Object)this.programNumber()).add("PsiControl", (Object)this.psiControlAsString()).add("TimecodeSource", (Object)this.timecodeSourceAsString()).add("VideoSelector", (Object)this.videoSelector()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioSelectorGroups": {
                return Optional.ofNullable(clazz.cast(this.audioSelectorGroups()));
            }
            case "AudioSelectors": {
                return Optional.ofNullable(clazz.cast(this.audioSelectors()));
            }
            case "CaptionSelectors": {
                return Optional.ofNullable(clazz.cast(this.captionSelectors()));
            }
            case "DeblockFilter": {
                return Optional.ofNullable(clazz.cast(this.deblockFilterAsString()));
            }
            case "DenoiseFilter": {
                return Optional.ofNullable(clazz.cast(this.denoiseFilterAsString()));
            }
            case "FileInput": {
                return Optional.ofNullable(clazz.cast(this.fileInput()));
            }
            case "FilterEnable": {
                return Optional.ofNullable(clazz.cast(this.filterEnableAsString()));
            }
            case "FilterStrength": {
                return Optional.ofNullable(clazz.cast(this.filterStrength()));
            }
            case "InputClippings": {
                return Optional.ofNullable(clazz.cast(this.inputClippings()));
            }
            case "ProgramNumber": {
                return Optional.ofNullable(clazz.cast(this.programNumber()));
            }
            case "PsiControl": {
                return Optional.ofNullable(clazz.cast(this.psiControlAsString()));
            }
            case "TimecodeSource": {
                return Optional.ofNullable(clazz.cast(this.timecodeSourceAsString()));
            }
            case "VideoSelector": {
                return Optional.ofNullable(clazz.cast(this.videoSelector()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Input, T> g) {
        return obj -> g.apply((Input)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AudioSelectorGroup> audioSelectorGroups = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AudioSelector> audioSelectors = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, CaptionSelector> captionSelectors = DefaultSdkAutoConstructMap.getInstance();
        private String deblockFilter;
        private String denoiseFilter;
        private String fileInput;
        private String filterEnable;
        private Integer filterStrength;
        private List<InputClipping> inputClippings = DefaultSdkAutoConstructList.getInstance();
        private Integer programNumber;
        private String psiControl;
        private String timecodeSource;
        private VideoSelector videoSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            this.audioSelectorGroups(model.audioSelectorGroups);
            this.audioSelectors(model.audioSelectors);
            this.captionSelectors(model.captionSelectors);
            this.deblockFilter(model.deblockFilter);
            this.denoiseFilter(model.denoiseFilter);
            this.fileInput(model.fileInput);
            this.filterEnable(model.filterEnable);
            this.filterStrength(model.filterStrength);
            this.inputClippings(model.inputClippings);
            this.programNumber(model.programNumber);
            this.psiControl(model.psiControl);
            this.timecodeSource(model.timecodeSource);
            this.videoSelector(model.videoSelector);
        }

        public final Map<String, AudioSelectorGroup.Builder> getAudioSelectorGroups() {
            return this.audioSelectorGroups != null ? CollectionUtils.mapValues(this.audioSelectorGroups, AudioSelectorGroup::toBuilder) : null;
        }

        @Override
        public final Builder audioSelectorGroups(Map<String, AudioSelectorGroup> audioSelectorGroups) {
            this.audioSelectorGroups = ___mapOfAudioSelectorGroupCopier.copy(audioSelectorGroups);
            return this;
        }

        public final void setAudioSelectorGroups(Map<String, AudioSelectorGroup.BuilderImpl> audioSelectorGroups) {
            this.audioSelectorGroups = ___mapOfAudioSelectorGroupCopier.copyFromBuilder(audioSelectorGroups);
        }

        public final Map<String, AudioSelector.Builder> getAudioSelectors() {
            return this.audioSelectors != null ? CollectionUtils.mapValues(this.audioSelectors, AudioSelector::toBuilder) : null;
        }

        @Override
        public final Builder audioSelectors(Map<String, AudioSelector> audioSelectors) {
            this.audioSelectors = ___mapOfAudioSelectorCopier.copy(audioSelectors);
            return this;
        }

        public final void setAudioSelectors(Map<String, AudioSelector.BuilderImpl> audioSelectors) {
            this.audioSelectors = ___mapOfAudioSelectorCopier.copyFromBuilder(audioSelectors);
        }

        public final Map<String, CaptionSelector.Builder> getCaptionSelectors() {
            return this.captionSelectors != null ? CollectionUtils.mapValues(this.captionSelectors, CaptionSelector::toBuilder) : null;
        }

        @Override
        public final Builder captionSelectors(Map<String, CaptionSelector> captionSelectors) {
            this.captionSelectors = ___mapOfCaptionSelectorCopier.copy(captionSelectors);
            return this;
        }

        public final void setCaptionSelectors(Map<String, CaptionSelector.BuilderImpl> captionSelectors) {
            this.captionSelectors = ___mapOfCaptionSelectorCopier.copyFromBuilder(captionSelectors);
        }

        public final String getDeblockFilter() {
            return this.deblockFilter;
        }

        @Override
        public final Builder deblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
            return this;
        }

        @Override
        public final Builder deblockFilter(InputDeblockFilter deblockFilter) {
            this.deblockFilter(deblockFilter.toString());
            return this;
        }

        public final void setDeblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
        }

        public final String getDenoiseFilter() {
            return this.denoiseFilter;
        }

        @Override
        public final Builder denoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
            return this;
        }

        @Override
        public final Builder denoiseFilter(InputDenoiseFilter denoiseFilter) {
            this.denoiseFilter(denoiseFilter.toString());
            return this;
        }

        public final void setDenoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
        }

        public final String getFileInput() {
            return this.fileInput;
        }

        @Override
        public final Builder fileInput(String fileInput) {
            this.fileInput = fileInput;
            return this;
        }

        public final void setFileInput(String fileInput) {
            this.fileInput = fileInput;
        }

        public final String getFilterEnable() {
            return this.filterEnable;
        }

        @Override
        public final Builder filterEnable(String filterEnable) {
            this.filterEnable = filterEnable;
            return this;
        }

        @Override
        public final Builder filterEnable(InputFilterEnable filterEnable) {
            this.filterEnable(filterEnable.toString());
            return this;
        }

        public final void setFilterEnable(String filterEnable) {
            this.filterEnable = filterEnable;
        }

        public final Integer getFilterStrength() {
            return this.filterStrength;
        }

        @Override
        public final Builder filterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
            return this;
        }

        public final void setFilterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
        }

        public final Collection<InputClipping.Builder> getInputClippings() {
            return this.inputClippings != null ? (Collection)this.inputClippings.stream().map(InputClipping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputClippings(Collection<InputClipping> inputClippings) {
            this.inputClippings = ___listOfInputClippingCopier.copy(inputClippings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputClippings(InputClipping ... inputClippings) {
            this.inputClippings(Arrays.asList(inputClippings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputClippings(Consumer<InputClipping.Builder> ... inputClippings) {
            this.inputClippings(Stream.of(inputClippings).map(c -> (InputClipping)((InputClipping.Builder)InputClipping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputClippings(Collection<InputClipping.BuilderImpl> inputClippings) {
            this.inputClippings = ___listOfInputClippingCopier.copyFromBuilder(inputClippings);
        }

        public final Integer getProgramNumber() {
            return this.programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        public final String getPsiControl() {
            return this.psiControl;
        }

        @Override
        public final Builder psiControl(String psiControl) {
            this.psiControl = psiControl;
            return this;
        }

        @Override
        public final Builder psiControl(InputPsiControl psiControl) {
            this.psiControl(psiControl.toString());
            return this;
        }

        public final void setPsiControl(String psiControl) {
            this.psiControl = psiControl;
        }

        public final String getTimecodeSource() {
            return this.timecodeSource;
        }

        @Override
        public final Builder timecodeSource(String timecodeSource) {
            this.timecodeSource = timecodeSource;
            return this;
        }

        @Override
        public final Builder timecodeSource(InputTimecodeSource timecodeSource) {
            this.timecodeSource(timecodeSource.toString());
            return this;
        }

        public final void setTimecodeSource(String timecodeSource) {
            this.timecodeSource = timecodeSource;
        }

        public final VideoSelector.Builder getVideoSelector() {
            return this.videoSelector != null ? this.videoSelector.toBuilder() : null;
        }

        @Override
        public final Builder videoSelector(VideoSelector videoSelector) {
            this.videoSelector = videoSelector;
            return this;
        }

        public final void setVideoSelector(VideoSelector.BuilderImpl videoSelector) {
            this.videoSelector = videoSelector != null ? videoSelector.build() : null;
        }

        public Input build() {
            return new Input(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Input> {
        public Builder audioSelectorGroups(Map<String, AudioSelectorGroup> var1);

        public Builder audioSelectors(Map<String, AudioSelector> var1);

        public Builder captionSelectors(Map<String, CaptionSelector> var1);

        public Builder deblockFilter(String var1);

        public Builder deblockFilter(InputDeblockFilter var1);

        public Builder denoiseFilter(String var1);

        public Builder denoiseFilter(InputDenoiseFilter var1);

        public Builder fileInput(String var1);

        public Builder filterEnable(String var1);

        public Builder filterEnable(InputFilterEnable var1);

        public Builder filterStrength(Integer var1);

        public Builder inputClippings(Collection<InputClipping> var1);

        public Builder inputClippings(InputClipping ... var1);

        public Builder inputClippings(Consumer<InputClipping.Builder> ... var1);

        public Builder programNumber(Integer var1);

        public Builder psiControl(String var1);

        public Builder psiControl(InputPsiControl var1);

        public Builder timecodeSource(String var1);

        public Builder timecodeSource(InputTimecodeSource var1);

        public Builder videoSelector(VideoSelector var1);

        default public Builder videoSelector(Consumer<VideoSelector.Builder> videoSelector) {
            return this.videoSelector((VideoSelector)((VideoSelector.Builder)VideoSelector.builder().applyMutation(videoSelector)).build());
        }
    }
}

