/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.WavSettings;

public class WavSettingsUnmarshaller
implements Unmarshaller<WavSettings, JsonUnmarshallerContext> {
    private static final WavSettingsUnmarshaller INSTANCE = new WavSettingsUnmarshaller();

    public WavSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        WavSettings.Builder wavSettingsBuilder = WavSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bitDepth", targetDepth)) {
                    context.nextToken();
                    wavSettingsBuilder.bitDepth((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("channels", targetDepth)) {
                    context.nextToken();
                    wavSettingsBuilder.channels((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("sampleRate", targetDepth)) {
                    context.nextToken();
                    wavSettingsBuilder.sampleRate((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (WavSettings)wavSettingsBuilder.build();
    }

    public static WavSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

