/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Rectangle;

public class RectangleUnmarshaller
implements Unmarshaller<Rectangle, JsonUnmarshallerContext> {
    private static final RectangleUnmarshaller INSTANCE = new RectangleUnmarshaller();

    public Rectangle unmarshall(JsonUnmarshallerContext context) throws Exception {
        Rectangle.Builder rectangleBuilder = Rectangle.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("height", targetDepth)) {
                    context.nextToken();
                    rectangleBuilder.height((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("width", targetDepth)) {
                    context.nextToken();
                    rectangleBuilder.width((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("x", targetDepth)) {
                    context.nextToken();
                    rectangleBuilder.x((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("y", targetDepth)) {
                    context.nextToken();
                    rectangleBuilder.y((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Rectangle)rectangleBuilder.build();
    }

    public static RectangleUnmarshaller getInstance() {
        return INSTANCE;
    }
}

