/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.PresetSettings;
import software.amazon.awssdk.services.mediaconvert.transform.AudioDescriptionUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.CaptionDescriptionPresetUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.ContainerSettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.VideoDescriptionUnmarshaller;

public class PresetSettingsUnmarshaller
implements Unmarshaller<PresetSettings, JsonUnmarshallerContext> {
    private static final PresetSettingsUnmarshaller INSTANCE = new PresetSettingsUnmarshaller();

    public PresetSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        PresetSettings.Builder presetSettingsBuilder = PresetSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("audioDescriptions", targetDepth)) {
                    context.nextToken();
                    presetSettingsBuilder.audioDescriptions(new ListUnmarshaller((Unmarshaller)AudioDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("captionDescriptions", targetDepth)) {
                    context.nextToken();
                    presetSettingsBuilder.captionDescriptions(new ListUnmarshaller((Unmarshaller)CaptionDescriptionPresetUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("containerSettings", targetDepth)) {
                    context.nextToken();
                    presetSettingsBuilder.containerSettings(ContainerSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("videoDescription", targetDepth)) {
                    context.nextToken();
                    presetSettingsBuilder.videoDescription(VideoDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (PresetSettings)presetSettingsBuilder.build();
    }

    public static PresetSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

