/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.NoiseReducer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NoiseReducerMarshaller {
    private static final MarshallingInfo<String> FILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filter").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FILTERSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filterSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SPATIALFILTERSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spatialFilterSettings").isBinary(false).build();
    private static final NoiseReducerMarshaller INSTANCE = new NoiseReducerMarshaller();

    private NoiseReducerMarshaller() {
    }

    public static NoiseReducerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NoiseReducer noiseReducer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)noiseReducer, (String)"noiseReducer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)noiseReducer.filterString(), FILTER_BINDING);
            protocolMarshaller.marshall((Object)noiseReducer.filterSettings(), FILTERSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)noiseReducer.spatialFilterSettings(), SPATIALFILTERSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

