/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.CaptionDestinationSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CaptionDestinationSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> BURNINDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("burninDestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DVBSUBDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbSubDestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SCCDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sccDestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TELETEXTDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("teletextDestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TTMLDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ttmlDestinationSettings").isBinary(false).build();
    private static final CaptionDestinationSettingsMarshaller INSTANCE = new CaptionDestinationSettingsMarshaller();

    private CaptionDestinationSettingsMarshaller() {
    }

    public static CaptionDestinationSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CaptionDestinationSettings captionDestinationSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)captionDestinationSettings, (String)"captionDestinationSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)captionDestinationSettings.burninDestinationSettings(), BURNINDESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.destinationTypeString(), DESTINATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.dvbSubDestinationSettings(), DVBSUBDESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.sccDestinationSettings(), SCCDESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.teletextDestinationSettings(), TELETEXTDESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.ttmlDestinationSettings(), TTMLDESTINATIONSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

