/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.MovClapAtom;
import software.amazon.awssdk.services.mediaconvert.model.MovCslgAtom;
import software.amazon.awssdk.services.mediaconvert.model.MovMpeg2FourCCControl;
import software.amazon.awssdk.services.mediaconvert.model.MovPaddingControl;
import software.amazon.awssdk.services.mediaconvert.model.MovReference;
import software.amazon.awssdk.services.mediaconvert.transform.MovSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MovSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, MovSettings> {
    private final String clapAtom;
    private final String cslgAtom;
    private final String mpeg2FourCCControl;
    private final String paddingControl;
    private final String reference;

    private MovSettings(BuilderImpl builder) {
        this.clapAtom = builder.clapAtom;
        this.cslgAtom = builder.cslgAtom;
        this.mpeg2FourCCControl = builder.mpeg2FourCCControl;
        this.paddingControl = builder.paddingControl;
        this.reference = builder.reference;
    }

    public MovClapAtom clapAtom() {
        return MovClapAtom.fromValue(this.clapAtom);
    }

    public String clapAtomString() {
        return this.clapAtom;
    }

    public MovCslgAtom cslgAtom() {
        return MovCslgAtom.fromValue(this.cslgAtom);
    }

    public String cslgAtomString() {
        return this.cslgAtom;
    }

    public MovMpeg2FourCCControl mpeg2FourCCControl() {
        return MovMpeg2FourCCControl.fromValue(this.mpeg2FourCCControl);
    }

    public String mpeg2FourCCControlString() {
        return this.mpeg2FourCCControl;
    }

    public MovPaddingControl paddingControl() {
        return MovPaddingControl.fromValue(this.paddingControl);
    }

    public String paddingControlString() {
        return this.paddingControl;
    }

    public MovReference reference() {
        return MovReference.fromValue(this.reference);
    }

    public String referenceString() {
        return this.reference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clapAtomString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cslgAtomString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mpeg2FourCCControlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.paddingControlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MovSettings)) {
            return false;
        }
        MovSettings other = (MovSettings)obj;
        return Objects.equals(this.clapAtomString(), other.clapAtomString()) && Objects.equals(this.cslgAtomString(), other.cslgAtomString()) && Objects.equals(this.mpeg2FourCCControlString(), other.mpeg2FourCCControlString()) && Objects.equals(this.paddingControlString(), other.paddingControlString()) && Objects.equals(this.referenceString(), other.referenceString());
    }

    public String toString() {
        return ToString.builder((String)"MovSettings").add("ClapAtom", (Object)this.clapAtomString()).add("CslgAtom", (Object)this.cslgAtomString()).add("Mpeg2FourCCControl", (Object)this.mpeg2FourCCControlString()).add("PaddingControl", (Object)this.paddingControlString()).add("Reference", (Object)this.referenceString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClapAtom": {
                return Optional.of(clazz.cast(this.clapAtomString()));
            }
            case "CslgAtom": {
                return Optional.of(clazz.cast(this.cslgAtomString()));
            }
            case "Mpeg2FourCCControl": {
                return Optional.of(clazz.cast(this.mpeg2FourCCControlString()));
            }
            case "PaddingControl": {
                return Optional.of(clazz.cast(this.paddingControlString()));
            }
            case "Reference": {
                return Optional.of(clazz.cast(this.referenceString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MovSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String clapAtom;
        private String cslgAtom;
        private String mpeg2FourCCControl;
        private String paddingControl;
        private String reference;

        private BuilderImpl() {
        }

        private BuilderImpl(MovSettings model) {
            this.clapAtom(model.clapAtom);
            this.cslgAtom(model.cslgAtom);
            this.mpeg2FourCCControl(model.mpeg2FourCCControl);
            this.paddingControl(model.paddingControl);
            this.reference(model.reference);
        }

        public final String getClapAtom() {
            return this.clapAtom;
        }

        @Override
        public final Builder clapAtom(String clapAtom) {
            this.clapAtom = clapAtom;
            return this;
        }

        @Override
        public final Builder clapAtom(MovClapAtom clapAtom) {
            this.clapAtom(clapAtom.toString());
            return this;
        }

        public final void setClapAtom(String clapAtom) {
            this.clapAtom = clapAtom;
        }

        public final String getCslgAtom() {
            return this.cslgAtom;
        }

        @Override
        public final Builder cslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
            return this;
        }

        @Override
        public final Builder cslgAtom(MovCslgAtom cslgAtom) {
            this.cslgAtom(cslgAtom.toString());
            return this;
        }

        public final void setCslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
        }

        public final String getMpeg2FourCCControl() {
            return this.mpeg2FourCCControl;
        }

        @Override
        public final Builder mpeg2FourCCControl(String mpeg2FourCCControl) {
            this.mpeg2FourCCControl = mpeg2FourCCControl;
            return this;
        }

        @Override
        public final Builder mpeg2FourCCControl(MovMpeg2FourCCControl mpeg2FourCCControl) {
            this.mpeg2FourCCControl(mpeg2FourCCControl.toString());
            return this;
        }

        public final void setMpeg2FourCCControl(String mpeg2FourCCControl) {
            this.mpeg2FourCCControl = mpeg2FourCCControl;
        }

        public final String getPaddingControl() {
            return this.paddingControl;
        }

        @Override
        public final Builder paddingControl(String paddingControl) {
            this.paddingControl = paddingControl;
            return this;
        }

        @Override
        public final Builder paddingControl(MovPaddingControl paddingControl) {
            this.paddingControl(paddingControl.toString());
            return this;
        }

        public final void setPaddingControl(String paddingControl) {
            this.paddingControl = paddingControl;
        }

        public final String getReference() {
            return this.reference;
        }

        @Override
        public final Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public final Builder reference(MovReference reference) {
            this.reference(reference.toString());
            return this;
        }

        public final void setReference(String reference) {
            this.reference = reference;
        }

        public MovSettings build() {
            return new MovSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MovSettings> {
        public Builder clapAtom(String var1);

        public Builder clapAtom(MovClapAtom var1);

        public Builder cslgAtom(String var1);

        public Builder cslgAtom(MovCslgAtom var1);

        public Builder mpeg2FourCCControl(String var1);

        public Builder mpeg2FourCCControl(MovMpeg2FourCCControl var1);

        public Builder paddingControl(String var1);

        public Builder paddingControl(MovPaddingControl var1);

        public Builder reference(String var1);

        public Builder reference(MovReference var1);
    }
}

