/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.HlsEncryptionType;
import software.amazon.awssdk.services.mediaconvert.model.HlsInitializationVectorInManifest;
import software.amazon.awssdk.services.mediaconvert.model.HlsKeyProviderType;
import software.amazon.awssdk.services.mediaconvert.model.SpekeKeyProvider;
import software.amazon.awssdk.services.mediaconvert.model.StaticKeyProvider;
import software.amazon.awssdk.services.mediaconvert.transform.HlsEncryptionSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HlsEncryptionSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsEncryptionSettings> {
    private final String constantInitializationVector;
    private final String encryptionMethod;
    private final String initializationVectorInManifest;
    private final SpekeKeyProvider spekeKeyProvider;
    private final StaticKeyProvider staticKeyProvider;
    private final String type;

    private HlsEncryptionSettings(BuilderImpl builder) {
        this.constantInitializationVector = builder.constantInitializationVector;
        this.encryptionMethod = builder.encryptionMethod;
        this.initializationVectorInManifest = builder.initializationVectorInManifest;
        this.spekeKeyProvider = builder.spekeKeyProvider;
        this.staticKeyProvider = builder.staticKeyProvider;
        this.type = builder.type;
    }

    public String constantInitializationVector() {
        return this.constantInitializationVector;
    }

    public HlsEncryptionType encryptionMethod() {
        return HlsEncryptionType.fromValue(this.encryptionMethod);
    }

    public String encryptionMethodString() {
        return this.encryptionMethod;
    }

    public HlsInitializationVectorInManifest initializationVectorInManifest() {
        return HlsInitializationVectorInManifest.fromValue(this.initializationVectorInManifest);
    }

    public String initializationVectorInManifestString() {
        return this.initializationVectorInManifest;
    }

    public SpekeKeyProvider spekeKeyProvider() {
        return this.spekeKeyProvider;
    }

    public StaticKeyProvider staticKeyProvider() {
        return this.staticKeyProvider;
    }

    public HlsKeyProviderType type() {
        return HlsKeyProviderType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constantInitializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionMethodString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationVectorInManifestString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spekeKeyProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticKeyProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsEncryptionSettings)) {
            return false;
        }
        HlsEncryptionSettings other = (HlsEncryptionSettings)obj;
        return Objects.equals(this.constantInitializationVector(), other.constantInitializationVector()) && Objects.equals(this.encryptionMethodString(), other.encryptionMethodString()) && Objects.equals(this.initializationVectorInManifestString(), other.initializationVectorInManifestString()) && Objects.equals(this.spekeKeyProvider(), other.spekeKeyProvider()) && Objects.equals(this.staticKeyProvider(), other.staticKeyProvider()) && Objects.equals(this.typeString(), other.typeString());
    }

    public String toString() {
        return ToString.builder((String)"HlsEncryptionSettings").add("ConstantInitializationVector", (Object)this.constantInitializationVector()).add("EncryptionMethod", (Object)this.encryptionMethodString()).add("InitializationVectorInManifest", (Object)this.initializationVectorInManifestString()).add("SpekeKeyProvider", (Object)this.spekeKeyProvider()).add("StaticKeyProvider", (Object)this.staticKeyProvider()).add("Type", (Object)this.typeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConstantInitializationVector": {
                return Optional.of(clazz.cast(this.constantInitializationVector()));
            }
            case "EncryptionMethod": {
                return Optional.of(clazz.cast(this.encryptionMethodString()));
            }
            case "InitializationVectorInManifest": {
                return Optional.of(clazz.cast(this.initializationVectorInManifestString()));
            }
            case "SpekeKeyProvider": {
                return Optional.of(clazz.cast(this.spekeKeyProvider()));
            }
            case "StaticKeyProvider": {
                return Optional.of(clazz.cast(this.staticKeyProvider()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsEncryptionSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String constantInitializationVector;
        private String encryptionMethod;
        private String initializationVectorInManifest;
        private SpekeKeyProvider spekeKeyProvider;
        private StaticKeyProvider staticKeyProvider;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsEncryptionSettings model) {
            this.constantInitializationVector(model.constantInitializationVector);
            this.encryptionMethod(model.encryptionMethod);
            this.initializationVectorInManifest(model.initializationVectorInManifest);
            this.spekeKeyProvider(model.spekeKeyProvider);
            this.staticKeyProvider(model.staticKeyProvider);
            this.type(model.type);
        }

        public final String getConstantInitializationVector() {
            return this.constantInitializationVector;
        }

        @Override
        public final Builder constantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
            return this;
        }

        public final void setConstantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
        }

        public final String getEncryptionMethod() {
            return this.encryptionMethod;
        }

        @Override
        public final Builder encryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
            return this;
        }

        @Override
        public final Builder encryptionMethod(HlsEncryptionType encryptionMethod) {
            this.encryptionMethod(encryptionMethod.toString());
            return this;
        }

        public final void setEncryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
        }

        public final String getInitializationVectorInManifest() {
            return this.initializationVectorInManifest;
        }

        @Override
        public final Builder initializationVectorInManifest(String initializationVectorInManifest) {
            this.initializationVectorInManifest = initializationVectorInManifest;
            return this;
        }

        @Override
        public final Builder initializationVectorInManifest(HlsInitializationVectorInManifest initializationVectorInManifest) {
            this.initializationVectorInManifest(initializationVectorInManifest.toString());
            return this;
        }

        public final void setInitializationVectorInManifest(String initializationVectorInManifest) {
            this.initializationVectorInManifest = initializationVectorInManifest;
        }

        public final SpekeKeyProvider.Builder getSpekeKeyProvider() {
            return this.spekeKeyProvider != null ? this.spekeKeyProvider.toBuilder() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        public final void setSpekeKeyProvider(SpekeKeyProvider.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        public final StaticKeyProvider.Builder getStaticKeyProvider() {
            return this.staticKeyProvider != null ? this.staticKeyProvider.toBuilder() : null;
        }

        @Override
        public final Builder staticKeyProvider(StaticKeyProvider staticKeyProvider) {
            this.staticKeyProvider = staticKeyProvider;
            return this;
        }

        public final void setStaticKeyProvider(StaticKeyProvider.BuilderImpl staticKeyProvider) {
            this.staticKeyProvider = staticKeyProvider != null ? staticKeyProvider.build() : null;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HlsKeyProviderType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public HlsEncryptionSettings build() {
            return new HlsEncryptionSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsEncryptionSettings> {
        public Builder constantInitializationVector(String var1);

        public Builder encryptionMethod(String var1);

        public Builder encryptionMethod(HlsEncryptionType var1);

        public Builder initializationVectorInManifest(String var1);

        public Builder initializationVectorInManifest(HlsInitializationVectorInManifest var1);

        public Builder spekeKeyProvider(SpekeKeyProvider var1);

        default public Builder spekeKeyProvider(Consumer<SpekeKeyProvider.Builder> spekeKeyProvider) {
            return this.spekeKeyProvider((SpekeKeyProvider)((SpekeKeyProvider.Builder)SpekeKeyProvider.builder().apply(spekeKeyProvider)).build());
        }

        public Builder staticKeyProvider(StaticKeyProvider var1);

        default public Builder staticKeyProvider(Consumer<StaticKeyProvider.Builder> staticKeyProvider) {
            return this.staticKeyProvider((StaticKeyProvider)((StaticKeyProvider.Builder)StaticKeyProvider.builder().apply(staticKeyProvider)).build());
        }

        public Builder type(String var1);

        public Builder type(HlsKeyProviderType var1);
    }
}

