/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.transform.FrameCaptureSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FrameCaptureSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, FrameCaptureSettings> {
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final Integer maxCaptures;
    private final Integer quality;

    private FrameCaptureSettings(BuilderImpl builder) {
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.maxCaptures = builder.maxCaptures;
        this.quality = builder.quality;
    }

    public Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public Integer maxCaptures() {
        return this.maxCaptures;
    }

    public Integer quality() {
        return this.quality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCaptures());
        hashCode = 31 * hashCode + Objects.hashCode(this.quality());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameCaptureSettings)) {
            return false;
        }
        FrameCaptureSettings other = (FrameCaptureSettings)obj;
        return Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.maxCaptures(), other.maxCaptures()) && Objects.equals(this.quality(), other.quality());
    }

    public String toString() {
        return ToString.builder((String)"FrameCaptureSettings").add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("MaxCaptures", (Object)this.maxCaptures()).add("Quality", (Object)this.quality()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FramerateDenominator": {
                return Optional.of(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.of(clazz.cast(this.framerateNumerator()));
            }
            case "MaxCaptures": {
                return Optional.of(clazz.cast(this.maxCaptures()));
            }
            case "Quality": {
                return Optional.of(clazz.cast(this.quality()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FrameCaptureSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private Integer maxCaptures;
        private Integer quality;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameCaptureSettings model) {
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.maxCaptures(model.maxCaptures);
            this.quality(model.quality);
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final Integer getMaxCaptures() {
            return this.maxCaptures;
        }

        @Override
        public final Builder maxCaptures(Integer maxCaptures) {
            this.maxCaptures = maxCaptures;
            return this;
        }

        public final void setMaxCaptures(Integer maxCaptures) {
            this.maxCaptures = maxCaptures;
        }

        public final Integer getQuality() {
            return this.quality;
        }

        @Override
        public final Builder quality(Integer quality) {
            this.quality = quality;
            return this;
        }

        public final void setQuality(Integer quality) {
            this.quality = quality;
        }

        public FrameCaptureSettings build() {
            return new FrameCaptureSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FrameCaptureSettings> {
        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder maxCaptures(Integer var1);

        public Builder quality(Integer var1);
    }
}

