/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.RemixSettings;
import software.amazon.awssdk.services.mediaconvert.transform.ChannelMappingUnmarshaller;

public class RemixSettingsUnmarshaller
implements Unmarshaller<RemixSettings, JsonUnmarshallerContext> {
    private static final RemixSettingsUnmarshaller INSTANCE = new RemixSettingsUnmarshaller();

    public RemixSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        RemixSettings.Builder remixSettingsBuilder = RemixSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("channelMapping", targetDepth)) {
                    context.nextToken();
                    remixSettingsBuilder.channelMapping(ChannelMappingUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("channelsIn", targetDepth)) {
                    context.nextToken();
                    remixSettingsBuilder.channelsIn((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("channelsOut", targetDepth)) {
                    context.nextToken();
                    remixSettingsBuilder.channelsOut((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (RemixSettings)remixSettingsBuilder.build();
    }

    public static RemixSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

