/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.ProresSettings;

@SdkInternalApi
public class ProresSettingsMarshaller {
    private static final MarshallingInfo<String> CODECPROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecProfile").build();
    private static final MarshallingInfo<String> FRAMERATECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateControl").build();
    private static final MarshallingInfo<String> FRAMERATECONVERSIONALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateConversionAlgorithm").build();
    private static final MarshallingInfo<Integer> FRAMERATEDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateDenominator").build();
    private static final MarshallingInfo<Integer> FRAMERATENUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateNumerator").build();
    private static final MarshallingInfo<String> INTERLACEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interlaceMode").build();
    private static final MarshallingInfo<String> PARCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parControl").build();
    private static final MarshallingInfo<Integer> PARDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parDenominator").build();
    private static final MarshallingInfo<Integer> PARNUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parNumerator").build();
    private static final MarshallingInfo<String> SLOWPAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slowPal").build();
    private static final MarshallingInfo<String> TELECINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("telecine").build();
    private static final ProresSettingsMarshaller INSTANCE = new ProresSettingsMarshaller();

    public static ProresSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProresSettings proresSettings, ProtocolMarshaller protocolMarshaller) {
        if (proresSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)proresSettings.codecProfileString(), CODECPROFILE_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.framerateControlString(), FRAMERATECONTROL_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.framerateConversionAlgorithmString(), FRAMERATECONVERSIONALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.framerateDenominator(), FRAMERATEDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.framerateNumerator(), FRAMERATENUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.interlaceModeString(), INTERLACEMODE_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.parControlString(), PARCONTROL_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.parDenominator(), PARDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.parNumerator(), PARNUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.slowPalString(), SLOWPAL_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.telecineString(), TELECINE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

