/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.OutputGroupSettings;

@SdkInternalApi
public class OutputGroupSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> DASHISOGROUPSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dashIsoGroupSettings").build();
    private static final MarshallingInfo<StructuredPojo> FILEGROUPSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileGroupSettings").build();
    private static final MarshallingInfo<StructuredPojo> HLSGROUPSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsGroupSettings").build();
    private static final MarshallingInfo<StructuredPojo> MSSMOOTHGROUPSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("msSmoothGroupSettings").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final OutputGroupSettingsMarshaller INSTANCE = new OutputGroupSettingsMarshaller();

    public static OutputGroupSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputGroupSettings outputGroupSettings, ProtocolMarshaller protocolMarshaller) {
        if (outputGroupSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)outputGroupSettings.dashIsoGroupSettings(), DASHISOGROUPSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)outputGroupSettings.fileGroupSettings(), FILEGROUPSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)outputGroupSettings.hlsGroupSettings(), HLSGROUPSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)outputGroupSettings.msSmoothGroupSettings(), MSSMOOTHGROUPSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)outputGroupSettings.typeString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

