/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.OutputDetail;

@SdkInternalApi
public class OutputDetailMarshaller {
    private static final MarshallingInfo<Integer> DURATIONINMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("durationInMs").build();
    private static final MarshallingInfo<StructuredPojo> VIDEODETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("videoDetails").build();
    private static final OutputDetailMarshaller INSTANCE = new OutputDetailMarshaller();

    public static OutputDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputDetail outputDetail, ProtocolMarshaller protocolMarshaller) {
        if (outputDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)outputDetail.durationInMs(), DURATIONINMS_BINDING);
            protocolMarshaller.marshall((Object)outputDetail.videoDetails(), VIDEODETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

