/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.NielsenConfiguration;

@SdkInternalApi
public class NielsenConfigurationMarshaller {
    private static final MarshallingInfo<Integer> BREAKOUTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("breakoutCode").build();
    private static final MarshallingInfo<String> DISTRIBUTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("distributorId").build();
    private static final NielsenConfigurationMarshaller INSTANCE = new NielsenConfigurationMarshaller();

    public static NielsenConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NielsenConfiguration nielsenConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (nielsenConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)nielsenConfiguration.breakoutCode(), BREAKOUTCODE_BINDING);
            protocolMarshaller.marshall((Object)nielsenConfiguration.distributorId(), DISTRIBUTORID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

