/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Mp4Settings;

@SdkInternalApi
public class Mp4SettingsMarshaller {
    private static final MarshallingInfo<String> CSLGATOM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cslgAtom").build();
    private static final MarshallingInfo<String> FREESPACEBOX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("freeSpaceBox").build();
    private static final MarshallingInfo<String> MOOVPLACEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("moovPlacement").build();
    private static final MarshallingInfo<String> MP4MAJORBRAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mp4MajorBrand").build();
    private static final Mp4SettingsMarshaller INSTANCE = new Mp4SettingsMarshaller();

    public static Mp4SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Mp4Settings mp4Settings, ProtocolMarshaller protocolMarshaller) {
        if (mp4Settings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mp4Settings.cslgAtomString(), CSLGATOM_BINDING);
            protocolMarshaller.marshall((Object)mp4Settings.freeSpaceBoxString(), FREESPACEBOX_BINDING);
            protocolMarshaller.marshall((Object)mp4Settings.moovPlacementString(), MOOVPLACEMENT_BINDING);
            protocolMarshaller.marshall((Object)mp4Settings.mp4MajorBrand(), MP4MAJORBRAND_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

