/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Deinterlacer;

@SdkInternalApi
public class DeinterlacerMarshaller {
    private static final MarshallingInfo<String> ALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithm").build();
    private static final MarshallingInfo<String> CONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("control").build();
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mode").build();
    private static final DeinterlacerMarshaller INSTANCE = new DeinterlacerMarshaller();

    public static DeinterlacerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Deinterlacer deinterlacer, ProtocolMarshaller protocolMarshaller) {
        if (deinterlacer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deinterlacer.algorithmString(), ALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)deinterlacer.controlString(), CONTROL_BINDING);
            protocolMarshaller.marshall((Object)deinterlacer.modeString(), MODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

