/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.ChannelMapping;

@SdkInternalApi
public class ChannelMappingMarshaller {
    private static final MarshallingInfo<List> OUTPUTCHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputChannels").build();
    private static final ChannelMappingMarshaller INSTANCE = new ChannelMappingMarshaller();

    public static ChannelMappingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ChannelMapping channelMapping, ProtocolMarshaller protocolMarshaller) {
        if (channelMapping == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(channelMapping.outputChannels(), OUTPUTCHANNELS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

